/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.mgmt.service.impl;

import cn.afterturn.easypoi.excel.entity.result.ExcelImportResult;
import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.util.DateConverter;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import com.yunxi.dg.base.mgmt.application.rpc.proxy.blakclistbiz.IWarehouseBlacklistApiProxy;
import com.yunxi.dg.base.mgmt.application.rpc.proxy.inventorybiz.IDgLogicWarehouseApiProxy;
import com.yunxi.dg.base.mgmt.application.rpc.proxy.inventorybiz.IDgPhysicsWarehouseApiProxy;
import com.yunxi.dg.base.mgmt.application.rpc.proxy.old.IItemDgQueryApiProxy;
import com.yunxi.dg.base.mgmt.application.rpc.proxy.planbiz.IPlanConfigApiProxy;
import com.yunxi.dg.base.mgmt.application.rpc.proxy.transferbiz.ITransferPlanOrderApiProxy;
import com.yunxi.dg.base.ocs.mgmt.application.dto.blacklistbiz.PageWarehouseBlacklistDto;
import com.yunxi.dg.base.ocs.mgmt.application.dto.blacklistbiz.WareHouseBlacklistDto;
import com.yunxi.dg.base.ocs.mgmt.application.dto.entity.DgPhysicsWarehouseDto;
import com.yunxi.dg.base.ocs.mgmt.application.dto.entity.TransferPlanOrderDetailDto;
import com.yunxi.dg.base.ocs.mgmt.application.dto.entity.TransferPlanOrderDto;
import com.yunxi.dg.base.ocs.mgmt.application.dto.enums.FileModeTypeEnum;
import com.yunxi.dg.base.ocs.mgmt.application.dto.enums.FileOperationStatusEnum;
import com.yunxi.dg.base.ocs.mgmt.application.dto.enums.SalesPlanPlanPeriodEnum;
import com.yunxi.dg.base.ocs.mgmt.application.dto.inventory.DgLogicWarehouseOrgRespDto;
import com.yunxi.dg.base.ocs.mgmt.application.dto.old.ItemDgDto;
import com.yunxi.dg.base.ocs.mgmt.application.dto.old.ItemExchangeUnitBatchDto;
import com.yunxi.dg.base.ocs.mgmt.application.dto.old.ItemExchangeUnitDgRespDto;
import com.yunxi.dg.base.ocs.mgmt.application.dto.old.ItemExchangeUnitDto;
import com.yunxi.dg.base.ocs.mgmt.application.dto.old.ItemSkuDgRespDto;
import com.yunxi.dg.base.ocs.mgmt.application.dto.old.ItemSkuQueryDgReqDto;
import com.yunxi.dg.base.ocs.mgmt.application.dto.planbiz.SalesPlanDistributionReqDto;
import com.yunxi.dg.base.ocs.mgmt.application.dto.planbiz.SalesPlanDistributionRespDto;
import com.yunxi.dg.base.ocs.mgmt.application.dto.request.TransferPlanOrderImportDto;
import com.yunxi.dg.base.ocs.mgmt.application.dto.transferbiz.BatchCreateTransferPlanDto;
import com.yunxi.dg.base.ocs.mgmt.application.dto.transferbiz.CreateTransferPlanDto;
import com.yunxi.dg.base.poi.dto.ImportBaseModeDto;
import com.yunxi.dg.base.poi.dto.ImportFileOperationCommonReqDto;
import com.yunxi.dg.base.poi.dto.ImportFileOperationCommonRespDto;
import com.yunxi.dg.base.poi.service.AbstractBaseFileOperationCommonService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="AbstractBaseFileOperationCommonService_transfer_plan_order")
public class TransferPlanOrderOperationCommonServiceImpl
extends AbstractBaseFileOperationCommonService {
    private static final Logger logger = LoggerFactory.getLogger(TransferPlanOrderOperationCommonServiceImpl.class);
    @Resource
    private ITransferPlanOrderApiProxy iTransferPlanOrderApiProxy;
    @Resource
    private IDgLogicWarehouseApiProxy iDgLogicWarehouseApiProxy;
    @Resource
    private IDgPhysicsWarehouseApiProxy iDgPhysicsWarehouseApiProxy;
    @Resource
    private IItemDgQueryApiProxy iItemDgQueryApiProxy;
    @Resource
    private IWarehouseBlacklistApiProxy iWarehouseBlacklistApiProxy;
    @Resource
    private IPlanConfigApiProxy planConfigApiProxy;

    public Object verifyImportFileOperationCommon(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto) {
        HashMap<String, TransferPlanOrderImportDto> repetitionMap = new HashMap<String, TransferPlanOrderImportDto>();
        HashMap<String, List> mergeMap = new HashMap<String, List>();
        List importDtoList = BeanUtil.copyToList((Collection)result.getList(), TransferPlanOrderImportDto.class);
        Map<String, List<DgPhysicsWarehouseDto>> physicsWarehouseDtoMap = this.mapDgPhysicsWarehouse();
        List<String> itemCodeList = importDtoList.stream().map(e -> e.getSkuCode()).collect(Collectors.toList());
        Map<String, ItemSkuDgRespDto> mapItemSkuDg = this.mapItemSkuDgResp(itemCodeList);
        Map<String, DgLogicWarehouseOrgRespDto> mapOrgInfo = this.mapOrgDtoInfo();
        Map<String, Map<String, WareHouseBlacklistDto>> wareHouseBlacklistMap = this.getWareHouseBlacklistMap();
        Map<String, List<TransferPlanOrderImportDto>> planNameGroupByMap = importDtoList.stream().collect(Collectors.groupingBy(TransferPlanOrderImportDto::getPlanName));
        Map<String, TransferPlanOrderDto> mapPlanName = this.mapTransferPlanName(importDtoList, planNameGroupByMap.keySet());
        Map<String, ItemExchangeUnitDgRespDto> unitDgRespDtoMap = this.mapItemExchangeUnitDgRespDto(importDtoList);
        SalesPlanDistributionRespDto planConfig = this.planConfig();
        for (TransferPlanOrderImportDto importDto : importDtoList) {
            this.verifyRepetitionPlanOrderInfo(repetitionMap, planNameGroupByMap, importDto, commonReqDto, respDto);
            this.verifyPlanName(mapPlanName, importDto, commonReqDto, respDto);
            this.verifyInventoryMsg(physicsWarehouseDtoMap, wareHouseBlacklistMap, importDto, commonReqDto, respDto);
            this.verifyItemMsg(mapItemSkuDg, unitDgRespDtoMap, importDto, commonReqDto, respDto);
            this.verifyOrg(mapOrgInfo, importDto, commonReqDto, respDto);
            this.verifyPlanConfig(planConfig, importDto, commonReqDto, respDto);
            if (!StrUtil.isBlank((CharSequence)importDto.getErrorMsg())) continue;
            List mergePlanOrders = mergeMap.getOrDefault(importDto.mergeUniqueKey(), new ArrayList());
            mergePlanOrders.add(importDto);
            mergeMap.put(importDto.mergeUniqueKey(), mergePlanOrders);
        }
        return mergeMap;
    }

    public void callBackImportFileOperationCommonSync(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto, Object object) {
        respDto.setStatus(FileOperationStatusEnum.IMPORT_SUCCESS.getCode());
        Map mergeMap = (Map)object;
        if (CollectionUtil.isEmpty((Map)mergeMap)) {
            respDto.setStatus(FileOperationStatusEnum.IMPORT_ERROR.getCode());
            return;
        }
        if (CollectionUtil.isNotEmpty((Map)mergeMap) && !respDto.getErrorDetails().isEmpty()) {
            respDto.setStatus(FileOperationStatusEnum.IMPORT_PARTIAL_SUCCESS.getCode());
        }
        this.insertTransferPlanOrderBatch(mergeMap);
    }

    public void callBackImportFileOperationCommonAsync(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto, Object object) {
        this.callBackImportFileOperationCommonSync(result, commonReqDto, respDto, object);
    }

    private void verifyPlanConfig(SalesPlanDistributionRespDto planConfig, TransferPlanOrderImportDto importDto, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto) {
        Date date;
        DateConverter dateConverter;
        Date convert;
        if (StrUtil.isNotBlank((CharSequence)importDto.getErrorMsg())) {
            return;
        }
        planConfig = planConfig != null ? planConfig : new SalesPlanDistributionRespDto();
        SalesPlanPlanPeriodEnum periodEnum = SalesPlanPlanPeriodEnum.enumOf((Integer)(planConfig.getPlanPeriod() == null ? 1 : planConfig.getPlanPeriod()));
        if (!importDto.getCycleType().trim().equals(periodEnum.getDesc())) {
            importDto.setErrorMsg(String.format("\u7b2c%s\u884c\u6570\u636e\u6709\u8bef,%s", importDto.getRowNum() + FileModeTypeEnum.getInstance((String)commonReqDto.getKey()).getHeadRows(), String.format("\u8f93\u5165\u5468\u671f\u7c7b\u578b\u5fc5\u987b\u662f:%s\uff0c\u8bf7\u68c0\u67e5", periodEnum.getDesc())));
            respDto.getErrorDetails().add(importDto);
            return;
        }
        if (SalesPlanPlanPeriodEnum.MONTH.getDesc().equals(importDto.getCycleType()) && (convert = (dateConverter = new DateConverter()).convert(importDto.getSupplyCycle())).compareTo(date = dateConverter.convert(DateConverter.format((Date)new Date(), (String)"yyyy-MM"))) < 0) {
            importDto.setErrorMsg(String.format("\u7b2c%s\u884c\u6570\u636e\u6709\u8bef,%s", importDto.getRowNum() + FileModeTypeEnum.getInstance((String)commonReqDto.getKey()).getHeadRows(), "\u8865\u8d27\u5468\u671f\u53ea\u80fd\u662f\u5f53\u524d\u53ca\u4ee5\u540e\u6708\u4efd"));
            respDto.getErrorDetails().add(importDto);
            return;
        }
    }

    private Map<String, Map<String, WareHouseBlacklistDto>> getWareHouseBlacklistMap() {
        PageWarehouseBlacklistDto pageWarehouseBlacklistDto = new PageWarehouseBlacklistDto();
        pageWarehouseBlacklistDto.setPageNum(Integer.valueOf(1));
        pageWarehouseBlacklistDto.setPageSize(Integer.valueOf(Integer.MAX_VALUE));
        RestResponse pageinfo = this.iWarehouseBlacklistApiProxy.pageinfo(pageWarehouseBlacklistDto);
        return ((List)Optional.ofNullable(((PageInfo)RestResponseHelper.extractData((RestResponse)pageinfo)).getList()).orElse(new ArrayList())).stream().collect(Collectors.groupingBy(WareHouseBlacklistDto::getOrganizationCode, Collectors.toMap(WareHouseBlacklistDto::getWarehouseCode, Function.identity())));
    }

    private void verifyPlanName(Map<String, TransferPlanOrderDto> mapPlanName, TransferPlanOrderImportDto importDto, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto) {
        if (StrUtil.isNotBlank((CharSequence)importDto.getErrorMsg())) {
            return;
        }
        TransferPlanOrderDto planOrderDto = mapPlanName.get(importDto.getPlanName());
        if (Objects.nonNull(planOrderDto)) {
            importDto.setErrorMsg(String.format("\u7b2c%s\u884c\u6570\u636e\u6709\u8bef,%s", importDto.getRowNum() + FileModeTypeEnum.getInstance((String)commonReqDto.getKey()).getHeadRows(), "\u8be5\u8c03\u62e8\u8ba1\u5212\u540d\u79f0\u5df2\u7ecf\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5"));
            respDto.getErrorDetails().add(importDto);
            return;
        }
    }

    private Map<String, TransferPlanOrderDto> mapTransferPlanName(List<TransferPlanOrderImportDto> importDtoList, Set<String> planNameSet) {
        RestResponse response = this.iTransferPlanOrderApiProxy.queryByNameList((List)Lists.newArrayList(planNameSet));
        return ((List)Optional.ofNullable(RestResponseHelper.extractData((RestResponse)response)).orElse(new ArrayList())).stream().collect(Collectors.toMap(TransferPlanOrderDto::getPlanName, Function.identity(), (v1, v2) -> v1));
    }

    private Map<String, DgLogicWarehouseOrgRespDto> mapOrgDtoInfo() {
        RestResponse response = this.iDgLogicWarehouseApiProxy.queryOrgList();
        Map<String, DgLogicWarehouseOrgRespDto> orgCheckMap = ((List)response.getData()).stream().collect(Collectors.toMap(DgLogicWarehouseOrgRespDto::getOrgCode, Function.identity(), (e1, e2) -> e2));
        return orgCheckMap;
    }

    private Map<String, ItemSkuDgRespDto> mapItemSkuDgResp(List<String> itemCodeList) {
        RestResponse response = this.iItemDgQueryApiProxy.querySkuList(ItemSkuQueryDgReqDto.builder().skuCodeList(itemCodeList).build());
        return ((List)Optional.ofNullable(RestResponseHelper.extractData((RestResponse)response)).orElse(new ArrayList())).stream().collect(Collectors.toMap(ItemSkuDgRespDto::getCode, Function.identity()));
    }

    private Map<String, List<DgPhysicsWarehouseDto>> mapDgPhysicsWarehouse() {
        RestResponse response = this.iDgPhysicsWarehouseApiProxy.queryAll();
        return ((List)Optional.ofNullable(RestResponseHelper.extractData((RestResponse)response)).orElse(new ArrayList())).stream().collect(Collectors.groupingBy(DgPhysicsWarehouseDto::getWarehouseCode));
    }

    private void verifyOrg(Map<String, DgLogicWarehouseOrgRespDto> orgCheckMap, TransferPlanOrderImportDto importDto, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto) {
        if (StrUtil.isNotBlank((CharSequence)importDto.getErrorMsg())) {
            return;
        }
        DgLogicWarehouseOrgRespDto orgAdvRespDto = orgCheckMap.get(importDto.getOrganizationCode());
        if (Objects.isNull(orgAdvRespDto)) {
            importDto.setErrorMsg(String.format("\u7b2c%s\u884c\u6570\u636e\u6709\u8bef,%s", importDto.getRowNum() + FileModeTypeEnum.getInstance((String)commonReqDto.getKey()).getHeadRows(), "\u7ec4\u7ec7\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5"));
            respDto.getErrorDetails().add(importDto);
            return;
        }
        importDto.setOrganizationCode(orgAdvRespDto.getOrgCode());
        importDto.setOrganizationId(orgAdvRespDto.getOrgId());
        importDto.setOrganizationName(orgAdvRespDto.getOrgName());
    }

    private void verifyItemMsg(Map<String, ItemSkuDgRespDto> mapItemSkuDgResp, Map<String, ItemExchangeUnitDgRespDto> unitDgRespDtoMap, TransferPlanOrderImportDto importDto, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto) {
        ItemSkuDgRespDto itemSkuDgRespDto = mapItemSkuDgResp.get(importDto.getSkuCode());
        if (StrUtil.isNotBlank((CharSequence)importDto.getErrorMsg())) {
            return;
        }
        if (Objects.isNull(itemSkuDgRespDto)) {
            importDto.setErrorMsg(String.format("\u7b2c%s\u884c\u6570\u636e\u6709\u8bef,%s", importDto.getRowNum() + FileModeTypeEnum.getInstance((String)commonReqDto.getKey()).getHeadRows(), "\u5546\u54c1\u4fe1\u606f\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5"));
            respDto.getErrorDetails().add(importDto);
            return;
        }
        ItemExchangeUnitDgRespDto itemUnit = unitDgRespDtoMap.getOrDefault(importDto.getExchangUnitUniqueKey(), new ItemExchangeUnitDgRespDto());
        ItemDgDto itemDgDto = itemSkuDgRespDto.getItemDgDto();
        importDto.setItemName(itemDgDto.getName());
        importDto.setItemCode(itemDgDto.getCode());
        importDto.setSkuName(itemSkuDgRespDto.getName());
        importDto.setPlanWeight(itemUnit.getNetWeight());
        importDto.setPlanVolume(itemUnit.getVolume());
        importDto.setPlanAmount(itemUnit.getCostPrice());
    }

    private void verifyInventoryMsg(Map<String, List<DgPhysicsWarehouseDto>> checkWarehouseMap, Map<String, Map<String, WareHouseBlacklistDto>> wareHouseBlacklistMap, TransferPlanOrderImportDto importDto, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto) {
        if (StrUtil.isNotBlank((CharSequence)importDto.getErrorMsg())) {
            return;
        }
        List<DgPhysicsWarehouseDto> warehouseDtos = checkWarehouseMap.get(importDto.getPhysicsWarehouseCode());
        if (CollectionUtil.isEmpty(warehouseDtos)) {
            importDto.setErrorMsg(String.format("\u7b2c%s\u884c\u6570\u636e\u6709\u8bef,%s", importDto.getRowNum() + FileModeTypeEnum.getInstance((String)commonReqDto.getKey()).getHeadRows(), "\u8865\u8d27\u7269\u7406\u4ed3\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5"));
            respDto.getErrorDetails().add(importDto);
            return;
        }
        if (CollectionUtil.isNotEmpty(warehouseDtos) && warehouseDtos.size() > 1) {
            importDto.setErrorMsg(String.format("\u7b2c%s\u884c\u6570\u636e\u6709\u8bef,%s", importDto.getRowNum() + FileModeTypeEnum.getInstance((String)commonReqDto.getKey()).getHeadRows(), "\u8865\u8d27\u7269\u7406\u4ed3\u4e0d\u552f\u4e00\uff0c\u8bf7\u68c0\u67e5"));
            respDto.getErrorDetails().add(importDto);
            return;
        }
        Map<String, WareHouseBlacklistDto> blacklistDtoMap = wareHouseBlacklistMap.get(importDto.getOrganizationCode());
        if (CollectionUtil.isNotEmpty(blacklistDtoMap) && blacklistDtoMap.containsKey(importDto.getPhysicsWarehouseCode())) {
            importDto.setErrorMsg(String.format("\u7b2c%s\u884c\u6570\u636e\u6709\u8bef,%s", importDto.getRowNum() + FileModeTypeEnum.getInstance((String)commonReqDto.getKey()).getHeadRows(), "\u540c\u4e00\u7ec4\u7ec7\u4e0e\u8865\u8d27\u7269\u7406\u4ed3\u5e93\u5728\u8865\u8d27\u9ed1\u540d\u5355\u4e2d,\u4e0d\u53ef\u4ee5\u505a\u8c03\u62e8\u8ba1\u5212"));
            respDto.getErrorDetails().add(importDto);
            return;
        }
        importDto.setPhysicsWarehouseName(warehouseDtos.get(0).getWarehouseName());
    }

    private void insertTransferPlanOrderBatch(Map<String, List<TransferPlanOrderImportDto>> mergeMap) {
        BatchCreateTransferPlanDto planOrderDto = new BatchCreateTransferPlanDto();
        List list = planOrderDto.getList();
        for (Map.Entry<String, List<TransferPlanOrderImportDto>> entry : mergeMap.entrySet()) {
            TransferPlanOrderImportDto firstImportDto = entry.getValue().get(0);
            CreateTransferPlanDto createTransferPlanDto = new CreateTransferPlanDto();
            createTransferPlanDto.setPlanName(firstImportDto.getPlanName());
            createTransferPlanDto.setSupplyCycle(firstImportDto.getSupplyCycle());
            createTransferPlanDto.setPreOrderNo(firstImportDto.getForecastOrderNo());
            createTransferPlanDto.setCycleType(SalesPlanPlanPeriodEnum.enumOf((String)firstImportDto.getCycleType().trim()).getType());
            createTransferPlanDto.setDetails(BeanUtil.copyToList((Collection)entry.getValue(), TransferPlanOrderDetailDto.class));
            list.add(createTransferPlanDto);
        }
        planOrderDto.setList(list);
        RestResponseHelper.extractData((RestResponse)this.iTransferPlanOrderApiProxy.batchInsert(planOrderDto));
    }

    private boolean verifyRepetitionPlanOrderInfo(Map<String, TransferPlanOrderImportDto> repetitionMap, Map<String, List<TransferPlanOrderImportDto>> planNameGroupByMap, TransferPlanOrderImportDto importDto, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto) {
        if (StrUtil.isNotBlank((CharSequence)importDto.getErrorMsg())) {
            return false;
        }
        TransferPlanOrderImportDto repeatDto = repetitionMap.get(importDto.repetitionUniqueKey());
        if (Objects.nonNull(repeatDto)) {
            repeatDto.setErrorMsg(String.format("\u7b2c%s\u884c\u6570\u636e\u6709\u8bef,%s", repeatDto.getRowNum() + FileModeTypeEnum.getInstance((String)commonReqDto.getKey()).getHeadRows(), "\u540c\u4e00\u4e2a\u8ba1\u5212\u5355\u4e0b\u5b58\u5728\u91cd\u590d\u7684\u6570\u636e\uff0c\u8bf7\u68c0\u67e5"));
            importDto.setErrorMsg(String.format("\u7b2c%s\u884c\u6570\u636e\u6709\u8bef,%s", importDto.getRowNum() + FileModeTypeEnum.getInstance((String)commonReqDto.getKey()).getHeadRows(), "\u540c\u4e00\u4e2a\u8ba1\u5212\u5355\u4e0b\u5b58\u5728\u91cd\u590d\u7684\u6570\u636e\uff0c\u8bf7\u68c0\u67e5"));
            respDto.getErrorDetails().add(importDto);
            if (!respDto.getErrorDetails().contains(repeatDto)) {
                respDto.getErrorDetails().add(repeatDto);
            }
            return false;
        }
        Map<String, List<TransferPlanOrderImportDto>> groupingByMap = planNameGroupByMap.get(importDto.getPlanName()).stream().collect(Collectors.groupingBy(TransferPlanOrderImportDto::mergeUniqueKey));
        if (groupingByMap.size() > 1) {
            planNameGroupByMap.get(importDto.getPlanName()).stream().forEach(e -> {
                e.setErrorMsg(String.format("\u7b2c%s\u884c\u6570\u636e\u6709\u8bef,%s", e.getRowNum() + FileModeTypeEnum.getInstance((String)commonReqDto.getKey()).getHeadRows(), "\u76f8\u540c\u8ba1\u5212\u540d\u79f0\u89c6\u4e3a\u540c\u4e00\u4e2a\u8ba1\u5212\u5355\uff0c\u5219\u5468\u671f\u3001\u5468\u671f\u7c7b\u578b\u3001\u524d\u7f6e\u5355\u53f7\u5fc5\u987b\u4e00\u76f4"));
                respDto.getErrorDetails().add(e);
            });
            return false;
        }
        repetitionMap.put(importDto.repetitionUniqueKey(), importDto);
        return true;
    }

    private Map<String, ItemExchangeUnitDgRespDto> mapItemExchangeUnitDgRespDto(List<TransferPlanOrderImportDto> importDtoList) {
        ArrayList<ItemExchangeUnitDto> itemUnits = new ArrayList<ItemExchangeUnitDto>();
        for (TransferPlanOrderImportDto importDto : importDtoList) {
            logger.info("importDto->{}", (Object)JSON.toJSONString(importDtoList));
            if (!StrUtil.isBlank((CharSequence)importDto.getSkuCode())) continue;
            ItemExchangeUnitDto unitDto = ItemExchangeUnitDto.builder().currentUnit(StrUtil.isBlank((CharSequence)importDto.getUnit()) ? "basicUnit" : importDto.getUnit()).currentNum(new BigDecimal(importDto.getPlanQuantity())).skuCode(importDto.getSkuCode()).build();
            itemUnits.add(unitDto);
        }
        ItemExchangeUnitBatchDto batchDto = new ItemExchangeUnitBatchDto();
        batchDto.setUnitDtos(itemUnits);
        logger.info("\u6362\u7b97\u5546\u54c1\u5355\u4f4d-\u300b{}", (Object)JSON.toJSONString((Object)batchDto));
        RestResponse response = this.iItemDgQueryApiProxy.batchExchangeUnit((List)Lists.newArrayList((Object[])new ItemExchangeUnitBatchDto[]{batchDto}));
        logger.info("\u67e5\u8be2\u5546\u54c1\u660e\u7ec6-\u300b{}", (Object)JSON.toJSONString((Object)response));
        return ((List)RestResponseHelper.extractData((RestResponse)response)).stream().collect(Collectors.toMap(ItemExchangeUnitDgRespDto::getUniqueKey, Function.identity(), (v1, v2) -> v1));
    }

    private SalesPlanDistributionRespDto planConfig() {
        SalesPlanDistributionReqDto salesPlanDistributionReqDto = new SalesPlanDistributionReqDto();
        SalesPlanDistributionRespDto data = (SalesPlanDistributionRespDto)this.planConfigApiProxy.getSalePlanDetail(salesPlanDistributionReqDto).getData();
        logger.info("SalesPlanDistributionRespDto--\u300b{}", (Object)JSON.toJSONString((Object)data));
        return data;
    }
}

