/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.mgmt.service.impl;

import cn.afterturn.easypoi.excel.entity.result.ExcelImportResult;
import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.share.dto.entity.TransferGoodsOrderDto;
import com.yunxi.dg.base.center.share.dto.entity.TransferGoodsOrderPageReqDto;
import com.yunxi.dg.base.center.share.proxy.entity.ITransferGoodsOrderApiProxy;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.mgmt.application.rpc.proxy.sku.IItemSkuDgQueryApiProxy;
import com.yunxi.dg.base.mgmt.service.enums.ExportTransferGoodsOrderEnum;
import com.yunxi.dg.base.ocs.mgmt.application.dto.enums.FileModeTypeEnum;
import com.yunxi.dg.base.ocs.mgmt.application.dto.proxy.item.ItemSkuDgRespDto;
import com.yunxi.dg.base.ocs.mgmt.application.dto.request.ImportTransferGoodsOrderDto;
import com.yunxi.dg.base.ocs.mgmt.application.dto.response.ExportTransferGoodsOrderRespDto;
import com.yunxi.dg.base.poi.constant.PoiFileModeMap;
import com.yunxi.dg.base.poi.dto.ExportBaseModeDto;
import com.yunxi.dg.base.poi.dto.ExportQueryParamsReqDto;
import com.yunxi.dg.base.poi.dto.ImportBaseModeDto;
import com.yunxi.dg.base.poi.dto.ImportFileOperationCommonReqDto;
import com.yunxi.dg.base.poi.dto.ImportFileOperationCommonRespDto;
import com.yunxi.dg.base.poi.service.AbstractBaseFileOperationCommonService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="AbstractBaseFileOperationCommonService_channel_transfer_goods_order")
public class ChannelTransferGoodsOrderCommonServiceImpl
extends AbstractBaseFileOperationCommonService {
    private static final Logger log = LoggerFactory.getLogger(ChannelTransferGoodsOrderCommonServiceImpl.class);
    @Resource
    private IItemSkuDgQueryApiProxy itemSkuDgQueryApiProxy;
    @Resource
    private ITransferGoodsOrderApiProxy iTransferGoodsOrderApiProxy;

    public Object verifyImportFileOperationCommon(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto) {
        log.info("\u5f00\u59cb\u5bfc\u5165\u6e20\u9053\u8c03\u8d27\u5355");
        if (CollectionUtil.isEmpty((Collection)result.getList())) {
            return new ArrayList();
        }
        ArrayList<ImportTransferGoodsOrderDto> passList = new ArrayList<ImportTransferGoodsOrderDto>();
        List resultList = BeanUtil.copyToList((Collection)result.getList(), ImportTransferGoodsOrderDto.class);
        log.info("\u5f00\u59cb\u5bfc\u5165\u6e20\u9053\u8c03\u8d27\u5355,\u5bfc\u5165\u6e20\u9053\u8c03\u8d27\u5355\u6570\u636e:{}", (Object)JSON.toJSONString((Object)resultList));
        ArrayList<String> skuCodePassList = new ArrayList<String>();
        for (ImportTransferGoodsOrderDto dto : resultList) {
            boolean isPass = this.paramVerify(dto, skuCodePassList);
            if (!isPass) {
                this.setErrorMsg(dto, String.format("\u7b2c%s\u884c\u6570\u636e\u6709\u8bef,%s", dto.getRowNum() + FileModeTypeEnum.getInstance((String)commonReqDto.getKey()).getHeadRows(), dto.getErrorMsg()));
                respDto.getErrorDetails().add(dto);
            }
            skuCodePassList.add(dto.getSkuCode());
            passList.add(dto);
        }
        respDto.setDetails(passList);
        return passList;
    }

    public List<? extends ExportBaseModeDto> callBackScrollData(ExportQueryParamsReqDto exportQueryParamsReqDto) {
        String key = exportQueryParamsReqDto.getExportFileParams().getKey();
        String filter = exportQueryParamsReqDto.getFilter();
        log.info("\u6e20\u9053\u8c03\u8d27\u5355\u5bfc\u51fa\u67e5\u8be2\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)exportQueryParamsReqDto));
        AssertUtils.isTrue((boolean)FileModeTypeEnum.CHANNEL_TRANSFER_GOODS_ORDER.getKey().equals(key), (String)"\u4e1a\u52a1key\u6709\u8bef");
        TransferGoodsOrderPageReqDto reqDto = new TransferGoodsOrderPageReqDto();
        if (StringUtils.isNotBlank((CharSequence)filter)) {
            reqDto = (TransferGoodsOrderPageReqDto)JSON.parseObject((String)filter, TransferGoodsOrderPageReqDto.class);
        }
        List pageData = ((PageInfo)RestResponseHelper.extractData((RestResponse)this.iTransferGoodsOrderApiProxy.page(reqDto))).getList();
        ArrayList<ExportTransferGoodsOrderRespDto> list = new ArrayList<ExportTransferGoodsOrderRespDto>();
        Integer num = 1;
        for (TransferGoodsOrderDto dto : pageData) {
            ExportTransferGoodsOrderRespDto exportTransferGoodsOrderRespDto = (ExportTransferGoodsOrderRespDto)BeanUtil.copyProperties((Object)dto, ExportTransferGoodsOrderRespDto.class, (String[])new String[0]);
            Integer n = num;
            Integer n2 = num = Integer.valueOf(num + 1);
            exportTransferGoodsOrderRespDto.setNumber(n);
            if (Objects.nonNull(dto.getOrderSource())) {
                exportTransferGoodsOrderRespDto.setOrderSource(ExportTransferGoodsOrderEnum.getInstance(dto.getOrderSource().toString()).getDesc());
            }
            if (StringUtils.isNotBlank((CharSequence)dto.getBusinessType())) {
                exportTransferGoodsOrderRespDto.setBusinessType(ExportTransferGoodsOrderEnum.getInstance(dto.getBusinessType()).getDesc());
            }
            if (StringUtils.isNotBlank((CharSequence)dto.getOrderStatus())) {
                exportTransferGoodsOrderRespDto.setOrderStatus(ExportTransferGoodsOrderEnum.getInstance(dto.getOrderStatus()).getDesc());
            }
            exportTransferGoodsOrderRespDto.setAuditQuantity(Integer.valueOf(dto.getAuditQuantity().intValue()));
            exportTransferGoodsOrderRespDto.setCompleteQuantity(Integer.valueOf(dto.getCompleteQuantity().intValue()));
            exportTransferGoodsOrderRespDto.setTotalQuantity(Integer.valueOf(dto.getTotalQuantity().intValue()));
            exportTransferGoodsOrderRespDto.setCreateTime(DateUtil.formatDateTime((Date)dto.getCreateTime()));
            exportTransferGoodsOrderRespDto.setUpdateTime(DateUtil.formatDateTime((Date)dto.getUpdateTime()));
            list.add(exportTransferGoodsOrderRespDto);
        }
        log.info("\u6e20\u9053\u8c03\u8d27\u5355\u5bfc\u51fa\u5927\u5c0f:{}", (Object)list.size());
        return list;
    }

    private boolean paramVerify(ImportTransferGoodsOrderDto dto, List<String> skuCodePassList) {
        if (CollectionUtil.isNotEmpty(skuCodePassList) && skuCodePassList.contains(dto.getSkuCode())) {
            dto.setErrorMsg("sku\u7f16\u7801\u5df2\u91cd\u590d\u63d0\u4ea4");
            return false;
        }
        List list = (List)RestResponseHelper.extractData((RestResponse)this.itemSkuDgQueryApiProxy.queryBySkuCode((List)ListUtil.toList((Object[])new String[]{dto.getSkuCode()})));
        if (CollectionUtil.isEmpty((Collection)list)) {
            dto.setErrorMsg("\u8be5\u5546\u54c1\u4e0d\u5b58\u5728");
            return false;
        }
        Map<String, String> collect = list.stream().filter(itemSkuDgRespDto -> StringUtils.isNotBlank((CharSequence)itemSkuDgRespDto.getCode())).collect(Collectors.toMap(ItemSkuDgRespDto::getCode, ItemSkuDgRespDto::getName));
        dto.setName(collect.get(dto.getSkuCode()));
        return true;
    }

    private String setErrorMsg(ImportTransferGoodsOrderDto dto, String errorMsg) {
        log.info("\u6821\u9a8c\u9519\u8bef\u4fe1\u606f{}", (Object)errorMsg);
        dto.setErrorMsg(errorMsg);
        return dto.getErrorMsg();
    }

    public void initTemplateMap(ExportQueryParamsReqDto exportQueryParamsReqDto) {
        String filter = exportQueryParamsReqDto.getFilter();
        TransferGoodsOrderPageReqDto reqDto = new TransferGoodsOrderPageReqDto();
        if (StringUtils.isNotBlank((CharSequence)filter)) {
            reqDto = (TransferGoodsOrderPageReqDto)JSON.parseObject((String)filter, TransferGoodsOrderPageReqDto.class);
        }
        FileModeTypeEnum fileModeTypeEnum = FileModeTypeEnum.CHANNEL_TRANSFER_GOODS_ORDER;
        PoiFileModeMap.exportTemplateMap.remove((Object)fileModeTypeEnum.getKey());
        if (reqDto != null && reqDto.getOrderType() == 2) {
            PoiFileModeMap.exportTemplateMap.put((Object)fileModeTypeEnum.getKey(), ExportTransferGoodsOrderRespDto.class);
            PoiFileModeMap.exportTemplateMap.put((Object)fileModeTypeEnum.getKey(), (Object)1);
            PoiFileModeMap.exportTemplateMap.put((Object)fileModeTypeEnum.getKey(), (Object)"\u5728\u5236\u6e20\u9053\u8c03\u8d27\u5355");
            PoiFileModeMap.exportTemplateMap.put((Object)fileModeTypeEnum.getKey(), (Object)"\u5728\u5236\u6e20\u9053\u8c03\u8d27\u5355\u5bfc\u51fa");
        } else {
            PoiFileModeMap.exportTemplateMap.put((Object)fileModeTypeEnum.getKey(), ExportTransferGoodsOrderRespDto.class);
            PoiFileModeMap.exportTemplateMap.put((Object)fileModeTypeEnum.getKey(), (Object)1);
            PoiFileModeMap.exportTemplateMap.put((Object)fileModeTypeEnum.getKey(), (Object)fileModeTypeEnum.getName());
            PoiFileModeMap.exportTemplateMap.put((Object)fileModeTypeEnum.getKey(), (Object)fileModeTypeEnum.getExportFunctionName());
        }
    }
}

