/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.mgmt.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.dtyunxi.rest.RestResponse;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Maps;
import com.yunxi.dg.base.center.item.dto.request.ItemRemarkDgReqDto;
import com.yunxi.dg.base.center.item.dto.response.DgItemSkuPageRespDto;
import com.yunxi.dg.base.center.item.proxy.item.IItemDgApiProxy;
import com.yunxi.dg.base.center.openapi.dto.erp.ErpInventoryAvailNumberDto;
import com.yunxi.dg.base.center.openapi.dto.erp.ErpInventoryNumQueryDto;
import com.yunxi.dg.base.center.openapi.proxy.erp.IExternalInventoryErpApiProxy;
import com.yunxi.dg.base.center.report.dto.inventory.DgLogicInventoryTotalDto;
import com.yunxi.dg.base.center.report.dto.inventory.DgLogicInventoryTotalPageReqDto;
import com.yunxi.dg.base.center.report.proxy.inventory.IDgLogicInventoryTotalApiProxy;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import com.yunxi.dg.base.commons.utils.decimal.BigDecimalUtils;
import com.yunxi.dg.base.mgmt.application.rpc.dto.request.ItemQueryDgReqDto;
import com.yunxi.dg.base.mgmt.application.rpc.dto.request.UnitDgReqDto;
import com.yunxi.dg.base.mgmt.application.rpc.dto.response.DgItemSkuRespDto;
import com.yunxi.dg.base.mgmt.application.rpc.dto.response.UnitDgRespDto;
import com.yunxi.dg.base.mgmt.application.rpc.proxy.sku.IItemSkuDgQueryApiProxy;
import com.yunxi.dg.base.mgmt.application.rpc.proxy.unit.IUnitDgQueryApiProxy;
import com.yunxi.dg.base.mgmt.service.IOcsItemService;
import com.yunxi.dg.base.ocs.mgmt.application.dto.enums.LogicWarehouseQualityEnum;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.compress.utils.Lists;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OcsItemServiceImpl
implements IOcsItemService {
    @Resource
    private IItemDgApiProxy iItemDgApiProxy;
    @Autowired
    private IDgLogicInventoryTotalApiProxy iDgLogicInventoryTotalApiProxy;
    @Autowired
    private IExternalInventoryErpApiProxy iExternalInventoryErpApiProxy;
    @Autowired
    private IItemSkuDgQueryApiProxy iItemSkuDgQueryApiProxy;
    @Autowired
    private IUnitDgQueryApiProxy iUnitDgQueryApiProxy;

    @Override
    public RestResponse<Void> batchItemRemark(ItemRemarkDgReqDto reqDto) {
        return new RestResponse(RestResponseHelper.extractData((RestResponse)this.iItemDgApiProxy.batchItemRemark(reqDto)));
    }

    @Override
    public RestResponse<PageInfo<DgItemSkuPageRespDto>> queryItemListByPage(ItemQueryDgReqDto dto) {
        PageInfo dtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.iItemSkuDgQueryApiProxy.queryItemListByPage(dto));
        if (CollectionUtil.isEmpty((Collection)dtoPageInfo.getList())) {
            return new RestResponse();
        }
        List itemSkuPageRespDtoList = dtoPageInfo.getList();
        List<String> skuCodeList = itemSkuPageRespDtoList.stream().map(DgItemSkuRespDto::getSkuCode).distinct().collect(Collectors.toList());
        Map<String, BigDecimal> skuCodeQuantityMap = this.getSkuCodeQuantityMap(dto, skuCodeList);
        List unitDgRespDtoList = (List)Optional.ofNullable(RestResponseHelper.extractData((RestResponse)this.iUnitDgQueryApiProxy.queryList(new UnitDgReqDto()))).orElse(Lists.newArrayList());
        Map<String, Integer> unitMap = unitDgRespDtoList.stream().collect(Collectors.toMap(UnitDgRespDto::getCode, UnitDgRespDto::getDecimalLimit, (k1, k2) -> k1));
        itemSkuPageRespDtoList.forEach(itemSkuPageRespDto -> {
            itemSkuPageRespDto.setAvailable((BigDecimal)skuCodeQuantityMap.get(itemSkuPageRespDto.getSkuCode()));
            itemSkuPageRespDto.setDecimalLimit((Integer)unitMap.get(itemSkuPageRespDto.getUnit()));
        });
        dtoPageInfo.setList(itemSkuPageRespDtoList);
        return new RestResponse((Object)dtoPageInfo);
    }

    @Override
    public PageInfo<DgItemSkuPageRespDto> querySkuPage(ItemQueryDgReqDto reqDto) {
        PageInfo dgItemSkuPageRespDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.iItemSkuDgQueryApiProxy.queryItemListByPage(reqDto));
        if (CollectionUtil.isEmpty((Collection)dgItemSkuPageRespDtoPageInfo.getList())) {
            return new PageInfo();
        }
        List skuDetailRespDtos = dgItemSkuPageRespDtoPageInfo.getList();
        List skuCodeList = skuDetailRespDtos.stream().map(DgItemSkuRespDto::getSkuCode).collect(Collectors.toList());
        List unitList = skuDetailRespDtos.stream().map(DgItemSkuRespDto::getUnit).collect(Collectors.toList());
        UnitDgReqDto unitDgReqDto = new UnitDgReqDto();
        unitDgReqDto.setCodeList(unitList);
        List unitDgRespDtos = (List)Optional.ofNullable(RestResponseHelper.extractData((RestResponse)this.iUnitDgQueryApiProxy.queryList(unitDgReqDto))).orElse(Lists.newArrayList());
        Map<String, List<UnitDgRespDto>> unitMap = unitDgRespDtos.stream().collect(Collectors.groupingBy(UnitDgRespDto::getCode));
        DgLogicInventoryTotalPageReqDto pageReqDto = new DgLogicInventoryTotalPageReqDto();
        pageReqDto.setSkuCodeList(skuCodeList);
        pageReqDto.setLogicWarehouseCode(reqDto.getLogicWarehouseCode());
        pageReqDto.setInventoryPropertyList((List)org.assertj.core.util.Lists.newArrayList((Object[])new String[]{LogicWarehouseQualityEnum.QUALIFIED.getCode()}));
        List dgLogicInventoryTotalDtos = (List)Optional.ofNullable(RestResponseHelper.extractData((RestResponse)this.iDgLogicInventoryTotalApiProxy.queryList(pageReqDto))).orElse(Lists.newArrayList());
        Map skuCodeMap = dgLogicInventoryTotalDtos.stream().collect(Collectors.toMap(DgLogicInventoryTotalDto::getSkuCode, Function.identity(), (o1, o2) -> o1));
        skuDetailRespDtos.forEach(dto -> {
            DgLogicInventoryTotalDto logicInventoryTotalDto;
            if (skuCodeMap.containsKey(dto.getSkuCode()) && (logicInventoryTotalDto = (DgLogicInventoryTotalDto)skuCodeMap.get(dto.getSkuCode())) != null) {
                dto.setAvailable(logicInventoryTotalDto.getAvailable());
                dto.setBalance(logicInventoryTotalDto.getBalance());
            }
            if (unitMap.containsKey(dto.getUnit())) {
                dto.setUnitConvertList((List)unitMap.get(dto.getUnit()));
            }
        });
        return dgItemSkuPageRespDtoPageInfo;
    }

    private Map<String, BigDecimal> getSkuCodeQuantityMap(ItemQueryDgReqDto dto, List<String> skuCodeList) {
        ErpInventoryNumQueryDto erpInventoryNumQueryDto = new ErpInventoryNumQueryDto();
        erpInventoryNumQueryDto.setItemCodes(skuCodeList);
        erpInventoryNumQueryDto.setCompanyCode(dto.getCompanyCode());
        List availNumberDtoList = (List)Optional.ofNullable(RestResponseHelper.extractData((RestResponse)this.iExternalInventoryErpApiProxy.batchQueryAvailInventoryNumber(erpInventoryNumQueryDto))).orElse(Lists.newArrayList());
        HashMap skuCodeQuantityMap = Maps.newHashMap();
        for (ErpInventoryAvailNumberDto erpInventoryAvailNumberDto : availNumberDtoList) {
            skuCodeQuantityMap.put(erpInventoryAvailNumberDto.getItemCode(), BigDecimalUtils.parse((String)String.valueOf(erpInventoryAvailNumberDto.getAvailableQuantity())));
        }
        return skuCodeQuantityMap;
    }
}

