/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.mgmt.service.impl;

import cn.afterturn.easypoi.excel.entity.result.ExcelImportResult;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.rest.RestResponse;
import com.github.pagehelper.PageInfo;
import com.yundt.boot.center.data.api.query.IDictQueryApi;
import com.yundt.boot.center.data.dto.dto.DictDto;
import com.yundt.boot.center.data.dto.dto.DictValueDto;
import com.yundt.boot.center.data.dto.request.AreaQueryNameReqDto;
import com.yundt.boot.center.data.dto.response.AreaExtRespDto;
import com.yunxi.dg.base.center.customer.api.api.IDgCsShipmentEnterpriseApi;
import com.yunxi.dg.base.center.customer.api.query.IDgCsShipmentEnterpriseQueryApi;
import com.yunxi.dg.base.center.customer.dto.request.DgCsShipmentEnterprisePageReqDto;
import com.yunxi.dg.base.center.customer.dto.request.DgCsShipmentEnterpriseReqDto;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import com.yunxi.dg.base.mgmt.application.rpc.proxy.query.IAreaExtQueryApiProxy;
import com.yunxi.dg.base.ocs.mgmt.application.dto.enums.FileModeTypeEnum;
import com.yunxi.dg.base.ocs.mgmt.application.dto.enums.FileOperationStatusEnum;
import com.yunxi.dg.base.ocs.mgmt.application.dto.enums.ShipmentEnterpriseTypeEnum;
import com.yunxi.dg.base.ocs.mgmt.application.dto.request.ShipmentEnterpriseImportReqDto;
import com.yunxi.dg.base.poi.dto.ImportBaseModeDto;
import com.yunxi.dg.base.poi.dto.ImportFileOperationCommonReqDto;
import com.yunxi.dg.base.poi.dto.ImportFileOperationCommonRespDto;
import com.yunxi.dg.base.poi.service.AbstractBaseFileOperationCommonService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.assertj.core.util.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service(value="AbstractBaseFileOperationCommonService_shipment_enterprise_import")
public class ShipmentEnterpriseValueCommonServiceImpl
extends AbstractBaseFileOperationCommonService {
    private static final Logger log = LoggerFactory.getLogger(ShipmentEnterpriseValueCommonServiceImpl.class);
    @Resource
    IDgCsShipmentEnterpriseApi iDgCsShipmentEnterpriseApi;
    @Resource
    IDgCsShipmentEnterpriseQueryApi iDgCsShipmentEnterpriseQueryApi;
    @Resource
    private IAreaExtQueryApiProxy areaExtQueryApiProxy;
    @Resource
    private IDictQueryApi iDictQueryApi;

    public Object verifyImportFileOperationCommon(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto) {
        ArrayList list = new ArrayList();
        if (CollectionUtil.isEmpty((Collection)result.getList())) {
            return new ArrayList();
        }
        CubeBeanUtils.copyCollection(list, (Collection)result.getList(), ShipmentEnterpriseImportReqDto.class);
        ArrayList<ShipmentEnterpriseImportReqDto> passList = new ArrayList<ShipmentEnterpriseImportReqDto>();
        ArrayList reqList = new ArrayList();
        list.forEach(o -> {
            AreaQueryNameReqDto reqDto = new AreaQueryNameReqDto();
            if (StrUtil.isNotBlank((CharSequence)o.getProvinceAndCode())) {
                String[] provinceSplit = o.getProvinceAndCode().split("\\|");
                reqDto.setProvinceName(provinceSplit[0]);
                log.info("\u5207\u5206\u540e\u7684\u7701:" + provinceSplit[0]);
                o.setProvince(provinceSplit[0]);
                o.setProvinceCode(provinceSplit[1]);
            }
            if (StrUtil.isNotBlank((CharSequence)o.getCityAndCode())) {
                String[] citySplit = o.getCityAndCode().split("\\|");
                reqDto.setCityName(citySplit[0]);
                log.info("\u5207\u5206\u540e\u7684\u5e02:" + citySplit[0]);
                o.setCity(citySplit[0]);
                o.setCityCode(citySplit[1]);
            }
            if (StrUtil.isNotBlank((CharSequence)o.getCountyAndCode())) {
                String[] countySplit = o.getCountyAndCode().split("\\|");
                reqDto.setAreaName(countySplit[0]);
                log.info("\u5207\u5206\u540e\u7684\u533a:" + countySplit[0]);
                o.setCounty(countySplit[0]);
                o.setCountyCode(countySplit[1]);
            }
            reqList.add(reqDto);
        });
        List areaExtRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.areaExtQueryApiProxy.queryByAreaName(reqList));
        Map<String, AreaExtRespDto> areaMap = ((List)Optional.ofNullable(areaExtRespDtos).orElse(new ArrayList())).stream().collect(Collectors.toMap(o -> o.getProvinceName() + o.getCityName() + o.getAreaName(), Function.identity(), (k1, k2) -> k1));
        for (ShipmentEnterpriseImportReqDto seImportReqDto : list) {
            Boolean verify = this.unitVerify(seImportReqDto, areaMap);
            if (verify.booleanValue()) {
                passList.add(seImportReqDto);
                continue;
            }
            seImportReqDto.setErrorMsg(String.format("\u7b2c%s\u884c\u6570\u636e\u6709\u8bef,%s", seImportReqDto.getRowNum() + FileModeTypeEnum.getInstance((String)commonReqDto.getKey()).getHeadRows(), seImportReqDto.getErrorMsg()));
            respDto.getErrorDetails().add(seImportReqDto);
        }
        respDto.setDetails(passList);
        return passList;
    }

    private Boolean unitVerify(ShipmentEnterpriseImportReqDto seImportReqDto, Map<String, AreaExtRespDto> areaMap) {
        if (Objects.isNull(seImportReqDto.getCode())) {
            seImportReqDto.setErrorMsg("\u7269\u6d41\u5546\u7f16\u7801\u4e0d\u53ef\u4e3a\u7a7a");
            return false;
        }
        ShipmentEnterpriseImportReqDto importReqDto = new ShipmentEnterpriseImportReqDto();
        importReqDto.setCode(seImportReqDto.getCode());
        if (this.EntityExist(importReqDto).booleanValue()) {
            seImportReqDto.setErrorMsg(seImportReqDto.getName() + "\u7269\u6d41\u5546\u7f16\u7801\u5df2\u5b58\u5728");
            return false;
        }
        if (!this.RegexMatch(importReqDto.getCode()).booleanValue()) {
            seImportReqDto.setErrorMsg("\u7269\u6d41\u5546\u7f16\u7801\u53ea\u652f\u6301\u6570\u5b57\u3001\u82f1\u6587\u5b57\u6bcd\u3001\u6807\u70b9\u7b26\u53f7\uff0c\u8bf7\u68c0\u67e5");
            return false;
        }
        if (Objects.isNull(seImportReqDto.getName())) {
            seImportReqDto.setErrorMsg("\u7269\u6d41\u5546\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
            return false;
        }
        importReqDto = new ShipmentEnterpriseImportReqDto();
        importReqDto.setName(seImportReqDto.getName());
        if (this.EntityExist(importReqDto).booleanValue()) {
            seImportReqDto.setErrorMsg(seImportReqDto.getName() + "\u7269\u6d41\u5546\u540d\u79f0\u5df2\u5b58\u5728");
            return false;
        }
        if (Objects.isNull(seImportReqDto.getType())) {
            seImportReqDto.setErrorMsg("\u7269\u6d41\u5546\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
            return false;
        }
        if (Objects.isNull(seImportReqDto.getLogisticsType())) {
            seImportReqDto.setErrorMsg("\u627f\u8fd0\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a");
            return false;
        }
        if (StringUtils.isNotBlank((CharSequence)seImportReqDto.getProvinceAndCode()) || StringUtils.isNotBlank((CharSequence)seImportReqDto.getCityAndCode()) || StringUtils.isNotBlank((CharSequence)seImportReqDto.getCountyAndCode())) {
            String key = seImportReqDto.getProvince() + seImportReqDto.getCity() + seImportReqDto.getCounty();
            log.info("\u7701\u5e02\u533a\u5408\u5e76\u540e\u7684\u5b57\u7b26\u4e32\uff1a" + key);
            AreaExtRespDto areaExtRespDto = areaMap.get(key);
            if (ObjectUtil.isEmpty((Object)areaExtRespDto)) {
                seImportReqDto.setErrorMsg("\u7701\u5e02\u533a\u627e\u4e0d\u5230\u5bf9\u5e94\u6570\u636e");
                return false;
            }
        }
        if (Objects.isNull(seImportReqDto.getContactAddress())) {
            seImportReqDto.setErrorMsg("\u8be6\u7ec6\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a");
            return false;
        }
        String trim = seImportReqDto.getContactAddress().trim();
        if (trim.length() > 32) {
            seImportReqDto.setErrorMsg("\u8be6\u7ec6\u5730\u5740\u4e0d\u80fd\u8d85\u8fc732\u4e2a\u5b57\u7b26");
            return false;
        }
        if (Objects.isNull(seImportReqDto.getContact())) {
            seImportReqDto.setErrorMsg("\u8054\u7cfb\u4eba\u4e0d\u80fd\u4e3a\u7a7a");
            return false;
        }
        trim = seImportReqDto.getContact().trim();
        if (trim.length() > 32) {
            seImportReqDto.setErrorMsg("\u8054\u7cfb\u4eba\u4e0d\u80fd\u8d85\u8fc732\u4e2a\u5b57\u7b26");
            return false;
        }
        if (Objects.isNull(seImportReqDto.getContactPhone())) {
            seImportReqDto.setErrorMsg("\u8054\u7cfb\u7535\u8bdd\u4e0d\u80fd\u4e3a\u7a7a");
            return false;
        }
        trim = seImportReqDto.getContactPhone().trim();
        if (trim.length() > 32) {
            seImportReqDto.setErrorMsg("\u8054\u7cfb\u7535\u8bdd\u4e0d\u80fd\u8d85\u8fc732\u4e2a\u5b57\u7b26");
            return false;
        }
        return true;
    }

    private Boolean RegexMatch(String code) {
        Pattern pattern = Pattern.compile("[a-zA-Z0-9\\.\\,\\?\\!\\;\\:\\-\\_\\=\\+\\*\\/\\\\\\#\\@\\$\\%\\^\\&\\(\\)]+");
        return pattern.matcher(code).matches();
    }

    private Boolean EntityExist(ShipmentEnterpriseImportReqDto importReqDto) {
        DgCsShipmentEnterprisePageReqDto pageReqDto = new DgCsShipmentEnterprisePageReqDto();
        BeanUtils.copyProperties((Object)importReqDto, (Object)pageReqDto);
        List list = ((PageInfo)this.iDgCsShipmentEnterpriseQueryApi.page(pageReqDto).getData()).getList();
        if (CollectionUtil.isNotEmpty((Collection)list) && list.size() > 0) {
            return true;
        }
        return false;
    }

    public void callBackImportFileOperationCommonAsync(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto, Object object) {
        List passList = (List)object;
        if (CollectionUtil.isEmpty((Collection)passList)) {
            respDto.setStatus(FileOperationStatusEnum.IMPORT_ERROR.getCode());
            return;
        }
        respDto.setStatus(FileOperationStatusEnum.IMPORT_SUCCESS.getCode());
        if (CollectionUtil.isNotEmpty((Collection)passList) && !respDto.getErrorDetails().isEmpty()) {
            respDto.setStatus(FileOperationStatusEnum.IMPORT_PARTIAL_SUCCESS.getCode());
        }
        log.info("\u4e0a\u4e0b\u6587userCode:{}", (Object)commonReqDto.getCreatePerson());
        ArrayList reqDtos = Lists.newArrayList();
        DictDto dictDto = (DictDto)RestResponseHelper.extractData((RestResponse)this.iDictQueryApi.queryByGroupCodeAndCode("customer_logistics_mode", "customer_logistics_mode"));
        AssertUtils.notNull((Object)dictDto, (String)"\u67e5\u8be2\u6570\u5b57\u5b57\u5178\u8fd4\u56de\u96c6\u5408\u4e3a\u7a7a");
        if (Objects.nonNull(dictDto)) {
            List dictValueList = dictDto.getDictValueList();
            HashMap<String, String> dictMap = new HashMap<String, String>();
            Iterator iterator = dictValueList.iterator();
            while (iterator.hasNext()) {
                DictValueDto dto = (DictValueDto)iterator.next();
                dictMap.put(dto.getLabel(), dto.getValue());
            }
            for (ShipmentEnterpriseImportReqDto shipmentEnterpriseImportReqDto : passList) {
                String[] split = shipmentEnterpriseImportReqDto.getLogisticsType().split(",");
                ArrayList<String> convertList = new ArrayList<String>();
                for (String label : split) {
                    String value = (String)dictMap.get(label);
                    if (value == null) continue;
                    convertList.add(value);
                }
                String resultLogisticsType = String.join((CharSequence)",", convertList);
                shipmentEnterpriseImportReqDto.setLogisticsType(resultLogisticsType);
                log.info("\u8f6c\u6362\u540e\u7684\u627f\u8fd0\u65b9\u5f0f:" + shipmentEnterpriseImportReqDto.getLogisticsType());
            }
        }
        try {
            for (ShipmentEnterpriseImportReqDto importReqDto : passList) {
                DgCsShipmentEnterpriseReqDto reqDto = new DgCsShipmentEnterpriseReqDto();
                BeanUtils.copyProperties((Object)importReqDto, (Object)reqDto);
                Optional<Integer> code = Arrays.stream(ShipmentEnterpriseTypeEnum.values()).filter(i -> i.getValue().equals(importReqDto.getType())).map(i -> i.getCode()).findFirst();
                if (!code.isPresent()) {
                    log.info("\u7269\u6d41\u5546\u7c7b\u578b\u4f20\u5165\u6709\u8bef\uff01");
                }
                reqDto.setType(code.get());
                reqDtos.add(reqDto);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.iDgCsShipmentEnterpriseApi.batchInsert((List)reqDtos);
    }
}

