/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.mgmt.service.impl;

import cn.afterturn.easypoi.excel.entity.result.ExcelImportResult;
import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.mgmt.application.rpc.proxy.reconciliationbiz.IChannelBillApiProxy;
import com.yunxi.dg.base.ocs.mgmt.application.dto.enums.ChannelEnum;
import com.yunxi.dg.base.ocs.mgmt.application.dto.enums.FileModeTypeEnum;
import com.yunxi.dg.base.ocs.mgmt.application.dto.enums.FileOperationStatusEnum;
import com.yunxi.dg.base.ocs.mgmt.application.dto.request.ImportXzyWxBillDto;
import com.yunxi.dg.base.ocs.mgmt.application.dto.response.ChannelBillDto;
import com.yunxi.dg.base.poi.dto.ImportBaseModeDto;
import com.yunxi.dg.base.poi.dto.ImportFileOperationCommonReqDto;
import com.yunxi.dg.base.poi.dto.ImportFileOperationCommonRespDto;
import com.yunxi.dg.base.poi.service.AbstractBaseFileOperationCommonService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="AbstractBaseFileOperationCommonService_xzy_bill_import")
public class XzyBillCommonServiceImpl
extends AbstractBaseFileOperationCommonService {
    private static final Logger log = LoggerFactory.getLogger(XzyBillCommonServiceImpl.class);
    @Resource
    protected IChannelBillApiProxy channelBillApi;

    public Object verifyImportFileOperationCommon(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto) {
        ArrayList list = new ArrayList();
        if (CollectionUtil.isEmpty((Collection)result.getList())) {
            return new ArrayList();
        }
        CubeBeanUtils.copyCollection(list, (Collection)result.getList(), ImportXzyWxBillDto.class);
        ArrayList<ImportXzyWxBillDto> passList = new ArrayList<ImportXzyWxBillDto>();
        for (ImportXzyWxBillDto dto : list) {
            dto.setBillTime(StringUtils.replace((String)dto.getBillTime(), (String)"`", (String)""));
            dto.setBalance(StringUtils.replace((String)dto.getBalance(), (String)"`", (String)""));
            dto.setBusinessName(StringUtils.replace((String)dto.getBusinessName(), (String)"`", (String)""));
            dto.setBusinessType(StringUtils.replace((String)dto.getBusinessType(), (String)"`", (String)""));
            dto.setBusinessVoucherNo(StringUtils.replace((String)dto.getBusinessVoucherNo(), (String)"`", (String)""));
            dto.setRemark(StringUtils.replace((String)dto.getRemark(), (String)"`", (String)""));
            dto.setChangeApplyPerson(StringUtils.replace((String)dto.getChangeApplyPerson(), (String)"`", (String)""));
            dto.setFlowNo(StringUtils.replace((String)dto.getFlowNo(), (String)"`", (String)""));
            dto.setSzAmount(StringUtils.replace((String)dto.getSzAmount(), (String)"`", (String)""));
            dto.setSzType(StringUtils.replace((String)dto.getSzType(), (String)"`", (String)""));
            dto.setWechatOrderNo(StringUtils.replace((String)dto.getWechatOrderNo(), (String)"`", (String)""));
            Boolean billVerify = this.verify(dto);
            if (!billVerify.booleanValue()) {
                dto.setErrorMsg(String.format("\u7b2c%s\u884c\u6570\u636e\u6709\u8bef,%s", dto.getRowNum() + FileModeTypeEnum.getInstance((String)commonReqDto.getKey()).getHeadRows(), dto.getErrorMsg()));
                respDto.getErrorDetails().add(dto);
                continue;
            }
            passList.add(dto);
        }
        respDto.setDetails(passList);
        return passList;
    }

    public void callBackImportFileOperationCommonAsync(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto, Object object) {
        List passList = (List)object;
        if (CollectionUtil.isEmpty((Collection)passList)) {
            respDto.setStatus(FileOperationStatusEnum.IMPORT_ERROR.getCode());
            return;
        }
        respDto.setStatus(FileOperationStatusEnum.IMPORT_SUCCESS.getCode());
        if (CollectionUtil.isNotEmpty((Collection)passList) && !respDto.getErrorDetails().isEmpty()) {
            respDto.setStatus(FileOperationStatusEnum.IMPORT_PARTIAL_SUCCESS.getCode());
        }
        ArrayList channelBillDtos = Lists.newArrayList();
        try {
            for (ImportXzyWxBillDto billDto : passList) {
                ChannelBillDto dto = new ChannelBillDto();
                dto.setChannelCode(ChannelEnum.XZY.getCode());
                dto.setChannelName(ChannelEnum.XZY.getName());
                dto.setSerialNo(billDto.getWechatOrderNo());
                dto.setPlatformSerialNo(billDto.getBusinessVoucherNo());
                dto.setUniqueSerialNo(billDto.getWechatOrderNo().concat(billDto.getBusinessType()));
                dto.setProduceDate(DateUtil.parseDate((String)billDto.getBillTime(), (String)"yyyy-MM-dd HH:mm:ss"));
                dto.setData(JSON.toJSONString((Object)billDto));
                this.setCreatePerson(commonReqDto, dto);
                channelBillDtos.add(dto);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        log.info("\u6279\u91cf\u4fdd\u5b58\u9500\u8d5e\u4e91\u539f\u59cb\u8d26\u5355,\u6570\u91cf\u4e3a:{}", (Object)channelBillDtos.size());
        this.channelBillApi.importInsertBatch((List)channelBillDtos);
    }

    private Boolean verify(ImportXzyWxBillDto dto) {
        return true;
    }

    protected void setCreatePerson(ImportFileOperationCommonReqDto commonReqDto, ChannelBillDto dto) {
        dto.setCreatePerson(commonReqDto.getCreatePerson());
        dto.setUpdatePerson(commonReqDto.getCreatePerson());
    }
}

