/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.mgmt.service.utils;

import java.util.function.BiConsumer;
import java.util.function.Function;

public class CostDateUtils {
    public static String format(Integer date, String type) {
        if (type == null) {
            return date == null ? null : date.toString();
        }
        switch (type) {
            case "date": {
                return CostDateUtils.formatDate(date);
            }
            case "month": {
                return CostDateUtils.formatMonth(date);
            }
            case "quarter": {
                return CostDateUtils.formatQuarter(date);
            }
        }
        return date == null ? null : date.toString();
    }

    public static <T> void formatDate(T t, String type, Function<T, Integer> getter, BiConsumer<T, String> setter) {
        if (t == null) {
            return;
        }
        Integer value = getter.apply(t);
        if (value == null) {
            return;
        }
        setter.accept(t, CostDateUtils.format(value, type));
    }

    public static String formatDate(Integer date) {
        if (date == null) {
            return null;
        }
        String str = date.toString();
        return str.substring(0, 4) + "-" + str.substring(4, 6) + "-" + str.substring(6);
    }

    public static String formatMonth(Integer date) {
        if (date == null) {
            return null;
        }
        String str = date.toString();
        return str.substring(0, 4) + "-" + str.substring(4, 6);
    }

    public static String formatQuarter(Integer date) {
        if (date == null) {
            return null;
        }
        String str = date.toString();
        return str.substring(0, 4) + "-Q" + str.substring(4);
    }
}

