/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.mgmt.service.utils;

import com.dtyunxi.cube.commons.exceptions.BizException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;

public class PercentageUtils {
    public static <T> void setPercentages(List<T> list, List<Function<T, BigDecimal>> getters, List<BiConsumer<T, String>> setters, int scale) {
        if (list == null || list.isEmpty()) {
            return;
        }
        if (getters.size() != setters.size()) {
            throw new BizException("getters\u548csetters\u957f\u5ea6\u5fc5\u987b\u4e00\u81f4");
        }
        for (T t : list) {
            PercentageUtils.setPercentage(t, getters, setters, scale);
        }
    }

    public static <T> void setPercentage(T item, List<Function<T, BigDecimal>> getters, List<BiConsumer<T, String>> setters, int scale) {
        if (item == null) {
            return;
        }
        if (getters.size() != setters.size()) {
            throw new BizException("getters\u548csetters\u957f\u5ea6\u5fc5\u987b\u4e00\u81f4");
        }
        for (int i = 0; i < getters.size(); ++i) {
            Function<T, BigDecimal> getter = getters.get(i);
            BiConsumer<T, String> setter = setters.get(i);
            PercentageUtils.setPercentage(item, getter, setter, scale);
        }
    }

    public static <T> void setPercentage(T t, Function<T, BigDecimal> getter, BiConsumer<T, String> setter, int scale) {
        if (t == null) {
            return;
        }
        BigDecimal value = getter.apply(t);
        if (value != null) {
            value = value.multiply(new BigDecimal(100)).setScale(scale, RoundingMode.HALF_UP);
            String p = value.stripTrailingZeros().toPlainString() + "%";
            setter.accept(t, p);
        }
    }
}

