/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.mgmt.service.finance.impl;

import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSONObject;
import com.aliyun.openservices.shade.org.apache.commons.lang3.StringUtils;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.rest.RestResponse;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.finance.dto.entity.BookkeepingVerificationReportQueryDto;
import com.yunxi.dg.base.center.finance.dto.entity.InvoiceReconciliationReportQueryDto;
import com.yunxi.dg.base.center.finance.dto.request.BillInfoReportQueryDto;
import com.yunxi.dg.base.center.finance.dto.response.BillInfoReportRespDto;
import com.yunxi.dg.base.center.finance.proxy.entity.IBillInfoApiProxy;
import com.yunxi.dg.base.center.finance.proxy.entity.IInvoiceReconciliationReportApiProxy;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import com.yunxi.dg.base.mgmt.service.finance.FinancialManagementInvoiceManagementInvoicedReportService;
import com.yunxi.dg.base.ocs.mgmt.application.dto.finance.BookkeepingVerificationReporQueryParams;
import com.yunxi.dg.base.ocs.mgmt.application.dto.finance.BookkeepingVerificationReportVo;
import com.yunxi.dg.base.ocs.mgmt.application.dto.finance.GetInvoicedReportListPageParams;
import com.yunxi.dg.base.ocs.mgmt.application.dto.finance.InvoiceReconciliationReportQueryParams;
import com.yunxi.dg.base.ocs.mgmt.application.dto.finance.InvoiceReconciliationReportVo;
import com.yunxi.dg.base.ocs.mgmt.application.dto.finance.InvoicedReportVO;
import com.yunxi.dg.base.poi.service.AbstractBaseFileOperationCommonService;
import io.swagger.annotations.ApiParam;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.validation.Valid;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestBody;

@Service(value="abstractFileOperationCommonService_bill_report")
public class FinancialManagementInvoiceManagementInvoicedReportServiceServiceImpl
extends AbstractBaseFileOperationCommonService
implements FinancialManagementInvoiceManagementInvoicedReportService {
    private static final Logger logger = LoggerFactory.getLogger(FinancialManagementInvoiceManagementInvoicedReportServiceServiceImpl.class);
    @Resource
    private IBillInfoApiProxy billInfoQueryApi;
    @Resource
    private IInvoiceReconciliationReportApiProxy reportApiProxy;

    @Override
    public RestResponse<PageInfo<InvoicedReportVO>> getInvoicedReportListPage(@ApiParam(value="") @Valid @RequestBody(required=false) GetInvoicedReportListPageParams getInvoicedReportListPageParams) {
        BillInfoReportQueryDto billInfoReportQueryDto = new BillInfoReportQueryDto();
        this.queryPageParam(billInfoReportQueryDto, getInvoicedReportListPageParams);
        billInfoReportQueryDto.setQueryFlag("query");
        RestResponse pageInfoRestResponse = this.billInfoQueryApi.queryBillInfoReportPage(billInfoReportQueryDto);
        PageInfo dtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)pageInfoRestResponse);
        PageInfo pageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)pageInfo, (Object)dtoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        if (CollectionUtils.isEmpty((Collection)dtoPageInfo.getList())) {
            new RestResponse((Object)pageInfo);
        }
        List invoicedReportVOList = dtoPageInfo.getList().stream().map(billInfo -> {
            InvoicedReportVO invoicedReportVO = new InvoicedReportVO();
            this.getInvoiceResponseParams(invoicedReportVO, (BillInfoReportRespDto)billInfo);
            return invoicedReportVO;
        }).collect(Collectors.toList());
        pageInfo.setList(invoicedReportVOList);
        return new RestResponse((Object)pageInfo);
    }

    @Override
    public RestResponse<PageInfo<InvoiceReconciliationReportVo>> getInvoicedReconciliationReportListPage(InvoiceReconciliationReportQueryParams params) {
        InvoiceReconciliationReportQueryDto queryDto = new InvoiceReconciliationReportQueryDto();
        this.queryInvoiceReportPageParam(queryDto, params);
        logger.info("\u53d1\u7968\u6838\u5bf9\u62a5\u8868\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)queryDto));
        PageInfo dtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.reportApiProxy.queryPage(queryDto));
        PageInfo pageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)pageInfo, (Object)dtoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        if (CollectionUtils.isEmpty((Collection)dtoPageInfo.getList())) {
            new RestResponse((Object)pageInfo);
        }
        List reconciliationReportVos = dtoPageInfo.getList().stream().map(v -> {
            InvoiceReconciliationReportVo reconciliationReportVo = new InvoiceReconciliationReportVo();
            CubeBeanUtils.copyProperties((Object)reconciliationReportVo, (Object)v, (String[])new String[0]);
            return reconciliationReportVo;
        }).collect(Collectors.toList());
        pageInfo.setList(reconciliationReportVos);
        return new RestResponse((Object)pageInfo);
    }

    public void queryInvoiceReportPageParam(InvoiceReconciliationReportQueryDto queryDto, InvoiceReconciliationReportQueryParams params) {
        queryDto.setPageNum(params.getPageNum());
        queryDto.setPageSize(params.getPageSize());
        if (StringUtils.isNotBlank((CharSequence)params.getSkuCode())) {
            queryDto.setSkuCode(params.getSkuCode());
        }
        if (CollectionUtils.isNotEmpty((Collection)params.getSkuCodeList())) {
            queryDto.setSkuCodeList(params.getSkuCodeList());
        }
        if (CollectionUtils.isNotEmpty((Collection)params.getPlatformOrderNoList())) {
            queryDto.setPlatformOrderNoList(params.getPlatformOrderNoList());
        }
        if (StringUtils.isNotBlank((CharSequence)params.getPlatformOrderNo())) {
            queryDto.setPlatformOrderNo(params.getPlatformOrderNo());
        }
        if (StringUtils.isNotBlank((CharSequence)params.getShopCode())) {
            queryDto.setShopCode(params.getShopCode());
        }
        if (CollectionUtils.isNotEmpty((Collection)params.getShopCodeList())) {
            queryDto.setShopCodeList(params.getShopCodeList());
        }
        if (StringUtils.isNotBlank((CharSequence)params.getChannelCode())) {
            queryDto.setChannelCode(params.getChannelCode());
        }
        if (CollectionUtils.isNotEmpty((Collection)params.getChannelCodeList())) {
            queryDto.setChannelCodeList(params.getChannelCodeList());
        }
        if (StringUtils.isNotBlank((CharSequence)params.getCustomerCode())) {
            queryDto.setCustomerCode(params.getCustomerCode());
        }
        if (CollectionUtils.isNotEmpty((Collection)params.getCustomerCodeList())) {
            queryDto.setCustomerCodeList(params.getCustomerCodeList());
        }
        if (StringUtils.isNotBlank((CharSequence)params.getDifference())) {
            queryDto.setDifference(params.getDifference());
        }
        if (StringUtils.isNotBlank((CharSequence)params.getBusinessStarDate())) {
            queryDto.setBusinessStarDate(params.getBusinessStarDate());
        }
        if (StringUtils.isNotBlank((CharSequence)params.getBusinessEndDate())) {
            queryDto.setBusinessEndDate(params.getBusinessEndDate());
        }
        if (StringUtils.isNotBlank((CharSequence)params.getChargeStartDate())) {
            queryDto.setChargeStartDate(params.getChargeStartDate());
        }
        if (StringUtils.isNotBlank((CharSequence)params.getChargeEndDate())) {
            queryDto.setChargeEndDate(params.getChargeEndDate());
        }
        if (StringUtils.isNotBlank((CharSequence)params.getInvoiceStartDate())) {
            queryDto.setInvoiceStartDate(params.getInvoiceStartDate());
        }
        if (StringUtils.isNotBlank((CharSequence)params.getInvoiceEndDate())) {
            queryDto.setInvoiceEndDate(params.getInvoiceEndDate());
        }
    }

    @Override
    public RestResponse<PageInfo<BookkeepingVerificationReportVo>> getVerificationReport(BookkeepingVerificationReporQueryParams params) {
        BookkeepingVerificationReportQueryDto queryDto = new BookkeepingVerificationReportQueryDto();
        this.queryVerificationReportParam(queryDto, params);
        PageInfo dtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.reportApiProxy.verificationReport(queryDto));
        PageInfo pageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)pageInfo, (Object)dtoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        if (CollectionUtils.isEmpty((Collection)dtoPageInfo.getList())) {
            new RestResponse((Object)pageInfo);
        }
        List verificationReporVos = dtoPageInfo.getList().stream().map(v -> {
            BookkeepingVerificationReportVo verificationReporVo = new BookkeepingVerificationReportVo();
            CubeBeanUtils.copyProperties((Object)verificationReporVo, (Object)v, (String[])new String[0]);
            return verificationReporVo;
        }).collect(Collectors.toList());
        pageInfo.setList(verificationReporVos);
        return new RestResponse((Object)pageInfo);
    }

    public void queryVerificationReportParam(BookkeepingVerificationReportQueryDto queryDto, BookkeepingVerificationReporQueryParams params) {
        queryDto.setPageNum(params.getPageNum());
        queryDto.setPageSize(params.getPageSize());
        if (CollectionUtils.isNotEmpty((Collection)params.getOrderNoList())) {
            queryDto.setOrderNoList(params.getOrderNoList());
        }
        if (StringUtils.isNotBlank((CharSequence)params.getOrderNo())) {
            queryDto.setOrderNo(params.getOrderNo());
        }
        if (StringUtils.isNotBlank((CharSequence)params.getShopCode())) {
            queryDto.setShopCode(params.getShopCode());
        }
        if (CollectionUtils.isNotEmpty((Collection)params.getShopCodeList())) {
            queryDto.setShopCodeList(params.getShopCodeList());
        }
        if (StringUtils.isNotBlank((CharSequence)params.getVarianceType())) {
            queryDto.setVarianceType(params.getVarianceType());
        }
        if (StringUtils.isNotBlank((CharSequence)params.getBusinessStarDate())) {
            queryDto.setBusinessStarDate(params.getBusinessStarDate());
        }
        if (StringUtils.isNotBlank((CharSequence)params.getBusinessEndDate())) {
            queryDto.setBusinessEndDate(params.getBusinessEndDate());
        }
    }

    public void queryPageParam(BillInfoReportQueryDto billInfoReportQueryDto, GetInvoicedReportListPageParams getInvoicedReportListPageParams) {
        billInfoReportQueryDto.setPageNum(getInvoicedReportListPageParams.getPageNum());
        billInfoReportQueryDto.setPageSize(getInvoicedReportListPageParams.getPageSize());
        if (StringUtils.isNotBlank((CharSequence)getInvoicedReportListPageParams.getInvoicingDateStart())) {
            billInfoReportQueryDto.setExternalInvoiceBeginTime(getInvoicedReportListPageParams.getInvoicingDateStart() + " 00:00:00");
        }
        if (StringUtils.isNotBlank((CharSequence)getInvoicedReportListPageParams.getInvoicingDateEnd())) {
            billInfoReportQueryDto.setExternalInvoiceEndTime(getInvoicedReportListPageParams.getInvoicingDateEnd() + " 23:59:59");
        }
        if (CollectionUtils.isNotEmpty((Collection)getInvoicedReportListPageParams.getEnterpriseList())) {
            billInfoReportQueryDto.setEnterpriseList(getInvoicedReportListPageParams.getEnterpriseList());
        }
        if (CollectionUtils.isNotEmpty((Collection)getInvoicedReportListPageParams.getEnterpriseIdList())) {
            billInfoReportQueryDto.setEnterpriseIdList(getInvoicedReportListPageParams.getEnterpriseIdList());
        }
        if (CollectionUtils.isNotEmpty((Collection)getInvoicedReportListPageParams.getInvoiceChannelList())) {
            billInfoReportQueryDto.setBillChannelList(getInvoicedReportListPageParams.getInvoiceChannelList());
        }
        if (StringUtils.isNotBlank((CharSequence)getInvoicedReportListPageParams.getShopCode())) {
            ArrayList<String> shopCodeList = new ArrayList<String>();
            shopCodeList.add(getInvoicedReportListPageParams.getShopCode());
            billInfoReportQueryDto.setShopCodeList(shopCodeList);
        }
        if (CollectionUtils.isNotEmpty((Collection)getInvoicedReportListPageParams.getInvoiceAccountTypeList())) {
            billInfoReportQueryDto.setBillTypeList(getInvoicedReportListPageParams.getInvoiceAccountTypeList());
        }
        if (CollectionUtils.isNotEmpty((Collection)getInvoicedReportListPageParams.getInvoiceTypeList())) {
            billInfoReportQueryDto.setInvoiceType(getInvoicedReportListPageParams.getInvoiceTypeList());
        }
    }

    public void getInvoiceResponseParams(InvoicedReportVO invoicedReportVO, BillInfoReportRespDto billInfoRespDto) {
        invoicedReportVO.setId(billInfoRespDto.getId());
        invoicedReportVO.setInvoicedTime(DateUtil.format((Date)billInfoRespDto.getExternalInvoiceTime(), (String)"yyyy-MM-dd HH:mm:ss"));
        invoicedReportVO.setInvoiceTradeNo(billInfoRespDto.getBillFlowNo());
        invoicedReportVO.setPlatformOrderNo(billInfoRespDto.getPlatformOrderNo());
        invoicedReportVO.setStationName(billInfoRespDto.getSite());
        invoicedReportVO.setShopCode(billInfoRespDto.getShopCode());
        invoicedReportVO.setShopName(billInfoRespDto.getShopName());
        invoicedReportVO.setCustomerCode(billInfoRespDto.getCustomerCode());
        invoicedReportVO.setCompanyName(billInfoRespDto.getCustomerName());
        invoicedReportVO.setInvoiceEntityName(billInfoRespDto.getEnterprise());
        invoicedReportVO.setInvoiceChannelName(billInfoRespDto.getBillChannel());
        invoicedReportVO.setInvoiceAccountTypeName(billInfoRespDto.getBillType());
        invoicedReportVO.setInvoiceTypeName(billInfoRespDto.getInvoiceType());
        invoicedReportVO.setInvoiceAmount(null != billInfoRespDto.getInvoiceAmount() ? billInfoRespDto.getInvoiceAmount().stripTrailingZeros().toPlainString() : null);
        invoicedReportVO.setNoTaxRateAmount(null != billInfoRespDto.getExclusiveTaxAmount() ? billInfoRespDto.getExclusiveTaxAmount().stripTrailingZeros() : null);
        invoicedReportVO.setTaxRateAmount(null != billInfoRespDto.getTaxAmount() ? billInfoRespDto.getTaxAmount().stripTrailingZeros() : null);
        invoicedReportVO.setInvoiceNo(billInfoRespDto.getExternalInvoiceNo());
        invoicedReportVO.setInvoiceCode(billInfoRespDto.getExternalInvoiceCode());
        invoicedReportVO.setInvoiceHeader(billInfoRespDto.getBillTitle());
        invoicedReportVO.setTaxpayerIdentificationNo(billInfoRespDto.getTaxesCode());
        invoicedReportVO.setMaterialType(billInfoRespDto.getItemType());
        invoicedReportVO.setInvoiceRemark(billInfoRespDto.getInvoiceRemarks());
    }
}

