/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.mgmt.service.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.rest.RestResponse;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.openapi.dto.req.DgAfterSaleOrderValidReqDto;
import com.yunxi.dg.base.center.openapi.dto.req.DgEsPerformOrderReqDto;
import com.yunxi.dg.base.center.openapi.dto.resp.DgAfterSaleOrderDetailRespDto;
import com.yunxi.dg.base.center.openapi.dto.resp.DgEsPerformOrderRespDto;
import com.yunxi.dg.base.center.openapi.dto.resp.DgPerformOrderItemLineRespDto;
import com.yunxi.dg.base.center.openapi.proxy.trade.IDgPerformOrderApiProxy;
import com.yunxi.dg.base.center.trade.dto.aftersale.DgAfterSaleOrderItemReqDto;
import com.yunxi.dg.base.center.trade.dto.aftersale.DgAfterSaleOrderItemRespDto;
import com.yunxi.dg.base.center.trade.dto.aftersale.DgAfterSaleOrderRespDto;
import com.yunxi.dg.base.center.trade.proxy.aftersale.IDgAfterSaleOrderApiProxy;
import com.yunxi.dg.base.commons.dto.BaseDto;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import com.yunxi.dg.base.mgmt.service.IOcsPerformOrderService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OcsPerformOrderServiceImpl
implements IOcsPerformOrderService {
    private final Logger logger = LoggerFactory.getLogger(OcsPerformOrderServiceImpl.class);
    @Autowired
    private IDgPerformOrderApiProxy iDgPerformOrderApiProxy;
    @Autowired
    private IDgAfterSaleOrderApiProxy iDgAfterSaleOrderApiProxy;

    @Override
    public RestResponse<PageInfo<DgEsPerformOrderRespDto>> queryEsByPage(DgEsPerformOrderReqDto filter) {
        return new RestResponse(RestResponseHelper.extractData((RestResponse)this.iDgPerformOrderApiProxy.queryEsByPage(filter)));
    }

    @Override
    public RestResponse<PageInfo<DgPerformOrderItemLineRespDto>> queryByDetailPage(DgEsPerformOrderReqDto filter) {
        return this.iDgPerformOrderApiProxy.queryByDetailPage(filter);
    }

    @Override
    public RestResponse<PageInfo<DgAfterSaleOrderDetailRespDto>> queryAfterDetailByPage(DgAfterSaleOrderValidReqDto filter) {
        Integer pageNum = filter.getPageNum();
        Integer pageSize = filter.getPageSize();
        this.logger.info("\u67e5\u8be2\u7684\u53c2\u6570\u662f{}", (Object)JSON.toJSONString((Object)filter));
        PageHelper.startPage((int)pageNum, (int)pageSize);
        List dgAfterSaleOrderRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.iDgPerformOrderApiProxy.queryAfterSaleOrderDetail(filter));
        AssertUtils.notEmpty((Collection)dgAfterSaleOrderRespDtos, (String)"\u552e\u540e\u5355\u4e0d\u5b58\u5728");
        this.logger.info("\u8fd4\u56de\u7684\u552e\u540e\u5355\u57fa\u672c\u4fe1\u606f\u662f{}", (Object)JSON.toJSONString((Object)dgAfterSaleOrderRespDtos));
        Map map = dgAfterSaleOrderRespDtos.stream().collect(Collectors.toMap(BaseDto::getId, Function.identity()));
        this.logger.info("\u8fd4\u56de\u7684\u552e\u540e\u5355\u57fa\u7840\u4fe1\u606f\u662f{}", (Object)JSON.toJSONString(map));
        HashMap<Long, List> itemMap = new HashMap<Long, List>();
        for (Object dgAfterSaleOrderRespDto : dgAfterSaleOrderRespDtos) {
            DgAfterSaleOrderItemReqDto dgAfterSaleOrderItemReqDto = new DgAfterSaleOrderItemReqDto();
            dgAfterSaleOrderItemReqDto.setAfterSaleOrderId(dgAfterSaleOrderRespDto.getId());
            RestResponse pageInfoRestResponse = this.iDgAfterSaleOrderApiProxy.queryByPage(dgAfterSaleOrderItemReqDto, filter.getPageNum(), filter.getPageSize());
            PageInfo pageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)pageInfoRestResponse);
            itemMap.put(dgAfterSaleOrderRespDto.getId(), pageInfo.getList());
        }
        this.logger.info("\u8fd4\u56de\u7684\u552e\u540e\u5355\u660e\u7ec6\u4fe1\u606f\u662f{}", (Object)JSON.toJSONString(itemMap));
        ArrayList<DgAfterSaleOrderDetailRespDto> dgAfterSaleOrderDetailRespDtos = new ArrayList<DgAfterSaleOrderDetailRespDto>();
        for (Map.Entry entry : itemMap.entrySet()) {
            for (DgAfterSaleOrderItemRespDto dgAfterSaleOrderItemRespDto : (List)entry.getValue()) {
                DgAfterSaleOrderDetailRespDto dgAfterSaleOrderDetailRespDto = new DgAfterSaleOrderDetailRespDto();
                Long afterSaleOrderId = dgAfterSaleOrderItemRespDto.getAfterSaleOrderId();
                DgAfterSaleOrderRespDto dgAfterSaleOrderRespDto = (DgAfterSaleOrderRespDto)map.get(afterSaleOrderId);
                this.getDgAfterSaleOrderRespDto(dgAfterSaleOrderDetailRespDto, dgAfterSaleOrderRespDto);
                this.getDgAfterSaleOrderItemRespDto(dgAfterSaleOrderDetailRespDto, dgAfterSaleOrderItemRespDto);
                dgAfterSaleOrderDetailRespDtos.add(dgAfterSaleOrderDetailRespDto);
            }
        }
        this.logger.info("\u8fd4\u56de\u7684\u552e\u540e\u5355\u660e\u7ec6\u7ec4\u88c5\u540e\u4fe1\u606f\u662f{}", (Object)JSON.toJSONString(dgAfterSaleOrderDetailRespDtos));
        PageInfo dgAfterSaleOrderDetailRespDtoPageInfo = new PageInfo(dgAfterSaleOrderDetailRespDtos);
        return new RestResponse((Object)dgAfterSaleOrderDetailRespDtoPageInfo);
    }

    private void getDgAfterSaleOrderItemRespDto(DgAfterSaleOrderDetailRespDto dgAfterSaleOrderDetailRespDto, DgAfterSaleOrderItemRespDto dgAfterSaleOrderItemRespDto) {
        BeanUtils.copyProperties((Object)dgAfterSaleOrderItemRespDto, (Object)dgAfterSaleOrderDetailRespDto);
    }

    private void getDgAfterSaleOrderRespDto(DgAfterSaleOrderDetailRespDto dgAfterSaleOrderDetailRespDto, DgAfterSaleOrderRespDto dgAfterSaleOrderRespDto) {
        BeanUtils.copyProperties((Object)dgAfterSaleOrderRespDto, (Object)dgAfterSaleOrderDetailRespDto);
    }
}

