/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.mgmt.service.impl;

import cn.afterturn.easypoi.excel.entity.result.ExcelImportResult;
import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.rest.RestResponse;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.customer.dto.request.DgCustomerInfoQueryExtDto;
import com.yunxi.dg.base.center.customer.proxy.query.ITransactionCustomerQueryApiProxy;
import com.yunxi.dg.base.center.inventory.dto.entity.ShippingMarkManagementDto;
import com.yunxi.dg.base.center.inventory.dto.entity.ShippingMarkManagementPageReqDto;
import com.yunxi.dg.base.center.inventory.proxy.entity.IShippingMarkManagementApiProxy;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import com.yunxi.dg.base.ocs.mgmt.application.dto.enums.FileModeTypeEnum;
import com.yunxi.dg.base.ocs.mgmt.application.dto.request.ImportShippingMarkManagementCustomerReqDto;
import com.yunxi.dg.base.ocs.mgmt.application.dto.response.ExportShippingMarkManagementCustomerRespDto;
import com.yunxi.dg.base.poi.dto.ExportBaseModeDto;
import com.yunxi.dg.base.poi.dto.ExportQueryParamsReqDto;
import com.yunxi.dg.base.poi.dto.ImportBaseModeDto;
import com.yunxi.dg.base.poi.dto.ImportFileOperationCommonReqDto;
import com.yunxi.dg.base.poi.dto.ImportFileOperationCommonRespDto;
import com.yunxi.dg.base.poi.enums.FileOperationStatusEnum;
import com.yunxi.dg.base.poi.service.AbstractBaseFileOperationCommonService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="AbstractBaseFileOperationCommonService_shipping_mark_management_customer")
public class ShippingMarkManagementCustomerCommonServiceImpl
extends AbstractBaseFileOperationCommonService {
    private static final Logger log = LoggerFactory.getLogger(ShippingMarkManagementCustomerCommonServiceImpl.class);
    @Resource
    private IShippingMarkManagementApiProxy iShippingMarkManagementApiProxy;
    @Resource
    private ITransactionCustomerQueryApiProxy iTransactionCustomerQueryApiProxy;

    public Object verifyImportFileOperationCommon(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto) {
        log.info("\u5f00\u59cb\u551b\u5934\u7ba1\u7406\u6309\u5ba2\u6237\u5bfc\u5165");
        if (CollectionUtil.isEmpty((Collection)result.getList())) {
            return new ArrayList();
        }
        if (result.getList().size() > 1000) {
            respDto.setErrorMsg("\u6279\u91cf\u5bfc\u5165\u4e0d\u652f\u6301\u8d85\u8fc71000\u884c");
            respDto.setStatus(FileOperationStatusEnum.IMPORT_ERROR.getCode());
            return new ArrayList();
        }
        List list = BeanUtil.copyToList((Collection)result.getList(), ImportShippingMarkManagementCustomerReqDto.class);
        ArrayList passList = Lists.newArrayList();
        List<String> collect = list.stream().map(ImportShippingMarkManagementCustomerReqDto::getCustomerCode).filter(customerCode -> StringUtils.isNotBlank((CharSequence)customerCode)).collect(Collectors.toList());
        for (ImportShippingMarkManagementCustomerReqDto dto : list) {
            boolean isPass = this.paramVerify(dto, collect);
            if (isPass) {
                passList.add(dto);
                continue;
            }
            dto.setErrorMsg(String.format("\u7b2c%s\u884c\u6570\u636e\u6709\u8bef,%s", dto.getRowNum() + FileModeTypeEnum.getInstance((String)commonReqDto.getKey()).getHeadRows(), dto.getErrorMsg()));
            respDto.getErrorDetails().add(dto);
        }
        List reqDto = BeanUtil.copyToList((Collection)passList, ShippingMarkManagementDto.class);
        for (ShippingMarkManagementDto dto : reqDto) {
            ShippingMarkManagementPageReqDto pageReqDto = new ShippingMarkManagementPageReqDto();
            pageReqDto.setCustomerCode(dto.getCustomerCode());
            List shippingMarkManagementDtoList = ((PageInfo)RestResponseHelper.extractData((RestResponse)this.iShippingMarkManagementApiProxy.page(pageReqDto))).getList();
            if (CollectionUtil.isNotEmpty((Collection)shippingMarkManagementDtoList)) {
                RestResponseHelper.checkOrThrow((RestResponse)this.iShippingMarkManagementApiProxy.update(dto));
                continue;
            }
            RestResponseHelper.checkOrThrow((RestResponse)this.iShippingMarkManagementApiProxy.insert(dto));
        }
        respDto.setDetails((List)passList);
        return passList;
    }

    public List<? extends ExportBaseModeDto> callBackScrollData(ExportQueryParamsReqDto exportQueryParamsReqDto) throws Exception {
        String key = exportQueryParamsReqDto.getExportFileParams().getKey();
        String filter = exportQueryParamsReqDto.getFilter();
        log.info("\u551b\u5934\u7ba1\u7406\u6309\u5ba2\u6237\u5bfc\u51fa\u67e5\u8be2\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)exportQueryParamsReqDto));
        AssertUtils.isTrue((boolean)FileModeTypeEnum.SHIPPING_MARK_MANAGEMENT_CUSTOMER.getKey().equals(key), (String)"\u4e1a\u52a1key\u6709\u8bef");
        ShippingMarkManagementPageReqDto pageReqDto = new ShippingMarkManagementPageReqDto();
        if (StrUtil.isNotBlank((CharSequence)filter)) {
            pageReqDto = (ShippingMarkManagementPageReqDto)JSON.parseObject((String)filter, ShippingMarkManagementPageReqDto.class);
        }
        List pageList = ((PageInfo)RestResponseHelper.extractData((RestResponse)this.iShippingMarkManagementApiProxy.page(pageReqDto))).getList();
        ArrayList<ExportShippingMarkManagementCustomerRespDto> list = new ArrayList<ExportShippingMarkManagementCustomerRespDto>();
        if (CollectionUtil.isEmpty((Collection)pageList)) {
            return Collections.EMPTY_LIST;
        }
        Integer num = 1;
        for (ShippingMarkManagementDto dto : pageList) {
            ExportShippingMarkManagementCustomerRespDto exportDto = (ExportShippingMarkManagementCustomerRespDto)BeanUtil.copyProperties((Object)dto, ExportShippingMarkManagementCustomerRespDto.class, (String[])new String[0]);
            Integer n = num;
            Integer n2 = num = Integer.valueOf(num + 1);
            exportDto.setNumber(n);
            list.add(exportDto);
        }
        log.info("\u551b\u5934\u7ba1\u7406\u5bfc\u51fa\u5927\u5c0f:{}", (Object)list.size());
        return list;
    }

    private boolean paramVerify(ImportShippingMarkManagementCustomerReqDto dto, List<String> collect) {
        if (CollectionUtil.isNotEmpty(collect) && collect.contains(dto.getCustomerCode())) {
            dto.setErrorMsg("\u5ba2\u6237\u7f16\u7801\u5df2\u91cd\u590d\u63d0\u4ea4");
            return false;
        }
        DgCustomerInfoQueryExtDto queryExtDto = new DgCustomerInfoQueryExtDto();
        queryExtDto.setCustomerCode(dto.getCustomerCode());
        List dgCustomerInfoRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.iTransactionCustomerQueryApiProxy.queryListExt(queryExtDto));
        if (CollectionUtil.isEmpty((Collection)dgCustomerInfoRespDtos)) {
            dto.setErrorMsg("\u5ba2\u6237\u7f16\u7801\u4e0d\u5b58\u5728");
            return false;
        }
        return true;
    }
}

