/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.mgmt.excel;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.ExcelImportUtil;
import cn.afterturn.easypoi.excel.annotation.Excel;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.ImportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import cn.afterturn.easypoi.excel.entity.result.ExcelImportResult;
import cn.hutool.poi.excel.ExcelReader;
import cn.hutool.poi.excel.ExcelUtil;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.huieryun.oss.api.IObjectStorageService;
import com.dtyunxi.lang.BusinessRuntimeException;
import com.dtyunxi.util.MD5Util;
import com.dtyunxi.util.SpringBeanUtil;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.mgmt.excel.BaseExcelStyle;
import com.yunxi.dg.base.mgmt.excel.CheckUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcelUtils {
    private static final Logger logger = LoggerFactory.getLogger(ExcelUtils.class);
    private static IObjectStorageService objectStorageService;
    private static String BUCKET_NAME;
    private static String END_POINT;
    public static final int MAX_CNT = 10000;

    public static ExcelReader getExcelReader(String fileUrl, Class beanType) {
        ExcelReader excelReader = ExcelUtil.getReader((InputStream)ExcelUtils.getInputStream(fileUrl));
        ExcelUtils.addHeaderAlias(excelReader, beanType);
        return excelReader;
    }

    public static ExcelReader getExcelReader(InputStream inputStream, Class beanType) {
        ExcelReader excelReader = ExcelUtil.getReader((InputStream)inputStream);
        ExcelUtils.addHeaderAlias(excelReader, beanType);
        return excelReader;
    }

    public static void addHeaderAlias(ExcelReader excelReader, Class beanType) {
        Field[] fields;
        for (Field field : fields = beanType.getDeclaredFields()) {
            Excel annotation = field.getAnnotation(Excel.class);
            if (annotation == null) continue;
            String header = field.getAnnotation(Excel.class).name();
            excelReader.addHeaderAlias(header, field.getName());
        }
    }

    public static InputStream getInputStream(String url) {
        InputStream is = null;
        try {
            HttpURLConnection httpURLConnection = ExcelUtils.getHttpURLConnection(url);
            is = httpURLConnection.getInputStream();
        }
        catch (FileNotFoundException e) {
            logger.error("\u8bfb\u53d6\u6587\u4ef6IO\u5f02\u5e38", (Throwable)e);
            throw new BizException("\u6587\u4ef6\u4e0d\u5b58\u5728");
        }
        catch (IOException e) {
            logger.error("\u8bfb\u53d6\u6587\u4ef6IO\u5f02\u5e38", (Throwable)e);
            throw new BizException("\u8bfb\u53d6\u6587\u4ef6IO\u5f02\u5e38");
        }
        return is;
    }

    public static ByteArrayOutputStream write(Class clazz, List list) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Workbook workbook = ExcelExportUtil.exportBigExcel((ExportParams)new ExportParams(), (Class)clazz, (Collection)list);
        try {
            workbook.write((OutputStream)byteArrayOutputStream);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        ExcelExportUtil.closeExportBigExcel();
        return byteArrayOutputStream;
    }

    public static ByteArrayInputStream write2InputStream(Class clazz, List list) {
        return new ByteArrayInputStream(ExcelUtils.write(clazz, list).toByteArray());
    }

    public static void checkFileSize(InputStream inputStream, int fileSize) {
        try {
            if (inputStream.available() > 0) {
                double size = inputStream.available() / 0x100000;
                logger.info("\u6587\u4ef6size:" + size + "M");
                if (size > (double)fileSize) {
                    throw new BizException("\u6587\u4ef6\u4e0d\u80fd\u5927\u4e8e" + fileSize + "M");
                }
            }
        }
        catch (IOException e) {
            logger.error("\u8bfb\u53d6\u6587\u4ef6IO\u5f02\u5e38", (Throwable)e);
            throw new BizException("\u8bfb\u53d6\u6587\u4ef6IO\u5f02\u5e38");
        }
    }

    public static BigDecimal getFileSize(InputStream inputStream) {
        BigDecimal fileSize = BigDecimal.ZERO;
        try {
            if (inputStream.available() > 0) {
                fileSize = BigDecimal.valueOf(inputStream.available()).divide(BigDecimal.valueOf(1024L));
            }
        }
        catch (IOException e) {
            logger.error("\u8bfb\u53d6\u6587\u4ef6IO\u5f02\u5e38", (Throwable)e);
            throw new BizException("\u8bfb\u53d6\u6587\u4ef6IO\u5f02\u5e38");
        }
        return fileSize.setScale(2, 4);
    }

    public static HttpURLConnection getHttpURLConnection(String url) {
        HttpURLConnection http = null;
        try {
            URL realUrl = new URL(url);
            http = (HttpURLConnection)realUrl.openConnection();
            http.setRequestMethod("GET");
            http.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            http.setDoOutput(true);
            http.setDoInput(true);
            System.setProperty("sun.net.client.defaultConnectTimeout", "30000");
            System.setProperty("sun.net.client.defaultReadTimeout", "30000");
            http.connect();
        }
        catch (IOException e) {
            logger.error("\u8bfb\u53d6\u6587\u4ef6IO\u5f02\u5e38", (Throwable)e);
            throw new BizException("\u8bfb\u53d6\u6587\u4ef6IO\u5f02\u5e38");
        }
        return http;
    }

    public static <T> String getExportUrl(List<T> excelRespDtos, Class<T> tClass, String title, String excelName) {
        if (CollectionUtils.isEmpty(excelRespDtos)) {
            excelRespDtos = Lists.newArrayList();
        }
        if (excelRespDtos.size() > 10000) {
            logger.info("\u8fdb\u5165\u5bfc\u5927\u6279\u91cf\u6570\u636e");
            return ExcelUtils.getBigDataExportUrl(excelRespDtos, tClass, title, excelName);
        }
        logger.info("\u8fdb\u5165\u5bfc\u5c0f\u6279\u91cf\u6570\u636e");
        return ExcelUtils.getSmallDataExportUrl(excelRespDtos, tClass, title, excelName);
    }

    public static <T> String getExportUrlStyle(List<T> excelRespDtos, Class<T> tClass, String title, String excelName, BaseExcelStyle style) {
        if (CollectionUtils.isEmpty(excelRespDtos)) {
            excelRespDtos = Lists.newArrayList();
        }
        if (excelRespDtos.size() > 10000) {
            logger.info("\u8fdb\u5165\u5bfc\u5927\u6279\u91cf\u6570\u636e");
            return ExcelUtils.getBigDataExportUrl(excelRespDtos, tClass, title, excelName);
        }
        logger.info("\u8fdb\u5165\u5bfc\u5c0f\u6279\u91cf\u6570\u636e");
        return ExcelUtils.getSmallDataExportUrlStyle(excelRespDtos, tClass, title, excelName, style);
    }

    public static boolean checkExcelHeader(List<Object> readRow, Class clazz) {
        Field[] fields;
        StringBuilder fieldNames = new StringBuilder();
        for (Field field : fields = clazz.getDeclaredFields()) {
            Excel annotation = field.getAnnotation(Excel.class);
            if (annotation == null) continue;
            String annotationName = field.getAnnotation(Excel.class).name();
            fieldNames.append(annotationName);
        }
        StringBuilder headerNames = new StringBuilder();
        for (Object headerName : readRow) {
            if (headerName == null) continue;
            headerNames.append(headerName);
        }
        String md5FieldNames = MD5Util.getMd5ByString((String)fieldNames.toString());
        String md5HeaderNames = MD5Util.getMd5ByString((String)headerNames.toString());
        logger.info("md5FieldNames = {} fieldNames ={}", (Object)md5FieldNames, (Object)fieldNames.toString());
        logger.info("md5HeaderNames = {} fieldNames ={}", (Object)md5HeaderNames, (Object)headerNames.toString());
        return md5FieldNames.equals(md5HeaderNames);
    }

    public static <T> List<T> parseImportFile(String fileUrl, Class clazz) {
        long startTime = System.currentTimeMillis();
        if (StringUtils.isBlank((CharSequence)fileUrl)) {
            throw new BizException("\u5bfc\u5165\u8def\u5f84\u4e0d\u5b58\u5728");
        }
        InputStream inputStream = ExcelUtils.getInputStream(fileUrl);
        ExcelImportResult<T> data = ExcelUtils.importExcel(inputStream, 0, 1, clazz);
        logger.info("\u5bfc\u5165\u89e3\u6790excel\u6587\u4ef6, \u8017\u65f6={}", (Object)(System.currentTimeMillis() - startTime));
        return data.getList();
    }

    private static <T> ExcelImportResult<T> importExcel(InputStream inputStream, Integer titleRows, Integer headerRows, Class pojoClass) {
        ImportParams params = new ImportParams();
        params.setTitleRows(titleRows.intValue());
        params.setHeadRows(headerRows.intValue());
        params.setNeedVerify(true);
        ExcelImportResult result = null;
        try {
            result = ExcelImportUtil.importExcelMore((InputStream)inputStream, (Class)pojoClass, (ImportParams)params);
            ExcelUtils.handleImportResultListFilterEmpty(result);
            return result;
        }
        catch (NoSuchElementException var7) {
            throw new BusinessRuntimeException("excel\u6587\u4ef6\u4e0d\u80fd\u4e3a\u7a7a");
        }
        catch (Exception var8) {
            throw new BusinessRuntimeException(var8.getMessage());
        }
    }

    public static void handleImportResultListFilterEmpty(ExcelImportResult result) {
        ArrayList fails = new ArrayList();
        boolean isFail = false;
        if (result.isVerfiyFail()) {
            for (Object val : result.getFailList()) {
                boolean b = CheckUtils.checkFieldAllNull(val);
                if (b) continue;
                logger.info("\u5b58\u5728\u6821\u9a8c\u5931\u8d25\u7684");
                fails.add(val);
                isFail = true;
            }
        }
        result.setFailList(fails);
        result.setVerfiyFail(isFail);
        List list = result.getList().stream().filter(l -> !CheckUtils.checkFieldAllNull(l)).collect(Collectors.toList());
        result.setList(list);
    }

    public static String getLoadWorkbookPath(Workbook workbook, String fileName, String title) {
        return ExcelUtils.getLoadUrl(workbook, fileName, title);
    }

    private static <T> String getSmallDataExportUrl(List<T> excelRespDtos, Class<T> tClass, String title, String excelName) {
        String fileName = excelName + ".xlsx";
        ExportParams params = new ExportParams(title, "", ExcelType.XSSF);
        Workbook workbook = ExcelExportUtil.exportExcel((ExportParams)params, tClass, excelRespDtos);
        return ExcelUtils.getLoadUrl(workbook, fileName, title);
    }

    private static <T> String getSmallDataExportUrlStyle(List<T> excelRespDtos, Class<T> tClass, String title, String excelName, BaseExcelStyle style) {
        String fileName = excelName + ".xlsx";
        ExportParams params = new ExportParams(title, "", ExcelType.XSSF);
        Workbook workbook = ExcelExportUtil.exportExcel((ExportParams)params, tClass, excelRespDtos);
        ExcelUtils.handStyle(workbook, style);
        return ExcelUtils.getLoadUrl(workbook, fileName, title);
    }

    private static void handStyle(Workbook workbook, BaseExcelStyle style) {
        try {
            Sheet sheetAt = workbook.getSheetAt(0);
            int lastRowNum = sheetAt.getLastRowNum();
            int physicalNumberOfCells = sheetAt.getRow(0).getPhysicalNumberOfCells();
            CellStyle headCellStyle = workbook.createCellStyle();
            CellStyle formCellStyle = workbook.createCellStyle();
            for (int i = 0; i <= lastRowNum; ++i) {
                Row row = sheetAt.getRow(i);
                for (int j = 1; j < physicalNumberOfCells; ++j) {
                    Cell cell = row.getCell(j);
                    Font font = workbook.createFont();
                    if (j >= style.getHeadIndex() && i == 0) {
                        headCellStyle.setFont(font);
                        headCellStyle.setFillForegroundColor(style.getHeadBackgroundColor());
                        headCellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
                        font.setColor(style.getHeadCharacter());
                        font.setBold(true);
                        cell.setCellStyle(headCellStyle);
                        continue;
                    }
                    if (i < 1 || j < style.getHeadIndex()) continue;
                    formCellStyle.setFont(font);
                    formCellStyle.setFillForegroundColor(style.getHeadBackgroundColor());
                    formCellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
                    cell.setCellStyle(formCellStyle);
                }
            }
        }
        catch (Exception e) {
            logger.error("\u8bbe\u7f6e\u6837\u5f0f\u5f02\u5e38", (Throwable)e);
        }
    }

    private static <T> String getBigDataExportUrl(List<T> excelRespDtos, Class<T> tClass, String title, String excelName) {
        ArrayList<T> list = new ArrayList<T>();
        Workbook workbook = null;
        ExportParams params = new ExportParams(title, "");
        int size = excelRespDtos.size();
        int cnt = 0;
        cnt = size % 10000 == 0 ? size / 10000 : size / 10000 + 1;
        for (int i = 0; i < cnt; ++i) {
            if (i != cnt - 1) {
                list.addAll(excelRespDtos.subList(i * 10000, (i + 1) * 10000));
            } else {
                list.addAll(excelRespDtos.subList(i * 10000, excelRespDtos.size()));
            }
            workbook = ExcelExportUtil.exportBigExcel((ExportParams)params, tClass, list);
            list.clear();
        }
        ExcelExportUtil.closeExportBigExcel();
        String fileName = excelName + ".xlsx";
        return ExcelUtils.getLoadUrl(workbook, fileName, title);
    }

    private static <T> String getBigDataExportUrlStyle(List<T> excelRespDtos, Class<T> tClass, String title, String excelName, BaseExcelStyle style) {
        ArrayList<T> list = new ArrayList<T>();
        Workbook workbook = null;
        ExportParams params = new ExportParams(title, "");
        int size = excelRespDtos.size();
        int cnt = 0;
        cnt = size % 10000 == 0 ? size / 10000 : size / 10000 + 1;
        for (int i = 0; i < cnt; ++i) {
            if (i != cnt - 1) {
                list.addAll(excelRespDtos.subList(i * 10000, (i + 1) * 10000));
            } else {
                list.addAll(excelRespDtos.subList(i * 10000, excelRespDtos.size()));
            }
            workbook = ExcelExportUtil.exportBigExcel((ExportParams)params, tClass, list);
            list.clear();
        }
        ExcelUtils.handStyle(workbook, style);
        ExcelExportUtil.closeExportBigExcel();
        String fileName = excelName + ".xlsx";
        return ExcelUtils.getLoadUrl(workbook, fileName, title);
    }

    private static void initConfig() {
        if (objectStorageService == null) {
            objectStorageService = (IObjectStorageService)SpringBeanUtil.getBean(IObjectStorageService.class);
        }
        if (BUCKET_NAME == null) {
            BUCKET_NAME = SpringBeanUtil.getApplicationContext().getEnvironment().getProperty("huieryun.ossregistryvo.bucketName");
        }
        if (END_POINT == null) {
            END_POINT = SpringBeanUtil.getApplicationContext().getEnvironment().getProperty("huieryun.ossregistryvo.endpoint");
        }
    }

    private static String getLoadUrl(Workbook workbook, String fileName, String title) {
        ExcelUtils.initConfig();
        ByteArrayOutputStream fos = null;
        ByteArrayInputStream fis = null;
        String url = "";
        try {
            fos = new ByteArrayOutputStream();
            workbook.write((OutputStream)fos);
            fis = new ByteArrayInputStream(fos.toByteArray());
            url = objectStorageService.put(BUCKET_NAME, fileName, (InputStream)fis);
        }
        catch (IOException e) {
            logger.error("{}\u5bfc\u51faexcel\u5f02\u5e38", (Object)title, (Object)e);
            throw new BusinessRuntimeException(title + "\u5bfc\u51faexcel\u5f02\u5e38");
        }
        finally {
            try {
                if (fos != null) {
                    fos.close();
                }
                if (fis != null) {
                    fis.close();
                }
                if (workbook != null) {
                    workbook.close();
                }
            }
            catch (IOException e) {
                logger.error("\u5173\u95ed\u6d41\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
            }
        }
        return url;
    }
}

