/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.mgmt.service.impl;

import cn.afterturn.easypoi.excel.entity.result.ExcelImportResult;
import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.NumberUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.rest.RestResponse;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import com.yunxi.dg.base.commons.utils.decimal.BigDecimalUtils;
import com.yunxi.dg.base.mgmt.application.rpc.dto.inventory.AssemblyDisassemblyOrderComboReqDto;
import com.yunxi.dg.base.mgmt.application.rpc.dto.inventory.AssemblyDisassemblyOrderDetailDto;
import com.yunxi.dg.base.mgmt.application.rpc.dto.inventory.AssemblyDisassemblyOrderDto;
import com.yunxi.dg.base.mgmt.application.rpc.dto.inventory.DgLogicInventoryDto;
import com.yunxi.dg.base.mgmt.application.rpc.dto.inventory.DgLogicInventoryListReqDto;
import com.yunxi.dg.base.mgmt.application.rpc.dto.request.BundleItemDgReqDto;
import com.yunxi.dg.base.mgmt.application.rpc.dto.request.ItemQueryDgReqDto;
import com.yunxi.dg.base.mgmt.application.rpc.dto.request.UnitDgReqDto;
import com.yunxi.dg.base.mgmt.application.rpc.dto.response.DgItemSkuDetailRespDto;
import com.yunxi.dg.base.mgmt.application.rpc.dto.response.DgItemSkuRespDto;
import com.yunxi.dg.base.mgmt.application.rpc.dto.response.ItemVersionDgRespDto;
import com.yunxi.dg.base.mgmt.application.rpc.dto.response.UnitDgRespDto;
import com.yunxi.dg.base.mgmt.application.rpc.proxy.inventory.IAssemblyDisassemblyOrderApiProxy;
import com.yunxi.dg.base.mgmt.application.rpc.proxy.inventory.IDgLogicInventoryApiProxy;
import com.yunxi.dg.base.mgmt.application.rpc.proxy.sku.IItemSkuDgQueryApiProxy;
import com.yunxi.dg.base.mgmt.application.rpc.proxy.unit.IUnitDgQueryApiProxy;
import com.yunxi.dg.base.ocs.mgmt.application.dto.enums.AssemblyDisassemblyOrderBizTypeEnum;
import com.yunxi.dg.base.ocs.mgmt.application.dto.enums.FileModeTypeEnum;
import com.yunxi.dg.base.ocs.mgmt.application.dto.enums.FileOperationStatusEnum;
import com.yunxi.dg.base.ocs.mgmt.application.dto.request.AssemblyDisassemblyOrderImportDto;
import com.yunxi.dg.base.poi.dto.ImportBaseModeDto;
import com.yunxi.dg.base.poi.dto.ImportFileOperationCommonReqDto;
import com.yunxi.dg.base.poi.dto.ImportFileOperationCommonRespDto;
import com.yunxi.dg.base.poi.service.AbstractBaseFileOperationCommonService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

@Service(value="AbstractBaseFileOperationCommonService_assembly_disassembly_order_import")
public class AssemblyDisassemblyOrderCommonServiceImpl
extends AbstractBaseFileOperationCommonService {
    private static final Logger log = LoggerFactory.getLogger(AssemblyDisassemblyOrderCommonServiceImpl.class);
    @Resource
    private IDgLogicInventoryApiProxy dgLogicInventoryApiProxy;
    @Resource
    private IUnitDgQueryApiProxy unitDgQueryApiProxy;
    @Resource
    private IItemSkuDgQueryApiProxy itemSkuDgQueryApiProxy;
    @Resource
    private IAssemblyDisassemblyOrderApiProxy assemblyDisassemblyOrderApiProxy;

    public Object verifyImportFileOperationCommon(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto) {
        log.info("\u7ec4\u88c5\u62c6\u5378\u5bfc\u5165\u6570\u636e\uff1a{}", (Object)JSONObject.toJSONString(result));
        ArrayList passList = Lists.newArrayList();
        List resultList = BeanUtil.copyToList((Collection)result.getList(), AssemblyDisassemblyOrderImportDto.class);
        if (CollectionUtil.isEmpty((Collection)resultList)) {
            respDto.setErrorMsg("\u5bfc\u5165\u5185\u5bb9\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01");
            respDto.setStatus(FileOperationStatusEnum.IMPORT_ERROR.getCode());
            return new ArrayList();
        }
        if (resultList.size() > 1000) {
            respDto.setErrorMsg("\u6279\u91cf\u5bfc\u5165\u4e0d\u652f\u6301\u8d85\u8fc71000\u884c");
            respDto.setStatus(FileOperationStatusEnum.IMPORT_ERROR.getCode());
            return new ArrayList();
        }
        List<String> skuCodes = resultList.stream().map(AssemblyDisassemblyOrderImportDto::getSkuCode).collect(Collectors.toList());
        List<String> logicWarehouseCodes = resultList.stream().map(AssemblyDisassemblyOrderImportDto::getLogicWarehouseCode).collect(Collectors.toList());
        List<DgLogicInventoryDto> logicInventorys = this.getLogicInventoryByCodes(skuCodes, logicWarehouseCodes);
        Map<String, List<DgLogicInventoryDto>> inventoryMap = logicInventorys.stream().collect(Collectors.groupingBy(DgLogicInventoryDto::getWarehouseCode));
        Map<String, UnitDgRespDto> unitMap = this.getUnitMap();
        Map<String, String> code2NameMap = unitMap.values().stream().collect(Collectors.toMap(UnitDgRespDto::getCode, UnitDgRespDto::getName));
        Map<String, DgItemSkuDetailRespDto> skuInfoMap = this.getSkuInfoByCodes(skuCodes);
        Map<String, List<ItemVersionDgRespDto>> bomInfoMap = skuInfoMap.values().stream().collect(Collectors.toMap(DgItemSkuRespDto::getSkuCode, DgItemSkuRespDto::getVersionDgReqDtos));
        for (AssemblyDisassemblyOrderImportDto importDto : resultList) {
            boolean isPass = this.checkAndInitParam(importDto, inventoryMap, unitMap, bomInfoMap, skuInfoMap, code2NameMap);
            if (isPass) {
                importDto.setErrorMsg(String.format("\u7b2c%s\u884c\u6570\u636e\u6709\u8bef,%s", importDto.getRowNum() + FileModeTypeEnum.getInstance((String)commonReqDto.getKey()).getHeadRows(), importDto.getErrorMsg()));
                respDto.getErrorDetails().add(importDto);
                continue;
            }
            passList.add(importDto);
        }
        respDto.setDetails((List)passList);
        return passList;
    }

    public void callBackImportFileOperationCommonAsync(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto, Object object) {
        log.info("\u7ec4\u88c5\u62c6\u5378-callBackImportFileOperationCommonAsync-->result:{}", (Object)JSON.toJSONString(result));
        List passList = (List)object;
        if (CollectionUtil.isEmpty((Collection)passList)) {
            respDto.setStatus(FileOperationStatusEnum.IMPORT_ERROR.getCode());
            return;
        }
        if (CollectionUtil.isNotEmpty((Collection)passList) && !respDto.getErrorDetails().isEmpty()) {
            return;
        }
        respDto.setStatus(FileOperationStatusEnum.IMPORT_SUCCESS.getCode());
        try {
            List<AssemblyDisassemblyOrderImportDto> mergeList = this.mergeTheSameRecords(passList);
            List<AssemblyDisassemblyOrderComboReqDto> assemblyDisassemblyOrderComboReqs = this.buildAssemblyDisassemblyOrderComboReq(mergeList);
            this.assemblyDisassemblyOrderApiProxy.insertBatch(assemblyDisassemblyOrderComboReqs);
        }
        catch (Exception e) {
            log.info("\u5bfc\u5165\u7ec4\u88c5\u62c6\u5378\u5355\u5931\u8d25", (Throwable)e);
            respDto.setStatus(FileOperationStatusEnum.IMPORT_ERROR.getCode());
            respDto.setErrorMsg(e.getMessage());
        }
    }

    public List<AssemblyDisassemblyOrderImportDto> mergeTheSameRecords(List<AssemblyDisassemblyOrderImportDto> passList) {
        LinkedHashMap<String, AssemblyDisassemblyOrderImportDto> existMap = new LinkedHashMap<String, AssemblyDisassemblyOrderImportDto>(passList.size());
        StringBuilder sb = null;
        Iterator<AssemblyDisassemblyOrderImportDto> iterator = passList.iterator();
        while (iterator.hasNext()) {
            sb = new StringBuilder();
            AssemblyDisassemblyOrderImportDto importDto = iterator.next();
            String key = sb.append(importDto.getBizType()).append(importDto.getLogicWarehouseCode()).append(importDto.getSkuCode()).toString();
            if (!existMap.containsKey(key)) {
                existMap.put(key, importDto);
                continue;
            }
            AssemblyDisassemblyOrderImportDto existImportDto = (AssemblyDisassemblyOrderImportDto)existMap.get(key);
            existImportDto.setPlanQuantity(Integer.valueOf(NumberUtil.add((Number)existImportDto.getPlanQuantity(), (Number)importDto.getPlanQuantity()).intValue()));
        }
        return new ArrayList<AssemblyDisassemblyOrderImportDto>(existMap.values());
    }

    private List<AssemblyDisassemblyOrderComboReqDto> buildAssemblyDisassemblyOrderComboReq(List<AssemblyDisassemblyOrderImportDto> passList) {
        Map<String, String> unitCode2NameMap = this.getUnitCode2NameMap();
        ArrayList<AssemblyDisassemblyOrderComboReqDto> result = new ArrayList<AssemblyDisassemblyOrderComboReqDto>();
        for (AssemblyDisassemblyOrderImportDto orderImportDto : passList) {
            AssemblyDisassemblyOrderComboReqDto comboReqDto = new AssemblyDisassemblyOrderComboReqDto();
            comboReqDto.setCommitType("SAVE");
            comboReqDto.setOrder(this.buildAssemblyDisassemblyOrder(orderImportDto));
            comboReqDto.setPackageList(this.buildPackDetailDto(orderImportDto));
            comboReqDto.setDetailList(this.buildDetailDto(orderImportDto, unitCode2NameMap));
            result.add(comboReqDto);
        }
        return result;
    }

    public AssemblyDisassemblyOrderDto buildAssemblyDisassemblyOrder(AssemblyDisassemblyOrderImportDto orderImportDto) {
        AssemblyDisassemblyOrderDto orderDto = new AssemblyDisassemblyOrderDto();
        orderDto.setBizTime(orderImportDto.getBizDate());
        orderDto.setBizType(AssemblyDisassemblyOrderBizTypeEnum.getByDesc((String)orderImportDto.getBizType()).getType());
        orderDto.setExternalOrderNo(orderImportDto.getExternalOrderNo());
        orderDto.setLogicWarehouseCode(orderImportDto.getLogicWarehouseCode());
        orderDto.setLogicWarehouseName(orderImportDto.getLogicWarehouseName());
        orderDto.setRemark(orderImportDto.getRemark());
        orderDto.setNoBatch(Integer.valueOf(0));
        return orderDto;
    }

    private List<AssemblyDisassemblyOrderDetailDto> buildPackDetailDto(AssemblyDisassemblyOrderImportDto orderImportDto) {
        AssemblyDisassemblyOrderDetailDto detailDto = new AssemblyDisassemblyOrderDetailDto();
        BeanUtil.copyProperties((Object)orderImportDto, (Object)detailDto, (String[])new String[0]);
        BeanUtil.copyProperties((Object)orderImportDto.getItem(), (Object)detailDto, (String[])new String[0]);
        detailDto.setType(Integer.valueOf(1));
        detailDto.setInventoryProperty("qualified");
        detailDto.setQuantity(orderImportDto.getPlanQuantity());
        return Collections.singletonList(detailDto);
    }

    private List<AssemblyDisassemblyOrderDetailDto> buildDetailDto(AssemblyDisassemblyOrderImportDto orderImportDto, Map<String, String> unitCode2NameMap) {
        ArrayList<AssemblyDisassemblyOrderDetailDto> details = new ArrayList<AssemblyDisassemblyOrderDetailDto>();
        ItemVersionDgRespDto bomInfo = this.getBomInfoByCodes(orderImportDto.getSkuCode(), orderImportDto.getBomVersion());
        if (bomInfo == null) {
            log.info("\u5b50\u54c1\u6570\u636e\u4e3a\u7a7a\uff0c\u5f02\u5e38\uff01");
            return null;
        }
        Integer planQuantity = orderImportDto.getPlanQuantity();
        BigDecimal unitPrice = orderImportDto.getUnitPrice();
        BigDecimal totalPrice = BigDecimal.ZERO;
        List<String> skuCodes = bomInfo.getBundleItemBomDgReqDtoList().stream().map(BundleItemDgReqDto::getSubSkuCode).collect(Collectors.toList());
        Map<String, DgItemSkuDetailRespDto> code2DetailMap = this.getSkuInfoByCodes(skuCodes);
        List<DgLogicInventoryDto> logicInventoryList = this.getLogicInventoryByCodes(skuCodes, Collections.singletonList(orderImportDto.getLogicWarehouseCode()));
        Map skuCode2InventoryMap = logicInventoryList.stream().collect(Collectors.toMap(DgLogicInventoryDto::getSkuCode, Function.identity(), (k1, k2) -> k1));
        for (BundleItemDgReqDto item : bomInfo.getBundleItemBomDgReqDtoList()) {
            totalPrice = NumberUtil.add((Number)totalPrice, (Number)NumberUtil.mul((Number)item.getRetailPrice(), (Number)item.getNum()));
        }
        for (BundleItemDgReqDto bundleItemDgReqDto : bomInfo.getBundleItemBomDgReqDtoList()) {
            if (!code2DetailMap.containsKey(bundleItemDgReqDto.getSubSkuCode())) continue;
            DgItemSkuDetailRespDto detailRespDto = code2DetailMap.get(bundleItemDgReqDto.getSubSkuCode());
            BigDecimal retailPrice = bundleItemDgReqDto.getRetailPrice();
            Integer num = bundleItemDgReqDto.getNum();
            AssemblyDisassemblyOrderDetailDto detailDto = new AssemblyDisassemblyOrderDetailDto();
            detailDto.setType(Integer.valueOf(2));
            detailDto.setItemProperty(String.valueOf(detailRespDto.getItemAttribute()));
            detailDto.setSkuDisplayName(detailRespDto.getSkuDisplayName());
            detailDto.setSkuCode(detailRespDto.getSkuCode());
            detailDto.setSkuName(detailRespDto.getSkuName());
            detailDto.setArtNo(detailRespDto.getItemCode());
            detailDto.setUnit(unitCode2NameMap.get(detailRespDto.getUnit()));
            detailDto.setMixtureRatio(num);
            DgLogicInventoryDto dgLogicInventoryDto = (DgLogicInventoryDto)skuCode2InventoryMap.get(detailRespDto.getSkuCode());
            if (dgLogicInventoryDto != null) {
                detailDto.setAvailable(dgLogicInventoryDto.getAvailable());
                detailDto.setInventoryProperty("qualified");
            }
            int sum = planQuantity * num;
            detailDto.setQuantity(Integer.valueOf(sum));
            detailDto.setUnitPrice(AssemblyDisassemblyOrderCommonServiceImpl.calculate(unitPrice, retailPrice, sum, totalPrice));
            detailDto.setVolume(detailRespDto.getVolume() == null ? BigDecimal.ZERO : new BigDecimal(sum).multiply(detailRespDto.getVolume()));
            detailDto.setWeight(detailRespDto.getGrossWeight() == null ? BigDecimal.ZERO : new BigDecimal(sum).multiply(detailRespDto.getGrossWeight()));
            details.add(detailDto);
        }
        return details;
    }

    public static BigDecimal calculate(BigDecimal unitPrice, BigDecimal retailPrice, Integer subNumber, BigDecimal allPrice) {
        if (retailPrice.compareTo(BigDecimal.ZERO) == 0) {
            return BigDecimal.ZERO;
        }
        BigDecimal divide = NumberUtil.div((Number)retailPrice.multiply(new BigDecimal(subNumber)), (Number)allPrice);
        return NumberUtil.round((BigDecimal)NumberUtil.mul((BigDecimal[])new BigDecimal[]{unitPrice.multiply(divide)}), (int)2);
    }

    public boolean checkAndInitParam(AssemblyDisassemblyOrderImportDto dto, Map<String, List<DgLogicInventoryDto>> inventoryMap, Map<String, UnitDgRespDto> unitMap, Map<String, List<ItemVersionDgRespDto>> bomInfoMap, Map<String, DgItemSkuDetailRespDto> skuInfoMap, Map<String, String> code2NameMap) {
        StringBuffer errorMsg = new StringBuffer();
        if (StringUtils.isBlank((CharSequence)dto.getBizType())) {
            errorMsg.append("\u4e1a\u52a1\u7c7b\u578b\u672a\u586b\u5199;");
        } else if (ObjectUtils.isEmpty((Object)AssemblyDisassemblyOrderBizTypeEnum.getByDesc((String)dto.getBizType()))) {
            errorMsg.append("\u4e1a\u52a1\u7c7b\u578b\u4e0d\u5b58\u5728;");
        }
        if (StringUtils.isEmpty((CharSequence)dto.getLogicWarehouseCode())) {
            errorMsg.append("\u903b\u8f91\u4ed3\u7f16\u7801\u672a\u586b\u5199;");
        } else if (!inventoryMap.containsKey(dto.getLogicWarehouseCode())) {
            errorMsg.append("\u903b\u8f91\u4ed3\u7f16\u7801\u4e0d\u5b58\u5728;");
        }
        if (ObjectUtils.isEmpty((Object)dto.getPlanQuantity())) {
            dto.setPlanQuantity(Integer.valueOf(0));
            errorMsg.append("\u8ba1\u5212\u52a0\u5de5\u6570\u91cf\u672a\u586b\u5199;");
        } else {
            if (BigDecimalUtils.leZero((BigDecimal)new BigDecimal(dto.getPlanQuantity())).booleanValue()) {
                errorMsg.append("\u8ba1\u5212\u52a0\u5de5\u6570\u91cf\u5fc5\u987b\u4e3a\u6b63\u6574\u6570;");
            }
            if (BigDecimalUtils.gt((BigDecimal)new BigDecimal(dto.getPlanQuantity()), (BigDecimal)new BigDecimal(10000000L)).booleanValue()) {
                errorMsg.append("\u8ba1\u5212\u52a0\u5de5\u6570\u91cf\u4e0d\u80fd\u8d85\u8fc77\u4f4d;");
            }
        }
        if (StringUtils.isEmpty((CharSequence)dto.getSkuCode())) {
            errorMsg.append("SKU\u7f16\u7801\u672a\u586b\u5199;");
        } else if (!skuInfoMap.containsKey(dto.getSkuCode())) {
            errorMsg.append("SKU\u7f16\u7801\u4e0d\u5b58\u5728;");
        } else {
            Map skuCode2InventoryDtoMap = ((List)inventoryMap.getOrDefault(dto.getLogicWarehouseCode(), new ArrayList())).stream().collect(Collectors.toMap(DgLogicInventoryDto::getSkuCode, Function.identity()));
            DgLogicInventoryDto dgLogicInventoryDto = (DgLogicInventoryDto)skuCode2InventoryDtoMap.get(dto.getSkuCode());
            if (dgLogicInventoryDto == null) {
                errorMsg.append("SKU\u7f16\u7801\u4e0d\u5b58\u5728;");
            } else if (!(AssemblyDisassemblyOrderBizTypeEnum.isAssemble((String)dto.getBizType()) || BigDecimal.ZERO.compareTo(dgLogicInventoryDto.getAvailable()) != 0 && new BigDecimal(dto.getPlanQuantity()).compareTo(dgLogicInventoryDto.getAvailable()) <= 0)) {
                errorMsg.append("\u8ba1\u5212\u52a0\u5de5\u6570\u91cf\u4e0d\u80fd\u5927\u4e8e\u53ef\u7528\u5e93\u5b58;");
            } else {
                DgItemSkuDetailRespDto detailRespDto = skuInfoMap.get(dto.getSkuCode());
                if (detailRespDto != null) {
                    AssemblyDisassemblyOrderImportDto.Item item = new AssemblyDisassemblyOrderImportDto.Item();
                    item.setSkuCode(detailRespDto.getSkuCode());
                    item.setSkuName(detailRespDto.getSkuName());
                    item.setSkuDisplayName(detailRespDto.getSkuDisplayName());
                    item.setArtNo(detailRespDto.getItemCode());
                    item.setVolume(detailRespDto.getVolume());
                    item.setWeight(detailRespDto.getGrossWeight());
                    item.setItemProperty(String.valueOf(detailRespDto.getItemAttribute()));
                    item.setAvailable(dgLogicInventoryDto.getAvailable());
                    dto.setItem(item);
                }
            }
        }
        String unit = dto.getUnit();
        if (StringUtils.isBlank((CharSequence)unit)) {
            if (!skuInfoMap.containsKey(dto.getSkuCode())) {
                errorMsg.append("SKU\u7f16\u7801").append(dto.getSkuCode()).append("\u627e\u4e0d\u5230\u9ed8\u8ba4\u7684\u5355\u4f4d");
            } else {
                DgItemSkuDetailRespDto detailRespDto = skuInfoMap.get(dto.getSkuCode());
                log.info("\u7ec4\u88c5\u62c6\u5378\u83b7\u53d6\u9ed8\u8ba4\u5355\u4f4d\u586b\u5145-->itemSkuDgRespDto:{}", (Object)JSON.toJSONString((Object)detailRespDto));
                dto.setUnit(code2NameMap.get(detailRespDto.getUnit()));
            }
        } else {
            UnitDgRespDto respDto = unitMap.get(unit);
            if (ObjectUtil.isNotEmpty((Object)respDto)) {
                dto.setUnit(respDto.getName());
            } else {
                errorMsg.append("SKU\u7f16\u7801").append(dto.getSkuCode()).append("\u5728\u5355\u4f4d\u6863\u6848\u4e2d\u627e\u4e0d\u5230\u8be5\u586b\u5199\u7684\u5355\u4f4d").append(unit);
            }
        }
        List<ItemVersionDgRespDto> itemVersions = bomInfoMap.get(dto.getSkuCode());
        if (CollectionUtil.isEmpty(itemVersions)) {
            errorMsg.append("SKU\u7f16\u7801").append(dto.getSkuCode()).append("\u627e\u4e0d\u5230bom\u7248\u672c");
        } else {
            ItemVersionDgRespDto itemVersionDgRespDto = null;
            if (StringUtils.isBlank((CharSequence)dto.getBomVersion())) {
                itemVersionDgRespDto = itemVersions.get(itemVersions.size() - 1);
                log.info("\u7ec4\u88c5\u62c6\u5378\u9ed8\u8ba4bom\u7248\u672c\u586b\u5145-->itemVersionDgRespDto:{}", (Object)JSONObject.toJSONString((Object)itemVersionDgRespDto));
                dto.setBomVersion(itemVersionDgRespDto.getVersion());
            }
            for (ItemVersionDgRespDto respDto : itemVersions) {
                if (!respDto.getVersion().equals(dto.getBomVersion())) continue;
                itemVersionDgRespDto = respDto;
                break;
            }
            if (itemVersionDgRespDto == null) {
                errorMsg.append("\u627e\u4e0d\u5230bom\u7248\u672c;");
            } else {
                List<String> subSkuCodes = itemVersionDgRespDto.getBundleItemBomDgReqDtoList().stream().map(BundleItemDgReqDto::getSubSkuCode).collect(Collectors.toList());
                Map<String, DgItemSkuDetailRespDto> skuId2InfoMap = null;
                if (CollectionUtil.isEmpty(subSkuCodes) || CollectionUtil.isEmpty(skuId2InfoMap = this.getSkuInfoByCodes(subSkuCodes))) {
                    errorMsg.append("bom\u7248\u672c\u6ca1\u6709\u5bf9\u5e94\u5b50\u54c1;");
                } else {
                    List<String> skuCodes = skuId2InfoMap.values().stream().map(DgItemSkuRespDto::getSkuCode).collect(Collectors.toList());
                    Map skuCode2InventoryDtoMap = this.getLogicInventoryByCodes(skuCodes, Collections.singletonList(dto.getLogicWarehouseCode())).stream().collect(Collectors.toMap(DgLogicInventoryDto::getSkuCode, Function.identity(), (k1, k2) -> k1));
                    for (BundleItemDgReqDto reqDto : itemVersionDgRespDto.getBundleItemBomDgReqDtoList()) {
                        DgItemSkuDetailRespDto detailRespDto = skuId2InfoMap.get(reqDto.getSubSkuCode());
                        if (detailRespDto == null) {
                            errorMsg.append("\u6ca1\u6709\u5bf9\u5e94\u5b50\u54c1\u3010").append(reqDto.getSubSkuCode()).append("\u3011\u4fe1\u606f");
                            continue;
                        }
                        DgLogicInventoryDto dgLogicInventoryDto = (DgLogicInventoryDto)skuCode2InventoryDtoMap.get(detailRespDto.getSkuCode());
                        if (dgLogicInventoryDto == null) {
                            errorMsg.append("\u5bf9\u5e94\u5b50\u54c1\u3010").append(detailRespDto.getSkuCode()).append("\u3011\u6ca1\u6709\u5e93\u5b58\u4fe1\u606f\u4fe1\u606f");
                            continue;
                        }
                        if (dgLogicInventoryDto.getAvailable().compareTo(BigDecimal.ZERO) != 0 && new BigDecimal(reqDto.getNum() * dto.getPlanQuantity()).compareTo(dgLogicInventoryDto.getAvailable()) <= 0) continue;
                        errorMsg.append(String.format("\u5b50\u54c1\u3010%s\u3011\u8ba1\u5212\u52a0\u5de5\u6570\u91cf\u4e0d\u80fd\u5927\u4e8e\u53ef\u7528\u5e93\u5b58;", dgLogicInventoryDto.getSkuCode()));
                    }
                }
            }
        }
        if (ObjectUtils.isEmpty((Object)dto.getUnitPrice())) {
            errorMsg.append("\u9884\u4f30\u52a0\u5de5\u8d39\u5355\u4ef7\u672a\u586b\u5199;");
        } else {
            if (BigDecimalUtils.ltZero((BigDecimal)dto.getUnitPrice()).booleanValue()) {
                errorMsg.append("\u9884\u4f30\u52a0\u5de5\u8d39\u5355\u4ef7\u4e0d\u80fd\u5c0f\u4e8e0;");
            }
            if (BigDecimalUtils.gt((BigDecimal)dto.getUnitPrice(), (BigDecimal)new BigDecimal(9999999L)).booleanValue()) {
                errorMsg.append("\u9884\u4f30\u52a0\u5de5\u8d39\u5355\u4ef7\u4e0d\u80fd\u8d85\u8fc78\u4f4d\u6574\u6570;");
            }
            dto.setUnitPrice(NumberUtil.roundDown((BigDecimal)dto.getUnitPrice(), (int)2));
        }
        if (StringUtils.isNotEmpty((CharSequence)dto.getRemark()) && dto.getRemark().length() > 200) {
            errorMsg.append("\u884c\u5907\u6ce8\u4e0d\u80fd\u8d85\u8fc7200\u4e2a\u5b57\u7b26;");
        }
        if (ObjectUtils.isEmpty((Object)dto.getBizDate())) {
            dto.setBizDate(new Date());
        }
        if (StringUtils.isNotEmpty((CharSequence)dto.getExternalOrderNo()) && dto.getExternalOrderNo().length() > 30) {
            errorMsg.append("\u5916\u90e8\u8ba2\u5355\u53f7\u4e0d\u80fd\u8d85\u8fc730\u4e2a\u5b57\u7b26");
        }
        dto.setErrorMsg(errorMsg.toString());
        return errorMsg.length() > 0;
    }

    private ItemVersionDgRespDto getBomInfoByCodes(String skuCode, String version) {
        ItemQueryDgReqDto skuReqDto = new ItemQueryDgReqDto();
        skuReqDto.setSkuCode(skuCode);
        List data = (List)this.itemSkuDgQueryApiProxy.querySkuList(skuReqDto).getData();
        if (CollectionUtil.isEmpty((Collection)data)) {
            return null;
        }
        for (ItemVersionDgRespDto respDto : ((DgItemSkuDetailRespDto)data.get(0)).getVersionDgReqDtos()) {
            if (!respDto.getVersion().equals(version)) continue;
            return respDto;
        }
        return null;
    }

    private Map<String, DgItemSkuDetailRespDto> getSkuInfoByCodes(List<String> skuCodes) {
        ItemQueryDgReqDto skuReqDto = new ItemQueryDgReqDto();
        skuReqDto.setSkuCodes(skuCodes);
        return ((List)this.itemSkuDgQueryApiProxy.querySkuList(skuReqDto).getData()).stream().collect(Collectors.toMap(DgItemSkuRespDto::getSkuCode, Function.identity()));
    }

    private List<DgLogicInventoryDto> getLogicInventoryByCodes(List<String> skuCodes, List<String> warehouseCodes) {
        DgLogicInventoryListReqDto reqDto = new DgLogicInventoryListReqDto();
        reqDto.setLogicWarehouseCodeList(warehouseCodes);
        reqDto.setSkuCodeList(skuCodes);
        reqDto.setBatchType(Boolean.valueOf(false));
        reqDto.setPageNum(Integer.valueOf(1));
        reqDto.setInventoryPropertyList(Arrays.asList("qualified"));
        reqDto.setPageSize(Integer.valueOf(skuCodes.size()));
        List dgLogicInventoryDtos = Optional.ofNullable(((PageInfo)RestResponseHelper.extractData((RestResponse)this.dgLogicInventoryApiProxy.page(reqDto))).getList()).orElse(new ArrayList());
        return dgLogicInventoryDtos;
    }

    private Map<String, UnitDgRespDto> getUnitMap() {
        return ((List)Optional.ofNullable(RestResponseHelper.extractData((RestResponse)this.unitDgQueryApiProxy.queryList(new UnitDgReqDto()))).orElse(new ArrayList())).stream().collect(Collectors.toMap(UnitDgRespDto::getName, Function.identity(), (k1, k2) -> k1));
    }

    private Map<String, String> getUnitCode2NameMap() {
        return ((List)Optional.ofNullable(RestResponseHelper.extractData((RestResponse)this.unitDgQueryApiProxy.queryList(new UnitDgReqDto()))).orElse(new ArrayList())).stream().collect(Collectors.toMap(UnitDgRespDto::getCode, UnitDgRespDto::getName, (k1, k2) -> k1));
    }
}

