/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.mgmt.service.impl;

import cn.afterturn.easypoi.excel.entity.result.ExcelImportResult;
import cn.hutool.core.collection.CollectionUtil;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.mgmt.application.rpc.dto.entity.ItemRelationComparisonDgDto;
import com.yunxi.dg.base.mgmt.application.rpc.dto.entity.ItemRelationComparisonDgListReqDto;
import com.yunxi.dg.base.mgmt.application.rpc.dto.request.DgShopQueryReqDto;
import com.yunxi.dg.base.mgmt.application.rpc.dto.request.ItemQueryDgReqDto;
import com.yunxi.dg.base.mgmt.application.rpc.dto.request.ItemRelationComparisonDgReqDto;
import com.yunxi.dg.base.mgmt.application.rpc.dto.response.DgItemSkuDetailRespDto;
import com.yunxi.dg.base.mgmt.application.rpc.dto.response.DgItemSkuRespDto;
import com.yunxi.dg.base.mgmt.application.rpc.dto.response.DgShopRespDto;
import com.yunxi.dg.base.mgmt.application.rpc.proxy.comparison.IItemRelationComparisonDgApiProxy;
import com.yunxi.dg.base.mgmt.application.rpc.proxy.comparison.IItemRelationComparisonDgQueryApiProxy;
import com.yunxi.dg.base.mgmt.application.rpc.proxy.query.IDgShopQueryApiProxy;
import com.yunxi.dg.base.mgmt.application.rpc.proxy.sku.IItemSkuDgQueryApiProxy;
import com.yunxi.dg.base.ocs.mgmt.application.dto.enums.FileModeTypeEnum;
import com.yunxi.dg.base.ocs.mgmt.application.dto.enums.FileOperationStatusEnum;
import com.yunxi.dg.base.ocs.mgmt.application.dto.request.ImportItemRelationComparisonModeDto;
import com.yunxi.dg.base.poi.dto.ImportBaseModeDto;
import com.yunxi.dg.base.poi.dto.ImportFileOperationCommonReqDto;
import com.yunxi.dg.base.poi.dto.ImportFileOperationCommonRespDto;
import com.yunxi.dg.base.poi.service.AbstractBaseFileOperationCommonService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="AbstractBaseFileOperationCommonService_item_relation_comparison_import")
public class ItemRelationComparisonCommonServiceImpl
extends AbstractBaseFileOperationCommonService {
    private static final Logger log = LoggerFactory.getLogger(ItemRelationComparisonCommonServiceImpl.class);
    @Resource
    private IDgShopQueryApiProxy dgShopQueryApiProxy;
    @Resource
    private IItemSkuDgQueryApiProxy itemSkuDgQueryApiProxy;
    @Resource
    private IItemRelationComparisonDgQueryApiProxy itemRelationComparisonDgQueryApiProxy;
    @Resource
    private IItemRelationComparisonDgApiProxy itemRelationComparisonDgApiProxy;

    public Object verifyImportFileOperationCommon(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto) {
        ArrayList list = new ArrayList();
        if (CollectionUtil.isEmpty((Collection)result.getList())) {
            return new ArrayList();
        }
        CubeBeanUtils.copyCollection(list, (Collection)result.getList(), ImportItemRelationComparisonModeDto.class);
        ArrayList<ImportItemRelationComparisonModeDto> passList = new ArrayList<ImportItemRelationComparisonModeDto>();
        ArrayList<String> shopCodeList = new ArrayList<String>();
        ArrayList<String> skuCodeList = new ArrayList<String>();
        HashMap<String, ItemRelationComparisonDgDto> relationComparisonMap = new HashMap();
        ArrayList<String> channelKeys = new ArrayList<String>();
        for (ImportItemRelationComparisonModeDto dto : list) {
            shopCodeList.add(dto.getShopCode());
            skuCodeList.add(dto.getSkuCode());
            String channelKey = dto.getChannelSkuCode() + dto.getChannelSkuId() + dto.getChannelItemCode() + dto.getChannelItemId() + dto.getShopCode();
            channelKeys.add(channelKey);
        }
        if (CollectionUtil.isNotEmpty(channelKeys)) {
            ItemRelationComparisonDgListReqDto reqDto = new ItemRelationComparisonDgListReqDto();
            reqDto.setChannelItemKeys(channelKeys);
            List data = (List)this.itemRelationComparisonDgQueryApiProxy.queryByList(reqDto).getData();
            if (CollectionUtil.isNotEmpty((Collection)data)) {
                relationComparisonMap = data.stream().collect(Collectors.toMap(ItemRelationComparisonDgDto::getChannelItemKey, Function.identity(), (k1, k2) -> k2));
            }
        }
        Map<String, Object> shopMap = new HashMap<String, DgShopRespDto>();
        Map<String, Object> skuMap = new HashMap<String, DgItemSkuDetailRespDto>();
        if (CollectionUtil.isNotEmpty(shopCodeList)) {
            DgShopQueryReqDto reqDto = new DgShopQueryReqDto();
            reqDto.setStoreCodeList(shopCodeList);
            List shopRespDtos = (List)this.dgShopQueryApiProxy.queryListShop(reqDto).getData();
            shopMap = shopRespDtos.stream().collect(Collectors.toMap(DgShopRespDto::getStoreCode, Function.identity(), (k1, k2) -> k2));
        }
        if (CollectionUtil.isNotEmpty(skuCodeList)) {
            ItemQueryDgReqDto skuReqDto = new ItemQueryDgReqDto();
            skuReqDto.setSkuCodes(skuCodeList);
            List skuDetailRespDtos = (List)this.itemSkuDgQueryApiProxy.querySkuList(skuReqDto).getData();
            skuMap = skuDetailRespDtos.stream().collect(Collectors.toMap(DgItemSkuRespDto::getSkuCode, Function.identity(), (k1, k2) -> k2));
        }
        HashSet<String> channelKeySet = new HashSet<String>();
        for (ImportItemRelationComparisonModeDto dto : list) {
            Boolean verify = this.itemRelationComparisonVerify(dto, passList, shopMap, skuMap, relationComparisonMap, channelKeySet);
            if (!verify.booleanValue()) {
                dto.setErrorMsg(String.format("\u7b2c%s\u884c\u6570\u636e\u6709\u8bef,%s", dto.getRowNum() + FileModeTypeEnum.getInstance((String)commonReqDto.getKey()).getHeadRows(), dto.getErrorMsg()));
                respDto.getErrorDetails().add(dto);
                continue;
            }
            passList.add(dto);
        }
        respDto.setDetails(passList);
        return passList;
    }

    public void callBackImportFileOperationCommonAsync(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto, Object object) {
        List passList = (List)object;
        if (CollectionUtil.isEmpty((Collection)passList)) {
            respDto.setStatus(FileOperationStatusEnum.IMPORT_ERROR.getCode());
            return;
        }
        respDto.setStatus(FileOperationStatusEnum.IMPORT_SUCCESS.getCode());
        if (CollectionUtil.isNotEmpty((Collection)passList) && !respDto.getErrorDetails().isEmpty()) {
            respDto.setStatus(FileOperationStatusEnum.IMPORT_PARTIAL_SUCCESS.getCode());
        }
        log.info("\u4e0a\u4e0b\u6587userCode:{}", (Object)commonReqDto.getCreatePerson());
        ArrayList itemRelationComparisonDgReqDto = Lists.newArrayList();
        try {
            CubeBeanUtils.copyCollection((Collection)itemRelationComparisonDgReqDto, (Collection)passList, ItemRelationComparisonDgReqDto.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        for (ItemRelationComparisonDgReqDto relationComparisonDgReqDto : itemRelationComparisonDgReqDto) {
            Integer relationState = Objects.nonNull(relationComparisonDgReqDto.getSkuCode()) ? 1 : 0;
            relationComparisonDgReqDto.setRelationState(relationState);
        }
        log.info("\u6279\u91cf\u4fdd\u5b58\u5355\u4f4d,\u6570\u91cf\u4e3a:{}", (Object)itemRelationComparisonDgReqDto.size());
        this.itemRelationComparisonDgApiProxy.importInsertBatch((List)itemRelationComparisonDgReqDto);
    }

    private Boolean itemRelationComparisonVerify(ImportItemRelationComparisonModeDto dto, List<ImportItemRelationComparisonModeDto> passList, Map<String, DgShopRespDto> shopMap, Map<String, DgItemSkuDetailRespDto> skuMap, Map<String, ItemRelationComparisonDgDto> relationComparisonMap, Set<String> channelKeySet) {
        DgShopRespDto dgShopRespDto = shopMap.get(dto.getShopCode());
        DgItemSkuDetailRespDto dgItemSkuDetailRespDto = skuMap.get(dto.getSkuCode());
        String channelKey = dto.getChannelSkuCode() + dto.getChannelSkuId() + dto.getChannelItemCode() + dto.getChannelItemId() + dto.getShopCode();
        if (Objects.isNull(dgShopRespDto)) {
            dto.setErrorMsg("\u6240\u5c5e\u5e97\u94fa\u4e0d\u5b58\u5728");
            return false;
        }
        if (Objects.isNull(dgItemSkuDetailRespDto)) {
            dto.setErrorMsg("\u5546\u54c1\u4fe1\u606f\u4e0d\u5b58\u5728");
            return false;
        }
        if (Objects.nonNull(relationComparisonMap.get(channelKey))) {
            dto.setErrorMsg("\u6570\u636e\u5df2\u5b58\u5728\uff0c\u8bf7\u52ff\u91cd\u590d\u63d0\u4ea4");
            return false;
        }
        if (channelKeySet.contains(channelKey)) {
            dto.setErrorMsg(channelKey + "\u6570\u636e\u5df2\u5b58\u5728\uff0c\u8bf7\u52ff\u91cd\u590d\u63d0\u4ea4");
            return false;
        }
        channelKeySet.add(channelKey);
        dto.setShopName(dgShopRespDto.getStoreName());
        dto.setChannelName(dgShopRespDto.getChannelName());
        dto.setChannelCode(dgShopRespDto.getChannelCode());
        dto.setItemCode(dgItemSkuDetailRespDto.getItemCode());
        dto.setItemName(dgItemSkuDetailRespDto.getItemName());
        dto.setSkuName(dgItemSkuDetailRespDto.getSkuName());
        return true;
    }
}

