/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.mgmt.service.impl;

import cn.afterturn.easypoi.excel.entity.result.ExcelImportResult;
import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.NumberUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.rest.RestResponse;
import com.yunxi.dg.base.center.inventory.dto.entity.LogicLockOrderDetailDto;
import com.yunxi.dg.base.center.inventory.dto.entity.LogicLockOrderDto;
import com.yunxi.dg.base.center.inventory.proxy.entity.ILogicLockOrderApiProxy;
import com.yunxi.dg.base.center.report.dto.inventory.DgLogicInventoryTotalDto;
import com.yunxi.dg.base.center.report.dto.inventory.DgLogicInventoryTotalPageReqDto;
import com.yunxi.dg.base.center.report.proxy.inventory.IDgLogicInventoryTotalApiProxy;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import com.yunxi.dg.base.commons.utils.decimal.BigDecimalUtils;
import com.yunxi.dg.base.mgmt.application.rpc.dto.entity.LogicWarehousePageReqDto;
import com.yunxi.dg.base.mgmt.application.rpc.dto.entity.LogicWarehouseRespDto;
import com.yunxi.dg.base.mgmt.application.rpc.dto.request.ItemQueryDgReqDto;
import com.yunxi.dg.base.mgmt.application.rpc.dto.response.DgItemSkuDetailRespDto;
import com.yunxi.dg.base.mgmt.application.rpc.dto.response.DgItemSkuRespDto;
import com.yunxi.dg.base.mgmt.application.rpc.proxy.sku.IItemSkuDgQueryApiProxy;
import com.yunxi.dg.base.mgmt.application.rpc.proxy.warehouse.ILogicWarehouseApiProxy;
import com.yunxi.dg.base.ocs.mgmt.application.dto.enums.FileModeTypeEnum;
import com.yunxi.dg.base.ocs.mgmt.application.dto.enums.LogicWarehouseQualityEnum;
import com.yunxi.dg.base.ocs.mgmt.application.dto.request.ImportLogicLockOrderModeDto;
import com.yunxi.dg.base.poi.dto.ImportBaseModeDto;
import com.yunxi.dg.base.poi.dto.ImportFileOperationCommonReqDto;
import com.yunxi.dg.base.poi.dto.ImportFileOperationCommonRespDto;
import com.yunxi.dg.base.poi.enums.FileOperationStatusEnum;
import com.yunxi.dg.base.poi.service.AbstractBaseFileOperationCommonService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="AbstractBaseFileOperationCommonService_logic_lock_order")
public class LogicLockOrderCommonServiceImpl
extends AbstractBaseFileOperationCommonService {
    private static final Logger log = LoggerFactory.getLogger(LogicLockOrderCommonServiceImpl.class);
    @Resource
    private IDgLogicInventoryTotalApiProxy dgLogicInventoryTotalApiProxy;
    @Resource
    private IItemSkuDgQueryApiProxy itemSkuDgQueryApiProxy;
    @Resource
    private ILogicWarehouseApiProxy logicWarehouseApiProxy;
    @Resource
    private ILogicLockOrderApiProxy logicLockOrderApiProxy;

    public Object verifyImportFileOperationCommon(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto) {
        log.info("\u5f00\u59cb\u5bfc\u5165\u903b\u8f91\u9501\u5e93\u5355");
        if (CollectionUtil.isEmpty((Collection)result.getList())) {
            return new ArrayList();
        }
        log.info("\u903b\u8f91\u9501\u5e93\u5355\u8bfb\u53d6\u6570\u91cf====>>>{}", (Object)result.getList().size());
        List resultList = BeanUtil.copyToList((Collection)result.getList(), ImportLogicLockOrderModeDto.class);
        List logicWarehouseCodeList = resultList.stream().map(ImportLogicLockOrderModeDto::getLogicWarehouseCode).distinct().collect(Collectors.toList());
        List skuCodeList = resultList.stream().map(ImportLogicLockOrderModeDto::getSkuCode).distinct().collect(Collectors.toList());
        DgLogicInventoryTotalPageReqDto dgLogicInventoryTotalPageReqDto = new DgLogicInventoryTotalPageReqDto();
        dgLogicInventoryTotalPageReqDto.setLogicWarehouseCodeList(logicWarehouseCodeList);
        dgLogicInventoryTotalPageReqDto.setSkuCodeList(skuCodeList);
        List dgLogicInventoryTotalDtos = (List)Optional.ofNullable(RestResponseHelper.extractData((RestResponse)this.dgLogicInventoryTotalApiProxy.queryList(dgLogicInventoryTotalPageReqDto))).orElse(Lists.newArrayList());
        Map<String, DgLogicInventoryTotalDto> inventoryTotalDtoMap = dgLogicInventoryTotalDtos.stream().collect(Collectors.toMap(o -> o.getWarehouseCode() + "_" + o.getSkuCode() + "_" + o.getInventoryProperty(), Function.identity(), (k1, k2) -> k1));
        ItemQueryDgReqDto itemQueryDgReqDto = new ItemQueryDgReqDto();
        itemQueryDgReqDto.setSkuCodes(skuCodeList);
        List dgItemSkuDetailRespDtos = Optional.ofNullable(RestResponseHelper.extractData((RestResponse)this.itemSkuDgQueryApiProxy.querySkuList(itemQueryDgReqDto))).orElse(new ArrayList());
        Map<String, DgItemSkuDetailRespDto> itemMap = dgItemSkuDetailRespDtos.stream().collect(Collectors.toMap(DgItemSkuRespDto::getSkuCode, Function.identity(), (k1, k2) -> k1));
        LogicWarehousePageReqDto reqDto = new LogicWarehousePageReqDto();
        reqDto.setWarehouseCodeList(logicWarehouseCodeList);
        List logicWarehouseRespDtos = (List)Optional.ofNullable(RestResponseHelper.extractData((RestResponse)this.logicWarehouseApiProxy.queryList(reqDto))).orElse(com.google.common.collect.Lists.newArrayList());
        Map<String, LogicWarehouseRespDto> warehouseRespDtoMap = logicWarehouseRespDtos.stream().collect(Collectors.toMap(LogicWarehouseRespDto::getWarehouseCode, Function.identity(), (k1, k2) -> k1));
        ArrayList<ImportLogicLockOrderModeDto> passList = new ArrayList<ImportLogicLockOrderModeDto>();
        ArrayList<ImportLogicLockOrderModeDto> errorList = new ArrayList<ImportLogicLockOrderModeDto>();
        for (ImportLogicLockOrderModeDto dto : resultList) {
            boolean isPass = this.paramVerify(dto, inventoryTotalDtoMap, itemMap, warehouseRespDtoMap);
            if (isPass) {
                this.setErrorMsg(dto, String.format("\u7b2c%s\u884c\u6570\u636e\u6709\u8bef,%s", dto.getRowNum() + FileModeTypeEnum.getInstance((String)commonReqDto.getKey()).getHeadRows(), dto.getErrorMsg()));
                errorList.add(dto);
                continue;
            }
            passList.add(dto);
        }
        respDto.setErrorDetails(errorList);
        respDto.setDetails(passList);
        return passList;
    }

    public void callBackImportFileOperationCommonAsync(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto, Object object) {
        List passList = (List)object;
        if (CollectionUtil.isEmpty((Collection)passList)) {
            respDto.setStatus(FileOperationStatusEnum.IMPORT_ERROR.getCode());
            return;
        }
        respDto.setStatus(FileOperationStatusEnum.IMPORT_SUCCESS.getCode());
        if (CollectionUtil.isNotEmpty((Collection)passList) && !respDto.getErrorDetails().isEmpty()) {
            respDto.setStatus(FileOperationStatusEnum.IMPORT_PARTIAL_SUCCESS.getCode());
        }
        try {
            ArrayList<LogicLockOrderDto> orderDtoList = new ArrayList<LogicLockOrderDto>();
            this.assembleDtos(orderDtoList, passList);
            for (LogicLockOrderDto lockOrderDto : orderDtoList) {
                this.logicLockOrderApiProxy.insert(lockOrderDto);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info("\u5bfc\u5165\u903b\u8f91\u9501\u5e93\u5355\u5931\u8d25:{}", (Object)e.getMessage());
            respDto.setStatus(FileOperationStatusEnum.IMPORT_ERROR.getCode());
            respDto.setErrorMsg(e.getMessage());
        }
    }

    private void assembleDtos(List<LogicLockOrderDto> orderDtoList, List<ImportLogicLockOrderModeDto> passList) {
        Map<String, List<ImportLogicLockOrderModeDto>> passMap = passList.stream().collect(Collectors.groupingBy(this::getGroupKey));
        log.info("\u5bfc\u5165\u903b\u8f91\u9501\u5e93\u5355\u5206\u7ec4\u540epassMap:{}", (Object)JSON.toJSONString(passMap));
        passMap.forEach((key, importDtos) -> {
            LogicLockOrderDto lockOrderDto = new LogicLockOrderDto();
            ArrayList detailDtoArrayList = new ArrayList();
            ImportLogicLockOrderModeDto importDto = (ImportLogicLockOrderModeDto)importDtos.get(0);
            BeanUtil.copyProperties((Object)importDto, (Object)lockOrderDto, (String[])new String[0]);
            lockOrderDto.setOrderType("logic_lock");
            lockOrderDto.setLogicWarehouseCode(importDto.getLogicWarehouseCode());
            lockOrderDto.setLogicWarehouseName(importDto.getLogicWarehouseName());
            lockOrderDto.setBusinessType("logic_lock");
            if (StringUtils.isNotEmpty((CharSequence)importDto.getLockStartDate())) {
                lockOrderDto.setLockStartDate((Date)DateUtil.parseDate((CharSequence)importDto.getLockStartDate()));
            }
            if (StringUtils.isNotEmpty((CharSequence)importDto.getLockEndDate())) {
                lockOrderDto.setLockEndDate((Date)DateUtil.parseDate((CharSequence)importDto.getLockEndDate()));
            }
            lockOrderDto.setOrganizationCode(importDto.getOrganizationCode());
            lockOrderDto.setOrganizationName(importDto.getOrganizationName());
            lockOrderDto.setRemark(importDto.getRemark());
            lockOrderDto.setCommitType("SAVE");
            Map<String, List<ImportLogicLockOrderModeDto>> detailMap = importDtos.stream().collect(Collectors.groupingBy(this::getGroupDetailKey));
            log.info("\u5bfc\u5165\u903b\u8f91\u9501\u5e93\u5355\u660e\u7ec6\u5206\u7ec4detailMap:{}", (Object)JSON.toJSONString(detailMap));
            detailMap.forEach((detailKey, detailDtoList) -> {
                ImportLogicLockOrderModeDto detailDto = (ImportLogicLockOrderModeDto)detailDtoList.get(0);
                LogicLockOrderDetailDto orderDetailDto = (LogicLockOrderDetailDto)BeanUtil.toBean((Object)detailDto, LogicLockOrderDetailDto.class);
                orderDetailDto.setSkuCode(detailDto.getSkuCode());
                orderDetailDto.setUnit(detailDto.getUnit());
                orderDetailDto.setSkuName(detailDto.getSkuName());
                orderDetailDto.setSpuCode(detailDto.getSpuCode());
                orderDetailDto.setSpuName(detailDto.getSpuName());
                orderDetailDto.setInventoryProperty(detailDto.getInventoryProperty());
                BigDecimal planQuantity = detailDtoList.stream().map(o -> new BigDecimal(o.getPlanQuantity())).reduce(BigDecimal.ZERO, BigDecimal::add);
                orderDetailDto.setPlanQuantity(planQuantity);
                detailDtoArrayList.add(orderDetailDto);
            });
            lockOrderDto.setDetailDtoList(detailDtoArrayList);
            orderDtoList.add(lockOrderDto);
        });
    }

    private boolean paramVerify(ImportLogicLockOrderModeDto dto, Map<String, DgLogicInventoryTotalDto> inventoryTotalDtoMap, Map<String, DgItemSkuDetailRespDto> itemMap, Map<String, LogicWarehouseRespDto> warehouseRespDtoMap) {
        ArrayList errorMsgList = com.google.common.collect.Lists.newArrayList();
        if (StringUtils.isEmpty((CharSequence)dto.getBusinessTypeName())) {
            errorMsgList.add("\u4e1a\u52a1\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        } else if (!StringUtils.equals((CharSequence)dto.getBusinessTypeName(), (CharSequence)"\u903b\u8f91\u9501\u5e93")) {
            errorMsgList.add("\u4e1a\u52a1\u7c7b\u578b\u586b\u5199\u9519\u8bef");
        }
        if (StringUtils.isEmpty((CharSequence)dto.getLogicWarehouseCode())) {
            errorMsgList.add("\u9501\u5e93\u4ed3\u5e93\u7f16\u7801\u672a\u586b\u5199");
        } else {
            LogicWarehouseRespDto logicWarehouseRespDto = warehouseRespDtoMap.get(dto.getLogicWarehouseCode());
            if (null == logicWarehouseRespDto) {
                errorMsgList.add("\u9501\u5e93\u4ed3\u5e93\u7f16\u7801\u4e0d\u5b58\u5728");
            } else {
                dto.setLogicWarehouseName(logicWarehouseRespDto.getWarehouseName());
                dto.setOrganizationCode(logicWarehouseRespDto.getOrganizationCode());
                dto.setOrganizationName(logicWarehouseRespDto.getOrganizationName());
            }
        }
        if (StrUtil.isBlank((CharSequence)dto.getLockStartDate())) {
            errorMsgList.add("\u9501\u5e93\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        } else {
            String lockStartDate = this.pareDate(dto.getLockStartDate());
            if (null == lockStartDate) {
                errorMsgList.add("\u9501\u5e93\u5f00\u59cb\u65f6\u95f4\u683c\u5f0f\u4e0d\u7b26\u5408 yyyy/MM/dd");
            } else {
                dto.setLockStartDate(lockStartDate);
            }
        }
        if (StrUtil.isBlank((CharSequence)dto.getLockEndDate())) {
            errorMsgList.add("\u9501\u5e93\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        } else {
            String lockEndDate = this.pareDate(dto.getLockEndDate());
            if (null == lockEndDate) {
                errorMsgList.add("\u9501\u5e93\u7ed3\u675f\u65f6\u95f4\u683c\u5f0f\u4e0d\u7b26\u5408 yyyy/MM/dd");
            } else {
                dto.setLockEndDate(lockEndDate);
            }
        }
        String today = DateUtil.today();
        if (StringUtils.isNotEmpty((CharSequence)dto.getLockStartDate()) && StringUtils.isNotEmpty((CharSequence)dto.getLockEndDate())) {
            String lockStartDate = this.pareDate(dto.getLockStartDate());
            String lockEndDate = this.pareDate(dto.getLockEndDate());
            if (null != lockEndDate && null != lockStartDate) {
                if (DateUtil.compare((Date)DateUtil.parseDate((CharSequence)lockStartDate), (Date)DateUtil.parseDate((CharSequence)today)) < 0) {
                    errorMsgList.add("\u9501\u5e93\u5f00\u59cb\u65f6\u95f4\u4e0d\u53ef\u5c0f\u4e8e\u5f53\u524d\u65f6\u95f4");
                }
                if (DateUtil.compare((Date)DateUtil.parseDate((CharSequence)lockEndDate), (Date)DateUtil.parseDate((CharSequence)lockStartDate)) < 0) {
                    errorMsgList.add("\u9501\u5e93\u7ed3\u675f\u65f6\u95f4\u4e0d\u53ef\u5c0f\u4e8e\u9501\u5e93\u5f00\u59cb\u65f6\u95f4");
                }
            }
        }
        if (StringUtils.isEmpty((CharSequence)dto.getSkuCode())) {
            errorMsgList.add("SKU\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        } else {
            DgItemSkuDetailRespDto itemSkuDgRespDto = itemMap.get(dto.getSkuCode());
            if (null == itemSkuDgRespDto) {
                errorMsgList.add("SKU\u7f16\u7801\u4e0d\u5b58\u5728");
            } else {
                dto.setSkuName(itemSkuDgRespDto.getSkuName());
                dto.setUnit(itemSkuDgRespDto.getUnit());
                dto.setSpuCode(itemSkuDgRespDto.getItemCode());
                dto.setSpuName(itemSkuDgRespDto.getItemName());
                dto.setSkuDisplayName(itemSkuDgRespDto.getSkuDisplayName());
            }
        }
        if (StringUtils.isEmpty((CharSequence)dto.getInventoryPropertyName())) {
            errorMsgList.add("\u5e93\u5b58\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a");
        } else {
            LogicWarehouseQualityEnum qualityEnum = LogicWarehouseQualityEnum.getByDesc((String)dto.getInventoryPropertyName());
            if (ObjectUtil.isEmpty((Object)qualityEnum)) {
                errorMsgList.add("\u5e93\u5b58\u72b6\u6001\u7c7b\u578b\u586b\u5199\u9519\u8bef");
            } else {
                dto.setInventoryProperty(qualityEnum.getCode());
            }
        }
        if (StringUtils.isEmpty((CharSequence)dto.getPlanQuantity())) {
            errorMsgList.add("\u8ba1\u5212\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
        } else {
            DgLogicInventoryTotalDto dgLogicInventoryTotalDto = inventoryTotalDtoMap.get(dto.getLogicWarehouseCode() + "_" + dto.getSkuCode() + "_" + dto.getInventoryProperty());
            if (null == dgLogicInventoryTotalDto) {
                errorMsgList.add("\u8be5\u4ed3+\u54c1+\u5e93\u5b58\u72b6\u6001\uff0c\u5728\u603b\u5e93\u5b58\u4e2d\u4e0d\u5b58\u5728");
            } else if (!dto.getPlanQuantity().matches("\\d+")) {
                errorMsgList.add("\u8ba1\u5212\u51fa\u5e93\u6570\u91cf\u5fc5\u987b\u4e3a\u6b63\u6574\u6570");
            } else {
                if (BigDecimalUtils.eqZero((BigDecimal)new BigDecimal(dto.getPlanQuantity())).booleanValue()) {
                    errorMsgList.add("\u8ba1\u5212\u9501\u5e93\u6570\u91cf\u4e0d\u80fd\u7b49\u4e8e0");
                }
                if (BigDecimalUtils.gt((BigDecimal)new BigDecimal(dto.getPlanQuantity()), (BigDecimal)dgLogicInventoryTotalDto.getAvailable()).booleanValue()) {
                    errorMsgList.add("\u8ba1\u5212\u9501\u5e93\u6570\u91cf\u5927\u4e8e\u53ef\u7528\u5e93\u5b58");
                }
            }
        }
        if (CollectionUtil.isNotEmpty((Collection)errorMsgList)) {
            dto.setErrorMsg(StrUtil.join((CharSequence)";", (Iterable)errorMsgList));
            return true;
        }
        return false;
    }

    private String setErrorMsg(ImportLogicLockOrderModeDto dto, String errorMsg) {
        log.info("\u6821\u9a8c\u9519\u8bef\u4fe1\u606f{}", (Object)errorMsg);
        dto.setErrorMsg(errorMsg);
        return dto.getErrorMsg();
    }

    private String pareDate(String dateStr) {
        Object date;
        block3: {
            date = null;
            try {
                date = DateUtil.parse((CharSequence)dateStr, (String)"yyyy/MM/dd");
            }
            catch (Exception e) {
                if (!NumberUtil.isNumber((CharSequence)dateStr)) break block3;
                date = org.apache.poi.ss.usermodel.DateUtil.getJavaDate((double)NumberUtil.parseDouble((String)dateStr));
            }
        }
        if (null == date) {
            return null;
        }
        return DateUtil.format((Date)date, (String)"yyyy/MM/dd");
    }

    private String getGroupKey(ImportLogicLockOrderModeDto o) {
        return o.getBusinessType() + o.getLogicWarehouseCode() + o.getLockStartDate() + o.getLockEndDate();
    }

    private String getGroupDetailKey(ImportLogicLockOrderModeDto o) {
        return o.getSkuCode() + o.getInventoryPropertyName();
    }
}

