/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.mgmt.service.operation.impl;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.huieryun.log.RequestId;
import com.dtyunxi.rest.RestResponse;
import com.yunxi.dg.base.mgmt.service.operation.AbstractFileOperationCommonService;
import com.yunxi.dg.base.mgmt.service.operation.FileOperationCommonService;
import com.yunxi.dg.base.ocs.mgmt.application.dto.financial.ExportFileOperationCommonReqDto;
import com.yunxi.dg.base.ocs.mgmt.application.dto.financial.ExportFileOperationCommonRespDto;
import com.yunxi.dg.base.ocs.mgmt.application.dto.financial.ImportFileOperationCommonReqDto;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.collections4.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class FileOperationCommonServiceImpl
implements FileOperationCommonService {
    private static final Logger logger = LoggerFactory.getLogger(FileOperationCommonService.class);
    private static final String MAP_SERVICE_NAME = "abstractFileOperationCommonService";
    @Autowired
    private Map<String, AbstractFileOperationCommonService> mapService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    @Async
    public RestResponse<String> importFileOperationCommon(ImportFileOperationCommonReqDto commonReqDto) {
        if (MapUtils.isNotEmpty((Map)commonReqDto.getContextMap())) {
            commonReqDto.getContextMap().forEach((key, value) -> ServiceContext.getContext().setAttachment(key, value));
            String reqId = Optional.ofNullable(commonReqDto.getContextMap().get("yes.req.requestId")).orElse(RequestId.createReqId());
            MDC.put((String)"yes.req.requestId", (String)reqId);
        }
        logger.info("commonReqDto=\u300b{}", (Object)JSON.toJSONString((Object)commonReqDto));
        return null;
    }

    @Override
    public RestResponse<ExportFileOperationCommonRespDto> exportFileOperationCommon(Long taskId) {
        return null;
    }

    @Override
    public RestResponse<Integer> exportTotal(ExportFileOperationCommonReqDto commonReqDto) {
        AbstractFileOperationCommonService commonService = this.getCommonService(commonReqDto.getKey());
        return new RestResponse((Object)commonService.exportTotal(commonReqDto));
    }

    private void checkExportFileOperationCommonParam(ExportFileOperationCommonReqDto commonReqDto) {
        if (Objects.isNull(commonReqDto)) {
            throw new BizException("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StrUtil.isBlank((CharSequence)commonReqDto.getKey())) {
            throw new BizException("\u64cd\u4f5c\u529f\u80fd\u6a21\u5757\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private void checkImportFileOperationCommonParam(ImportFileOperationCommonReqDto commonReqDto) {
        if (Objects.isNull(commonReqDto)) {
            throw new BizException("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StrUtil.isBlank((CharSequence)commonReqDto.getUrl())) {
            throw new BizException("\u4e0a\u4f20\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StrUtil.isBlank((CharSequence)commonReqDto.getKey())) {
            throw new BizException("\u64cd\u4f5c\u529f\u80fd\u6a21\u5757\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StrUtil.isBlank((CharSequence)commonReqDto.getTaskCode())) {
            throw new BizException("\u5bfc\u5165\u4efb\u52a1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private AbstractFileOperationCommonService getCommonService(String module) {
        return null;
    }
}

