/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.mgmt.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.rest.RestResponse;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.report.dto.inventory.DgAllInventoryDto;
import com.yunxi.dg.base.center.report.dto.inventory.DgAllInventoryReqDto;
import com.yunxi.dg.base.center.report.proxy.inventory.ILogicInventoryApiProxy;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import com.yunxi.dg.base.mgmt.service.enums.ExportBalanceInventoryEnum;
import com.yunxi.dg.base.ocs.mgmt.application.dto.enums.FileModeTypeEnum;
import com.yunxi.dg.base.ocs.mgmt.application.dto.response.ExportBalanceInventoryRespDto;
import com.yunxi.dg.base.poi.dto.ExportBaseModeDto;
import com.yunxi.dg.base.poi.dto.ExportQueryParamsReqDto;
import com.yunxi.dg.base.poi.service.AbstractBaseFileOperationCommonService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="AbstractBaseFileOperationCommonService_balance_inventory_export")
public class BalanceInventoryCommonServiceImpl
extends AbstractBaseFileOperationCommonService {
    private static final Logger log = LoggerFactory.getLogger(BalanceInventoryCommonServiceImpl.class);
    @Resource
    private ILogicInventoryApiProxy iLogicInventoryApiProxy;

    public List<? extends ExportBaseModeDto> callBackScrollData(ExportQueryParamsReqDto exportQueryParamsReqDto) throws Exception {
        String key = exportQueryParamsReqDto.getExportFileParams().getKey();
        String filter = exportQueryParamsReqDto.getFilter();
        log.info("\u5373\u65f6\u5e93\u5b58\u67e5\u8be2\u5bfc\u51fa\u67e5\u8be2\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)exportQueryParamsReqDto));
        AssertUtils.isTrue((boolean)FileModeTypeEnum.BALANCE_INVENTORY_EXPORT.getKey().equals(key), (String)"\u4e1a\u52a1key\u6709\u8bef");
        DgAllInventoryReqDto pageReqDto = new DgAllInventoryReqDto();
        if (StrUtil.isNotBlank((CharSequence)filter)) {
            pageReqDto = (DgAllInventoryReqDto)JSON.parseObject((String)filter, DgAllInventoryReqDto.class);
        }
        List pageList = ((PageInfo)RestResponseHelper.extractData((RestResponse)this.iLogicInventoryApiProxy.queryAllInventoryPage(pageReqDto))).getList();
        ArrayList<ExportBalanceInventoryRespDto> list = new ArrayList<ExportBalanceInventoryRespDto>();
        if (CollectionUtil.isEmpty((Collection)pageList)) {
            return Collections.EMPTY_LIST;
        }
        Integer num = 1;
        for (DgAllInventoryDto dto : pageList) {
            ExportBalanceInventoryRespDto exportDto = (ExportBalanceInventoryRespDto)BeanUtil.copyProperties((Object)dto, ExportBalanceInventoryRespDto.class, (String[])new String[0]);
            Integer n = num;
            Integer n2 = num = Integer.valueOf(num + 1);
            exportDto.setNumber(n);
            exportDto.setExpireTime(DateUtil.formatDateTime((Date)dto.getExpireTime()));
            exportDto.setProduceTime(DateUtil.formatDateTime((Date)dto.getProduceTime()));
            exportDto.setUnit(ExportBalanceInventoryEnum.getInstance(dto.getUnit()).getDesc());
            list.add(exportDto);
        }
        log.info("\u5373\u65f6\u5e93\u5b58\u67e5\u8be2\u5bfc\u51fa\u5927\u5c0f:{}", (Object)list.size());
        return list;
    }
}

