/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.mgmt.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.cube.utils.enums.DatePattern;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.util.ParamConverter;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.finance.dto.request.BookKeepingRemarkReqDto;
import com.yunxi.dg.base.center.finance.dto.request.BookKeepingRepairReqDto;
import com.yunxi.dg.base.center.finance.dto.request.KeepAccountsDetailReqDto;
import com.yunxi.dg.base.center.finance.dto.request.KeepQueryConditionDto;
import com.yunxi.dg.base.center.finance.dto.request.KeepQueryConditionQueryPageDto;
import com.yunxi.dg.base.center.finance.dto.request.MamualKeepAccountReqDto;
import com.yunxi.dg.base.center.finance.dto.request.PushKeepAccountsReqDto;
import com.yunxi.dg.base.center.finance.dto.request.UpdateKeepVoucherDto;
import com.yunxi.dg.base.center.finance.dto.response.PushKeepAccountsRespDto;
import com.yunxi.dg.base.center.finance.dto.response.RetryKeepReqDto;
import com.yunxi.dg.base.center.finance.proxy.entity.IKeepAccountsDetailApiProxy;
import com.yunxi.dg.base.center.finance.proxy.entity.IPushKeepAccountsApiProxy;
import com.yunxi.dg.base.mgmt.excel.AbleEasyPoiExportUtil;
import com.yunxi.dg.base.mgmt.service.FinancialManagementBookkeepingManagementBookkeepingOrderService;
import com.yunxi.dg.base.mgmt.service.IDataExportServiceAble;
import com.yunxi.dg.base.mgmt.service.operation.impl.HandlerFileOperationCommonServiceImpl;
import com.yunxi.dg.base.ocs.mgmt.application.dto.enums.KeepSaleOrderTypeEnum;
import com.yunxi.dg.base.ocs.mgmt.application.dto.enums.MasterSlaveTypeEnum;
import com.yunxi.dg.base.ocs.mgmt.application.dto.enums.ModeTypeEnum;
import com.yunxi.dg.base.ocs.mgmt.application.dto.enums.SaleOrderTypeEnum;
import com.yunxi.dg.base.ocs.mgmt.application.dto.enums.VoucherTypeEnum;
import com.yunxi.dg.base.ocs.mgmt.application.dto.financial.ExportBookAccountOrderDto;
import com.yunxi.dg.base.ocs.mgmt.application.dto.financial.ExportFileOperationCommonReqDto;
import com.yunxi.dg.base.ocs.mgmt.application.dto.financial.request.BookkeepingRemarkOrderBody;
import com.yunxi.dg.base.ocs.mgmt.application.dto.financial.request.BookkeepingRepairOrderBody;
import com.yunxi.dg.base.ocs.mgmt.application.dto.financial.request.CreateHandworkBookkeepingCertificateBody;
import com.yunxi.dg.base.ocs.mgmt.application.dto.financial.request.GetBookkeepingOrderDetailParams;
import com.yunxi.dg.base.ocs.mgmt.application.dto.financial.request.GetBookkeepingOrderListPageBody;
import com.yunxi.dg.base.ocs.mgmt.application.dto.financial.request.MarkBookkeepingOrderBody;
import com.yunxi.dg.base.ocs.mgmt.application.dto.financial.request.RestartPushOfBookkeepingOrderBody;
import com.yunxi.dg.base.ocs.mgmt.application.dto.financial.request.UpdateBookkeepingDateBody;
import com.yunxi.dg.base.ocs.mgmt.application.dto.financial.response.BookkeepingDetailDto;
import com.yunxi.dg.base.ocs.mgmt.application.dto.financial.response.BookkeepingOrderDto;
import io.swagger.annotations.ApiParam;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.validation.Valid;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestBody;

@Service(value="abstractFileOperationCommonService_financial_management")
public class FinancialManagementBookkeepingManagementBookkeepingOrderServiceServiceImpl
extends HandlerFileOperationCommonServiceImpl
implements FinancialManagementBookkeepingManagementBookkeepingOrderService,
IDataExportServiceAble<ExportBookAccountOrderDto, ExportFileOperationCommonReqDto> {
    @Resource
    private IPushKeepAccountsApiProxy pushKeepAccountsApiProxy;
    @Resource
    private IKeepAccountsDetailApiProxy keepAccountsDetailApiProxy;
    private static final Logger logger = LoggerFactory.getLogger(FinancialManagementBookkeepingManagementBookkeepingOrderServiceServiceImpl.class);

    @Override
    public RestResponse<PageInfo<BookkeepingDetailDto>> getBookkeepingOrderDetailListPage(@ApiParam(value="") @Valid @RequestBody(required=false) GetBookkeepingOrderDetailParams getBookkeepingOrderDetailParams) {
        KeepQueryConditionDto queryConditionDto = new KeepQueryConditionDto();
        queryConditionDto.setId(getBookkeepingOrderDetailParams.getId());
        queryConditionDto.setChargeCode(getBookkeepingOrderDetailParams.getBookkeepingOrderNo());
        logger.info("\u8bb0\u8d26\u5355\u660e\u7ec6\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)queryConditionDto));
        PageInfo respDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.pushKeepAccountsApiProxy.queryDetailsByPage(getBookkeepingOrderDetailParams.getPageNum(), getBookkeepingOrderDetailParams.getPageSize(), queryConditionDto));
        logger.info("\u8bb0\u8d26\u5355\u660e\u7ec6\u51fa\u53c2:{}", (Object)JSON.toJSONString((Object)respDtoPageInfo));
        PageInfo pageInfo = new PageInfo();
        if (CollectionUtils.isEmpty((Collection)respDtoPageInfo.getList())) {
            return new RestResponse((Object)pageInfo);
        }
        CubeBeanUtils.copyProperties((Object)pageInfo, (Object)respDtoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        List list = respDtoPageInfo.getList().stream().map(o -> {
            BookkeepingDetailDto vo = new BookkeepingDetailDto();
            BeanUtils.copyProperties((Object)o, (Object)vo);
            vo.setWarehouseCode(o.getWarehouseCode());
            vo.setBookkeepingTypeName(o.getChargeAccountName());
            vo.setExpendIntegrate(ParamConverter.convertToBigDecimal((Object)o.getConsume()));
            vo.setExpendIntegrateNumber(o.getConsumeNo());
            vo.setCustomerCode(o.getCustomerCode());
            vo.setCustomerName(o.getCustomerName());
            vo.setSapDeliveryOrderNo(o.getDeliveryNote());
            vo.setSapInvoiceNumber(o.getInvoiceNo());
            vo.setObtainIntegrateNumber(o.getIssueNo());
            vo.setGoodsCode(o.getItemCode());
            vo.setQuantity(ParamConverter.convertToInteger((Object)o.getNum()));
            vo.setObtainIntegrate(ParamConverter.convertToBigDecimal((Object)o.getObtain()));
            vo.setSapTransitOrderNo(o.getPostingNo());
            vo.setRealAmount(o.getPrice());
            vo.setSapSaleOrderNo(o.getSaleNo());
            vo.setOrderNo(o.getOrderNo());
            if (null != o.getChargeDate()) {
                vo.setChargeDate(com.dtyunxi.util.DateUtil.format((Date)o.getChargeDate(), (String)"yyyy-MM-dd"));
            }
            vo.setCertificateType(o.getVoucherType());
            if (null != o.getAmount()) {
                vo.setSapPrice(o.getAmount() + "");
            }
            return vo;
        }).collect(Collectors.toList());
        pageInfo.setList(list);
        return new RestResponse((Object)pageInfo);
    }

    @Override
    public RestResponse<Void> createHandworkBookkeepingCertificate(@ApiParam(value="") @Valid @RequestBody(required=false) CreateHandworkBookkeepingCertificateBody createHandworkBookkeepingCertificateBody) {
        MamualKeepAccountReqDto reqDto = new MamualKeepAccountReqDto();
        reqDto.setStartTime(createHandworkBookkeepingCertificateBody.getStartDate());
        reqDto.setEndTime(createHandworkBookkeepingCertificateBody.getEndDate());
        reqDto.setOrderType(createHandworkBookkeepingCertificateBody.getOrderTypeCode());
        reqDto.setType("1");
        reqDto.setVoucherType(createHandworkBookkeepingCertificateBody.getVoucherType());
        reqDto.setChargeDate(createHandworkBookkeepingCertificateBody.getChargeDate());
        reqDto.setGeneratePerson(ServiceContext.getContext().getRequestUserCode());
        reqDto.setBillShopType(createHandworkBookkeepingCertificateBody.getBillShopType());
        reqDto.setWarehouseCode(createHandworkBookkeepingCertificateBody.getWarehouseCode());
        reqDto.setInnerOrderNos(createHandworkBookkeepingCertificateBody.getInnerOrderNos());
        logger.info("\u751f\u6210\u624b\u5de5\u51ed\u8bc1\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)reqDto));
        return this.keepAccountsDetailApiProxy.manualGenerateBookAccount(reqDto);
    }

    @Override
    public RestResponse<Map<String, BigDecimal>> queryTotal(GetBookkeepingOrderListPageBody getBookkeepingOrderListPageBody) {
        KeepQueryConditionDto keepQueryConditionDto = new KeepQueryConditionDto();
        this.getParams(getBookkeepingOrderListPageBody, keepQueryConditionDto);
        logger.info("\u8bb0\u8d26\u6570\u91cf\u91d1\u989d\u6c47\u603b\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)keepQueryConditionDto));
        Map resultMap = (Map)RestResponseHelper.extractData((RestResponse)this.pushKeepAccountsApiProxy.queryTotal(keepQueryConditionDto));
        logger.info("\u8bb0\u8d26\u6570\u91cf\u91d1\u989d\u6c47\u603b\u51fa\u53c2:{}", (Object)JSON.toJSONString((Object)resultMap));
        return new RestResponse((Object)resultMap);
    }

    @Override
    public RestResponse<PageInfo<BookkeepingOrderDto>> getBookkeepingOrderListPage(@ApiParam(value="") @RequestBody(required=false) @Valid GetBookkeepingOrderListPageBody getBookkeepingOrderListPageBody) {
        KeepQueryConditionDto keepQueryConditionDto = new KeepQueryConditionDto();
        this.getParams(getBookkeepingOrderListPageBody, keepQueryConditionDto);
        logger.info("\u8bb0\u8d26\u6c47\u603b\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)keepQueryConditionDto));
        PageInfo respDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.pushKeepAccountsApiProxy.queryPage(getBookkeepingOrderListPageBody.getPageNum(), getBookkeepingOrderListPageBody.getPageSize(), keepQueryConditionDto));
        logger.info("\u8bb0\u8d26\u6c47\u603b\u51fa\u53c2:{}", (Object)JSON.toJSONString((Object)respDtoPageInfo));
        PageInfo pageInfo = new PageInfo();
        if (CollectionUtils.isEmpty((Collection)respDtoPageInfo.getList())) {
            return new RestResponse((Object)pageInfo);
        }
        List infoList = respDtoPageInfo.getList();
        List chargeCodeList = infoList.stream().map(PushKeepAccountsRespDto::getChargeCode).distinct().collect(Collectors.toList());
        KeepAccountsDetailReqDto reqDto = new KeepAccountsDetailReqDto();
        reqDto.setChargeCodes(chargeCodeList);
        logger.info("\u8bb0\u8d26\u660e\u7ec6\u5217\u8868\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)reqDto));
        logger.info("\u8bb0\u8d26\u660e\u7ec6\u5217\u8868\u51fa\u53c2:{}", (Object)JSON.toJSONString((Object)reqDto));
        CubeBeanUtils.copyProperties((Object)pageInfo, (Object)respDtoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        List list = respDtoPageInfo.getList().stream().map(o -> {
            BookkeepingOrderDto vo = new BookkeepingOrderDto();
            BeanUtils.copyProperties((Object)o, (Object)vo);
            if (o.getChargeDate() != null) {
                vo.setBookkeepingDate(com.dtyunxi.util.DateUtil.format((Date)o.getChargeDate(), (String)DatePattern.DATE_PATTERN.getPattern()));
            }
            vo.setBookkeepingOrderTypeName(o.getOrderTypeName());
            vo.setBookkeepingOrderNo(o.getChargeCode());
            vo.setBussinessOrderNoList(o.getInnerOrderNo());
            vo.setPlatformNoList(o.getPlatformNo());
            if (o.getGenerateTime() != null) {
                vo.setCreateTime(com.dtyunxi.util.DateUtil.format((Date)o.getGenerateTime(), (String)DatePattern.DATETIME_PATTERN.getPattern()));
            }
            vo.setCertificateType(o.getVoucherType());
            vo.setBookkeepingTypeName(o.getChargeAccountName());
            vo.setSapDeliveryOrderNo(o.getDeliveryNote());
            vo.setSapSaleOrderNo(o.getSaleNo());
            vo.setInnerOrderNo(o.getInnerOrderNo());
            vo.setSapTransitOrderNo(o.getPostingNo());
            vo.setSapInvoiceNumber(o.getInvoiceNo());
            vo.setCustomerCode(o.getCustomerCode());
            vo.setWarehouseCode(o.getWarehouseCode());
            vo.setQuantity(o.getItemNum());
            Date chargeDate = o.getChargeDate();
            vo.setChargeDate(chargeDate);
            if (o.getItemPrice() != null) {
                vo.setRealAmount(o.getItemPrice().setScale(2));
            }
            if (o.getObtainIntegal() != null) {
                vo.setObtainIntegrate(ParamConverter.convertToBigDecimal((Object)o.getObtainIntegal()).setScale(2));
            }
            if (o.getConsumeIntegal() != null) {
                vo.setExpendIntegrate(ParamConverter.convertToBigDecimal((Object)o.getConsumeIntegal()).setScale(2));
            }
            vo.setBookkeepingResult(o.getKeepingResult());
            if (o.getDeliveryPushTime() != null) {
                vo.setDeliveryPushTime(com.dtyunxi.util.DateUtil.format((Date)o.getDeliveryPushTime(), (String)DatePattern.DATETIME_PATTERN.getPattern()));
            }
            if (o.getInvoicePushTime() != null) {
                vo.setInvoicePushTime(com.dtyunxi.util.DateUtil.format((Date)o.getInvoicePushTime(), (String)DatePattern.DATETIME_PATTERN.getPattern()));
            }
            vo.setFailResult(o.getReason());
            vo.setPushStatus(o.getPushStatus());
            vo.setBookReason(o.getBookReason());
            vo.setProjectNo(o.getProjectNo());
            vo.setCostCenter(o.getCostCenter());
            vo.setSapPushOrderId(o.getYxId());
            vo.setSiteCode(o.getSiteCode());
            vo.setSiteName(o.getSiteName());
            vo.setShopCode(o.getShopCode());
            vo.setShopName(o.getShopName());
            if (null != o.getDeliveryTime()) {
                vo.setDeliveryTime(com.dtyunxi.util.DateUtil.format((Date)o.getDeliveryTime(), (String)DatePattern.DATETIME_PATTERN.getPattern()));
            }
            if (null != o.getCompleteTime()) {
                vo.setCompleteTime(com.dtyunxi.util.DateUtil.format((Date)o.getCompleteTime(), (String)DatePattern.DATETIME_PATTERN.getPattern()));
            }
            vo.setGeneratePerson(o.getCreatePerson());
            vo.setPushPerson(o.getCreatePerson());
            if (null != o.getPlatformCreateTime()) {
                vo.setPlatformCreateTime(com.dtyunxi.util.DateUtil.format((Date)o.getPlatformCreateTime(), (String)DatePattern.DATETIME_PATTERN.getPattern()));
            }
            vo.setSaleOrderType(o.getSaleOrderType());
            vo.setBillShopType(o.getBillShopType());
            vo.setSaleOrderTypeName(KeepSaleOrderTypeEnum.getDesc((String)o.getSaleOrderType()));
            vo.setSaleOrderType(o.getSaleOrderType());
            vo.setMasterDeputyIdentity(o.getMasterDeputyIdentity());
            vo.setPlatformNo(o.getPlatformOrderNo());
            vo.setProductType(o.getItemType());
            vo.setBalanceProcessingResult(o.getBalanceProcessingResult());
            if (StringUtils.isNotBlank((CharSequence)o.getOrderType())) {
                vo.setLineOrderType("SALE_LIST".equalsIgnoreCase(o.getOrderType()) ? "\u6b63\u5411" : "\u9006\u5411");
            }
            return vo;
        }).collect(Collectors.toList());
        pageInfo.setList(list);
        return new RestResponse((Object)pageInfo);
    }

    @Override
    public RestResponse<Void> markBookkeepingOrder(@ApiParam(value="") @Valid @RequestBody(required=false) MarkBookkeepingOrderBody markBookkeepingOrderBody) {
        if (Objects.isNull(markBookkeepingOrderBody)) {
            throw new BizException("\u8bf7\u6c42\u53c2\u6570\u4e3a\u7a7a!");
        }
        ArrayList<PushKeepAccountsReqDto> reqDtos = new ArrayList<PushKeepAccountsReqDto>();
        PushKeepAccountsReqDto accountsReqDto = new PushKeepAccountsReqDto();
        String chargeDate = markBookkeepingOrderBody.getBookkeepingDate() + " " + com.dtyunxi.util.DateUtil.format((Date)new Date(), (String)"HH:mm:ss");
        accountsReqDto.setId(markBookkeepingOrderBody.getId());
        accountsReqDto.setChargeDate(DateUtil.parseDate((String)chargeDate, (String)DatePattern.DATETIME_PATTERN.getPattern()));
        accountsReqDto.setDeliveryNote(markBookkeepingOrderBody.getSapDeliveryOrderNo());
        accountsReqDto.setSaleNo(markBookkeepingOrderBody.getSapSaleOrderNo());
        accountsReqDto.setPostingNo(markBookkeepingOrderBody.getSapTransitOrderNo());
        accountsReqDto.setInvoiceNo(markBookkeepingOrderBody.getSapInvoiceNumber());
        accountsReqDto.setReason(markBookkeepingOrderBody.getFailResult());
        accountsReqDto.setGroupReceiveOrder(markBookkeepingOrderBody.getGroupReceiveOrder());
        reqDtos.add(accountsReqDto);
        return this.pushKeepAccountsApiProxy.abnormalBookkeepingCorrection(reqDtos);
    }

    @Override
    public RestResponse<Object> bookKeepingRemark(@ApiParam(value="") @Valid @RequestBody(required=false) BookkeepingRemarkOrderBody bookkeepingRemarkOrderBody) {
        if (Objects.isNull(bookkeepingRemarkOrderBody)) {
            throw new BizException("\u8bf7\u6c42\u53c2\u6570\u4e3a\u7a7a!");
        }
        BookKeepingRemarkReqDto bookKeepingRemarkReqDto = new BookKeepingRemarkReqDto();
        bookKeepingRemarkReqDto.setKeepingResult(bookkeepingRemarkOrderBody.getKeepingResult());
        bookKeepingRemarkReqDto.setIds(bookkeepingRemarkOrderBody.getIds());
        bookKeepingRemarkReqDto.setUpdatePerson(ServiceContext.getContext().getRequestUserCode());
        return new RestResponse(RestResponseHelper.extractData((RestResponse)this.pushKeepAccountsApiProxy.bookKeepingRemark(bookKeepingRemarkReqDto)));
    }

    @Override
    public RestResponse<Object> repairKeepAccountDocumentNo(@ApiParam(value="") @Valid @RequestBody(required=false) BookkeepingRepairOrderBody bookkeepingRepairOrderBody) {
        if (Objects.isNull(bookkeepingRepairOrderBody)) {
            throw new BizException("\u8bf7\u6c42\u53c2\u6570\u4e3a\u7a7a!");
        }
        BookKeepingRepairReqDto bookKeepingRepairReqDto = new BookKeepingRepairReqDto();
        bookKeepingRepairReqDto.setDocumentNo(bookkeepingRepairOrderBody.getDocumentNo());
        bookKeepingRepairReqDto.setId(bookkeepingRepairOrderBody.getId());
        bookKeepingRepairReqDto.setUpdatePerson(ServiceContext.getContext().getRequestUserCode());
        return new RestResponse(RestResponseHelper.extractData((RestResponse)this.pushKeepAccountsApiProxy.repairKeepAccountDocumentNo(bookKeepingRepairReqDto)));
    }

    @Override
    public RestResponse<Object> restartPushBookkeepingOrder(@ApiParam(value="") @Valid @RequestBody(required=false) RestartPushOfBookkeepingOrderBody restartPushOfBookkeepingOrderBody) {
        if (!CollectionUtils.isNotEmpty((Collection)restartPushOfBookkeepingOrderBody.getIds())) {
            throw new BizException("ids\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ArrayList<RetryKeepReqDto> retryKeepReqDtos = new ArrayList<RetryKeepReqDto>();
        for (String id : restartPushOfBookkeepingOrderBody.getIds()) {
            PushKeepAccountsRespDto pushKeepAccountsRespDto = (PushKeepAccountsRespDto)RestResponseHelper.extractData((RestResponse)this.pushKeepAccountsApiProxy.queryById(ParamConverter.convertToLong((Object)id)));
            RetryKeepReqDto keepReqDto = new RetryKeepReqDto();
            BeanUtils.copyProperties((Object)pushKeepAccountsRespDto, (Object)keepReqDto);
            keepReqDto.setId(pushKeepAccountsRespDto.getId());
            keepReqDto.setYxId(pushKeepAccountsRespDto.getYxId());
            keepReqDto.setPushPerson(ServiceContext.getContext().getRequestUserCode());
            if (pushKeepAccountsRespDto.getChargeDate() != null) {
                keepReqDto.setChargeDate(com.dtyunxi.util.DateUtil.format((Date)pushKeepAccountsRespDto.getChargeDate(), (String)DatePattern.DATE_PATTERN.getPattern()));
            }
            keepReqDto.setChargecCode(keepReqDto.getChargecCode());
            keepReqDto.setTestSuccessAndFailure(restartPushOfBookkeepingOrderBody.getTestSuccessAndFailure());
            keepReqDto.setActionType(restartPushOfBookkeepingOrderBody.getActionType());
            retryKeepReqDtos.add(keepReqDto);
        }
        return new RestResponse(RestResponseHelper.extractData((RestResponse)this.pushKeepAccountsApiProxy.retryKeep(retryKeepReqDtos)));
    }

    @Override
    public RestResponse<Object> batchRemove(@Valid RestartPushOfBookkeepingOrderBody restartPushOfBookkeepingOrderBody) {
        if (!CollectionUtils.isNotEmpty((Collection)restartPushOfBookkeepingOrderBody.getIds())) {
            throw new BizException("ids\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ArrayList retryKeepReqDtos = new ArrayList();
        restartPushOfBookkeepingOrderBody.getIds().forEach(v -> {
            RetryKeepReqDto keepReqDto = new RetryKeepReqDto();
            keepReqDto.setId(ParamConverter.convertToLong((Object)v));
            keepReqDto.setUpdatePerson(ServiceContext.getContext().getRequestUserCode());
            retryKeepReqDtos.add(keepReqDto);
        });
        return new RestResponse(RestResponseHelper.extractData((RestResponse)this.pushKeepAccountsApiProxy.deleteKeepAccount(retryKeepReqDtos)));
    }

    @Override
    public RestResponse<Object> updateBookkeepingDate(@ApiParam(value="") @Valid @RequestBody(required=false) UpdateBookkeepingDateBody updateBookkeepingDateBody) {
        if (ObjectUtil.isEmpty((Object)updateBookkeepingDateBody.getIds())) {
            throw new BizException("id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        UpdateKeepVoucherDto updateKeepVoucherDto = new UpdateKeepVoucherDto();
        updateKeepVoucherDto.setIds(updateBookkeepingDateBody.getIds().stream().map(s -> Long.parseLong(s)).collect(Collectors.toList()));
        if (updateBookkeepingDateBody.getBookkeepingDate() != null) {
            String keepingDate = updateBookkeepingDateBody.getBookkeepingDate() + " " + com.dtyunxi.util.DateUtil.format((Date)new Date(), (String)"HH:mm:ss");
            updateKeepVoucherDto.setChargeDate(com.dtyunxi.util.DateUtil.parse((String)keepingDate, (String)DatePattern.DATETIME_PATTERN.getPattern()));
        }
        logger.info("\u4fee\u6539\u8bb0\u8d26\u65e5\u671f\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)updateKeepVoucherDto));
        return new RestResponse(RestResponseHelper.extractData((RestResponse)this.pushKeepAccountsApiProxy.updateKeepAcountTime(updateKeepVoucherDto)));
    }

    @Override
    public Integer exportTotal(ExportFileOperationCommonReqDto commonReqDto) {
        PageInfo respDtoPageInfo;
        String filter = commonReqDto.getFilter();
        GetBookkeepingOrderListPageBody params = new GetBookkeepingOrderListPageBody();
        KeepQueryConditionDto queryDto = new KeepQueryConditionDto();
        if (StringUtils.isNotBlank((CharSequence)commonReqDto.getFilter())) {
            params = (GetBookkeepingOrderListPageBody)JSON.parseObject((String)commonReqDto.getFilter(), GetBookkeepingOrderListPageBody.class);
            this.getParams(params, queryDto);
        }
        if (CollectionUtils.isEmpty((Collection)(respDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.pushKeepAccountsApiProxy.queryPage(Integer.valueOf(1), Integer.valueOf(1), queryDto))).getList())) {
            return 0;
        }
        return ParamConverter.convertToInteger((Object)respDtoPageInfo.getTotal());
    }

    @Override
    public List<ExportBookAccountOrderDto> scrollData(ExportFileOperationCommonReqDto commonReqDto) {
        logger.info(JSON.toJSONString((Object)commonReqDto));
        if (commonReqDto.getPageNum() != null && commonReqDto.getPageNum() < 0) {
            return Lists.newArrayList();
        }
        String filter = commonReqDto.getFilter();
        GetBookkeepingOrderListPageBody params = new GetBookkeepingOrderListPageBody();
        KeepQueryConditionDto queryDto = new KeepQueryConditionDto();
        if (StringUtils.isNotBlank((CharSequence)commonReqDto.getFilter())) {
            params = (GetBookkeepingOrderListPageBody)JSON.parseObject((String)commonReqDto.getFilter(), GetBookkeepingOrderListPageBody.class);
            this.getParams(params, queryDto);
        }
        PageInfo respDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.pushKeepAccountsApiProxy.queryPage(commonReqDto.getPageNum(), commonReqDto.getPageSize(), queryDto));
        List<Object> list = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)respDtoPageInfo.getList())) {
            list = respDtoPageInfo.getList().stream().map(o -> {
                ExportBookAccountOrderDto vo = new ExportBookAccountOrderDto();
                BeanUtils.copyProperties((Object)o, (Object)vo);
                if (o.getChargeDate() != null) {
                    vo.setBookkeepingDate(com.dtyunxi.util.DateUtil.format((Date)o.getChargeDate(), (String)DatePattern.DATE_PATTERN.getPattern()));
                }
                vo.setBookkeepingOrderTypeName(o.getOrderTypeName());
                vo.setBookkeepingOrderNo(o.getChargeCode());
                if (Objects.equals(SaleOrderTypeEnum.EXCHANGE_ORDER.getCode(), o.getSaleOrderType())) {
                    vo.setExchangeFlag("\u6362");
                } else {
                    vo.setExchangeFlag(null);
                }
                if (o.getGenerateTime() != null) {
                    vo.setCreateTime(com.dtyunxi.util.DateUtil.format((Date)o.getGenerateTime(), (String)DatePattern.DATETIME_PATTERN.getPattern()));
                }
                if (VoucherTypeEnum.INVOICE.getCode().equals(o.getVoucherType())) {
                    vo.setCertificateType(VoucherTypeEnum.INVOICE.getName());
                } else if (VoucherTypeEnum.DELIVERY.getCode().equals(o.getVoucherType())) {
                    vo.setCertificateType(VoucherTypeEnum.DELIVERY.getName());
                }
                vo.setBookkeepingTypeName(o.getChargeAccountName());
                vo.setSaPDeliveryOrderNo(o.getDeliveryNote());
                vo.setSaPSaleOrderNo(o.getSaleNo());
                vo.setSaPInvoiceNumber(o.getInvoiceNo());
                vo.setCustomerCode(o.getCustomerCode());
                vo.setWarehoseCode(o.getWarehouseCode());
                vo.setQuantity(o.getItemNum());
                if (o.getItemPrice() != null) {
                    vo.setRealAmount(o.getItemPrice().setScale(2));
                }
                if ("1".equals(o.getKeepingResult())) {
                    vo.setBookkeepingResult("\u8bb0\u8d26\u5931\u8d25");
                } else if ("0".equals(o.getKeepingResult())) {
                    vo.setBookkeepingResult("\u8bb0\u8d26\u6210\u529f");
                }
                if (o.getDeliveryPushTime() != null) {
                    vo.setDeliveryPushTime(com.dtyunxi.util.DateUtil.format((Date)o.getGenerateTime(), (String)DatePattern.DATETIME_PATTERN.getPattern()));
                }
                if (o.getInvoicePushTime() != null) {
                    vo.setInvoicePushTime(com.dtyunxi.util.DateUtil.format((Date)o.getGenerateTime(), (String)DatePattern.DATETIME_PATTERN.getPattern()));
                }
                vo.setFailResult(o.getReason());
                vo.setCustomerName(o.getCustomerName());
                vo.setSiteCode(o.getSiteCode());
                vo.setSiteName(o.getSiteName());
                vo.setShopCode(o.getShopCode());
                vo.setShopName(o.getShopName());
                if (null != o.getDeliveryTime()) {
                    vo.setDeliveryTime(com.dtyunxi.util.DateUtil.format((Date)o.getDeliveryTime(), (String)DatePattern.DATETIME_PATTERN.getPattern()));
                }
                if (null != o.getCompleteTime()) {
                    vo.setCompleteTime(com.dtyunxi.util.DateUtil.format((Date)o.getCompleteTime(), (String)DatePattern.DATETIME_PATTERN.getPattern()));
                }
                vo.setMasterDeputyIdentity(Objects.equals(MasterSlaveTypeEnum.MASTER.getCode(), o.getMasterDeputyIdentity()) ? "\u4e3b\u7f16\u7801" : "\u526f\u7f16\u7801");
                vo.setSaleOrderTypeName(KeepSaleOrderTypeEnum.getDesc((String)o.getSaleOrderType()));
                vo.setInvoiceNo(o.getInvoiceNo());
                vo.setPlatformNo(o.getPlatformNo());
                return vo;
            }).collect(Collectors.toList());
        }
        if (list.size() < commonReqDto.getPageSize()) {
            commonReqDto.setPageNum(Integer.valueOf(-1));
        } else {
            commonReqDto.setPageNum(Integer.valueOf(commonReqDto.getPageNum() + 1));
        }
        return list;
    }

    @Override
    public String exportFileOperationCommon(ExportFileOperationCommonReqDto commonReqDto) {
        ModeTypeEnum anEnum = ModeTypeEnum.getInstance((String)commonReqDto.getKey());
        if (commonReqDto.getPageSize() != null && commonReqDto.getPageSize() > 1000) {
            commonReqDto.setPageSize(Integer.valueOf(1000));
        }
        return AbleEasyPoiExportUtil.uploadFile(this, (Object)commonReqDto, anEnum.getExportTemplate(), commonReqDto.getFileName());
    }

    private void getParams(GetBookkeepingOrderListPageBody getBookkeepingOrderListPageBody, KeepQueryConditionDto keepQueryConditionDto) {
        CubeBeanUtils.copyProperties((Object)keepQueryConditionDto, (Object)getBookkeepingOrderListPageBody, (String[])new String[0]);
        keepQueryConditionDto.setChargeCodes(getBookkeepingOrderListPageBody.getBookkeepingOrderNo());
        keepQueryConditionDto.setStartTime(getBookkeepingOrderListPageBody.getBookkeepingDateStart());
        keepQueryConditionDto.setEndTime(getBookkeepingOrderListPageBody.getBookkeepingDateEnd());
        keepQueryConditionDto.setOrderType(getBookkeepingOrderListPageBody.getBookkeepingOrderType());
        keepQueryConditionDto.setOrderTypes(getBookkeepingOrderListPageBody.getBookkeepingOrderTypes());
        keepQueryConditionDto.setVoucherType(getBookkeepingOrderListPageBody.getCertificateType());
        keepQueryConditionDto.setGenerateStartTime(getBookkeepingOrderListPageBody.getCreateTimeStart());
        keepQueryConditionDto.setGenerateEndTime(getBookkeepingOrderListPageBody.getCreateTimeEnd());
        keepQueryConditionDto.setKeepingResult(getBookkeepingOrderListPageBody.getBookkeepingResult());
        keepQueryConditionDto.setCustomerCode(getBookkeepingOrderListPageBody.getCustomerCode());
        keepQueryConditionDto.setCustomerCodeList(getBookkeepingOrderListPageBody.getCustomerCodeList());
        keepQueryConditionDto.setWarehouseCode(getBookkeepingOrderListPageBody.getWarehouseCode());
        keepQueryConditionDto.setWarehouseCodeList(getBookkeepingOrderListPageBody.getWarehouseCodes());
        keepQueryConditionDto.setSaleNo(getBookkeepingOrderListPageBody.getSapSaleOrderNo());
        keepQueryConditionDto.setDeliveryNote(getBookkeepingOrderListPageBody.getSapDeliveryOrderNo());
        keepQueryConditionDto.setPostingNo(getBookkeepingOrderListPageBody.getSapTransitOrderNo());
        keepQueryConditionDto.setInvoiceNo(getBookkeepingOrderListPageBody.getSapInvoiceNumber());
        keepQueryConditionDto.setItemCode(getBookkeepingOrderListPageBody.getGoodsCode());
        keepQueryConditionDto.setPlatformOrderNos(getBookkeepingOrderListPageBody.getPlatformOrderNo());
        keepQueryConditionDto.setChargeAccountName(getBookkeepingOrderListPageBody.getBookkeepingTypeName());
        keepQueryConditionDto.setOrderNo(getBookkeepingOrderListPageBody.getOrderNo());
        keepQueryConditionDto.setOrderNos(getBookkeepingOrderListPageBody.getOrderNos());
        keepQueryConditionDto.setDeliveryTimeStart(getBookkeepingOrderListPageBody.getDeliveryTimeStart());
        keepQueryConditionDto.setDeliveryTimeEnd(getBookkeepingOrderListPageBody.getDeliveryTimeEnd());
        keepQueryConditionDto.setCompleteTimeStart(getBookkeepingOrderListPageBody.getCompleteTimeStart());
        keepQueryConditionDto.setCompleteTimeEnd(getBookkeepingOrderListPageBody.getCompleteTimeEnd());
        keepQueryConditionDto.setSiteCode(getBookkeepingOrderListPageBody.getSiteCode());
        keepQueryConditionDto.setSiteName(getBookkeepingOrderListPageBody.getSiteName());
        keepQueryConditionDto.setSiteCodes(getBookkeepingOrderListPageBody.getSiteCodes());
        keepQueryConditionDto.setShopCode(getBookkeepingOrderListPageBody.getShopCode());
        keepQueryConditionDto.setShopName(getBookkeepingOrderListPageBody.getShopName());
        keepQueryConditionDto.setShopCodes(getBookkeepingOrderListPageBody.getShopCodes());
        keepQueryConditionDto.setGeneratePerson(getBookkeepingOrderListPageBody.getGeneratePerson());
        keepQueryConditionDto.setPushPerson(getBookkeepingOrderListPageBody.getPushPerson());
        keepQueryConditionDto.setBillShopType(getBookkeepingOrderListPageBody.getBillShopType());
        keepQueryConditionDto.setMasterDeputyIdentity(getBookkeepingOrderListPageBody.getMasterDeputyIdentity());
        keepQueryConditionDto.setSaleOrderTypes(getBookkeepingOrderListPageBody.getSaleOrderType());
        keepQueryConditionDto.setLineOrderTypes(getBookkeepingOrderListPageBody.getLineOrderTypes());
        keepQueryConditionDto.setAccountingCompleteTimeStart(getBookkeepingOrderListPageBody.getAccountingCompleteTimeStart());
        keepQueryConditionDto.setAccountingCompleteTimeEnd(getBookkeepingOrderListPageBody.getAccountingCompleteTimeEnd());
        keepQueryConditionDto.setChargeAccountCodes(getBookkeepingOrderListPageBody.getChargeAccountCodes());
        keepQueryConditionDto.setSaleChannelCodes(getBookkeepingOrderListPageBody.getSaleChannelCodes());
    }

    @Override
    public RestResponse<PageInfo<BookkeepingOrderDto>> newQueryPage(KeepQueryConditionQueryPageDto keepQueryConditionQueryPageDto) {
        return this.pushKeepAccountsApiProxy.newQueryPage(keepQueryConditionQueryPageDto);
    }

    @Override
    public RestResponse<Object> batchDeleteBookKeeping(List<String> chargeCodes) {
        if (!CollectionUtils.isNotEmpty(chargeCodes)) {
            throw new BizException("\u8bb0\u8d26\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        logger.info("\u5220\u9664\u8bb0\u8d26\u5355\u5165\u53c2\uff1a{}", JSONObject.toJSON(chargeCodes));
        return new RestResponse(RestResponseHelper.extractData((RestResponse)this.pushKeepAccountsApiProxy.batchDeleteBookKeeping(chargeCodes)));
    }
}

