/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.mgmt.service.impl;

import cn.afterturn.easypoi.excel.entity.result.ExcelImportResult;
import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.rest.RestResponse;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.trade.dto.entity.DgNoSourceReturnRecordDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgNoSourceReturnRecordPageReqDto;
import com.yunxi.dg.base.center.trade.proxy.aftersale.IDgNoSourceReturnRecordApiProxy;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import com.yunxi.dg.base.ocs.mgmt.application.dto.enums.FileModeTypeEnum;
import com.yunxi.dg.base.ocs.mgmt.application.dto.enums.FileOperationStatusEnum;
import com.yunxi.dg.base.ocs.mgmt.application.dto.request.NoSourceOrderChargeRemarkImportDto;
import com.yunxi.dg.base.poi.dto.ImportBaseModeDto;
import com.yunxi.dg.base.poi.dto.ImportFileOperationCommonReqDto;
import com.yunxi.dg.base.poi.dto.ImportFileOperationCommonRespDto;
import com.yunxi.dg.base.poi.service.AbstractBaseFileOperationCommonService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="AbstractBaseFileOperationCommonService_noHeadReturnRecord_singleOrderImport")
public class NoSourceOrderChargeRemarkCommonServiceImpl
extends AbstractBaseFileOperationCommonService {
    private static final Logger log = LoggerFactory.getLogger(NoSourceOrderChargeRemarkCommonServiceImpl.class);
    @Resource
    private IDgNoSourceReturnRecordApiProxy dgNoSourceReturnRecordApiProxy;

    public Object verifyImportFileOperationCommon(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto) {
        log.info("\u552e\u540e\u9000\u8d27\u5339\u914d\u8bb0\u5f55-\u51b2\u5355\u5907\u6ce8\u5bfc\u5165\u6570\u636e\uff1a{}", (Object)JSONObject.toJSONString(result));
        ArrayList passList = Lists.newArrayList();
        List resultList = BeanUtil.copyToList((Collection)result.getList(), NoSourceOrderChargeRemarkImportDto.class);
        if (CollectionUtil.isEmpty((Collection)resultList)) {
            respDto.setErrorMsg("\u5bfc\u5165\u5185\u5bb9\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01");
            respDto.setStatus(FileOperationStatusEnum.IMPORT_ERROR.getCode());
            return new ArrayList();
        }
        if (resultList.size() > 20000) {
            respDto.setErrorMsg("\u6279\u91cf\u5bfc\u5165\u4e0d\u652f\u6301\u8d85\u8fc720000\u884c");
            respDto.setStatus(FileOperationStatusEnum.IMPORT_ERROR.getCode());
            return new ArrayList();
        }
        Set recordNos = resultList.stream().map(NoSourceOrderChargeRemarkImportDto::getReturnRecordSerialNo).collect(Collectors.toSet());
        List recordNoList = CollectionUtil.split(recordNos, (int)200);
        HashSet results = new HashSet();
        for (List recordList : recordNoList) {
            DgNoSourceReturnRecordPageReqDto reqDto = new DgNoSourceReturnRecordPageReqDto();
            reqDto.setReturnRecordSerialNos(recordList);
            reqDto.setPageSize(Integer.valueOf(200));
            results.addAll(((PageInfo)RestResponseHelper.extractData((RestResponse)this.dgNoSourceReturnRecordApiProxy.page(reqDto))).getList().stream().map(DgNoSourceReturnRecordDto::getReturnRecordSerialNo).collect(Collectors.toSet()));
        }
        for (NoSourceOrderChargeRemarkImportDto importDto : resultList) {
            if (!results.contains(importDto.getReturnRecordSerialNo())) {
                importDto.setErrorMsg("\u552e\u540e\u9000\u8d27\u5339\u914d\u8bb0\u5f55\u4e0d\u5b58\u5728\uff01");
                importDto.setErrorMsg(String.format("\u7b2c%s\u884c\u6570\u636e\u6709\u8bef,%s", importDto.getRowNum() + FileModeTypeEnum.getInstance((String)commonReqDto.getKey()).getHeadRows(), importDto.getErrorMsg()));
                respDto.getErrorDetails().add(importDto);
                continue;
            }
            passList.add(importDto);
        }
        return passList;
    }

    public void callBackImportFileOperationCommonAsync(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto, Object object) {
        log.info("\u552e\u540e\u9000\u8d27\u5339\u914d\u8bb0\u5f55-\u51b2\u5355\u5907\u6ce8\u5bfc\u5165-callBackImportFileOperationCommonAsync-->result:{}", (Object)JSON.toJSONString(result));
        List passList = (List)object;
        Map<String, List<NoSourceOrderChargeRemarkImportDto>> orderMap = passList.stream().collect(Collectors.groupingBy(NoSourceOrderChargeRemarkImportDto::getReturnRecordSerialNo));
        for (String orderKey : orderMap.keySet()) {
            List<NoSourceOrderChargeRemarkImportDto> noSourceOrderChargeRemarkImportDtos = orderMap.get(orderKey);
            NoSourceOrderChargeRemarkImportDto dto = noSourceOrderChargeRemarkImportDtos.get(0);
            DgNoSourceReturnRecordDto reqDto = new DgNoSourceReturnRecordDto();
            reqDto.setReturnRecordSerialNo(dto.getReturnRecordSerialNo());
            reqDto.setChargeOrderRemark(noSourceOrderChargeRemarkImportDtos.stream().map(NoSourceOrderChargeRemarkImportDto::getChargeOrderRemark).collect(Collectors.joining(",")));
            this.modifyRecord(respDto, reqDto, dto);
            noSourceOrderChargeRemarkImportDtos.forEach(giftDto -> giftDto.setErrorMsg(dto.getErrorMsg()));
        }
    }

    private void modifyRecord(ImportFileOperationCommonRespDto respDto, DgNoSourceReturnRecordDto reqDto, NoSourceOrderChargeRemarkImportDto dto) {
        try {
            log.info("\u552e\u540e\u9000\u8d27\u5339\u914d\u8bb0\u5f55-\u51b2\u5355\u5907\u6ce8\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
            RestResponseHelper.extractData((RestResponse)this.dgNoSourceReturnRecordApiProxy.modifyRemarkOrU9No(reqDto));
        }
        catch (Exception e) {
            log.error("\u5bfc\u5165\u552e\u540e\u9000\u8d27\u5339\u914d\u8bb0\u5f55-\u51b2\u5355\u5907\u6ce8\uff0c\u4fdd\u5b58\u5931\u8d25 {}", (Object)reqDto.getPlatformOrderNo(), (Object)e);
            this.setErrorMsg(dto, "\u552e\u540e\u9000\u8d27\u5339\u914d\u8bb0\u5f55-\u51b2\u5355\u5907\u6ce8\u4fdd\u5b58\u5931\u8d25\uff1a" + e.getMessage());
            respDto.getErrorDetails().add(dto);
        }
    }

    private void setErrorMsg(NoSourceOrderChargeRemarkImportDto dto, String msg) {
        dto.setErrorMsg(StringUtils.isBlank((CharSequence)dto.getErrorMsg()) ? String.format("\u7b2c%s\u884c\u6570\u636e\u6709\u8bef\uff0c%s", dto.getRowNum(), msg) : dto.getErrorMsg() + ";" + msg);
    }
}

