/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.mgmt.service.impl;

import cn.afterturn.easypoi.excel.entity.result.ExcelImportResult;
import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.dtyunxi.rest.RestResponse;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.item.dto.response.DgItemSkuPageRespDto;
import com.yunxi.dg.base.center.report.dto.inventory.DgLogicInventoryTotalPageReqDto;
import com.yunxi.dg.base.center.report.proxy.inventory.IDgLogicInventoryTotalApiProxy;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import com.yunxi.dg.base.mgmt.application.rpc.dto.request.ItemQueryDgReqDto;
import com.yunxi.dg.base.ocs.mgmt.application.api.item.IOcsItemDgApi;
import com.yunxi.dg.base.ocs.mgmt.application.dto.enums.FileModeTypeEnum;
import com.yunxi.dg.base.ocs.mgmt.application.dto.request.PartsRequistionItemImportDto;
import com.yunxi.dg.base.ocs.mgmt.application.dto.request.PartsRequistionItemImportRespDto;
import com.yunxi.dg.base.poi.dto.ImportBaseModeDto;
import com.yunxi.dg.base.poi.dto.ImportFileOperationCommonReqDto;
import com.yunxi.dg.base.poi.dto.ImportFileOperationCommonRespDto;
import com.yunxi.dg.base.poi.service.AbstractBaseFileOperationCommonService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="AbstractBaseFileOperationCommonService_parts_requisition_item_import")
public class PartsRequisitionItemCommonServiceImpl
extends AbstractBaseFileOperationCommonService {
    private static final Logger log = LoggerFactory.getLogger(PartsRequisitionItemCommonServiceImpl.class);
    @Resource
    private IDgLogicInventoryTotalApiProxy iDgLogicInventoryTotalApiProxy;
    @Resource
    private IOcsItemDgApi iOcsItemDgApi;

    public Object verifyImportFileOperationCommon(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto) {
        log.info("\u5f00\u59cb\u5bfc\u5165\u5747\u8861\u5206\u4ed3\u914d\u7f6e");
        if (CollectionUtil.isEmpty((Collection)result.getList())) {
            return new ArrayList();
        }
        List list = BeanUtil.copyToList((Collection)result.getList(), PartsRequistionItemImportDto.class);
        ArrayList<PartsRequistionItemImportRespDto> passList = new ArrayList<PartsRequistionItemImportRespDto>();
        ArrayList<PartsRequistionItemImportDto> uniqueList = new ArrayList<PartsRequistionItemImportDto>();
        Map extFields = commonReqDto.getExtFields();
        AssertUtils.notNull(extFields.get("saleOrganizationCode"), (String)"\u6838\u7b97\u516c\u53f8\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        for (PartsRequistionItemImportDto importDto : list) {
            if (this.paramVerify(importDto) && this.uniqueVerify(importDto, uniqueList)) {
                PartsRequistionItemImportRespDto importRespDto = new PartsRequistionItemImportRespDto();
                BeanUtil.copyProperties((Object)importDto, (Object)importRespDto, (String[])new String[0]);
                ItemQueryDgReqDto itemQueryDgReqDto = new ItemQueryDgReqDto();
                itemQueryDgReqDto.setCompanyCode((String)extFields.get("saleOrganizationCode"));
                itemQueryDgReqDto.setSkuCode(importDto.getSkuCode());
                List pageRespDtoList = ((PageInfo)this.iOcsItemDgApi.queryItemListByPage(itemQueryDgReqDto).getData()).getList();
                importRespDto.setSkuName(((DgItemSkuPageRespDto)pageRespDtoList.get(0)).getSkuName());
                importRespDto.setAvailable(((DgItemSkuPageRespDto)pageRespDtoList.get(0)).getAvailable());
                passList.add(importRespDto);
                uniqueList.add(importDto);
                continue;
            }
            importDto.setErrorMsg(String.format("\u7b2c%s\u884c\u6570\u636e\u6709\u8bef,%s", importDto.getRowNum() + FileModeTypeEnum.getInstance((String)commonReqDto.getKey()).getHeadRows(), importDto.getErrorMsg()));
            respDto.getErrorDetails().add(importDto);
        }
        respDto.setDetails(passList);
        return passList;
    }

    private boolean paramVerify(PartsRequistionItemImportDto importDto) {
        if (StrUtil.isBlank((CharSequence)importDto.getSkuCode())) {
            importDto.setErrorMsg("SKU\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            return false;
        }
        if (!this.RegexMatch(importDto.getSkuCode()).booleanValue()) {
            importDto.setErrorMsg("\u7269\u6d41\u5546\u7f16\u7801\u53ea\u652f\u6301\u6570\u5b57\u3001\u82f1\u6587\u5b57\u6bcd\u3001\u6807\u70b9\u7b26\u53f7\uff0c\u8bf7\u68c0\u67e5");
            return false;
        }
        DgLogicInventoryTotalPageReqDto dto = new DgLogicInventoryTotalPageReqDto();
        dto.setSkuCode(importDto.getSkuCode());
        List dgLogicInventoryTotalDtos = (List)RestResponseHelper.extractData((RestResponse)this.iDgLogicInventoryTotalApiProxy.queryList(dto));
        if (CollectionUtil.isEmpty((Collection)dgLogicInventoryTotalDtos)) {
            importDto.setErrorMsg("SKU\u7f16\u7801\u4e0d\u5b58\u5728");
            return false;
        }
        if (StrUtil.isBlank((CharSequence)importDto.getQuantity())) {
            importDto.setErrorMsg("\u8ba1\u5212\u51fa\u5e93\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
            return false;
        }
        return true;
    }

    private boolean uniqueVerify(PartsRequistionItemImportDto importDto, List<PartsRequistionItemImportDto> list) {
        if (CollectionUtil.isNotEmpty(list)) {
            for (PartsRequistionItemImportDto dto : list) {
                if (!importDto.getSkuCode().equals(dto.getSkuCode())) continue;
                return false;
            }
        }
        return true;
    }

    private Boolean RegexMatch(String code) {
        Pattern pattern = Pattern.compile("[a-zA-Z0-9\\.\\,\\?\\!\\;\\:\\-\\_\\=\\+\\*\\/\\\\\\#\\@\\$\\%\\^\\&\\(\\)\\{\\}\\[\\]\\`\\~\\<\\>]+");
        return pattern.matcher(code).matches();
    }
}

