/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.mgmt.excel;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.ExcelImportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.ImportParams;
import cn.afterturn.easypoi.excel.entity.TemplateExportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import cn.afterturn.easypoi.excel.entity.params.ExcelExportEntity;
import cn.afterturn.easypoi.excel.entity.result.ExcelImportResult;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.poi.excel.ExcelReader;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.huieryun.oss.api.IObjectStorageService;
import com.dtyunxi.lang.BusinessRuntimeException;
import com.dtyunxi.util.HttpUtil;
import com.dtyunxi.util.SpringBeanUtil;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.mgmt.excel.BaseExcelStyle;
import com.yunxi.dg.base.mgmt.excel.CheckUtils;
import com.yunxi.dg.base.mgmt.excel.ExcelUtils;
import com.yunxi.dg.base.ocs.mgmt.application.dto.enums.ModeTypeEnum;
import com.yunxi.dg.base.ocs.mgmt.application.dto.financial.ImportDismantleWhiteDto;
import com.yunxi.dg.base.ocs.mgmt.application.dto.financial.annotation.Label;
import com.yunxi.dg.base.poi.dto.ImportBaseModeDto;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EasyPoiExportUtil {
    private static final Logger logger = LoggerFactory.getLogger(EasyPoiExportUtil.class);
    private static IObjectStorageService objectStorageService;
    private static String bucketName;
    private static final Integer MAX_SIZE;

    public static void handleImportResultListFilterEmpty(ExcelImportResult result) {
        ArrayList fails = new ArrayList();
        boolean isFail = false;
        if (result.isVerfiyFail()) {
            for (Object val : result.getFailList()) {
                boolean b = CheckUtils.checkFieldAllNull(val);
                if (b) continue;
                logger.info("\u5b58\u5728\u6821\u9a8c\u5931\u8d25\u7684");
                fails.add(val);
                isFail = true;
            }
        }
        result.setFailList(fails);
        result.setVerfiyFail(isFail);
        List list = result.getList().stream().filter(l -> !CheckUtils.checkFieldAllNull(l)).collect(Collectors.toList());
        result.setList(list);
    }

    public static <T> ExcelImportResult<T> importExcel(InputStream inputStream, Integer titleRows, Integer headerRows, Class pojoClass) {
        ImportParams params = new ImportParams();
        params.setTitleRows(titleRows.intValue());
        params.setHeadRows(headerRows.intValue());
        ExcelImportResult result = null;
        try {
            result = ExcelImportUtil.importExcelMore((InputStream)inputStream, (Class)pojoClass, (ImportParams)params);
            EasyPoiExportUtil.handleImportResultListFilterEmpty(result);
            return result;
        }
        catch (NoSuchElementException var7) {
            throw new BusinessRuntimeException("excel\u6587\u4ef6\u4e0d\u80fd\u4e3a\u7a7a");
        }
        catch (Exception var8) {
            throw new BusinessRuntimeException(var8.getMessage());
        }
    }

    public static <T> ExcelImportResult<T> getImportResult(InputStream inputStream, Integer titleRows, Integer headerRows, Class pojoClass) {
        ImportParams params = new ImportParams();
        params.setTitleRows(titleRows.intValue());
        params.setHeadRows(headerRows.intValue());
        params.setKeyIndex(null);
        ExcelImportResult result = null;
        try {
            result = ExcelImportUtil.importExcelMore((InputStream)inputStream, (Class)pojoClass, (ImportParams)params);
            EasyPoiExportUtil.handleImportResultListFilterEmpty(result);
            return result;
        }
        catch (NoSuchElementException var7) {
            throw new BusinessRuntimeException("excel\u6587\u4ef6\u4e0d\u80fd\u4e3a\u7a7a");
        }
        catch (Exception var8) {
            throw new BusinessRuntimeException(var8.getMessage());
        }
    }

    public static <T> ExcelImportResult<T> getImportResult(InputStream inputStream, Integer titleRows, Integer headerRows, Integer count, Class pojoClass) {
        ImportParams params = new ImportParams();
        params.setTitleRows(titleRows.intValue());
        params.setHeadRows(headerRows.intValue());
        params.setReadRows(count.intValue());
        params.setKeyIndex(null);
        ExcelImportResult result = null;
        try {
            result = ExcelImportUtil.importExcelMore((InputStream)inputStream, (Class)pojoClass, (ImportParams)params);
            EasyPoiExportUtil.handleImportResultListFilterEmpty(result);
            return result;
        }
        catch (NoSuchElementException var8) {
            throw new BusinessRuntimeException("excel\u6587\u4ef6\u4e0d\u80fd\u4e3a\u7a7a");
        }
        catch (Exception var9) {
            throw new BusinessRuntimeException(var9.getMessage());
        }
    }

    public static <T> String getExportUrl(List<T> excelRespDtos, Class<T> tClass, String title, String excelName, String suffix) {
        if (objectStorageService == null) {
            objectStorageService = (IObjectStorageService)SpringBeanUtil.getBean(IObjectStorageService.class);
        }
        if (bucketName == null) {
            bucketName = SpringBeanUtil.getApplicationContext().getEnvironment().getProperty("huieryun.ossregistryvo.bucketName");
        }
        String downloadUrl = SpringBeanUtil.getApplicationContext().getEnvironment().getProperty("huieryun.ossregistryvo.endpoint");
        if (CollectionUtils.isEmpty(excelRespDtos)) {
            excelRespDtos = Lists.newArrayList();
        }
        ByteArrayOutputStream fos = null;
        String fileName = excelName + "." + suffix;
        ExportParams params = new ExportParams(title, "", ExcelType.XSSF);
        Workbook workbook = ExcelExportUtil.exportExcel((ExportParams)params, tClass, (Collection)excelRespDtos);
        String url = EasyPoiExportUtil.getFileUrl(title, downloadUrl, workbook, fos, fileName);
        return url;
    }

    public static <T> String exportByTemplate(String templateUrl, List<T> excelRespDtos, String excelName, String suffix, String title) {
        if (objectStorageService == null) {
            objectStorageService = (IObjectStorageService)SpringBeanUtil.getBean(IObjectStorageService.class);
        }
        if (bucketName == null) {
            bucketName = SpringBeanUtil.getApplicationContext().getEnvironment().getProperty("huieryun.ossregistryvo.bucketName");
        }
        String downloadUrl = SpringBeanUtil.getApplicationContext().getEnvironment().getProperty("huieryun.ossregistryvo.endpoint");
        if (CollectionUtils.isEmpty(excelRespDtos)) {
            excelRespDtos = Lists.newArrayList();
        }
        TemplateExportParams params = new TemplateExportParams(templateUrl, new Integer[0]);
        HashMap map = new HashMap(16);
        ArrayList listMap = new ArrayList();
        excelRespDtos.forEach(dto -> {
            try {
                Map describe = BeanUtils.describe((Object)dto);
                listMap.add(describe);
            }
            catch (Exception var3) {
                logger.error("\u5bf9\u8c61\u8f6c\u6362\u6210map\u5f02\u5e38");
                var3.printStackTrace();
            }
        });
        map.put("maplist", listMap);
        Workbook workbook = ExcelExportUtil.exportExcel((TemplateExportParams)params, map);
        String url = "";
        ByteArrayOutputStream fos = null;
        String fileName = excelName + "." + suffix;
        url = EasyPoiExportUtil.getFileUrl(title, downloadUrl, workbook, fos, fileName);
        return url;
    }

    public static String exportByMap(String fileName, ExportParams params, List<ExcelExportEntity> entityList, List<Map<String, Object>> list) {
        if (objectStorageService == null) {
            objectStorageService = (IObjectStorageService)SpringBeanUtil.getBean(IObjectStorageService.class);
        }
        if (bucketName == null) {
            bucketName = SpringBeanUtil.getApplicationContext().getEnvironment().getProperty("huieryun.ossregistryvo.bucketName");
        }
        String downloadUrl = SpringBeanUtil.getApplicationContext().getEnvironment().getProperty("huieryun.ossregistryvo.endpoint");
        Workbook workbook = ExcelExportUtil.exportExcel((ExportParams)params, entityList, list);
        return EasyPoiExportUtil.getFileUrl(fileName, downloadUrl, workbook, null, fileName);
    }

    private static String getFileUrl(String title, String downloadUrl, Workbook workbook, ByteArrayOutputStream fos, String fileName) {
        String url;
        try {
            fos = new ByteArrayOutputStream();
            workbook.write((OutputStream)fos);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(fos.toByteArray());
            objectStorageService.put(bucketName, fileName, (InputStream)byteArrayInputStream);
            url = downloadUrl + "/" + fileName;
        }
        catch (IOException var14) {
            logger.error(title + "\u5bfc\u51faexcel\u5f02\u5e38", (Object)var14.getMessage(), (Object)var14);
            throw new BusinessRuntimeException(title + "\u5bfc\u51faexcel\u5f02\u5e38");
        }
        finally {
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException var13) {
                logger.error("\u5173\u95ed\u6d41\u51fa\u73b0\u5f02\u5e38\uff1a{}", (Throwable)var13);
            }
        }
        return url;
    }

    public static <T> List<T> parseImportFile(String fileUrl, Class<T> clazz) {
        long startTime = System.currentTimeMillis();
        if (StringUtils.isBlank((CharSequence)fileUrl)) {
            throw new BizException("\u5bfc\u5165\u8def\u5f84\u4e0d\u5b58\u5728");
        }
        byte[] bytes = EasyPoiExportUtil.doGetRawData(fileUrl);
        Optional.ofNullable(bytes).orElseThrow(() -> new BizException("\u4e0b\u8f7d\u4e0d\u5230\u6587\u4ef6"));
        ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);
        Optional.ofNullable(inputStream).orElseThrow(() -> new BizException("\u5bfc\u5165\u53c2\u6570\u6709\u8bef"));
        ExcelImportResult<T> data = EasyPoiExportUtil.importExcel(inputStream, 0, 1, clazz);
        logger.info("\u5bfc\u5165\u89e3\u6790excel\u6587\u4ef6, \u8017\u65f6={}", (Object)(System.currentTimeMillis() - startTime));
        if (ImportBaseModeDto.class.isAssignableFrom(clazz)) {
            ExcelImportResult<T> result = data;
            EasyPoiExportUtil.verfiyExcelImportFail(result);
        }
        EasyPoiExportUtil.handleImportResultListFilterEmpty(data);
        return data.getList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] doGetRawData(String url) {
        CloseableHttpClient httpClient = null;
        HttpGet httpGet = null;
        byte[] result = null;
        try {
            HttpEntity resEntity;
            httpClient = HttpUtil.createSSLClientDefault();
            httpGet = new HttpGet(url);
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpGet);
            if (response != null && (resEntity = response.getEntity()) != null) {
                result = EntityUtils.toByteArray((HttpEntity)resEntity);
            }
        }
        catch (Exception var14) {
            logger.error("HttpClientUtils.doGet\u62a5\u9519,url=" + url, (Throwable)var14);
        }
        finally {
            if (null != httpGet) {
                httpGet.abort();
            }
            if (null != httpClient) {
                try {
                    httpClient.close();
                }
                catch (IOException iOException) {}
            }
        }
        return result;
    }

    public static List handlerExcelData(String modeType, String path, Integer headRows) {
        try {
            ExcelImportResult<ImportBaseModeDto> result = EasyPoiExportUtil.handlerExcelDataResult(modeType, path, headRows);
            EasyPoiExportUtil.verfiyExcelImportFail(result);
            return result.getList();
        }
        catch (BusinessRuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            logger.error("\u89e3\u6790\u6a21\u677f\u5931\u8d25", (Throwable)e);
            throw new BizException("\u89e3\u6790\u5bfc\u5165\u7684\u6570\u636e\u5931\u8d25");
        }
    }

    public static ExcelImportResult<ImportBaseModeDto> handlerExcelDataResult(String modeType, String path, Integer headRows) {
        InputStream inputStream = EasyPoiExportUtil.getInputStream(path);
        return EasyPoiExportUtil.handlerExcelDataResult(inputStream, modeType, headRows);
    }

    public static InputStream getInputStream(String url) {
        InputStream is = null;
        try {
            HttpURLConnection httpURLConnection = ExcelUtils.getHttpURLConnection(url);
            is = httpURLConnection.getInputStream();
        }
        catch (FileNotFoundException e) {
            throw new BizException("\u6587\u4ef6\u4e0d\u5b58\u5728");
        }
        catch (IOException e) {
            throw new BizException("\u8bfb\u53d6\u6587\u4ef6IO\u5f02\u5e38");
        }
        return is;
    }

    public static ExcelImportResult<ImportBaseModeDto> handlerExcelDataResult(Class classTemplate, String path, Integer headRows) {
        InputStream inputStream = EasyPoiExportUtil.getInputStream(path);
        return EasyPoiExportUtil.handlerExcelDataResult(classTemplate, inputStream, headRows);
    }

    public static void checkFileSize(InputStream inputStream, int fileSize) {
        try {
            if (inputStream.available() > 0) {
                double size = inputStream.available() / 0x100000;
                logger.info("\u6587\u4ef6size:" + size + "M");
                if (size > (double)fileSize) {
                    throw new BizException("\u6587\u4ef6\u4e0d\u80fd\u5927\u4e8e" + fileSize + "M");
                }
            }
        }
        catch (IOException e) {
            throw new BizException("\u8bfb\u53d6\u6587\u4ef6IO\u5f02\u5e38");
        }
    }

    public static ExcelImportResult<ImportBaseModeDto> handlerExcelDataResult(Class classTemplate, InputStream inputStream, Integer headRows) {
        try {
            ImportParams params = new ImportParams();
            params.setHeadRows(headRows.intValue());
            params.setNeedVerify(true);
            EasyPoiExportUtil.checkFileSize(inputStream, MAX_SIZE);
            ExcelImportResult result = ExcelImportUtil.importExcelMore((InputStream)inputStream, (Class)classTemplate, (ImportParams)params);
            EasyPoiExportUtil.handleImportResultListFilterEmpty(result);
            if (CollectionUtil.isEmpty((Collection)result.getList()) && CollectionUtil.isEmpty((Collection)result.getFailList())) {
                throw new BizException("\u8bf7\u4e0d\u8981\u5bfc\u5165\u7a7a\u6587\u4ef6");
            }
            return result;
        }
        catch (BusinessRuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            logger.error("\u89e3\u6790\u6a21\u677f\u5931\u8d25", (Throwable)e);
            throw new BizException("\u89e3\u6790\u5bfc\u5165\u7684\u6570\u636e\u5931\u8d25");
        }
    }

    public static ExcelImportResult<ImportBaseModeDto> handlerExcelDataResult(InputStream inputStream, String modeType, Integer headRows) {
        Class<ImportBaseModeDto> classTemplate = EasyPoiExportUtil.getClassTemplate(modeType);
        return EasyPoiExportUtil.handlerExcelDataResult(classTemplate, inputStream, headRows);
    }

    public static List handlerNewExcelData(String modeType, String path, Integer headRows) {
        try {
            ImportParams params = new ImportParams();
            params.setHeadRows(headRows.intValue());
            params.setNeedVerify(true);
            Class<ImportBaseModeDto> classTemplate = EasyPoiExportUtil.getClassNewTemplate(modeType);
            InputStream inputStream = EasyPoiExportUtil.getInputStream(path);
            ExcelImportResult result = ExcelImportUtil.importExcelMore((InputStream)inputStream, classTemplate, (ImportParams)params);
            EasyPoiExportUtil.handleImportResultListFilterEmpty(result);
            EasyPoiExportUtil.verfiyExcelImportFail((ExcelImportResult<ImportBaseModeDto>)result);
            return result.getList();
        }
        catch (BusinessRuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            logger.error("\u89e3\u6790\u6a21\u677f\u5931\u8d25", (Throwable)e);
            throw new BizException("\u89e3\u6790\u5bfc\u5165\u7684\u6570\u636e\u5931\u8d25");
        }
    }

    public static Class<ImportBaseModeDto> getClassTemplate(String modeType) {
        Class<ImportDismantleWhiteDto> classTemplate = null;
        switch (ModeTypeEnum.getInstance((String)modeType)) {
            case PHYSICAL_WAREHOUSE_QUERY: {
                classTemplate = ImportDismantleWhiteDto.class;
                break;
            }
        }
        if (classTemplate == null) {
            throw new BizException("\u8f93\u5165\u529f\u80fd\u6a21\u677f\u4e0d\u5728\u8303\u56f4\u4e4b\u5185");
        }
        return classTemplate;
    }

    public static String uploadFile(List reqDtos, String type, String title) {
        Class<ImportBaseModeDto> classTemplate = EasyPoiExportUtil.getClassTemplate(type);
        Label annotation = classTemplate.getAnnotation(Label.class);
        String fileName = String.format("%s_%s", annotation.desc(), System.currentTimeMillis());
        return ExcelUtils.getExportUrl(reqDtos, classTemplate, title, fileName);
    }

    public static String uploadFile(List list, Class classTemplate, String fileName) {
        if (CollectionUtil.isEmpty((Collection)list)) {
            list = new ArrayList();
        }
        return ExcelUtils.getExportUrl(list, classTemplate, null, fileName);
    }

    public static String uploadFileStype(List list, Class classTemplate, String fileName, BaseExcelStyle baseExcelStyle) {
        if (CollectionUtil.isEmpty((Collection)list)) {
            list = new ArrayList();
        }
        return ExcelUtils.getExportUrlStyle(list, classTemplate, null, fileName, baseExcelStyle);
    }

    public static String uploadFile(List list, Class classTemplate) {
        Label annotation = classTemplate.getAnnotation(Label.class);
        String fileName = String.format("%s_%s", annotation.desc(), System.currentTimeMillis());
        return EasyPoiExportUtil.uploadFile(list, classTemplate, fileName);
    }

    public static Class<ImportBaseModeDto> getClassNewTemplate(String modeType) {
        Class<ImportBaseModeDto> classTemplate = null;
        switch (ModeTypeEnum.getInstance((String)modeType)) {
            case PHYSICAL_WAREHOUSE_QUERY: {
                break;
            }
        }
        if (classTemplate == null) {
            throw new BizException("\u8f93\u5165\u529f\u80fd\u6a21\u677f\u4e0d\u5728\u8303\u56f4\u4e4b\u5185");
        }
        return classTemplate;
    }

    public static void checkExcelHeader(InputStream inputStream, ModeTypeEnum typeEnum, int rowNum) {
        ExcelReader excelReader;
        List names;
        boolean b;
        Class<ImportBaseModeDto> importTemplate = typeEnum.getImportTemplate();
        if (typeEnum.getImportTemplate() == null) {
            importTemplate = EasyPoiExportUtil.getClassTemplate(typeEnum.getKey());
        }
        if (!(b = ExcelUtils.checkExcelHeader(names = (excelReader = ExcelUtils.getExcelReader(inputStream, (Class)importTemplate)).readRow(rowNum), importTemplate))) {
            throw new BizException("\u4e0a\u4f20\u7684\u6a21\u677f\u4e0d\u5bf9\uff0c\u8bf7\u4e0b\u8f7d\u6700\u65b0\u7684\u6a21\u677f");
        }
    }

    public static void checkExcelHeader(InputStream inputStream, Class<? extends ImportBaseModeDto> clazz, int rowNum) {
        ExcelReader excelReader = ExcelUtils.getExcelReader(inputStream, clazz);
        List names = excelReader.readRow(rowNum);
        boolean b = ExcelUtils.checkExcelHeader(names, clazz);
        if (!b) {
            throw new BizException("\u4e0a\u4f20\u7684\u6a21\u677f\u4e0d\u5bf9\uff0c\u8bf7\u4e0b\u8f7d\u6700\u65b0\u7684\u6a21\u677f");
        }
    }

    public static void checkFileInfo(String url) {
        if (StringUtils.isEmpty((CharSequence)url)) {
            throw new BizException("\u6587\u4ef6\u8def\u52b2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String xls = "xls";
        String xlsx = "xlsx";
        if (!url.endsWith(xls) && !url.endsWith(xlsx)) {
            throw new BizException("\u6587\u4ef6\u683c\u5f0f\u4e0d\u6b63\u786e\uff01\u4ec5\u652f\u6301[xls\u548cxlsx]");
        }
    }

    private static void verfiyExcelImportFail(ExcelImportResult<ImportBaseModeDto> result) {
        if (result.isVerfiyFail()) {
            StringBuilder msgError = new StringBuilder();
            for (ImportBaseModeDto modeDto : result.getFailList()) {
                msgError.append(String.format("\u7b2c%s\u884c\u7684\u9519\u8bef\u662f:%s", modeDto.getRowNum(), modeDto.getErrorMsg())).append(";");
            }
            if (msgError.length() > 1) {
                throw new BizException(msgError.toString());
            }
        }
    }

    static {
        MAX_SIZE = 10;
    }
}

