/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.mgmt.service.finance.impl;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.util.ParamConverter;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.finance.dto.entity.BillEntityDto;
import com.yunxi.dg.base.center.finance.dto.entity.BillEntityPageReqDto;
import com.yunxi.dg.base.center.finance.dto.request.BillEntityReqDto;
import com.yunxi.dg.base.center.finance.dto.response.BillEntityRespDto;
import com.yunxi.dg.base.center.finance.proxy.entity.IBillEntityApiProxy;
import com.yunxi.dg.base.mgmt.service.finance.FinancialManagementInvoiceManagementInvoiceEntityManagementService;
import com.yunxi.dg.base.ocs.mgmt.application.dto.finance.BatchDeleteInvoiceEntityParams;
import com.yunxi.dg.base.ocs.mgmt.application.dto.finance.GetInvoiceEntityListPageParams;
import com.yunxi.dg.base.ocs.mgmt.application.dto.finance.InvoiceEntityVO;
import io.swagger.annotations.ApiParam;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

@Service
public class FinancialManagementInvoiceManagementInvoiceEntityManagementServiceServiceImpl
implements FinancialManagementInvoiceManagementInvoiceEntityManagementService {
    private static Logger logger = LoggerFactory.getLogger(FinancialManagementInvoiceManagementInvoiceEntityManagementServiceServiceImpl.class);
    @Resource
    private IBillEntityApiProxy billEntityApi;

    @Override
    public RestResponse<Object> addInvoiceEntity(@ApiParam(value="") @Valid @RequestBody(required=false) InvoiceEntityVO invoiceEntityVO) {
        String invoiceEntityCode = invoiceEntityVO.getInvoiceEntityCode();
        BillEntityPageReqDto billEntityPageReqDto = new BillEntityPageReqDto();
        billEntityPageReqDto.setEntityCode(invoiceEntityCode);
        PageInfo billEntityDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.billEntityApi.page(billEntityPageReqDto));
        List list = billEntityDtoPageInfo.getList();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            throw new BizException("\u4e3b\u4f53\u7f16\u7801\u5df2\u7ecf\u5b58\u5728:" + invoiceEntityCode);
        }
        BillEntityDto reqDto = new BillEntityDto();
        FinancialManagementInvoiceManagementInvoiceEntityManagementServiceServiceImpl.vo2ReqDto(invoiceEntityVO, reqDto);
        if (StrUtil.isNotBlank((CharSequence)invoiceEntityVO.getAllElectronicNormalInvoiceLimitAmount())) {
            reqDto.setEleSpeInvoiceLimit(new BigDecimal(invoiceEntityVO.getAllElectronicNormalInvoiceLimitAmount()));
        }
        logger.info("\u65b0\u589e\u5f00\u7968\u4e3b\u4f53\u5165\u53c2reqDto:{}", (Object)JSON.toJSONString((Object)reqDto));
        RestResponseHelper.extractData((RestResponse)this.billEntityApi.insert(reqDto));
        return new RestResponse();
    }

    @Override
    public RestResponse<Object> deleteInvoiceEntity(@ApiParam(value="") @Valid @RequestBody(required=false) BatchDeleteInvoiceEntityParams batchDeleteInvoiceEntityParams) {
        if (CollectionUtils.isNotEmpty((Collection)batchDeleteInvoiceEntityParams.getIds())) {
            RestResponseHelper.extractData((RestResponse)this.billEntityApi.removeBillEntity(batchDeleteInvoiceEntityParams.getIds()));
        }
        return new RestResponse();
    }

    @Override
    public RestResponse<InvoiceEntityVO> getInvoiceEntityDetail(@NotNull @ApiParam(value="", required=true) @Valid @RequestParam(value="id", required=true) String id) {
        BillEntityRespDto billEntityRespDto = (BillEntityRespDto)RestResponseHelper.extractData((RestResponse)this.billEntityApi.queryById(ParamConverter.convertToLong((Object)id)));
        InvoiceEntityVO vo = new InvoiceEntityVO();
        if (billEntityRespDto != null) {
            FinancialManagementInvoiceManagementInvoiceEntityManagementServiceServiceImpl.respDto2Vo(billEntityRespDto, vo);
        }
        return new RestResponse((Object)vo);
    }

    @Override
    public RestResponse<PageInfo<InvoiceEntityVO>> getInvoiceEntityListPage(@ApiParam(value="") @Valid @RequestBody(required=false) GetInvoiceEntityListPageParams getInvoiceEntityListPageParams) {
        BillEntityReqDto reqDto = new BillEntityReqDto();
        int pageSize = 10;
        int pageNum = 1;
        if (getInvoiceEntityListPageParams != null) {
            reqDto.setEntityName(getInvoiceEntityListPageParams.getInvoiceEntityName());
            reqDto.setEntityCode(getInvoiceEntityListPageParams.getInvoiceEntityCode());
            pageNum = getInvoiceEntityListPageParams.getPageNum();
            pageSize = getInvoiceEntityListPageParams.getPageSize();
        }
        String filter = JSON.toJSONString((Object)reqDto);
        logger.info("\u5f00\u7968\u4e3b\u4f53\u5217\u8868\u67e5\u8be2\u5165\u53c2reqDto\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        PageInfo billEntityRespDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.billEntityApi.queryByPage(Integer.valueOf(pageNum), Integer.valueOf(pageSize), filter));
        logger.info("\u5f00\u7968\u4e3b\u4f53\u5217\u8868\u67e5\u8be2\u51fa\u53c2billEntityRespDtoPageInfo\uff1a{}", (Object)JSON.toJSONString((Object)billEntityRespDtoPageInfo));
        ArrayList list = Lists.newArrayList();
        PageInfo pageInfo = new PageInfo();
        if (CollectionUtils.isNotEmpty((Collection)billEntityRespDtoPageInfo.getList())) {
            BeanUtils.copyProperties((Object)billEntityRespDtoPageInfo, (Object)pageInfo);
            List respDtos = billEntityRespDtoPageInfo.getList();
            respDtos.forEach(respDto -> {
                InvoiceEntityVO vo = new InvoiceEntityVO();
                FinancialManagementInvoiceManagementInvoiceEntityManagementServiceServiceImpl.respDto2Vo(respDto, vo);
                list.add(vo);
            });
        }
        pageInfo.setList((List)list);
        logger.info("\u5f00\u7968\u4e3b\u4f53\u5206\u9875\u6570\u636epageInfo:{}", (Object)JSON.toJSONString((Object)pageInfo));
        return new RestResponse((Object)pageInfo);
    }

    @Override
    public RestResponse<Object> updateInvoiceEntity(@ApiParam(value="", required=true) @PathVariable(value="id") String id, @ApiParam(value="") @Valid @RequestBody(required=false) InvoiceEntityVO invoiceEntityVO) {
        if (StringUtils.isBlank((CharSequence)id) && Objects.isNull(invoiceEntityVO)) {
            throw new BizException("\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        BillEntityDto reqDto = new BillEntityDto();
        FinancialManagementInvoiceManagementInvoiceEntityManagementServiceServiceImpl.vo2ReqDto(invoiceEntityVO, reqDto);
        reqDto.setId(ParamConverter.convertToLong((Object)id));
        RestResponseHelper.extractData((RestResponse)this.billEntityApi.update(reqDto));
        return new RestResponse();
    }

    private static void vo2ReqDto(InvoiceEntityVO invoiceEntityVO, BillEntityDto reqDto) {
        BeanUtils.copyProperties((Object)invoiceEntityVO, (Object)reqDto);
        reqDto.setEnterprise(invoiceEntityVO.getCompanyName());
        reqDto.setEntityName(invoiceEntityVO.getInvoiceEntityName());
        reqDto.setEntityCode(invoiceEntityVO.getInvoiceEntityCode());
        reqDto.setTaxesCode(invoiceEntityVO.getTaxpayerIdentificationNo());
        reqDto.setRegisteredAddress(invoiceEntityVO.getRegisterAddress());
        reqDto.setRegisteredPhone(invoiceEntityVO.getRegisterPhone());
        reqDto.setBankAccount(invoiceEntityVO.getBankAccountNo());
        reqDto.setBank(invoiceEntityVO.getDepositBank());
        reqDto.setCollectPerson(invoiceEntityVO.getPayeeName());
        reqDto.setReviewPerson(invoiceEntityVO.getCheckPerson());
        reqDto.setBillPerson(invoiceEntityVO.getInvoicingPerson());
        reqDto.setEleComInvoiceLimit(invoiceEntityVO.getElectronicNormalInvoiceLimitAmount() != null ? new BigDecimal(invoiceEntityVO.getElectronicNormalInvoiceLimitAmount()).setScale(2, 4) : new BigDecimal(0).setScale(2, 4));
        reqDto.setPapComInvoiceLimit(invoiceEntityVO.getPaperNormalInvoiceLimitAmount() != null ? new BigDecimal(invoiceEntityVO.getPaperNormalInvoiceLimitAmount()).setScale(2, 4) : new BigDecimal(0).setScale(2, 4));
        reqDto.setPapSpeInvoiceLimit(invoiceEntityVO.getPaperSpecialInvoiceLimitAmount() != null ? new BigDecimal(invoiceEntityVO.getPaperSpecialInvoiceLimitAmount()).setScale(2, 4) : new BigDecimal(0).setScale(2, 4));
        reqDto.setAllEleComInvoiceLimit(invoiceEntityVO.getAllElectronicNormalInvoiceLimitAmount() != null ? new BigDecimal(invoiceEntityVO.getAllElectronicNormalInvoiceLimitAmount()).setScale(2, 4) : new BigDecimal(0).setScale(2, 4));
        reqDto.setAllEleSpeInvoiceLimit(invoiceEntityVO.getAllElectronicSpecialInvoiceLimitAmount() != null ? new BigDecimal(invoiceEntityVO.getAllElectronicSpecialInvoiceLimitAmount()).setScale(2, 4) : new BigDecimal(0).setScale(2, 4));
        reqDto.setEleSpeInvoiceLimit(invoiceEntityVO.getElectronicSpecialInvoiceLimitAmount() != null ? new BigDecimal(invoiceEntityVO.getElectronicSpecialInvoiceLimitAmount()).setScale(2, 4) : new BigDecimal(0).setScale(2, 4));
    }

    private static void respDto2Vo(BillEntityRespDto respDto, InvoiceEntityVO vo) {
        BeanUtils.copyProperties((Object)respDto, (Object)vo);
        vo.setInvoiceEntityName(respDto.getEntityName());
        vo.setInvoiceEntityCode(respDto.getEntityCode());
        vo.setCompanyName(respDto.getEnterprise());
        vo.setTaxpayerIdentificationNo(respDto.getTaxesCode());
        vo.setRegisterAddress(respDto.getRegisteredAddress());
        vo.setRegisterPhone(respDto.getRegisteredPhone());
        vo.setDepositBank(respDto.getBank());
        vo.setBankAccountNo(respDto.getBankAccount());
        vo.setPayeeName(respDto.getCollectPerson());
        vo.setCheckPerson(respDto.getReviewPerson());
        vo.setInvoicingPerson(respDto.getBillPerson());
        vo.setElectronicNormalInvoiceLimitAmount(respDto.getEleComInvoiceLimit().setScale(2, 4).toString());
        vo.setPaperNormalInvoiceLimitAmount(respDto.getPapComInvoiceLimit().setScale(2, 4).toString());
        vo.setPaperSpecialInvoiceLimitAmount(respDto.getPapSpeInvoiceLimit().setScale(2, 6).toString());
        vo.setAllElectronicNormalInvoiceLimitAmount(null != respDto.getAllEleComInvoiceLimit() ? respDto.getAllEleComInvoiceLimit().setScale(2, 6).toString() : null);
        vo.setAllElectronicSpecialInvoiceLimitAmount(null != respDto.getAllEleSpeInvoiceLimit() ? respDto.getAllEleSpeInvoiceLimit().setScale(2, 6).toString() : null);
        vo.setElectronicSpecialInvoiceLimitAmount(null != respDto.getEleSpeInvoiceLimit() ? respDto.getEleSpeInvoiceLimit().setScale(2, 6).toString() : null);
        vo.setOrganizationCode(respDto.getOrganizationCode());
        vo.setOrganizationId(respDto.getOrganizationId());
    }

    private static void vo2RespDto(InvoiceEntityVO vo, BillEntityRespDto respDto) {
        BeanUtils.copyProperties((Object)vo, (Object)respDto);
        respDto.setEntityName(vo.getInvoiceEntityName());
        respDto.setEntityCode(vo.getInvoiceEntityCode());
        respDto.setEnterprise(vo.getCompanyName());
        respDto.setTaxesCode(vo.getTaxpayerIdentificationNo());
        respDto.setRegisteredAddress(vo.getRegisterAddress());
        respDto.setRegisteredPhone(vo.getRegisterPhone());
        respDto.setBank(vo.getDepositBank());
        respDto.setBankAccount(vo.getBankAccountNo());
        respDto.setCollectPerson(vo.getPayeeName());
        respDto.setReviewPerson(vo.getCheckPerson());
        respDto.setBillPerson(vo.getInvoicingPerson());
        respDto.setEleComInvoiceLimit(vo.getElectronicNormalInvoiceLimitAmount() != null ? new BigDecimal(vo.getElectronicNormalInvoiceLimitAmount()).setScale(2, 4) : new BigDecimal(0).setScale(2, 4));
        respDto.setPapComInvoiceLimit(vo.getPaperNormalInvoiceLimitAmount() != null ? new BigDecimal(vo.getPaperNormalInvoiceLimitAmount()).setScale(2, 4) : new BigDecimal(0).setScale(2, 4));
        respDto.setPapSpeInvoiceLimit(vo.getPaperSpecialInvoiceLimitAmount() != null ? new BigDecimal(vo.getPaperSpecialInvoiceLimitAmount()).setScale(2, 4) : new BigDecimal(0).setScale(2, 4));
    }
}

