/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.mgmt.service.finance.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.cube.utils.enums.DatePattern;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.util.DateUtil;
import com.dtyunxi.util.ParamConverter;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.finance.dto.request.AddBillAllElectricShopReqDto;
import com.yunxi.dg.base.center.finance.dto.request.BillAllElectricShopQueryDto;
import com.yunxi.dg.base.center.finance.dto.request.BillAllElectricShopReqDto;
import com.yunxi.dg.base.center.finance.dto.request.BillApplyAuditModifyStatusReqDto;
import com.yunxi.dg.base.center.finance.dto.request.BillApplyAuditReqDto;
import com.yunxi.dg.base.center.finance.dto.request.BillStrategyNoInvoiceItemReqDto;
import com.yunxi.dg.base.center.finance.dto.request.BillStrategyQueryReqDto;
import com.yunxi.dg.base.center.finance.dto.request.BillStrategyReqDto;
import com.yunxi.dg.base.center.finance.dto.request.BillStrategyShopReqDto;
import com.yunxi.dg.base.center.finance.dto.response.BillStrategyRespDto;
import com.yunxi.dg.base.center.finance.proxy.entity.IBillAllElectricShopApiProxy;
import com.yunxi.dg.base.center.finance.proxy.entity.IBillStrategyApiProxy;
import com.yunxi.dg.base.center.finance.proxy.entity.IBillStrategyShopApiProxy;
import com.yunxi.dg.base.center.finance.proxy.entity.IShopApiProxy;
import com.yunxi.dg.base.mgmt.service.finance.FinancialManagementInvoiceManagementInvoiceStrategyService;
import com.yunxi.dg.base.mgmt.service.utils.AssertUtil;
import com.yunxi.dg.base.ocs.mgmt.application.dto.finance.AddInvoiceStrategySettingShopListParams;
import com.yunxi.dg.base.ocs.mgmt.application.dto.finance.BatchSetInvoiceStrategyAutoAuditParams;
import com.yunxi.dg.base.ocs.mgmt.application.dto.finance.BillStrategyNoInvoiceItem;
import com.yunxi.dg.base.ocs.mgmt.application.dto.finance.DeleteInvoiceStrategyParams;
import com.yunxi.dg.base.ocs.mgmt.application.dto.finance.DeleteInvoiceStrategySettingShopListParams;
import com.yunxi.dg.base.ocs.mgmt.application.dto.finance.GetInvoiceStrategyListParams;
import com.yunxi.dg.base.ocs.mgmt.application.dto.finance.InvoiceStrategyVO;
import com.yunxi.dg.base.ocs.mgmt.application.dto.finance.InvoiceStrategyVOApplyShop;
import com.yunxi.dg.base.ocs.mgmt.application.dto.finance.ShopVO;
import com.yunxi.dg.base.ocs.mgmt.application.dto.finance.SubmitInvoiceStrategyBody;
import io.swagger.annotations.ApiParam;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.validation.Valid;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;

@Service
public class FinancialManagementInvoiceManagementInvoiceStrategyServiceServiceImpl
implements FinancialManagementInvoiceManagementInvoiceStrategyService {
    @Resource
    private IBillStrategyApiProxy billStrategyApi;
    @Resource
    private IBillStrategyShopApiProxy billStrategyShopApi;
    @Resource
    private IShopApiProxy shopApiProxy;
    @Resource
    private IBillAllElectricShopApiProxy billAllElectricShopApi;
    private static final Logger logger = LoggerFactory.getLogger(FinancialManagementInvoiceManagementInvoiceStrategyServiceServiceImpl.class);

    @Override
    public RestResponse<Object> addInvoiceStrategy(@ApiParam(value="") @Valid @RequestBody(required=false) SubmitInvoiceStrategyBody submitInvoiceStrategyBody) {
        if (Objects.isNull(submitInvoiceStrategyBody)) {
            throw new BizException("\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        BillStrategyReqDto reqDto = new BillStrategyReqDto();
        this.param2ReqDto(submitInvoiceStrategyBody, reqDto);
        logger.info("\u65b0\u589e\u5f00\u7968\u7b56\u7565\u5165\u53c2reqDto:{}", (Object)JSON.toJSONString((Object)reqDto));
        RestResponseHelper.extractData((RestResponse)this.billStrategyApi.addBillStrategy(reqDto));
        return new RestResponse();
    }

    @Override
    public RestResponse<Object> deleteInvoiceStrategy(@ApiParam(value="") @Valid @RequestBody(required=false) DeleteInvoiceStrategyParams deleteInvoiceStrategyParams) {
        if (CollectionUtils.isEmpty((Collection)deleteInvoiceStrategyParams.getStrategyIds())) {
            throw new BizException("\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        ArrayList ids = Lists.newArrayList();
        List strategyIds = deleteInvoiceStrategyParams.getStrategyIds();
        strategyIds.forEach(strategyId -> {
            Long id = ParamConverter.convertToLong((Object)strategyId);
            ids.add(id);
        });
        logger.info("\u5220\u9664\u5f00\u7968\u7b56\u7565\u5165\u53c2ids:{}", (Object)JSON.toJSONString((Object)ids));
        RestResponseHelper.extractData((RestResponse)this.billStrategyApi.removeBillStrategy((List)ids));
        return new RestResponse();
    }

    @Override
    public RestResponse<InvoiceStrategyVO> getInvoiceStrategyById(@ApiParam(value="", required=true) @PathVariable(value="id") String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            throw new BizException("\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        BillStrategyRespDto respDto = (BillStrategyRespDto)RestResponseHelper.extractData((RestResponse)this.billStrategyApi.queryById(ParamConverter.convertToLong((Object)id)));
        logger.info("\u5f00\u7968\u7b56\u7565\u8be6\u60c5\u67e5\u8be2\u51fa\u53c2respDto:{}", (Object)JSON.toJSONString((Object)respDto));
        InvoiceStrategyVO vo = new InvoiceStrategyVO();
        FinancialManagementInvoiceManagementInvoiceStrategyServiceServiceImpl.vo2RespDto(vo, respDto);
        logger.info("\u5f00\u7968\u7b56\u7565\u8be6\u60c5\u8fd4\u56devo:{}", (Object)JSON.toJSONString((Object)vo));
        return new RestResponse((Object)vo);
    }

    @Override
    public RestResponse<PageInfo<InvoiceStrategyVO>> getInvoiceStrategyListPage(@ApiParam(value="") @Valid @RequestBody(required=false) GetInvoiceStrategyListParams getInvoiceStrategyListParams) {
        if (Objects.isNull(getInvoiceStrategyListParams)) {
            throw new BizException("\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        BillStrategyQueryReqDto reqDto = new BillStrategyQueryReqDto();
        reqDto.setStrategyCode(getInvoiceStrategyListParams.getRuleCode());
        reqDto.setStrategyName(getInvoiceStrategyListParams.getRuleName());
        reqDto.setStrategyStatus(getInvoiceStrategyListParams.getRuleStatus());
        reqDto.setPageNum(getInvoiceStrategyListParams.getPageNum());
        reqDto.setPageSize(getInvoiceStrategyListParams.getPageSize());
        reqDto.setBillEntityName(getInvoiceStrategyListParams.getSpecialSubjectName());
        reqDto.setStrategyType(getInvoiceStrategyListParams.getStrategyType());
        reqDto.setInvoiceType(getInvoiceStrategyListParams.getInvoiceType());
        logger.info("\u5f00\u7968\u7b56\u7565\u5217\u8868\u5165\u53c2reqDto:{}", (Object)JSON.toJSONString((Object)reqDto));
        PageInfo dtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.billStrategyApi.queryByPage(reqDto));
        PageInfo pageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)pageInfo, (Object)dtoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        List<Object> list = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)dtoPageInfo.getList())) {
            list = dtoPageInfo.getList().stream().map(dto -> {
                InvoiceStrategyVO vo = new InvoiceStrategyVO();
                FinancialManagementInvoiceManagementInvoiceStrategyServiceServiceImpl.vo2RespDto(vo, dto);
                vo.setSpecialSubjectName(dto.getBillEntityName());
                return vo;
            }).collect(Collectors.toList());
        }
        logger.info("\u5f00\u7968\u7b56\u7565\u8fd4\u56de\u5217\u8868list:{}", (Object)JSON.toJSONString((Object)list));
        pageInfo.setList((List)list);
        return new RestResponse((Object)pageInfo);
    }

    @Override
    public RestResponse<Object> updateInvoiceStrategy(@ApiParam(value="", required=true) @PathVariable(value="id") String id, @ApiParam(value="") @Valid @RequestBody(required=false) SubmitInvoiceStrategyBody submitInvoiceStrategyBody) {
        if (StringUtils.isBlank((CharSequence)id) || Objects.isNull(submitInvoiceStrategyBody)) {
            throw new BizException("\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        BillStrategyReqDto reqDto = new BillStrategyReqDto();
        this.param2ReqDto(submitInvoiceStrategyBody, reqDto);
        reqDto.setId(ParamConverter.convertToLong((Object)id));
        RestResponseHelper.extractData((RestResponse)this.billStrategyApi.modifyBillStrategy(reqDto));
        return new RestResponse();
    }

    @Override
    public RestResponse<Object> updateInvoiceStrategyStatus(@ApiParam(value="") @Valid @RequestBody(required=false) SubmitInvoiceStrategyBody submitInvoiceStrategyBody) {
        if (Objects.isNull(submitInvoiceStrategyBody)) {
            throw new BizException("\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        BillApplyAuditModifyStatusReqDto reqDto = new BillApplyAuditModifyStatusReqDto();
        reqDto.setId(ParamConverter.convertToLong((Object)submitInvoiceStrategyBody.getRuleId()));
        reqDto.setStrategyStatus(submitInvoiceStrategyBody.getRuleStatus());
        RestResponseHelper.extractData((RestResponse)this.billStrategyApi.modifyStatus(reqDto));
        return new RestResponse();
    }

    @Override
    public RestResponse<Object> batchSetInvoiceStrategyAutoAudit(@ApiParam(value="") @Valid @RequestBody(required=false) BatchSetInvoiceStrategyAutoAuditParams batchSetInvoiceStrategyAutoAuditParams) {
        AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)batchSetInvoiceStrategyAutoAuditParams.getStrategyIds()), "\u7b56\u7565id\u4e0d\u80fd\u4e3a\u7a7a");
        BillApplyAuditReqDto billApplyAuditReqDto = new BillApplyAuditReqDto();
        List idList = batchSetInvoiceStrategyAutoAuditParams.getStrategyIds().stream().map(id -> Long.valueOf(id)).collect(Collectors.toList());
        billApplyAuditReqDto.setIds(idList);
        billApplyAuditReqDto.setBillAudit(batchSetInvoiceStrategyAutoAuditParams.getIsAutoAudit());
        billApplyAuditReqDto.setBillApplyType(batchSetInvoiceStrategyAutoAuditParams.getApplyInvoiceType());
        this.billStrategyApi.updateApplyAudit(billApplyAuditReqDto);
        return new RestResponse();
    }

    @Override
    public RestResponse<Object> addInvoiceStrategySettingShopList(@ApiParam(value="") @Valid @RequestBody(required=false) AddInvoiceStrategySettingShopListParams addInvoiceStrategySettingShopListParams) {
        AddBillAllElectricShopReqDto addReqDto = new AddBillAllElectricShopReqDto();
        addReqDto.setIsUpdate(Boolean.FALSE);
        ArrayList reqDtoList = new ArrayList();
        addInvoiceStrategySettingShopListParams.getShopList().forEach(shop -> {
            BillAllElectricShopReqDto billAllElectricShopReqDto = new BillAllElectricShopReqDto();
            billAllElectricShopReqDto.setShopId(ParamConverter.convertToLong((Object)shop.getShopId()));
            billAllElectricShopReqDto.setShopCode(shop.getShopCode());
            billAllElectricShopReqDto.setShopName(shop.getShopName());
            billAllElectricShopReqDto.setSiteId(ParamConverter.convertToLong((Object)shop.getStationId()));
            billAllElectricShopReqDto.setSiteCode(shop.getStationCode());
            billAllElectricShopReqDto.setSiteName(shop.getStationName());
            reqDtoList.add(billAllElectricShopReqDto);
        });
        addReqDto.setReqDtoList(reqDtoList);
        logger.info("\u65b0\u589e\u5168\u7535\u53d1\u7968\u5e97\u94fa\u914d\u7f6e:{}", (Object)JSON.toJSONString((Object)addReqDto));
        RestResponseHelper.extractData((RestResponse)this.billAllElectricShopApi.addUpdateBillAllElectricShop(addReqDto));
        return new RestResponse();
    }

    @Override
    public RestResponse<Object> deleteInvoiceStrategySettingShopList(@ApiParam(value="") @Valid @RequestBody(required=false) DeleteInvoiceStrategySettingShopListParams deleteInvoiceStrategySettingShopListParams) {
        List shopRowIdList = deleteInvoiceStrategySettingShopListParams.getShopRowIdList();
        if (CollectionUtils.isEmpty((Collection)shopRowIdList)) {
            throw new BizException("\u8bf7\u9009\u62e9\u9700\u8981\u5220\u9664\u7684\u5e97\u94fa");
        }
        List idList = shopRowIdList.stream().filter(StringUtils::isNotBlank).map(ParamConverter::convertToLong).distinct().collect(Collectors.toList());
        logger.info("\u5220\u9664\u5168\u7535\u53d1\u7968\u5e97\u94fa\u914d\u7f6e:{}", (Object)JSON.toJSONString(idList));
        RestResponseHelper.extractData((RestResponse)this.billAllElectricShopApi.removeBillAllElectricShop(idList));
        return new RestResponse();
    }

    @Override
    public RestResponse<Object> getInvoiceStrategySettingShopList() {
        BillAllElectricShopQueryDto queryDto = new BillAllElectricShopQueryDto();
        List respDtoList = (List)RestResponseHelper.extractData((RestResponse)this.billAllElectricShopApi.queryByList(queryDto));
        return new RestResponse((Object)respDtoList);
    }

    private void param2ReqDto(SubmitInvoiceStrategyBody param, BillStrategyReqDto reqDto) {
        List shopVOS;
        BeanUtils.copyProperties((Object)param, (Object)reqDto);
        reqDto.setStrategyCode(param.getRuleCode());
        reqDto.setStrategyName(param.getRuleName());
        reqDto.setStrategyStatus(param.getRuleStatus());
        reqDto.setBillChannel(param.getSpecialChannel());
        reqDto.setBillEntityName(param.getSpecialSubjectName());
        reqDto.setBillEntityCode(param.getSpecialSubjectId());
        reqDto.setBillObject(param.getSpecialOrderType());
        reqDto.setBillOrderPoint(param.getSpecialOrderStatus());
        reqDto.setBillRowName(param.getInvoiceTitleType());
        reqDto.setSpecification(param.getGoodsSpecificationName());
        reqDto.setBillGift(param.getInvoicingOfGift());
        reqDto.setRuleType(param.getRuleType());
        reqDto.setBillFreight(param.getInvoicingOfFreight());
        reqDto.setFreightCostItemId(param.getFreightGoodsId());
        reqDto.setFreightCostItemCode(param.getFreightGoodsCode());
        reqDto.setRemark(param.getRemarkType());
        reqDto.setTaxCode(param.getTaxCategoryCode());
        reqDto.setRemarkLength(param.getRemarkLength());
        reqDto.setStrategyRemark(param.getStrategyRemark());
        if (param.getTaxRate() != null) {
            reqDto.setTaxRate(new BigDecimal(param.getTaxRate()).setScale(2, 4));
        }
        reqDto.setBillAudit(param.getIsAutoAudit());
        reqDto.setBillApplyType(param.getApplyInvoiceType());
        reqDto.setApplyColourType(param.getApplyColourType());
        reqDto.setCreateTypeList(param.getCreateTypeList());
        reqDto.setNationalSupplementOrder(param.getNationalSupplementOrder());
        reqDto.setWhetherMergeItem(param.getWhetherMergeItem());
        reqDto.setApplyShop(param.getApplyShop().getApplicableType());
        reqDto.setStrategyType(param.getStrategyType());
        reqDto.setRemarkLength(param.getRemarkLength());
        reqDto.setStrategyRemark(param.getStrategyRemark());
        reqDto.setInvoiceType(param.getInvoiceType());
        reqDto.setUseBlackList(param.getUseBlackList());
        reqDto.setBlackListContent(param.getBlackListContent());
        ArrayList shopReqDtos = Lists.newArrayList();
        if ("part".equals(param.getApplyShop().getApplicableType()) && CollectionUtils.isNotEmpty((Collection)(shopVOS = param.getApplyShop().getApplicableList()))) {
            shopVOS.forEach(shopVO -> {
                BillStrategyShopReqDto shopReqDto = new BillStrategyShopReqDto();
                shopReqDto.setBillStrategyId(param.getId());
                shopReqDto.setId(shopVO.getId());
                shopReqDto.setShopName(shopVO.getShopName());
                shopReqDto.setShopCode(shopVO.getShopCode());
                shopReqDtos.add(shopReqDto);
            });
        }
        if ("all".equals(param.getApplyShop().getApplicableType())) {
            List shopDtoList = (List)RestResponseHelper.extractData((RestResponse)this.shopApiProxy.queryShopListAll());
            shopDtoList.forEach(shopExtRespDto -> {
                BillStrategyShopReqDto shopReqDto = new BillStrategyShopReqDto();
                shopReqDto.setBillStrategyId(param.getId());
                shopReqDto.setId(shopExtRespDto.getId());
                shopReqDto.setShopName(shopExtRespDto.getName());
                shopReqDto.setShopCode(shopExtRespDto.getCode());
                shopReqDtos.add(shopReqDto);
            });
        }
        reqDto.setShopReqDtos((List)shopReqDtos);
        if (CollectionUtils.isNotEmpty((Collection)param.getBillStrategyNoInvoiceItemList())) {
            ArrayList billStrategyNoInvoiceItemReqDtoList = new ArrayList();
            CubeBeanUtils.copyCollection(billStrategyNoInvoiceItemReqDtoList, (Collection)param.getBillStrategyNoInvoiceItemList(), BillStrategyNoInvoiceItemReqDto.class);
            reqDto.setBillStrategyNoInvoiceItemReqDtoList(billStrategyNoInvoiceItemReqDtoList);
        }
    }

    private static void vo2RespDto(InvoiceStrategyVO vo, BillStrategyRespDto respDto) {
        vo.setRuleName(respDto.getStrategyName());
        vo.setRuleId(ParamConverter.convertToString((Object)respDto.getId()));
        vo.setId(respDto.getId());
        vo.setRuleCode(respDto.getStrategyCode());
        vo.setRuleStatus(respDto.getStrategyStatus());
        vo.setSpecialOrderType(respDto.getBillObject());
        vo.setSpecialOrderStatus(respDto.getBillOrderPoint());
        vo.setRuleType(respDto.getRuleType());
        vo.setRemarkType(respDto.getRemark());
        vo.setTaxCategoryCode(respDto.getTaxCode());
        vo.setTaxRate(ParamConverter.convertToString((Object)respDto.getTaxRate()));
        vo.setIsAutoAudit(respDto.getBillAudit());
        vo.setGoodsSpecificationName(respDto.getSpecification());
        vo.setSpecialChannel(respDto.getBillChannel());
        vo.setInvoiceTitleType(respDto.getBillRowName());
        vo.setApplyInvoiceType(respDto.getBillApplyType());
        vo.setApplyColourType(respDto.getApplyColourType());
        vo.setCreateTypeList(respDto.getCreateTypeList());
        vo.setNationalSupplementOrder(respDto.getNationalSupplementOrder());
        vo.setUseBlackList(respDto.getUseBlackList());
        vo.setBlackListContent(respDto.getBlackListContent());
        vo.setInvoicingOfGift(respDto.getBillGift());
        vo.setInvoicingOfFreight(respDto.getBillFreight());
        vo.setFreightGoodsId(respDto.getFreightCostItemId());
        vo.setFreightGoodsCode(respDto.getFreightCostItemCode());
        vo.setSpecialSubjectId(respDto.getBillEntityCode());
        vo.setSpecialSubjectName(respDto.getBillEntityName());
        vo.setWhetherMergeItem(respDto.getWhetherMergeItem());
        vo.setRemarkLength(respDto.getRemarkLength());
        vo.setStrategyRemark(respDto.getStrategyRemark());
        vo.setInvoiceType(respDto.getInvoiceType());
        if (respDto.getCreateTime() != null) {
            vo.setCreateTime(DateUtil.format((Date)respDto.getCreateTime(), (String)DatePattern.DATETIME_PATTERN.getPattern()));
        }
        vo.setCreatePerson(respDto.getCreatePerson());
        if (respDto.getUpdateTime() != null) {
            vo.setUpdateTime(DateUtil.format((Date)respDto.getUpdateTime(), (String)DatePattern.DATETIME_PATTERN.getPattern()));
        }
        vo.setUpdatePerson(respDto.getUpdatePerson());
        InvoiceStrategyVOApplyShop invoiceStrategyVOApplyShop = new InvoiceStrategyVOApplyShop();
        invoiceStrategyVOApplyShop.setApplicableType(respDto.getApplyShop());
        ArrayList shopVOList = Lists.newArrayList();
        List billStrategyShopRespDtos = respDto.getShopRespDto();
        if (CollectionUtils.isNotEmpty((Collection)billStrategyShopRespDtos)) {
            billStrategyShopRespDtos.forEach(billStrategyShopRespDto -> {
                ShopVO shopVO = new ShopVO();
                shopVO.setId(billStrategyShopRespDto.getId());
                shopVO.setShopId(ParamConverter.convertToString((Object)billStrategyShopRespDto.getId()));
                shopVO.setShopName(billStrategyShopRespDto.getShopName());
                shopVO.setShopCode(billStrategyShopRespDto.getShopCode());
                shopVOList.add(shopVO);
            });
        }
        invoiceStrategyVOApplyShop.setApplicableList((List)shopVOList);
        vo.setApplyShop(invoiceStrategyVOApplyShop);
        if (CollectionUtils.isNotEmpty((Collection)respDto.getBillStrategyNoInvoiceItemRespDtoList())) {
            ArrayList billStrategyNoInvoiceItemList = new ArrayList();
            CubeBeanUtils.copyCollection(billStrategyNoInvoiceItemList, (Collection)respDto.getBillStrategyNoInvoiceItemRespDtoList(), BillStrategyNoInvoiceItem.class);
            vo.setBillStrategyNoInvoiceItemList(billStrategyNoInvoiceItemList);
        }
    }
}

