/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.mgmt.service.impl;

import cn.afterturn.easypoi.excel.entity.result.ExcelImportResult;
import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.huieryun.log.RequestId;
import com.dtyunxi.rest.RestResponse;
import com.github.pagehelper.PageInfo;
import com.wh.center.customer.api.dto.request.OperationTeamSelectReqDto;
import com.wh.center.customer.api.dto.response.OperationTeamSelectRespDto;
import com.wh.center.customer.api.query.IWhOperationTeamQueryApi;
import com.wh.center.data.api.dto.request.AreaNameReqDto;
import com.wh.center.data.api.dto.request.MatchByNameOrAliasReqDto;
import com.wh.center.data.api.dto.response.AreaMatchRespDto;
import com.wh.center.data.api.dto.response.AreaNodeDto;
import com.yunxi.dg.base.center.finance.dto.entity.GroupKeepAccountsConfigDto;
import com.yunxi.dg.base.center.finance.dto.request.GroupKeepReplaceAllReqDto;
import com.yunxi.dg.base.center.finance.dto.response.GroupKeepAccountsReplaceRespDto;
import com.yunxi.dg.base.center.finance.dto.response.GroupKeepReplaceAllRespDto;
import com.yunxi.dg.base.center.finance.proxy.entity.IGroupKeepAccountsConfigApiProxy;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import com.yunxi.dg.base.mgmt.application.rpc.proxy.query.IAreaExtQueryApiProxy;
import com.yunxi.dg.base.ocs.mgmt.application.dto.enums.FileOperationStatusEnum;
import com.yunxi.dg.base.ocs.mgmt.application.dto.request.GroupKeepAccountsConfigImportDto;
import com.yunxi.dg.base.poi.dto.ImportBaseModeDto;
import com.yunxi.dg.base.poi.dto.ImportFileOperationCommonReqDto;
import com.yunxi.dg.base.poi.dto.ImportFileOperationCommonRespDto;
import com.yunxi.dg.base.poi.service.AbstractBaseFileOperationCommonService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.stereotype.Service;

@Service(value="AbstractBaseFileOperationCommonService_group_keep_accounts_config_import")
public class GroupKeepAccountsConfigCommonServiceImpl
extends AbstractBaseFileOperationCommonService {
    private static final Logger log = LoggerFactory.getLogger(GroupKeepAccountsConfigCommonServiceImpl.class);
    @Resource
    private IAreaExtQueryApiProxy areaExtQueryApiProxy;
    @Resource
    private IWhOperationTeamQueryApi operationTeamQueryApi;
    @Resource
    private IGroupKeepAccountsConfigApiProxy groupKeepAccountsConfigApiProxy;

    public Object verifyImportFileOperationCommon(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto) {
        if (StringUtils.isBlank((CharSequence)ServiceContext.getContext().getRequestId())) {
            String requestId = RequestId.createReqId();
            MDC.put((String)"yes.req.requestId", (String)requestId);
            ServiceContext.getContext().setAttachment("yes.req.requestId", requestId);
        }
        log.info("\u5206\u7ec4\u8bb0\u8d26\u914d\u7f6e\u5bfc\u5165\u6570\u636e\uff1a{}", (Object)JSONObject.toJSONString(result));
        List resultList = BeanUtil.copyToList((Collection)result.getList(), GroupKeepAccountsConfigImportDto.class);
        if (CollectionUtil.isEmpty((Collection)resultList)) {
            respDto.setErrorMsg("\u5bfc\u5165\u5185\u5bb9\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5Excel\uff01");
            respDto.setStatus(FileOperationStatusEnum.IMPORT_ERROR.getCode());
            return new ArrayList();
        }
        ArrayList<AreaNameReqDto> provinces = new ArrayList<AreaNameReqDto>();
        HashSet<String> saleAreaCodes = new HashSet<String>();
        for (GroupKeepAccountsConfigImportDto dto : resultList) {
            boolean hasProvinceName = StrUtil.isNotBlank((CharSequence)dto.getProvinceName());
            Object province = null;
            if (hasProvinceName) {
                province = this.addAreaNameReq(provinces, 0, dto.getProvinceName());
            } else {
                dto.appendErrorMsg("\u7701\u4e0d\u80fd\u4e3a\u7a7a");
            }
            boolean bl = StrUtil.isNotBlank((CharSequence)dto.getCityName());
            if (!bl) {
                dto.appendErrorMsg("\u5e02\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StrUtil.isBlank((CharSequence)dto.getSaleAreaCode())) {
                dto.appendErrorMsg("\u9500\u552e\u533a\u57df\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            } else {
                saleAreaCodes.add(dto.getSaleAreaCode());
            }
            if (!hasProvinceName || !bl) continue;
            this.addAreaNameReq(province.getChildren(), 1, dto.getCityName());
        }
        Map<String, OperationTeamSelectRespDto> saleAreaMap = this.getSaleAreaMap(saleAreaCodes);
        AreaMatchRespDto areaMatch = this.processAreaNameCodeMap(provinces);
        HashMap<String, List> map = new HashMap<String, List>();
        for (GroupKeepAccountsConfigImportDto groupKeepAccountsConfigImportDto : resultList) {
            OperationTeamSelectRespDto area = saleAreaMap.get(groupKeepAccountsConfigImportDto.getSaleAreaCode());
            if (area == null) {
                groupKeepAccountsConfigImportDto.appendErrorMsg("\u9500\u552e\u533a\u57df\u4e0d\u5b58\u5728");
            } else {
                groupKeepAccountsConfigImportDto.setSaleAreaId(area.getId());
                groupKeepAccountsConfigImportDto.setSaleAreaName(area.getTeamName());
                groupKeepAccountsConfigImportDto.setSaleCompanyId(area.getDeptId());
                groupKeepAccountsConfigImportDto.setSaleCompanyCode(area.getOrgCode());
                groupKeepAccountsConfigImportDto.setSaleCompanyName(area.getDeptName());
                groupKeepAccountsConfigImportDto.setU9SaleAreaCode(area.getuCode());
                log.info("\u8bbe\u7f6eU9\u7f16\u7801\uff1a{} - {} - {}", new Object[]{groupKeepAccountsConfigImportDto.getSaleAreaCode(), groupKeepAccountsConfigImportDto.getSaleAreaName(), groupKeepAccountsConfigImportDto.getU9SaleAreaCode()});
            }
            AreaNodeDto province = areaMatch.matchAndSet(null, 0, () -> ((GroupKeepAccountsConfigImportDto)groupKeepAccountsConfigImportDto).getProvinceName(), arg_0 -> ((GroupKeepAccountsConfigImportDto)groupKeepAccountsConfigImportDto).setProvinceCode(arg_0), arg_0 -> ((GroupKeepAccountsConfigImportDto)groupKeepAccountsConfigImportDto).setProvinceName(arg_0));
            if (province == null || StringUtils.isBlank((CharSequence)province.getCode())) {
                groupKeepAccountsConfigImportDto.appendErrorMsg("\u7701\u4e0d\u5b58\u5728");
            }
            AreaNodeDto city = areaMatch.matchAndSet(province, 1, () -> ((GroupKeepAccountsConfigImportDto)groupKeepAccountsConfigImportDto).getCityName(), arg_0 -> ((GroupKeepAccountsConfigImportDto)groupKeepAccountsConfigImportDto).setCityCode(arg_0), arg_0 -> ((GroupKeepAccountsConfigImportDto)groupKeepAccountsConfigImportDto).setCityName(arg_0));
            if (city == null || StringUtils.isBlank((CharSequence)city.getCode())) {
                groupKeepAccountsConfigImportDto.appendErrorMsg("\u5e02\u4e0d\u5b58\u5728");
            }
            if (!StrUtil.isNotBlank((CharSequence)groupKeepAccountsConfigImportDto.getProvinceCode()) || !StrUtil.isNotBlank((CharSequence)groupKeepAccountsConfigImportDto.getCityCode())) continue;
            String key = groupKeepAccountsConfigImportDto.getProvinceCode() + "_" + groupKeepAccountsConfigImportDto.getCityCode();
            List list = map.computeIfAbsent(key, k -> new ArrayList());
            list.add(groupKeepAccountsConfigImportDto);
        }
        for (Map.Entry entry : map.entrySet()) {
            List list = (List)entry.getValue();
            if (list.size() <= 1) continue;
            for (GroupKeepAccountsConfigImportDto dto : list) {
                dto.appendErrorMsg("\u7701+\u5e02\u4e0d\u80fd\u91cd\u590d");
            }
        }
        ArrayList passList = resultList.stream().filter(p -> StrUtil.isBlank((CharSequence)p.getErrorMsg())).collect(Collectors.toList());
        log.info("\u5206\u7ec4\u8bb0\u8d26\u914d\u7f6e\u5bfc\u5165: resultList.size={}, passList.size={}", (Object)resultList.size(), (Object)passList.size());
        boolean bl = resultList.size() != passList.size();
        resultList.removeAll(passList);
        respDto.getErrorDetails().addAll(resultList);
        return bl ? new ArrayList() : passList;
    }

    private Map<String, OperationTeamSelectRespDto> getSaleAreaMap(Set<String> saleAreaCodes) {
        if (saleAreaCodes.isEmpty()) {
            return new HashMap<String, OperationTeamSelectRespDto>();
        }
        OperationTeamSelectReqDto reqDto = new OperationTeamSelectReqDto();
        reqDto.setTeamCodes(new ArrayList<String>(saleAreaCodes));
        RestResponse resp = this.operationTeamQueryApi.queryByPage(reqDto, Integer.valueOf(1), Integer.valueOf(saleAreaCodes.size()));
        PageInfo page = (PageInfo)RestResponseHelper.extractData((RestResponse)resp);
        if (page == null || page.getList() == null || page.getList().isEmpty()) {
            return new HashMap<String, OperationTeamSelectRespDto>();
        }
        return page.getList().stream().collect(Collectors.toMap(OperationTeamSelectRespDto::getTeamCode, Function.identity(), (a, b) -> b));
    }

    private AreaNameReqDto addAreaNameReq(List<AreaNameReqDto> list, int levelId, String name) {
        String finalName = Optional.ofNullable(name).orElse("");
        AreaNameReqDto req = list.stream().filter(s -> s.getLevelId().equals(levelId) && finalName.equals(s.getName())).findFirst().orElse(null);
        if (req != null) {
            return req;
        }
        req = new AreaNameReqDto();
        req.setLevelId(Integer.valueOf(levelId));
        req.setName(finalName);
        req.setChildren(new ArrayList());
        list.add(req);
        return req;
    }

    private AreaMatchRespDto processAreaNameCodeMap(List<AreaNameReqDto> provinces) {
        MatchByNameOrAliasReqDto req = new MatchByNameOrAliasReqDto();
        req.setProvinces(provinces);
        log.info("\u884c\u653f\u533a\u57df\u67e5\u8be2\u53c2\u6570\uff1a{}", JSON.toJSON((Object)req));
        RestResponse resp = this.areaExtQueryApiProxy.matchByNameOrAlias(req);
        log.info("\u884c\u653f\u533a\u57df\u67e5\u8be2\u7ed3\u679c\uff1a{}", JSON.toJSON((Object)resp));
        AreaMatchRespDto areaMatch = (AreaMatchRespDto)RestResponseHelper.extractData((RestResponse)resp);
        areaMatch.process();
        return areaMatch;
    }

    public void callBackImportFileOperationCommonAsync(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto, Object object) {
        List passList = (List)object;
        if (CollectionUtil.isEmpty((Collection)passList)) {
            respDto.setStatus(FileOperationStatusEnum.IMPORT_ERROR.getCode());
            return;
        }
        log.info("\u5206\u7ec4\u8bb0\u8d26\u914d\u7f6e\u5bfc\u5165:{}", (Object)JSON.toJSONString((Object)passList));
        List configs = passList.stream().map(k -> {
            GroupKeepAccountsConfigDto dto = new GroupKeepAccountsConfigDto();
            dto.setProvinceCode(k.getProvinceCode());
            dto.setProvinceName(k.getProvinceName());
            dto.setCityCode(k.getCityCode());
            dto.setCityName(k.getCityName());
            dto.setSaleAreaId(k.getSaleAreaId());
            dto.setSaleAreaCode(k.getSaleAreaCode());
            dto.setSaleAreaName(k.getSaleAreaName());
            dto.setSaleCompanyId(k.getSaleCompanyId());
            dto.setSaleCompanyCode(k.getSaleCompanyCode());
            dto.setSaleCompanyName(k.getSaleCompanyName());
            dto.setU9SaleAreaCode(k.getU9SaleAreaCode());
            log.info("\u5206\u7ec4\u8bb0\u8d26\u914d\u7f6e\u5bfc\u5165DTO:{}", (Object)JSON.toJSONString((Object)dto));
            return dto;
        }).collect(Collectors.toList());
        GroupKeepReplaceAllReqDto reqDto = new GroupKeepReplaceAllReqDto();
        reqDto.setConfigs(configs);
        try {
            RestResponse resp = this.groupKeepAccountsConfigApiProxy.replaceAll(reqDto);
            GroupKeepReplaceAllRespDto resultList = (GroupKeepReplaceAllRespDto)RestResponseHelper.extractData((RestResponse)resp);
            List resultConfigs = resultList.getConfigs();
            boolean allSuccess = true;
            for (int i = 0; i < passList.size(); ++i) {
                GroupKeepAccountsConfigImportDto pass = (GroupKeepAccountsConfigImportDto)passList.get(i);
                GroupKeepAccountsReplaceRespDto config = (GroupKeepAccountsReplaceRespDto)resultConfigs.get(i);
                if (config.getErrors() == null || config.getErrors().isEmpty()) continue;
                pass.appendErrorMsg(String.join((CharSequence)";", config.getErrors()));
                respDto.setStatus(FileOperationStatusEnum.IMPORT_ERROR.getCode());
                allSuccess = false;
            }
            if (allSuccess) {
                respDto.setStatus(FileOperationStatusEnum.IMPORT_SUCCESS.getCode());
            } else {
                respDto.setStatus(FileOperationStatusEnum.IMPORT_ERROR.getCode());
            }
        }
        catch (Exception e) {
            respDto.setStatus(FileOperationStatusEnum.IMPORT_ERROR.getCode());
            respDto.setErrorMsg(e.getMessage());
            throw new RuntimeException(e);
        }
    }
}

