/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.mgmt.service.impl;

import cn.afterturn.easypoi.excel.entity.result.ExcelImportResult;
import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.yunxi.dg.base.center.inventory.dto.inspection.InspectionRecordDto;
import com.yunxi.dg.base.center.inventory.proxy.inspection.IDgInspectionRecordApiProxy;
import com.yunxi.dg.base.center.report.dto.inventory.DgInspectionPassDto;
import com.yunxi.dg.base.center.report.dto.inventory.DgInspectionPassPageReqDto;
import com.yunxi.dg.base.center.report.proxy.inventory.IDgInspectionPassQueryApiProxy;
import com.yunxi.dg.base.ocs.mgmt.application.dto.ImportInspectionRecordModeDto;
import com.yunxi.dg.base.ocs.mgmt.application.dto.enums.FileModeTypeEnum;
import com.yunxi.dg.base.ocs.mgmt.application.dto.enums.FileOperationStatusEnum;
import com.yunxi.dg.base.poi.dto.ImportBaseModeDto;
import com.yunxi.dg.base.poi.dto.ImportFileOperationCommonReqDto;
import com.yunxi.dg.base.poi.dto.ImportFileOperationCommonRespDto;
import com.yunxi.dg.base.poi.service.AbstractBaseFileOperationCommonService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="AbstractBaseFileOperationCommonService_inspection_result_import")
public class InspectionRecordCommonServiceImpl
extends AbstractBaseFileOperationCommonService {
    private static final Logger log = LoggerFactory.getLogger(InspectionRecordCommonServiceImpl.class);
    @Resource
    private IDgInspectionPassQueryApiProxy inspectionPassQueryApiProxy;
    @Resource
    private IDgInspectionRecordApiProxy inspectionRecordApiProxy;

    public Object verifyImportFileOperationCommon(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto) {
        log.info("\u5f00\u59cb\u5bfc\u5165\u8d28\u68c0\u7ed3\u679c");
        if (CollectionUtil.isEmpty((Collection)result.getList())) {
            return new ArrayList();
        }
        if (result.getList().size() > 1000) {
            respDto.setErrorMsg("\u6279\u91cf\u5bfc\u5165\u4e0d\u652f\u6301\u8d85\u8fc71000\u884c");
            respDto.setStatus(FileOperationStatusEnum.IMPORT_ERROR.getCode());
            return new ArrayList();
        }
        ArrayList<ImportInspectionRecordModeDto> passList = new ArrayList<ImportInspectionRecordModeDto>();
        List resultList = BeanUtil.copyToList((Collection)result.getList(), ImportInspectionRecordModeDto.class);
        log.info("\u5f00\u59cb\u5bfc\u5165\u8d28\u68c0\u7ed3\u679c,\u5bfc\u5165\u8d28\u68c0\u7ed3\u679c\u6570\u636e:{}", (Object)JSON.toJSONString((Object)resultList));
        Map resultMap = resultList.stream().sorted(Comparator.comparing(ImportInspectionRecordModeDto::getInspectionResultTime, Comparator.nullsLast(Comparator.naturalOrder())).reversed()).collect(Collectors.toMap(o -> o.getSkuCode() + "_" + o.getBatch(), Function.identity(), (o1, o2) -> o1));
        List list = resultMap.values().stream().collect(Collectors.toList());
        List inspectionPassDtoList = Optional.ofNullable(this.inspectionPassQueryApiProxy.queryList(new DgInspectionPassPageReqDto()).getData()).orElse(new ArrayList());
        Map<String, List<String>> map = inspectionPassDtoList.stream().collect(Collectors.groupingBy(DgInspectionPassDto::getSkuCode, Collectors.mapping(DgInspectionPassDto::getBatch, Collectors.toList())));
        for (ImportInspectionRecordModeDto dto : list) {
            boolean isPass = this.paramVerify(dto, map);
            if (!isPass) {
                this.setErrorMsg(dto, String.format("\u7b2c%s\u884c\u6570\u636e\u6709\u8bef,%s", dto.getRowNum() + FileModeTypeEnum.getInstance((String)commonReqDto.getKey()).getHeadRows(), dto.getErrorMsg()));
                respDto.getErrorDetails().add(dto);
                continue;
            }
            passList.add(dto);
        }
        respDto.setDetails(passList);
        return passList;
    }

    public void callBackImportFileOperationCommonAsync(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto, Object object) {
        List passList = (List)object;
        if (CollectionUtil.isEmpty((Collection)passList)) {
            respDto.setStatus(FileOperationStatusEnum.IMPORT_ERROR.getCode());
            return;
        }
        respDto.setStatus(FileOperationStatusEnum.IMPORT_SUCCESS.getCode());
        log.info("\u5bfc\u5165\u8d28\u68c0\u7ed3\u679c\u6570\u636e:{}", (Object)JSON.toJSONString((Object)passList));
        List inspectionRecordDtos = BeanUtil.copyToList((Collection)passList, InspectionRecordDto.class);
        this.inspectionRecordApiProxy.save(inspectionRecordDtos);
    }

    private boolean paramVerify(ImportInspectionRecordModeDto dto, Map<String, List<String>> map) {
        if (StringUtils.isBlank((CharSequence)dto.getSkuCode())) {
            this.setErrorMsg(dto, "SKU\u7f16\u7801\u672a\u586b\u5199");
            return false;
        }
        if (!map.containsKey(dto.getSkuCode())) {
            this.setErrorMsg(dto, "\u8d28\u68c0\u8bb0\u5f55\u65e0\u6b64SKU\u7f16\u7801");
            return false;
        }
        if (StringUtils.isBlank((CharSequence)dto.getBatch())) {
            this.setErrorMsg(dto, "\u6279\u6b21\u53f7\u672a\u586b\u5199");
            return false;
        }
        List<String> batchList = map.get(dto.getSkuCode());
        if (!batchList.contains(dto.getBatch())) {
            this.setErrorMsg(dto, "\u8d28\u68c0\u8bb0\u5f55\u65e0\u6b64\u6279\u6b21");
            return false;
        }
        if (StringUtils.isBlank((CharSequence)dto.getInspectionResult())) {
            this.setErrorMsg(dto, "\u8d28\u68c0\u7ed3\u679c\u672a\u586b\u5199");
            return false;
        }
        if (!"\u5408\u683c".equals(dto.getInspectionResult()) && !"\u4e0d\u5408\u683c".equals(dto.getInspectionResult())) {
            this.setErrorMsg(dto, "\u8d28\u68c0\u7ed3\u679c\u586b\u5199\u6709\u8bef");
            return false;
        }
        if ("\u5408\u683c".equals(dto.getInspectionResult())) {
            dto.setInspectionResult("eligible");
        }
        if ("\u4e0d\u5408\u683c".equals(dto.getInspectionResult())) {
            dto.setInspectionResult("un_eligible");
        }
        if (dto.getInspectionReport() != null && !dto.getInspectionReport().startsWith("http")) {
            this.setErrorMsg(dto, "\u8be5\u7f51\u5740\u4e0d\u662fhttp\u5f00\u5934\uff0c\u65e0\u6cd5\u8bc6\u522b");
            return false;
        }
        if (dto.getInspectionResultTime() != null && !dto.getInspectionResultTime().matches("\\d{4}/\\d{2}/\\d{2}")) {
            this.setErrorMsg(dto, "\u751f\u4ea7\u65e5\u671f\u4e0d\u662fYYYY/MM/DD\u7684\u683c\u5f0f\uff0c\u8bf7\u8c03\u6574");
            return false;
        }
        return true;
    }

    private String setErrorMsg(ImportInspectionRecordModeDto dto, String errorMsg) {
        log.info("\u6821\u9a8c\u9519\u8bef\u4fe1\u606f{}", (Object)errorMsg);
        dto.setErrorMsg(errorMsg);
        return dto.getErrorMsg();
    }
}

