/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.mgmt.service.impl;

import cn.afterturn.easypoi.excel.entity.result.ExcelImportResult;
import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.dtyunxi.rest.RestResponse;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.yundt.boot.center.data.dto.response.AreaTreeRespExtDto;
import com.yunxi.dg.base.center.customer.dto.request.DgCsShipmentEnterprisePageReqDto;
import com.yunxi.dg.base.center.customer.dto.request.DgCustomerInfoQueryDto;
import com.yunxi.dg.base.center.customer.dto.response.DgCsShipmentEnterpriseRespDto;
import com.yunxi.dg.base.center.customer.dto.response.DgCustomerInfoRespDto;
import com.yunxi.dg.base.center.customer.proxy.query.IDgCsShipmentEnterpriseQueryApiProxy;
import com.yunxi.dg.base.center.customer.proxy.query.ITransactionCustomerQueryApiProxy;
import com.yunxi.dg.base.center.inventory.dto.entity.CsPhysicsWarehouseRespDto;
import com.yunxi.dg.base.center.inventory.dto.entity.PhysicsWarehouseQueryDto;
import com.yunxi.dg.base.center.inventory.proxy.warehouse.IPhysicsWarehouseApiProxy;
import com.yunxi.dg.base.center.logistics.dto.entity.LineDto;
import com.yunxi.dg.base.center.logistics.dto.entity.LinePageReqDto;
import com.yunxi.dg.base.center.logistics.proxy.entity.ILineApiProxy;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import com.yunxi.dg.base.mgmt.application.rpc.dto.request.AreaQueryExtReqDto;
import com.yunxi.dg.base.mgmt.application.rpc.proxy.query.IAreaExtQueryApiProxy;
import com.yunxi.dg.base.ocs.mgmt.application.constants.LogisticsTypeEnum;
import com.yunxi.dg.base.ocs.mgmt.application.dto.enums.FileModeTypeEnum;
import com.yunxi.dg.base.ocs.mgmt.application.dto.request.LineImportDto;
import com.yunxi.dg.base.poi.dto.ExportBaseModeDto;
import com.yunxi.dg.base.poi.dto.ExportQueryParamsReqDto;
import com.yunxi.dg.base.poi.dto.ImportBaseModeDto;
import com.yunxi.dg.base.poi.dto.ImportFileOperationCommonReqDto;
import com.yunxi.dg.base.poi.dto.ImportFileOperationCommonRespDto;
import com.yunxi.dg.base.poi.enums.FileOperationStatusEnum;
import com.yunxi.dg.base.poi.service.AbstractBaseFileOperationCommonService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="AbstractBaseFileOperationCommonService_line_import")
public class LineCommonServiceImpl
extends AbstractBaseFileOperationCommonService {
    private static final Logger log = LoggerFactory.getLogger(LineCommonServiceImpl.class);
    @Autowired
    private IAreaExtQueryApiProxy areaExtQueryApiProxy;
    @Resource
    private IDgCsShipmentEnterpriseQueryApiProxy dgCsShipmentEnterpriseQueryApiProxy;
    @Resource
    private ILineApiProxy lineApiProxy;
    @Resource
    private ITransactionCustomerQueryApiProxy transactionCustomerQueryApiProxy;
    @Resource
    private IPhysicsWarehouseApiProxy physicsWarehouseApiProxy;
    public static Map<String, String> areaNameDataMap = new ConcurrentHashMap<String, String>();
    public static final String LINE_TYPE_COMMON = "\u901a\u7528";
    public static final String LINE_TYPE_APPOINT = "\u6307\u5b9a";

    public void initAreaData() {
        AreaQueryExtReqDto reqDto = new AreaQueryExtReqDto();
        reqDto.setLevelId(Integer.valueOf(3));
        ArrayList<AreaTreeRespExtDto> areaTreeRespExtDtos = new ArrayList();
        try {
            areaTreeRespExtDtos = (List)RestResponseHelper.extractData((RestResponse)this.areaExtQueryApiProxy.queryByTree(reqDto));
        }
        catch (Exception e) {
            log.info("\u83b7\u53d6\u5b57\u5178\u6570\u636e\u5f02\u5e38");
        }
        if (CollectionUtil.isEmpty(areaTreeRespExtDtos)) {
            return;
        }
        this.getAreaNameMap(areaTreeRespExtDtos);
    }

    private void getAreaNameMap(List<AreaTreeRespExtDto> areaTreeRespExtDtos) {
        if (CollectionUtil.isEmpty(areaTreeRespExtDtos)) {
            return;
        }
        areaTreeRespExtDtos.forEach(dto -> {
            areaNameDataMap.put(dto.getName(), dto.getCode());
            this.getAreaNameMap(dto.getChildren());
        });
    }

    public Object verifyImportFileOperationCommon(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto) {
        List lineImportDtoList = Lists.newArrayList();
        if (CollectionUtil.isEmpty((Collection)result.getList())) {
            return lineImportDtoList;
        }
        log.info("\u8bfb\u53d6\u6570\u91cf===============>{}", (Object)result.getList().size());
        lineImportDtoList = BeanUtil.copyToList((Collection)result.getList(), LineImportDto.class);
        log.info("\u5bfc\u5165\u6570\u91cf===============>{}", (Object)lineImportDtoList.size());
        ArrayList passList = Lists.newArrayList();
        List logisticsProviderCodeList = lineImportDtoList.stream().map(LineImportDto::getLogisticsProviderCode).collect(Collectors.toList());
        DgCsShipmentEnterprisePageReqDto reqDto = new DgCsShipmentEnterprisePageReqDto();
        reqDto.setCodeList(logisticsProviderCodeList);
        PageInfo pageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.dgCsShipmentEnterpriseQueryApiProxy.page(reqDto));
        Map<Object, Object> shipmentEnterpriseRespDtoMap = Maps.newHashMap();
        if (Objects.nonNull(pageInfo) && CollectionUtil.isNotEmpty((Collection)pageInfo.getList())) {
            shipmentEnterpriseRespDtoMap = pageInfo.getList().stream().collect(Collectors.toMap(DgCsShipmentEnterpriseRespDto::getCode, Function.identity(), (v1, v2) -> v1));
        }
        Map<Object, Object> customerInfoRespDtoMap = Maps.newHashMap();
        List customerCodeList = lineImportDtoList.stream().filter(l -> StrUtil.isNotEmpty((CharSequence)l.getCustomerCode())).map(LineImportDto::getCustomerCode).collect(Collectors.toList());
        if (CollectionUtil.isNotEmpty(customerCodeList)) {
            DgCustomerInfoQueryDto customerInfoQueryDto = new DgCustomerInfoQueryDto();
            customerInfoQueryDto.setCodeList(customerCodeList);
            List dgCustomerInfoRespDtoList = (List)RestResponseHelper.extractData((RestResponse)this.transactionCustomerQueryApiProxy.queryList(customerInfoQueryDto));
            if (CollectionUtil.isNotEmpty((Collection)dgCustomerInfoRespDtoList)) {
                customerInfoRespDtoMap = dgCustomerInfoRespDtoList.stream().collect(Collectors.toMap(DgCustomerInfoRespDto::getCode, Function.identity(), (v1, v2) -> v2));
            }
        }
        List physicsWarehouseCodeList = lineImportDtoList.stream().map(LineImportDto::getPhysicsWarehouseCode).collect(Collectors.toList());
        PhysicsWarehouseQueryDto physicsWarehouseQueryDto = new PhysicsWarehouseQueryDto();
        physicsWarehouseQueryDto.setWarehouseCodeList(physicsWarehouseCodeList);
        List physicsWarehouseRespDtoList = (List)RestResponseHelper.extractData((RestResponse)this.physicsWarehouseApiProxy.queryByParam(physicsWarehouseQueryDto));
        Map<Object, Object> physicsWarehouseRespDtoMap = Maps.newHashMap();
        if (CollectionUtil.isNotEmpty((Collection)physicsWarehouseRespDtoList)) {
            physicsWarehouseRespDtoMap = physicsWarehouseRespDtoList.stream().collect(Collectors.toMap(CsPhysicsWarehouseRespDto::getWarehouseCode, Function.identity(), (v1, v2) -> v2));
        }
        List lineCodeList = lineImportDtoList.stream().map(LineImportDto::getLineCode).collect(Collectors.toList());
        LinePageReqDto linePageReqDto = new LinePageReqDto();
        linePageReqDto.setLineCodeList(lineCodeList);
        linePageReqDto.setPageSize(Integer.valueOf(lineImportDtoList.size()));
        PageInfo lineDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.lineApiProxy.page(linePageReqDto));
        Map<Object, Object> lineDtoMap = Maps.newHashMap();
        if (Objects.nonNull(lineDtoPageInfo) && CollectionUtil.isNotEmpty((Collection)lineDtoPageInfo.getList())) {
            lineDtoMap = lineDtoPageInfo.getList().stream().collect(Collectors.toMap(LineDto::getLineCode, Function.identity()));
        }
        for (LineImportDto dto : lineImportDtoList) {
            Boolean verify = this.verify(dto, shipmentEnterpriseRespDtoMap, customerInfoRespDtoMap, physicsWarehouseRespDtoMap, lineDtoMap);
            if (!verify.booleanValue()) {
                dto.setErrorMsg(String.format("\u7b2c%s\u884c\u6570\u636e\u6709\u8bef,%s", dto.getRowNum() + FileModeTypeEnum.getInstance((String)commonReqDto.getKey()).getHeadRows(), dto.getErrorMsg()));
                respDto.getErrorDetails().add(dto);
                continue;
            }
            passList.add(dto);
        }
        HashMap<String, Cloneable> dataMap = new HashMap<String, Cloneable>(passList.size());
        respDto.setDetails((List)passList);
        dataMap.put("passList", passList);
        dataMap.put("shipmentEnterpriseRespDtoMap", (Cloneable)((Object)shipmentEnterpriseRespDtoMap));
        dataMap.put("customerInfoRespDtoMap", (Cloneable)((Object)customerInfoRespDtoMap));
        dataMap.put("physicsWarehouseRespDtoMap", (Cloneable)((Object)physicsWarehouseRespDtoMap));
        return dataMap;
    }

    private Boolean verify(LineImportDto dto, Map<String, DgCsShipmentEnterpriseRespDto> shipmentEnterpriseRespDtoMap, Map<String, DgCustomerInfoRespDto> customerInfoRespDtoMap, Map<String, CsPhysicsWarehouseRespDto> physicsWarehouseRespDtoMap, Map<String, LineDto> lineDtoMap) {
        String county;
        String city;
        String province;
        if (StrUtil.isNotEmpty((CharSequence)dto.getProvince()) && StrUtil.isEmpty((CharSequence)(province = areaNameDataMap.get(dto.getProvince())))) {
            dto.setErrorMsg("\u7701\u4e0d\u5b58\u5728");
            return false;
        }
        if (StrUtil.isNotEmpty((CharSequence)dto.getCity()) && StrUtil.isEmpty((CharSequence)(city = areaNameDataMap.get(dto.getCity())))) {
            dto.setErrorMsg("\u5e02\u4e0d\u5b58\u5728");
            return false;
        }
        if (StrUtil.isNotEmpty((CharSequence)dto.getCounty()) && StrUtil.isEmpty((CharSequence)(county = areaNameDataMap.get(dto.getCounty())))) {
            dto.setErrorMsg("\u533a\u4e0d\u5b58\u5728");
            return false;
        }
        if (!shipmentEnterpriseRespDtoMap.containsKey(dto.getLogisticsProviderCode())) {
            dto.setErrorMsg("\u7269\u6d41\u5546\u7f16\u7801\u4e0d\u5b58\u5728");
            return false;
        }
        DgCsShipmentEnterpriseRespDto shipmentEnterpriseRespDto = shipmentEnterpriseRespDtoMap.get(dto.getLogisticsProviderCode());
        if (!dto.getLogisticsProviderName().equals(shipmentEnterpriseRespDto.getName())) {
            dto.setErrorMsg("\u7269\u6d41\u5546\u540d\u79f0\u4e0d\u5b58\u5728");
            return false;
        }
        if (!physicsWarehouseRespDtoMap.containsKey(dto.getPhysicsWarehouseCode())) {
            dto.setErrorMsg("\u53d1\u8d27\u5730\uff08\u7269\u7406\u4ed3\uff09\u4e0d\u5b58\u5728");
            return false;
        }
        if (lineDtoMap.containsKey(dto.getLineCode())) {
            dto.setErrorMsg("\u7ebf\u8def\u7f16\u7801\u5df2\u5b58\u5728");
            return false;
        }
        String code = LogisticsTypeEnum.getCodeByDesc((String)dto.getLogisticsTypeName());
        if (StrUtil.isEmpty((CharSequence)code)) {
            dto.setErrorMsg("\u627f\u8fd0\u65b9\u5f0f\u4e0d\u5b58\u5728");
            return false;
        }
        if (!LINE_TYPE_COMMON.equals(dto.getType())) {
            if (LINE_TYPE_APPOINT.equals(dto.getType())) {
                if (StrUtil.isEmpty((CharSequence)dto.getCustomerCode())) {
                    dto.setErrorMsg("\u5ba2\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
                    return false;
                }
                if (!customerInfoRespDtoMap.containsKey(dto.getCustomerCode())) {
                    dto.setErrorMsg("\u5ba2\u6237\u7f16\u7801\u4e0d\u5b58\u5728");
                    return false;
                }
                DgCustomerInfoRespDto dgCustomerInfoRespDto = customerInfoRespDtoMap.get(dto.getCustomerCode());
                if (!dgCustomerInfoRespDto.getName().equals(dto.getCustomerName())) {
                    dto.setErrorMsg("\u5ba2\u6237\u540d\u79f0\u4e0d\u6b63\u786e");
                    return false;
                }
            } else {
                dto.setErrorMsg("\u7ebf\u8def\u7c7b\u578b\u4e0d\u6b63\u786e");
                return false;
            }
        }
        return true;
    }

    public void callBackImportFileOperationCommonAsync(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto, Object object) {
        Map dataMap = (Map)object;
        List passList = (List)dataMap.get("passList");
        Map physicsWarehouseRespDtoMap = (Map)dataMap.get("physicsWarehouseRespDtoMap");
        if (CollectionUtil.isEmpty((Collection)passList)) {
            respDto.setStatus(FileOperationStatusEnum.IMPORT_ERROR.getCode());
            return;
        }
        respDto.setStatus(FileOperationStatusEnum.IMPORT_SUCCESS.getCode());
        if (CollectionUtil.isNotEmpty((Collection)passList) && !respDto.getErrorDetails().isEmpty()) {
            respDto.setStatus(FileOperationStatusEnum.IMPORT_PARTIAL_SUCCESS.getCode());
        }
        log.info("\u4e0a\u4e0b\u6587userCode:{}", (Object)commonReqDto.getCreatePerson());
        ArrayList lineDtoList = Lists.newArrayList();
        try {
            for (LineImportDto dto : passList) {
                String countyCode;
                String cityCode;
                String provinceCode;
                LineDto lineDto = new LineDto();
                BeanUtil.copyProperties((Object)dto, (Object)lineDto, (String[])new String[]{"type"});
                lineDto.setStatus(Integer.valueOf(1));
                lineDto.setType(this.transitionType(dto.getType()));
                if (StrUtil.isNotEmpty((CharSequence)dto.getProvince()) && StrUtil.isEmpty((CharSequence)(provinceCode = areaNameDataMap.get(dto.getProvince())))) {
                    lineDto.setProvinceCode(provinceCode);
                }
                if (StrUtil.isNotEmpty((CharSequence)dto.getCity()) && StrUtil.isEmpty((CharSequence)(cityCode = areaNameDataMap.get(dto.getCity())))) {
                    lineDto.setCityCode(cityCode);
                }
                if (StrUtil.isNotEmpty((CharSequence)dto.getCounty()) && StrUtil.isEmpty((CharSequence)(countyCode = areaNameDataMap.get(dto.getCounty())))) {
                    lineDto.setCountyCode(countyCode);
                }
                if (physicsWarehouseRespDtoMap.containsKey(dto.getPhysicsWarehouseCode())) {
                    lineDto.setPhysicsWarehouseCode(((CsPhysicsWarehouseRespDto)physicsWarehouseRespDtoMap.get(dto.getPhysicsWarehouseCode())).getWarehouseCode());
                    lineDto.setDeliverAddress(((CsPhysicsWarehouseRespDto)physicsWarehouseRespDtoMap.get(dto.getPhysicsWarehouseCode())).getWarehouseName());
                }
                StringBuffer sb = new StringBuffer();
                sb.append(lineDto.getProvince());
                if (StrUtil.isNotEmpty((CharSequence)lineDto.getCity())) {
                    sb.append(lineDto.getCity());
                }
                if (StrUtil.isNotEmpty((CharSequence)lineDto.getCounty())) {
                    sb.append(lineDto.getCounty());
                }
                String code = LogisticsTypeEnum.getCodeByDesc((String)dto.getLogisticsTypeName());
                lineDto.setLogisticsType(code);
                lineDto.setDetailAddr(sb.toString());
                lineDtoList.add(lineDto);
            }
        }
        catch (Exception e) {
            log.error("\u6784\u5efa\u6279\u91cf\u8fd0\u8f93\u8def\u7ebf\u4e3b\u6570\u636e\u8bf7\u6c42\u4f53\u9519\u8bef", (Throwable)e);
        }
        log.info("\u6279\u91cf\u65b0\u589e\u8fd0\u8f93\u4e3b\u8def\u7ebf,\u6570\u91cf\u4e3a:{}", (Object)lineDtoList.size());
        RestResponseHelper.checkOrThrow((RestResponse)this.lineApiProxy.importLine((List)lineDtoList));
    }

    public List<? extends ExportBaseModeDto> callBackScrollData(ExportQueryParamsReqDto exportQueryParamsReqDto) throws Exception {
        return super.callBackScrollData(exportQueryParamsReqDto);
    }

    private Integer transitionType(String type) {
        Integer lineType;
        switch (type) {
            case "\u901a\u7528": {
                lineType = 1;
                break;
            }
            default: {
                lineType = 2;
            }
        }
        return lineType;
    }
}

