/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.mgmt.service.impl;

import cn.afterturn.easypoi.excel.entity.result.ExcelImportResult;
import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.huieryun.log.RequestId;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.util.JacksonUtil;
import com.google.common.collect.Lists;
import com.wh.center.data.api.dto.response.AreaPathRespDto;
import com.yunxi.dg.base.center.customer.dto.request.DgEnterpriseQueryReqDto;
import com.yunxi.dg.base.center.customer.dto.response.DgEnterpriseRespDto;
import com.yunxi.dg.base.center.customer.proxy.query.IDgEnterpriseQueryApiProxy;
import com.yunxi.dg.base.center.trade.dto.entity.NationalSupplementAreaRuleDto;
import com.yunxi.dg.base.center.trade.dto.entity.NationalSupplementAreaRulePlatformCompanyDto;
import com.yunxi.dg.base.center.trade.proxy.entity.INationalSupplementAreaRuleApiProxy;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import com.yunxi.dg.base.mgmt.application.rpc.proxy.query.IAreaExtQueryApiProxy;
import com.yunxi.dg.base.ocs.mgmt.application.dto.enums.FileOperationStatusEnum;
import com.yunxi.dg.base.ocs.mgmt.application.dto.request.NationalSupplementAreaRuleImportDto;
import com.yunxi.dg.base.poi.dto.ImportBaseModeDto;
import com.yunxi.dg.base.poi.dto.ImportFileOperationCommonReqDto;
import com.yunxi.dg.base.poi.dto.ImportFileOperationCommonRespDto;
import com.yunxi.dg.base.poi.service.AbstractBaseFileOperationCommonService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.stereotype.Service;

@Service(value="AbstractBaseFileOperationCommonService_national_supplement_area_rule_import")
public class NationalSupplementAreaRuleCommonServiceImpl
extends AbstractBaseFileOperationCommonService {
    private static final Logger log = LoggerFactory.getLogger(NationalSupplementAreaRuleCommonServiceImpl.class);
    @Resource
    private IDgEnterpriseQueryApiProxy enterpriseQueryApiProxy;
    @Resource
    private INationalSupplementAreaRuleApiProxy nationalSupplementAreaRuleApiProxy;
    @Resource
    private IAreaExtQueryApiProxy areaExtQueryApiProxy;

    public Object verifyImportFileOperationCommon(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto) {
        if (StringUtils.isBlank((CharSequence)ServiceContext.getContext().getRequestId())) {
            String requestId = RequestId.createReqId();
            MDC.put((String)"yes.req.requestId", (String)requestId);
            ServiceContext.getContext().setAttachment("yes.req.requestId", requestId);
        }
        log.info("\u56fd\u8865\u533a\u57df\u89c4\u5219\u5bfc\u5165\u6570\u636e\uff1a{}", (Object)JSONObject.toJSONString(result));
        List resultList = BeanUtil.copyToList((Collection)result.getList(), NationalSupplementAreaRuleImportDto.class);
        if (CollectionUtil.isEmpty((Collection)resultList)) {
            respDto.setErrorMsg("\u5bfc\u5165\u5185\u5bb9\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5Excel\uff01");
            respDto.setStatus(FileOperationStatusEnum.IMPORT_ERROR.getCode());
            return new ArrayList();
        }
        ArrayList provinces = new ArrayList();
        HashMap<String, Integer> saleComapnyCountMap = new HashMap<String, Integer>();
        HashMap<String, Integer> platformComapnyCountMap = new HashMap<String, Integer>();
        HashSet<String> saleCompanyCodes = new HashSet<String>();
        HashSet<String> platformCompanyCodes = new HashSet<String>();
        HashSet<String> areaNames = new HashSet<String>();
        for (NationalSupplementAreaRuleImportDto dto : resultList) {
            if (StrUtil.isBlank((CharSequence)dto.getName())) {
                dto.appendErrorMsg("\u89c4\u5219\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StrUtil.isBlank((CharSequence)dto.getPlatformCompanyCodesStr())) {
                dto.appendErrorMsg("\u5e73\u53f0\u9500\u552e\u4e3b\u4f53\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            } else {
                dto.setPlatformCompanyCodes(Arrays.asList(dto.getPlatformCompanyCodesStr().split("[,\uff0c ]")).stream().map(String::trim).distinct().collect(Collectors.toList()));
                platformCompanyCodes.addAll(dto.getPlatformCompanyCodes());
                for (String platformCompanyCode : dto.getPlatformCompanyCodes()) {
                    Integer count = platformComapnyCountMap.computeIfAbsent(platformCompanyCode, k -> 0);
                    platformComapnyCountMap.put(platformCompanyCode, count + 1);
                }
            }
            if (StrUtil.isBlank((CharSequence)dto.getSaleCompanyCode())) {
                dto.appendErrorMsg("\u9500\u552e\u4e3b\u4f53\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            } else {
                saleCompanyCodes.add(dto.getSaleCompanyCode().trim());
                Integer count = saleComapnyCountMap.computeIfAbsent(dto.getSaleCompanyCode().trim(), k -> 0);
                saleComapnyCountMap.put(dto.getSaleCompanyCode().trim(), count + 1);
            }
            String startTimeStr = Optional.ofNullable(dto.getStartTimeStr()).map(String::trim).orElse("");
            if (StrUtil.isBlank((CharSequence)startTimeStr)) {
                dto.appendErrorMsg("\u6709\u6548\u671f\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
            } else if (!startTimeStr.matches("^\\d{4}-\\d{1,2}-\\d{1,2}$") && !startTimeStr.matches("^\\d{4}/\\d{1,2}/\\d{1,2}$")) {
                dto.appendErrorMsg("\u6709\u6548\u671f\u5f00\u59cb\u65f6\u95f4\u683c\u5f0f\u4e0d\u6b63\u786e");
            } else {
                dto.setStartTime(dto.toDate(startTimeStr));
            }
            String endTimeStr = Optional.ofNullable(dto.getEndTimeStr()).map(String::trim).orElse("");
            if (StrUtil.isBlank((CharSequence)endTimeStr)) {
                dto.appendErrorMsg("\u6709\u6548\u671f\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
            } else if (!endTimeStr.matches("^\\d{4}-\\d{1,2}-\\d{1,2}$") && !endTimeStr.matches("^\\d{4}/\\d{1,2}/\\d{1,2}$")) {
                dto.appendErrorMsg("\u6709\u6548\u671f\u7ed3\u675f\u65f6\u95f4\u683c\u5f0f\u4e0d\u6b63\u786e");
            } else {
                dto.setEndTime(dto.toDate(endTimeStr));
            }
            if (!StrUtil.isNotBlank((CharSequence)dto.getAreaListStr())) continue;
            dto.setAreaNames(Arrays.asList(dto.getAreaListStr().split("[,\uff0c ]")).stream().distinct().collect(Collectors.toList()));
            areaNames.addAll(dto.getAreaNames());
        }
        Map<String, DgEnterpriseRespDto> saleAreaMap = this.getSaleCompanyMap(saleCompanyCodes);
        Map<String, Set<AreaPathRespDto>> areaNameCodeMap = this.getAreaNameCodeMap(areaNames);
        HashMap map = new HashMap();
        Map<String, Long> dbSaleCompanyCountMap = this.getDbSaleCompanyCountMap(saleCompanyCodes);
        log.info("dbSaleCompanyCountMap={}", dbSaleCompanyCountMap);
        Map<String, Long> dbPlatformCompanyCountMap = this.getDbPlatformCompanyCountMap(platformCompanyCodes);
        log.info("dbPlatformCompanyCountMap={}", dbPlatformCompanyCountMap);
        for (NationalSupplementAreaRuleImportDto dto : resultList) {
            DgEnterpriseRespDto enterprise;
            List dbRepeatPlatformCompanyCodes;
            boolean isExcelPlatformCompanyCodeRepeat;
            if (saleComapnyCountMap.getOrDefault(dto.getSaleCompanyCode(), 0) > 1) {
                dto.appendErrorMsg("\u5f53\u524dExcel\u4e2d\u9500\u552e\u4e3b\u4f53\u7f16\u53f7\u91cd\u590d");
            }
            if (dbSaleCompanyCountMap.getOrDefault(dto.getSaleCompanyCode(), 0L) > 0L) {
                dto.appendErrorMsg("\u5df2\u5b58\u5728\u9500\u552e\u4e3b\u4f53\u7f16\u53f7[" + dto.getSaleCompanyCode() + "]\u7684\u8bb0\u5f55");
            }
            if (isExcelPlatformCompanyCodeRepeat = dto.getPlatformCompanyCodes().stream().anyMatch(k -> platformComapnyCountMap.getOrDefault(k, 0) > 1)) {
                dto.appendErrorMsg("\u5f53\u524dExcel\u4e2d\u5e73\u53f0\u4e3b\u4f53\u7f16\u53f7\u91cd\u590d");
            }
            if (!(dbRepeatPlatformCompanyCodes = dto.getPlatformCompanyCodes().stream().filter(k -> dbPlatformCompanyCountMap.getOrDefault(k, 0L) > 0L).collect(Collectors.toList())).isEmpty()) {
                dto.appendErrorMsg("\u5df2\u5b58\u5728\u5e73\u53f0\u4e3b\u4f53\u7f16\u53f7" + dbRepeatPlatformCompanyCodes + "\u7684\u8bb0\u5f55");
            }
            if ((enterprise = saleAreaMap.get(dto.getSaleCompanyCode())) == null) {
                dto.appendErrorMsg("\u9500\u552e\u4e3b\u4f53\u7f16\u53f7\u4e0d\u5b58\u5728");
            } else {
                dto.setSaleCompanyName(enterprise.getName());
            }
            if (CollectionUtil.isNotEmpty((Collection)dto.getAreaNames())) {
                ArrayList<String> notExistsAreaNames = new ArrayList<String>();
                ArrayList<String> duplicatesAreaNames = new ArrayList<String>();
                HashMap<String, String> areaNamePathMap = new HashMap<String, String>();
                for (String areaName2 : dto.getAreaNames()) {
                    Set areas = areaNameCodeMap.getOrDefault(areaName2, Collections.emptySet());
                    if (areas.isEmpty()) {
                        notExistsAreaNames.add(areaName2);
                        continue;
                    }
                    if (areas.size() > 1) {
                        duplicatesAreaNames.add(areaName2);
                        continue;
                    }
                    List pathCodes = ((AreaPathRespDto)areas.iterator().next()).getPathCodes();
                    areaNamePathMap.put(areaName2, String.join((CharSequence)"/", pathCodes));
                }
                if (!notExistsAreaNames.isEmpty()) {
                    dto.appendErrorMsg("\u533a\u57df\u4e0d\u5b58\u5728\uff1a" + notExistsAreaNames);
                }
                if (!duplicatesAreaNames.isEmpty()) {
                    dto.appendErrorMsg("\u533a\u57df\u540d\u79f0\u5b58\u5728\u591a\u4e2a\u7f16\u7801\uff0c\u8bf7\u786e\u8ba4\uff1a" + duplicatesAreaNames);
                }
                HashSet conflictAreaNames = new HashSet();
                areaNamePathMap.forEach((areaName, path) -> {
                    String conflictAreaName = this.isConflictAreaName((String)areaName, (Map<String, String>)areaNamePathMap);
                    if (StrUtil.isNotBlank((CharSequence)conflictAreaName)) {
                        conflictAreaNames.add(conflictAreaName);
                    } else {
                        Set areas = areaNameCodeMap.getOrDefault(areaName, Collections.emptySet());
                        dto.getAreaCodes().add(((AreaPathRespDto)areas.iterator().next()).getCode());
                    }
                });
                if (!conflictAreaNames.isEmpty()) {
                    dto.appendErrorMsg("\u533a\u57df\u5b58\u5728\u4e0a\u4e0b\u7ea7\u51b2\u7a81\uff1a" + conflictAreaNames);
                }
            }
            log.info("\u6821\u9a8cDTO\u5b8c\u6210\uff1a{}", (Object)JacksonUtil.toJson((Object)dto));
        }
        ArrayList passList = resultList.stream().filter(p -> StrUtil.isBlank((CharSequence)p.getErrorMsg())).collect(Collectors.toList());
        log.info("\u56fd\u8865\u533a\u57df\u89c4\u5219\u5bfc\u5165: resultList.size={}, passList.size={}", (Object)resultList.size(), (Object)passList.size());
        boolean isAllSuccess = resultList.size() != passList.size();
        resultList.removeAll(passList);
        respDto.getErrorDetails().addAll(resultList);
        return isAllSuccess ? new ArrayList() : passList;
    }

    private String isConflictAreaName(String areaName, Map<String, String> areaNamePathMap) {
        String curPath = areaNamePathMap.get(areaName);
        ArrayList<String> conflictAreaNames = new ArrayList<String>();
        areaNamePathMap.forEach((k, v) -> {
            if (k.equals(areaName)) {
                return;
            }
            if (curPath.startsWith((String)v) || v.startsWith(curPath)) {
                conflictAreaNames.add((String)k);
            }
        });
        if (conflictAreaNames.isEmpty()) {
            return null;
        }
        conflictAreaNames.add(areaName);
        return conflictAreaNames.stream().sorted().collect(Collectors.joining("\u3001"));
    }

    private Map<String, Long> getDbPlatformCompanyCountMap(Set<String> platformCompanyCodes) {
        if (CollectionUtil.isEmpty(platformCompanyCodes)) {
            return Collections.emptyMap();
        }
        RestResponse resp = this.nationalSupplementAreaRuleApiProxy.queryByPlatformCompanyCodes(new ArrayList<String>(platformCompanyCodes));
        List rules = (List)RestResponseHelper.extractData((RestResponse)resp);
        if (CollectionUtil.isEmpty((Collection)rules)) {
            return Collections.emptyMap();
        }
        return rules.stream().flatMap(k -> k.getPlatformCompanies().stream()).collect(Collectors.groupingBy(k -> k.getCode(), Collectors.counting()));
    }

    private Map<String, Long> getDbSaleCompanyCountMap(Set<String> saleCompanyCodes) {
        if (CollectionUtil.isEmpty(saleCompanyCodes)) {
            return Collections.emptyMap();
        }
        RestResponse resp = this.nationalSupplementAreaRuleApiProxy.queryBySaleCompanyCodes(new ArrayList<String>(saleCompanyCodes));
        List rules = (List)RestResponseHelper.extractData((RestResponse)resp);
        if (CollectionUtil.isEmpty((Collection)rules)) {
            return Collections.emptyMap();
        }
        return rules.stream().collect(Collectors.groupingBy(k -> k.getSaleCompanyCode(), Collectors.counting()));
    }

    private Map<String, Set<AreaPathRespDto>> getAreaNameCodeMap(Set<String> areaNames) {
        if (areaNames.isEmpty()) {
            return Collections.emptyMap();
        }
        RestResponse resp = this.areaExtQueryApiProxy.queryAreaPathByNameOrAlias(areaNames);
        List areaList = (List)RestResponseHelper.extractData((RestResponse)resp);
        if (CollectionUtil.isEmpty((Collection)areaList)) {
            return Collections.emptyMap();
        }
        HashMap<String, Set<AreaPathRespDto>> map = new HashMap<String, Set<AreaPathRespDto>>();
        for (AreaPathRespDto dto : areaList) {
            Set g = map.computeIfAbsent(dto.getName(), k -> new HashSet());
            g.add(dto);
            if (!StrUtil.isNotBlank((CharSequence)dto.getAlias())) continue;
            Arrays.stream(dto.getAlias().split(",")).filter(k -> StrUtil.isNotBlank((CharSequence)k)).forEach(k -> {
                Set c = map.computeIfAbsent((String)k, l -> new HashSet());
                c.add(dto);
            });
        }
        return map;
    }

    private Map<String, DgEnterpriseRespDto> getSaleCompanyMap(Set<String> saleAreaCodes) {
        if (saleAreaCodes.isEmpty()) {
            return new HashMap<String, DgEnterpriseRespDto>();
        }
        DgEnterpriseQueryReqDto reqDto = new DgEnterpriseQueryReqDto();
        reqDto.setCodeList(new ArrayList<String>(saleAreaCodes));
        List enterpriseList = (List)RestResponseHelper.extractData((RestResponse)this.enterpriseQueryApiProxy.queryList(reqDto));
        return enterpriseList.stream().collect(Collectors.toMap(DgEnterpriseRespDto::getCode, Function.identity(), (a, b) -> b));
    }

    public void callBackImportFileOperationCommonAsync(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto, Object object) {
        List passList = (List)object;
        if (CollectionUtil.isEmpty((Collection)passList)) {
            respDto.setStatus(FileOperationStatusEnum.IMPORT_ERROR.getCode());
            return;
        }
        log.info("\u56fd\u8865\u533a\u57df\u89c4\u5219\u5bfc\u5165:{}", (Object)JSON.toJSONString((Object)passList));
        List rules = passList.stream().map(k -> {
            NationalSupplementAreaRuleDto dto = new NationalSupplementAreaRuleDto();
            dto.setName(k.getName());
            dto.setSaleCompanyCode(k.getSaleCompanyCode());
            dto.setSaleCompanyName(k.getSaleCompanyName());
            dto.setStartTime(k.getStartTime());
            dto.setEndTime(k.getEndTime());
            dto.setPlatformCompanies(k.getPlatformCompanyCodes().stream().map(v -> {
                NationalSupplementAreaRulePlatformCompanyDto platformCompany = new NationalSupplementAreaRulePlatformCompanyDto();
                platformCompany.setCode(v);
                return platformCompany;
            }).collect(Collectors.toList()));
            dto.setAreaLimit(Integer.valueOf(k.getAreaCodes().isEmpty() ? 1 : 2));
            dto.setAreaPathCodes(k.getAreaCodes().stream().map(v -> Lists.newArrayList((Object[])new String[]{v})).collect(Collectors.toList()));
            log.info("\u56fd\u8865\u533a\u57df\u89c4\u5219\u5bfc\u5165DTO:{}", (Object)JSON.toJSONString((Object)dto));
            return dto;
        }).collect(Collectors.toList());
        try {
            RestResponse resp = this.nationalSupplementAreaRuleApiProxy.insertBatch(rules);
            log.info("\u56fd\u8865\u533a\u57df\u89c4\u5219\u5bfc\u5165\u7ed3\u679c\uff1a{}", (Object)JSON.toJSONString((Object)resp));
            if (resp.isSuccess()) {
                respDto.setStatus(FileOperationStatusEnum.IMPORT_SUCCESS.getCode());
            } else {
                respDto.setStatus(FileOperationStatusEnum.IMPORT_ERROR.getCode());
            }
        }
        catch (Exception e) {
            respDto.setStatus(FileOperationStatusEnum.IMPORT_ERROR.getCode());
            respDto.setErrorMsg(e.getMessage());
            throw new RuntimeException(e);
        }
    }
}

