/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.mgmt.service.impl;

import cn.afterturn.easypoi.excel.entity.result.ExcelImportResult;
import cn.hutool.core.collection.CollectionUtil;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.mgmt.application.rpc.api.itembiz.IPropApi;
import com.yunxi.dg.base.mgmt.service.impl.UnitCommonServiceImpl;
import com.yunxi.dg.base.ocs.mgmt.application.dto.enums.FileModeTypeEnum;
import com.yunxi.dg.base.ocs.mgmt.application.dto.enums.FileOperationStatusEnum;
import com.yunxi.dg.base.ocs.mgmt.application.dto.proxy.item.PropGroupReqDto;
import com.yunxi.dg.base.ocs.mgmt.application.dto.proxy.item.PropNameReqDto;
import com.yunxi.dg.base.ocs.mgmt.application.dto.request.ImportPropGroupDto;
import com.yunxi.dg.base.poi.dto.ImportBaseModeDto;
import com.yunxi.dg.base.poi.dto.ImportFileOperationCommonReqDto;
import com.yunxi.dg.base.poi.dto.ImportFileOperationCommonRespDto;
import com.yunxi.dg.base.poi.service.AbstractBaseFileOperationCommonService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="AbstractBaseFileOperationCommonService_prop_group_import")
public class PropGroupCommonServiceImpl
extends AbstractBaseFileOperationCommonService {
    private static final Logger log = LoggerFactory.getLogger(PropGroupCommonServiceImpl.class);
    private Logger logger = LoggerFactory.getLogger(UnitCommonServiceImpl.class);
    @Resource
    private IPropApi iPropApi;

    public Object verifyImportFileOperationCommon(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto) {
        ArrayList list = new ArrayList();
        if (CollectionUtil.isEmpty((Collection)result.getList())) {
            return new ArrayList();
        }
        this.logger.info("\u8bfb\u53d6\u6570\u91cf===============>{}", (Object)result.getList().size());
        CubeBeanUtils.copyCollection(list, (Collection)result.getList(), ImportPropGroupDto.class);
        this.logger.info("\u5bfc\u5165\u6570\u91cf===============>{}", (Object)list.size());
        ArrayList<ImportPropGroupDto> passList = new ArrayList<ImportPropGroupDto>();
        ArrayList<String> uniqueKeyList = new ArrayList<String>();
        for (ImportPropGroupDto dto : list) {
            Boolean verify = this.propGroupVerify(dto, passList, uniqueKeyList);
            if (!verify.booleanValue()) {
                dto.setErrorMsg(String.format("\u7b2c%s\u884c\u6570\u636e\u6709\u8bef,%s", dto.getRowNum() + FileModeTypeEnum.getInstance((String)commonReqDto.getKey()).getHeadRows(), dto.getErrorMsg()));
                respDto.getErrorDetails().add(dto);
                continue;
            }
            passList.add(dto);
        }
        respDto.setDetails(passList);
        return passList;
    }

    public void callBackImportFileOperationCommonAsync(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto, Object object) {
        List passList = (List)object;
        if (CollectionUtil.isEmpty((Collection)passList)) {
            respDto.setStatus(FileOperationStatusEnum.IMPORT_ERROR.getCode());
            return;
        }
        respDto.setStatus(FileOperationStatusEnum.IMPORT_SUCCESS.getCode());
        if (CollectionUtil.isNotEmpty((Collection)passList) && !respDto.getErrorDetails().isEmpty()) {
            respDto.setStatus(FileOperationStatusEnum.IMPORT_PARTIAL_SUCCESS.getCode());
        }
        log.info("\u4e0a\u4e0b\u6587userCode:{}", (Object)commonReqDto.getCreatePerson());
        ArrayList propGroupReqDtoList = Lists.newArrayList();
        try {
            for (ImportPropGroupDto propGroupDto : passList) {
                PropGroupReqDto reqDto = new PropGroupReqDto();
                reqDto.setName(propGroupDto.getName());
                reqDto.setAlias(propGroupDto.getAlias());
                switch (propGroupDto.getEntityType()) {
                    case "\u5546\u54c1": {
                        reqDto.setEntityType("item_main");
                        break;
                    }
                    case "\u7ec4\u5408\u5546\u54c1": {
                        reqDto.setEntityType("item_bundle");
                        break;
                    }
                    case "\u7ec4\u88c5\u5546\u54c1": {
                        reqDto.setEntityType("item_pack");
                        break;
                    }
                    case "\u5ba2\u5546": {
                        reqDto.setEntityType("cust_main");
                    }
                }
                ArrayList<PropNameReqDto> nameReqDtos = new ArrayList<PropNameReqDto>();
                List<String> names = Arrays.asList(propGroupDto.getPropName().replace("\uff0c", ",").split(","));
                for (String name : names) {
                    PropNameReqDto nameReqDto = new PropNameReqDto();
                    nameReqDto.setName(name);
                    nameReqDto.setStatus(Integer.valueOf(Objects.equals(propGroupDto.getStatus(), "\u7981\u7528") ? 0 : 1));
                    nameReqDtos.add(nameReqDto);
                    reqDto.setPropNameReqDtos(nameReqDtos);
                }
                propGroupReqDtoList.add(reqDto);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        log.info("\u6279\u91cf\u4fdd\u5b58\u5355\u4f4d,\u6570\u91cf\u4e3a:{}", (Object)propGroupReqDtoList.size());
        this.iPropApi.batchAddPropGroup((List)propGroupReqDtoList);
    }

    private Boolean propGroupVerify(ImportPropGroupDto dto, List<ImportPropGroupDto> passList, List<String> uniqueKeyList) {
        if (StringUtils.isBlank((CharSequence)dto.getName())) {
            dto.setErrorMsg("\u5c5e\u6027\u7ec4\u540d\u79f0\u4e0d\u53ef\u4e3a\u7a7a");
            return false;
        }
        if (dto.getName().length() > 20) {
            dto.setErrorMsg("\u5c5e\u6027\u7ec4\u540d\u79f0\u4e0d\u53ef\u8d85\u8fc720\u4e2a\u5b57");
            return false;
        }
        if (uniqueKeyList.contains(dto.getUniqueKey())) {
            dto.setErrorMsg("\u540c\u4e00\u5b9e\u4f53\u4e0b\u5c5e\u6027\u7ec4\u540d\u79f0\u4e0d\u53ef\u91cd\u590d");
            return false;
        }
        uniqueKeyList.add(dto.getUniqueKey());
        if (StringUtils.isBlank((CharSequence)dto.getAlias())) {
            dto.setErrorMsg("\u5c5e\u6027\u7ec4\u522b\u540d\u4e0d\u53ef\u4e3a\u7a7a");
            return false;
        }
        if (dto.getAlias().length() > 6) {
            dto.setErrorMsg("\u5c5e\u6027\u7ec4\u522b\u540d\u4e0d\u53ef\u8d85\u8fc76\u4e2a\u5b57");
            return false;
        }
        if (StringUtils.isBlank((CharSequence)dto.getEntityType())) {
            dto.setErrorMsg("\u6240\u5c5e\u5b9e\u4f53\u4e0d\u53ef\u4e3a\u7a7a");
            return false;
        }
        if (!(dto.getEntityType().equals("\u5546\u54c1") || dto.getEntityType().equals("\u7ec4\u5408\u5546\u54c1") || dto.getEntityType().equals("\u7ec4\u88c5\u5546\u54c1") || dto.getEntityType().equals("\u5ba2\u5546"))) {
            dto.setErrorMsg("\u6240\u5c5e\u5b9e\u4f53\u586b\u5199\u9519\u8bef\uff0c\u8bf7\u6309\u7167\u8303\u4f8b\u7684\u6548\u679c\u4fee\u6b63");
            return false;
        }
        if (StringUtils.isBlank((CharSequence)dto.getStatus())) {
            dto.setStatus("\u542f\u7528");
        }
        if (!dto.getStatus().equals("\u542f\u7528") && !dto.getStatus().equals("\u7981\u7528")) {
            dto.setErrorMsg("\u72b6\u6001\u586b\u5199\u9519\u8bef\uff0c\u8bf7\u6309\u7167\u8303\u4f8b\u7684\u6548\u679c\u4fee\u6b63");
            return false;
        }
        if (dto.getRemark().length() > 200) {
            dto.setErrorMsg("\u5907\u6ce8\u4e0d\u53ef\u8d85\u8fc7200\u4e2a\u5b57");
            return false;
        }
        return true;
    }
}

