/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.mgmt.service.impl;

import cn.afterturn.easypoi.excel.entity.result.ExcelImportResult;
import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.rest.RestResponse;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.customer.dto.request.DgCsSupplierPageReqDto;
import com.yunxi.dg.base.center.customer.dto.request.DgEnterpriseQueryReqDto;
import com.yunxi.dg.base.center.customer.dto.response.DgCsSupplierRespDto;
import com.yunxi.dg.base.center.customer.dto.response.DgEnterpriseRespDto;
import com.yunxi.dg.base.center.customer.proxy.query.IDgCsSupplierQueryApiProxy;
import com.yunxi.dg.base.center.customer.proxy.query.IDgEnterpriseQueryApiProxy;
import com.yunxi.dg.base.center.report.dto.entity.EnterpriceCrossPurchaseRelationDto;
import com.yunxi.dg.base.center.report.dto.entity.EnterpriceCrossPurchaseRelationPurchaseListReqDto;
import com.yunxi.dg.base.center.report.dto.entity.EnterpriceCrossSupplierRelationDto;
import com.yunxi.dg.base.center.report.dto.entity.EnterpriceCrossSupplierRelationSupplierListReqDto;
import com.yunxi.dg.base.center.report.dto.entity.EnterpriceCrossTradeRelationDto;
import com.yunxi.dg.base.center.report.dto.entity.EnterpriceCrossTradeRelationPageReqDto;
import com.yunxi.dg.base.center.report.dto.entity.EnterpriceCrossTradeRelationRespDto;
import com.yunxi.dg.base.center.report.proxy.customer.IDgCustomerInfoQueryApiProxy;
import com.yunxi.dg.base.center.report.proxy.entity.IEnterpriceCrossPurchaseRelationApiProxy;
import com.yunxi.dg.base.center.report.proxy.entity.IEnterpriceCrossSupplierRelationApiProxy;
import com.yunxi.dg.base.center.report.proxy.entity.IEnterpriceCrossTradeRelationApiProxy;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import com.yunxi.dg.base.ocs.mgmt.application.dto.enums.FileModeTypeEnum;
import com.yunxi.dg.base.ocs.mgmt.application.dto.enums.FileOperationStatusEnum;
import com.yunxi.dg.base.ocs.mgmt.application.dto.request.EnterpriceCrossTradeRelationImportDto;
import com.yunxi.dg.base.ocs.mgmt.application.dto.response.EnterpriceCrossTradeRelationExportDto;
import com.yunxi.dg.base.poi.dto.ExportBaseModeDto;
import com.yunxi.dg.base.poi.dto.ExportQueryParamsReqDto;
import com.yunxi.dg.base.poi.dto.ImportBaseModeDto;
import com.yunxi.dg.base.poi.dto.ImportFileOperationCommonReqDto;
import com.yunxi.dg.base.poi.dto.ImportFileOperationCommonRespDto;
import com.yunxi.dg.base.poi.service.AbstractBaseFileOperationCommonService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="AbstractBaseFileOperationCommonService_enterprice_cross_trade_relation")
public class EnterpriceCrossTradeRelationCommonServiceImpl
extends AbstractBaseFileOperationCommonService {
    private static final Logger log = LoggerFactory.getLogger(EnterpriceCrossTradeRelationCommonServiceImpl.class);
    @Resource
    private IEnterpriceCrossTradeRelationApiProxy iEnterpriceCrossTradeRelationApiProxy;
    @Resource
    private IEnterpriceCrossPurchaseRelationApiProxy iEnterpriceCrossPurchaseRelationApiProxy;
    @Resource
    private IEnterpriceCrossSupplierRelationApiProxy iEnterpriceCrossSupplierRelationApiProxy;
    @Resource
    private IDgCsSupplierQueryApiProxy iDgCsSupplierQueryApiProxy;
    @Resource
    private IDgCustomerInfoQueryApiProxy iDgCustomerInfoQueryApiProxy;
    @Resource
    private IDgEnterpriseQueryApiProxy iDgEnterpriseQueryApiProxy;

    public Object verifyImportFileOperationCommon(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto) {
        if (CollectionUtil.isEmpty((Collection)result.getList())) {
            return new ArrayList();
        }
        List importDtoList = BeanUtil.copyToList((Collection)result.getList(), EnterpriceCrossTradeRelationImportDto.class);
        ArrayList<EnterpriceCrossTradeRelationImportDto> passList = new ArrayList<EnterpriceCrossTradeRelationImportDto>();
        ArrayList<String> uniqueList = new ArrayList<String>();
        ArrayList<String> dgCsSupplierPageReqDtoCodeList = new ArrayList<String>();
        ArrayList<String> dgEnterpriseQueryReqDtoCodeList = new ArrayList<String>();
        for (EnterpriceCrossTradeRelationImportDto importDto : importDtoList) {
            if (StrUtil.isNotBlank((CharSequence)importDto.getSupplierRelationCode())) {
                dgCsSupplierPageReqDtoCodeList.add(importDto.getSupplierRelationCode());
            }
            if (!StrUtil.isNotBlank((CharSequence)importDto.getPurchaseRelationCode())) continue;
            dgEnterpriseQueryReqDtoCodeList.add(importDto.getPurchaseRelationCode());
        }
        DgCsSupplierPageReqDto dgCsSupplierPageReqDto = new DgCsSupplierPageReqDto();
        if (CollectionUtil.isNotEmpty(dgCsSupplierPageReqDtoCodeList)) {
            dgCsSupplierPageReqDto.setCodeList(dgCsSupplierPageReqDtoCodeList);
        }
        dgCsSupplierPageReqDto.setPageSize(Integer.valueOf(999));
        List dgCsSupplierRespDtoList = ((PageInfo)RestResponseHelper.extractData((RestResponse)this.iDgCsSupplierQueryApiProxy.page(dgCsSupplierPageReqDto))).getList();
        HashMap<String, DgCsSupplierRespDto> dgCsSupplierRespDtoMap = new HashMap<String, DgCsSupplierRespDto>();
        for (DgCsSupplierRespDto dto : dgCsSupplierRespDtoList) {
            dgCsSupplierRespDtoMap.put(dto.getCode(), dto);
        }
        DgEnterpriseQueryReqDto dgEnterpriseQueryReqDto = new DgEnterpriseQueryReqDto();
        if (CollectionUtil.isNotEmpty(dgEnterpriseQueryReqDtoCodeList)) {
            dgEnterpriseQueryReqDto.setCodeList(dgEnterpriseQueryReqDtoCodeList);
        }
        List dgEnterpriseRespDtoList = (List)RestResponseHelper.extractData((RestResponse)this.iDgEnterpriseQueryApiProxy.queryList(dgEnterpriseQueryReqDto));
        HashMap<String, DgEnterpriseRespDto> dgEnterpriseRespDtoMap = new HashMap<String, DgEnterpriseRespDto>();
        for (DgEnterpriseRespDto dto : dgEnterpriseRespDtoList) {
            dgEnterpriseRespDtoMap.put(dto.getCode(), dto);
        }
        for (EnterpriceCrossTradeRelationImportDto importDto : importDtoList) {
            if (this.paramVerify(importDto, dgCsSupplierRespDtoMap, dgEnterpriseRespDtoMap)) {
                passList.add(importDto);
            } else {
                importDto.setErrorMsg(String.format("\u7b2c%s\u884c\u6570\u636e\u6709\u8bef,%s", importDto.getRowNum() + FileModeTypeEnum.getInstance((String)commonReqDto.getKey()).getHeadRows(), importDto.getErrorMsg()));
                respDto.getErrorDetails().add(importDto);
            }
            if (CollectionUtil.isNotEmpty(uniqueList)) {
                for (String unique : uniqueList) {
                    if (!unique.equals(this.combineUniqueProperty(importDto))) continue;
                    importDto.setErrorMsg(String.format("\u7b2c%s\u884c\u6570\u636e\u6709\u8bef,%s", importDto.getRowNum() + FileModeTypeEnum.getInstance((String)commonReqDto.getKey()).getHeadRows(), "\u6709\u91cd\u590d\u884c\uff0c\u8bf7\u6821\u9a8c\u4f9b\u5e94\u5546\u548c\u91c7\u8d2d\u65b9\u552f\u4e00\u6027"));
                    respDto.getErrorDetails().add(importDto);
                }
            }
            uniqueList.add(this.combineUniqueProperty(importDto));
        }
        respDto.setDetails(passList);
        log.info("\u901a\u8fc7\u7684\u6570\u636epassList:", (Object)JSON.toJSONString(passList));
        return passList;
    }

    public void callBackImportFileOperationCommonAsync(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto, Object object) {
        List passList = (List)object;
        log.info("\u6821\u9a8c\u901a\u8fc7\u7684\u6570\u636epassList:", (Object)JSON.toJSONString((Object)passList));
        if (CollectionUtil.isEmpty((Collection)passList)) {
            respDto.setStatus(FileOperationStatusEnum.IMPORT_ERROR.getCode());
            log.info("\u6253\u5370\u54cd\u5e94\u72b6\u6001\uff1a" + respDto.getStatus());
            return;
        }
        respDto.setStatus(FileOperationStatusEnum.IMPORT_SUCCESS.getCode());
        if (CollectionUtil.isNotEmpty((Collection)passList) && !respDto.getErrorDetails().isEmpty()) {
            log.info("\u8fdb\u5165\u4e86\u90e8\u5206\u6210\u529f\u7684\u903b\u8f91,passList:" + passList + ",errorDetails:" + respDto.getErrorDetails());
            respDto.setStatus(FileOperationStatusEnum.IMPORT_PARTIAL_SUCCESS.getCode());
        }
        log.info("\u6253\u5370\u54cd\u5e94\u72b6\u6001:" + respDto.getStatus());
        log.info("\u4e0a\u4e0b\u6587userCode:{}", (Object)commonReqDto.getCreatePerson());
        try {
            ArrayList<String> purchaseRelationCodeList = new ArrayList<String>();
            ArrayList<String> supplierRelationCodeList = new ArrayList<String>();
            for (EnterpriceCrossTradeRelationImportDto importDto : passList) {
                purchaseRelationCodeList.add(importDto.getPurchaseRelationCode());
                supplierRelationCodeList.add(importDto.getSupplierRelationCode());
            }
            log.info("\u91c7\u8d2d\u65b9\u7f16\u7801\u96c6\u5408:{}", (Object)JSON.toJSONString(purchaseRelationCodeList));
            log.info("\u4f9b\u5e94\u5546\u7f16\u7801\u96c6\u5408:{}", (Object)JSON.toJSONString(supplierRelationCodeList));
            EnterpriceCrossSupplierRelationSupplierListReqDto supplierListReqDto = new EnterpriceCrossSupplierRelationSupplierListReqDto();
            supplierListReqDto.setSupplierCodes(supplierRelationCodeList);
            List enterpriceCrossSupplierRelationDtos = (List)RestResponseHelper.extractData((RestResponse)this.iEnterpriceCrossSupplierRelationApiProxy.supplierList(supplierListReqDto));
            log.info("\u67e5\u8be2\u516c\u53f8\u95f4\u4f9b\u5e94\u5546\u5173\u7cfb\u5b9e\u4f53List\uff1a" + enterpriceCrossSupplierRelationDtos);
            EnterpriceCrossPurchaseRelationPurchaseListReqDto purchaseListReqDto = new EnterpriceCrossPurchaseRelationPurchaseListReqDto();
            purchaseListReqDto.setPurchaseEnterpriseCodes(purchaseRelationCodeList);
            List enterpriceCrossPurchaseRelationDtos = (List)RestResponseHelper.extractData((RestResponse)this.iEnterpriceCrossPurchaseRelationApiProxy.purchaseEnterpriseList(purchaseListReqDto));
            log.info("\u67e5\u8be2\u516c\u53f8\u95f4\u91c7\u8d2d\u65b9\u5173\u7cfb\u5b9e\u4f53List\uff1a" + enterpriceCrossPurchaseRelationDtos);
            for (EnterpriceCrossTradeRelationImportDto importDto : passList) {
                EnterpriceCrossTradeRelationDto reqDto = new EnterpriceCrossTradeRelationDto();
                BeanUtil.copyProperties((Object)importDto, (Object)reqDto, (String[])new String[0]);
                if (CollectionUtil.isNotEmpty((Collection)enterpriceCrossSupplierRelationDtos)) {
                    for (EnterpriceCrossSupplierRelationDto supplierRelationDto : enterpriceCrossSupplierRelationDtos) {
                        if (!importDto.getSupplierRelationCode().equals(supplierRelationDto.getSupplierCode())) continue;
                        reqDto.setSupplierRelationId(supplierRelationDto.getId());
                    }
                }
                if (CollectionUtil.isNotEmpty((Collection)enterpriceCrossPurchaseRelationDtos)) {
                    for (EnterpriceCrossPurchaseRelationDto purchaseRelationDto : enterpriceCrossPurchaseRelationDtos) {
                        if (!importDto.getPurchaseRelationCode().equals(purchaseRelationDto.getPurchaseEnterpriseCode())) continue;
                        reqDto.setPurchaseRelationId(purchaseRelationDto.getId());
                    }
                }
                log.info("\u65b0\u589e\u5b9e\u4f53reqDto\uff1a" + reqDto);
                this.iEnterpriceCrossTradeRelationApiProxy.insert(reqDto);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public List<? extends ExportBaseModeDto> callBackScrollData(ExportQueryParamsReqDto exportQueryParamsReqDto) throws Exception {
        String key = exportQueryParamsReqDto.getExportFileParams().getKey();
        String filter = exportQueryParamsReqDto.getFilter();
        EnterpriceCrossTradeRelationPageReqDto pageReqDto = new EnterpriceCrossTradeRelationPageReqDto();
        if (StrUtil.isNotBlank((CharSequence)filter)) {
            pageReqDto = (EnterpriceCrossTradeRelationPageReqDto)JSON.parseObject((String)filter, EnterpriceCrossTradeRelationPageReqDto.class);
        }
        if (FileModeTypeEnum.ENTERPRICE_CROSS_TRADE_RELATION.getKey().equals(key)) {
            PageInfo enterpriceCrossTradeRelationRespDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.iEnterpriceCrossTradeRelationApiProxy.page(pageReqDto));
            if (null == enterpriceCrossTradeRelationRespDtoPageInfo || CollectionUtil.isEmpty((Collection)enterpriceCrossTradeRelationRespDtoPageInfo.getList())) {
                return Collections.EMPTY_LIST;
            }
            List list = enterpriceCrossTradeRelationRespDtoPageInfo.getList().stream().map(i -> {
                EnterpriceCrossTradeRelationExportDto exportDto = new EnterpriceCrossTradeRelationExportDto();
                BeanUtil.copyProperties((Object)i, (Object)exportDto, (String[])new String[0]);
                exportDto.setCreateTime(DateUtil.formatDateTime((Date)i.getCreateTime()));
                exportDto.setUpdateTime(DateUtil.formatDateTime((Date)i.getUpdateTime()));
                return exportDto;
            }).collect(Collectors.toList());
            return list;
        }
        return Collections.EMPTY_LIST;
    }

    private boolean paramVerify(EnterpriceCrossTradeRelationImportDto importDto, Map<String, DgCsSupplierRespDto> dgCsSupplierRespDtoMap, Map<String, DgEnterpriseRespDto> dgEnterpriseRespDtoMap) {
        if (StrUtil.isBlank((CharSequence)importDto.getSupplierRelationCode())) {
            importDto.setErrorMsg("\u4f9b\u5e94\u5546\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            return false;
        }
        DgCsSupplierRespDto dgCsSupplierRespDto = dgCsSupplierRespDtoMap.get(importDto.getSupplierRelationCode());
        if (ObjectUtil.isNull((Object)dgCsSupplierRespDto)) {
            if (StrUtil.isBlank((CharSequence)importDto.getSupplierRelationName())) {
                importDto.setErrorMsg("\u4f9b\u5e94\u5546\u4e0d\u5b58\u5728");
                return false;
            }
            DgCsSupplierPageReqDto reqDto = new DgCsSupplierPageReqDto();
            reqDto.setName(importDto.getSupplierRelationName());
            PageInfo dgCsSupplierRespDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.iDgCsSupplierQueryApiProxy.page(reqDto));
            if (ObjectUtil.isNull((Object)dgCsSupplierRespDtoPageInfo)) {
                importDto.setErrorMsg("\u4f9b\u5e94\u5546\u4e0d\u5b58\u5728");
                return false;
            }
            if (CollectionUtil.isEmpty((Collection)dgCsSupplierRespDtoPageInfo.getList())) {
                importDto.setErrorMsg("\u4f9b\u5e94\u5546\u4e0d\u5b58\u5728");
                return false;
            }
        }
        if (StrUtil.isBlank((CharSequence)importDto.getPurchaseRelationCode())) {
            importDto.setErrorMsg("\u91c7\u8d2d\u65b9\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            return false;
        }
        DgEnterpriseRespDto dgEnterpriseRespDto = dgEnterpriseRespDtoMap.get(importDto.getPurchaseRelationCode());
        if (ObjectUtil.isNull((Object)dgEnterpriseRespDto)) {
            if (StrUtil.isBlank((CharSequence)importDto.getPurchaseRelationName())) {
                importDto.setErrorMsg("\u9500\u552e\u516c\u53f8\u4e0d\u5b58\u5728");
                return false;
            }
            DgEnterpriseQueryReqDto reqDto2 = new DgEnterpriseQueryReqDto();
            reqDto2.setName(importDto.getPurchaseRelationName());
            PageInfo dgEnterpriseRespDtoPageInfo2 = (PageInfo)RestResponseHelper.extractData((RestResponse)this.iDgEnterpriseQueryApiProxy.queryPage(reqDto2));
            if (ObjectUtil.isNull((Object)dgEnterpriseRespDtoPageInfo2)) {
                importDto.setErrorMsg("\u9500\u552e\u516c\u53f8\u4e0d\u5b58\u5728");
                return false;
            }
            if (CollectionUtil.isEmpty((Collection)dgEnterpriseRespDtoPageInfo2.getList())) {
                importDto.setErrorMsg("\u9500\u552e\u516c\u53f8\u4e0d\u5b58\u5728");
                return false;
            }
        }
        String uniqueProperty = this.combineUniqueProperty(importDto);
        EnterpriceCrossTradeRelationPageReqDto pageReqDto = new EnterpriceCrossTradeRelationPageReqDto();
        BeanUtil.copyProperties((Object)importDto, (Object)pageReqDto, (String[])new String[0]);
        PageInfo enterpriceCrossTradeRelationRespDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.iEnterpriceCrossTradeRelationApiProxy.page(pageReqDto));
        if (ObjectUtil.isNotNull((Object)enterpriceCrossTradeRelationRespDtoPageInfo) && CollectionUtil.isNotEmpty((Collection)enterpriceCrossTradeRelationRespDtoPageInfo.getList())) {
            for (EnterpriceCrossTradeRelationRespDto respDto : enterpriceCrossTradeRelationRespDtoPageInfo.getList()) {
                String supplierCode = respDto.getSupplierCode();
                String purchaseEnterpriseCode = respDto.getPurchaseEnterpriseCode();
                StringBuffer s1 = new StringBuffer();
                s1.append(supplierCode);
                s1.append(purchaseEnterpriseCode);
                String supplierName = respDto.getSupplierName();
                String purchaseEnterpriseName = respDto.getPurchaseEnterpriseName();
                StringBuffer s2 = new StringBuffer();
                s2.append(supplierName);
                s2.append(purchaseEnterpriseName);
                if (!uniqueProperty.equals(s1.toString()) && !uniqueProperty.equals(s2.toString())) continue;
                importDto.setErrorMsg("\u6709\u91cd\u590d\u884c\uff0c\u8bf7\u6821\u9a8c\u4f9b\u5e94\u5546\u548c\u91c7\u8d2d\u65b9\u552f\u4e00\u6027");
                return false;
            }
        }
        return true;
    }

    private String combineUniqueProperty(EnterpriceCrossTradeRelationImportDto importDto) {
        if (StrUtil.isNotBlank((CharSequence)importDto.getSupplierRelationCode()) && StrUtil.isNotBlank((CharSequence)importDto.getPurchaseRelationCode())) {
            String supplierRelationId = importDto.getSupplierRelationCode();
            String purchaseRelationId = importDto.getPurchaseRelationCode();
            StringBuffer s = new StringBuffer();
            s.append(supplierRelationId);
            s.append(purchaseRelationId);
            return s.toString();
        }
        if (StrUtil.isNotBlank((CharSequence)importDto.getSupplierRelationName()) && StrUtil.isNotBlank((CharSequence)importDto.getPurchaseRelationName())) {
            String supplierRelationName = importDto.getSupplierRelationName();
            String purchaseRelationName = importDto.getPurchaseRelationName();
            StringBuffer s = new StringBuffer();
            s.append(supplierRelationName);
            s.append(purchaseRelationName);
            return s.toString();
        }
        return null;
    }
}

