/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.mgmt.service.impl;

import cn.afterturn.easypoi.excel.entity.result.ExcelImportResult;
import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.yunxi.dg.base.center.finance.dto.entity.KeepFinancialRemarksDto;
import com.yunxi.dg.base.center.finance.dto.entity.PerformOrderInfoDto;
import com.yunxi.dg.base.center.finance.dto.response.KeepAccountsDetailRespDto;
import com.yunxi.dg.base.center.finance.proxy.entity.IKeepAccountsDetailApiProxy;
import com.yunxi.dg.base.center.finance.proxy.entity.IPerformOrderInfoApiProxy;
import com.yunxi.dg.base.ocs.mgmt.application.dto.enums.FileOperationStatusEnum;
import com.yunxi.dg.base.ocs.mgmt.application.dto.finance.ImportKeepFinanceRemarkDto;
import com.yunxi.dg.base.ocs.mgmt.application.dto.finance.ImportKeepFinanceRemarkErrorDto;
import com.yunxi.dg.base.poi.dto.ImportBaseModeDto;
import com.yunxi.dg.base.poi.dto.ImportFileOperationCommonReqDto;
import com.yunxi.dg.base.poi.dto.ImportFileOperationCommonRespDto;
import com.yunxi.dg.base.poi.service.AbstractBaseFileOperationCommonService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service(value="AbstractBaseFileOperationCommonService_KEEP_FINANCE_REMARK")
public class FinancialManagementBookkeepingManagementBookkeepingDetaiFinanceRemarklServiceServiceImpl
extends AbstractBaseFileOperationCommonService {
    private static final Logger logger = LoggerFactory.getLogger(FinancialManagementBookkeepingManagementBookkeepingDetaiFinanceRemarklServiceServiceImpl.class);
    @Resource
    private IKeepAccountsDetailApiProxy keepAccountsDetailApiProxy;
    @Resource
    private IPerformOrderInfoApiProxy performOrderInfoApiQueryProxy;
    public static final String SALE_ORDER_NO_PREFIX = "DD";
    public static final String AFTER_SALE_ORDER_NO_PREFIX = "AF";

    public Object verifyImportFileOperationCommon(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto) {
        logger.info("\u5bfc\u5165\u8d22\u52a1\u5907\u6ce8\u4fe1\u606flist====>>>{}", (Object)result.getList().size());
        if (CollectionUtils.isEmpty((Collection)result.getList())) {
            return new ArrayList();
        }
        if (result.getList().size() > 1000) {
            respDto.setErrorMsg("\u6279\u91cf\u5bfc\u5165\u4e0d\u652f\u6301\u8d85\u8fc71000\u884c");
            respDto.setStatus(com.yunxi.dg.base.poi.enums.FileOperationStatusEnum.IMPORT_ERROR.getCode());
            return new ArrayList();
        }
        ArrayList list = new ArrayList();
        CubeBeanUtils.copyCollection(list, (Collection)result.getList(), ImportKeepFinanceRemarkDto.class);
        ArrayList passList = new ArrayList();
        HashSet platformOrderNoSet = new HashSet();
        HashSet repeatPlatformOrderNoSet = new HashSet();
        list.forEach(info -> {
            if (StringUtils.isNotBlank((CharSequence)info.getOrderNo())) {
                if (platformOrderNoSet.contains(info.getOrderNo())) {
                    repeatPlatformOrderNoSet.add(info.getOrderNo());
                } else {
                    platformOrderNoSet.add(info.getOrderNo());
                }
            }
        });
        List saleOrderNoPrefix = list.stream().filter(x -> null != x.getOrderNo() && x.getOrderNo().startsWith(SALE_ORDER_NO_PREFIX)).map(ImportKeepFinanceRemarkDto::getOrderNo).collect(Collectors.toList());
        List afterSaleOrderNoPrefix = list.stream().filter(x -> null != x.getOrderNo() && x.getOrderNo().startsWith(AFTER_SALE_ORDER_NO_PREFIX)).map(ImportKeepFinanceRemarkDto::getOrderNo).collect(Collectors.toList());
        List notAfterAndSaleOrderNoPrefix = list.stream().filter(x -> null != x.getOrderNo() && !x.getOrderNo().startsWith(SALE_ORDER_NO_PREFIX) && !x.getOrderNo().startsWith(AFTER_SALE_ORDER_NO_PREFIX)).map(ImportKeepFinanceRemarkDto::getOrderNo).collect(Collectors.toList());
        List performOrderInfoDtoList = (List)RestResponseHelper.extractData((RestResponse)this.performOrderInfoApiQueryProxy.queryByPlatformOrderNoList(new ArrayList(platformOrderNoSet)));
        Map map = ((List)Optional.ofNullable(performOrderInfoDtoList).orElse(new ArrayList())).stream().collect(Collectors.toMap(PerformOrderInfoDto::getPlatformOrderNo, Function.identity(), (v1, v2) -> v2));
        list.forEach(v -> {
            this.importApplySpaceHandle((ImportKeepFinanceRemarkDto)v);
            ImportKeepFinanceRemarkErrorDto msgDto = new ImportKeepFinanceRemarkErrorDto();
            ImportKeepFinanceRemarkDto successDto = new ImportKeepFinanceRemarkDto();
            ArrayList<String> errorList = new ArrayList<String>();
            if (StringUtils.isBlank((CharSequence)v.getOrderNo())) {
                errorList.add("\u672a\u5339\u914d\u5230\u5e73\u53f0\u5355\u53f7\u6216\u4e1a\u52a1\u5355\u53f7");
            } else if (!map.containsKey(v.getOrderNo())) {
                errorList.add("\u5e73\u53f0\u5355\u53f7\u6216\u4e1a\u52a1\u5355\u53f7\u4e0d\u5b58\u5728");
            }
            if (repeatPlatformOrderNoSet.contains(v.getOrderNo())) {
                errorList.add("\u5bfc\u5165\u7684\u5e73\u53f0\u5355\u53f7\u6216\u4e1a\u52a1\u5355\u53f7\u91cd\u590d");
            }
            if (StringUtils.isBlank((CharSequence)v.getFinancialRemark())) {
                errorList.add("\u8d22\u52a1\u5907\u6ce8\u4e3a\u7a7a");
            } else if (v.getFinancialRemark().length() > 500) {
                errorList.add("\u8d22\u52a1\u5907\u6ce8\u8d85\u8fc7500\u5b57\u7b26");
            }
            if (CollectionUtils.isNotEmpty((Collection)notAfterAndSaleOrderNoPrefix) && (CollectionUtils.isNotEmpty((Collection)saleOrderNoPrefix) || CollectionUtils.isNotEmpty((Collection)afterSaleOrderNoPrefix))) {
                errorList.add("\u540c\u65f6\u5b58\u5728\u5e73\u53f0\u5355\u53f7\u548c\u4e1a\u52a1\u5355\u53f7");
            }
            if (CollectionUtils.isNotEmpty(errorList)) {
                BeanUtils.copyProperties((Object)v, (Object)msgDto);
                msgDto.setErrorMsg(String.join((CharSequence)",", errorList));
                respDto.getErrorDetails().add(msgDto);
            } else {
                CubeBeanUtils.copyProperties((Object)successDto, (Object)v, (String[])new String[0]);
                passList.add(successDto);
            }
        });
        logger.info("\u8d22\u52a1\u5907\u6ce8\u6821\u9a8c\u901a\u8fc7\u6570\u91cf====>>>{}", (Object)passList.size());
        return passList;
    }

    public void callBackImportFileOperationCommonAsync(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto, Object object) {
        List successList = (List)object;
        if (CollectionUtil.isEmpty((Collection)successList)) {
            respDto.setStatus(com.yunxi.dg.base.poi.enums.FileOperationStatusEnum.IMPORT_ERROR.getCode());
            return;
        }
        if (CollectionUtils.isNotEmpty((Collection)successList) && CollectionUtils.isNotEmpty((Collection)respDto.getErrorDetails())) {
            respDto.setStatus(com.yunxi.dg.base.poi.enums.FileOperationStatusEnum.IMPORT_PARTIAL_SUCCESS.getCode());
        } else {
            respDto.setStatus(com.yunxi.dg.base.poi.enums.FileOperationStatusEnum.IMPORT_SUCCESS.getCode());
        }
        ArrayList remarksDtos = Lists.newArrayList();
        List orderNoLists = successList.stream().map(ImportKeepFinanceRemarkDto::getOrderNo).distinct().collect(Collectors.toList());
        List saleOrderDetailRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.keepAccountsDetailApiProxy.queryKeepDetaiByOrderNolList(orderNoLists));
        Map<Object, Object> saleOrderDetailRespDtosMap = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty((Collection)saleOrderDetailRespDtos)) {
            Map<Object, Object> finalSaleOrderDetailRespDtosMap = saleOrderDetailRespDtosMap = saleOrderDetailRespDtos.stream().collect(Collectors.groupingBy(KeepAccountsDetailRespDto::getOrderNo));
            successList.forEach(v -> {
                if (finalSaleOrderDetailRespDtosMap.containsKey(v.getOrderNo())) {
                    List detailRespDtos = (List)finalSaleOrderDetailRespDtosMap.get(v.getOrderNo());
                    detailRespDtos.forEach(j -> {
                        KeepFinancialRemarksDto remarksDto = new KeepFinancialRemarksDto();
                        remarksDto.setChargeCode(j.getChargeCode());
                        remarksDto.setFinancialRemark(v.getFinancialRemark());
                        remarksDto.setPlatformNo(j.getPlatformNo());
                        remarksDto.setOrderNo(v.getOrderNo());
                        remarksDtos.add(remarksDto);
                    });
                }
            });
        }
        List platformNoDetailRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.keepAccountsDetailApiProxy.queryKeepDetailPlatformNoList(orderNoLists));
        Map<Object, Object> platformNoDetailRespDtosMap = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty((Collection)platformNoDetailRespDtos)) {
            Map<Object, Object> finalPlatformNoDetailRespDtosMap = platformNoDetailRespDtosMap = platformNoDetailRespDtos.stream().collect(Collectors.groupingBy(KeepAccountsDetailRespDto::getPlatformNo));
            successList.forEach(v -> {
                if (finalPlatformNoDetailRespDtosMap.containsKey(v.getOrderNo())) {
                    List detailRespDtos = (List)finalPlatformNoDetailRespDtosMap.get(v.getOrderNo());
                    detailRespDtos.forEach(j -> {
                        KeepFinancialRemarksDto remarksDto = new KeepFinancialRemarksDto();
                        remarksDto.setChargeCode(j.getChargeCode());
                        remarksDto.setFinancialRemark(v.getFinancialRemark());
                        remarksDto.setPlatformNo(j.getPlatformNo());
                        remarksDto.setOrderNo(v.getOrderNo());
                        remarksDtos.add(remarksDto);
                    });
                }
            });
        }
        logger.info("\u5bfc\u5165\u8d22\u52a1\u5907\u6ce8:{}", (Object)JSON.toJSONString((Object)remarksDtos));
        if (CollectionUtils.isNotEmpty((Collection)remarksDtos)) {
            try {
                RestResponse response = this.keepAccountsDetailApiProxy.batchDealFinancialRemark((List)remarksDtos);
                if (!"0".equals(response.getResultCode())) {
                    logger.info("\u5bfc\u5165\u8d22\u52a1\u5907\u6ce8\u5931\u8d25\uff1a{}", (Object)response.getResultMsg());
                    respDto.setStatus(FileOperationStatusEnum.IMPORT_ERROR.getCode());
                } else {
                    respDto.setStatus(FileOperationStatusEnum.IMPORT_SUCCESS.getCode());
                }
            }
            catch (Exception e) {
                respDto.setStatus(FileOperationStatusEnum.IMPORT_ERROR.getCode());
                respDto.setErrorMsg(e.getMessage());
                throw new RuntimeException(e);
            }
        }
    }

    public void importApplySpaceHandle(ImportKeepFinanceRemarkDto remarkDto) {
        if (StringUtils.isNotBlank((CharSequence)remarkDto.getOrderNo())) {
            remarkDto.setOrderNo(remarkDto.getOrderNo().replace(" ", "").replace("\n", ""));
        }
    }
}

