/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.mgmt.service.impl;

import cn.afterturn.easypoi.excel.entity.result.ExcelImportResult;
import cn.hutool.core.collection.CollectionUtil;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.rest.RestResponse;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import com.yunxi.dg.base.mgmt.application.rpc.api.customerbiz.IDgTobOrganizationApi;
import com.yunxi.dg.base.mgmt.application.rpc.api.userbiz.IDgOrganizationApi;
import com.yunxi.dg.base.ocs.mgmt.application.dto.enums.FileModeTypeEnum;
import com.yunxi.dg.base.ocs.mgmt.application.dto.enums.FileOperationStatusEnum;
import com.yunxi.dg.base.ocs.mgmt.application.dto.proxy.customer.DgOrganizationReqDto;
import com.yunxi.dg.base.ocs.mgmt.application.dto.proxy.user.OrganizationDto;
import com.yunxi.dg.base.ocs.mgmt.application.dto.request.ImportInventoryOrganizationDto;
import com.yunxi.dg.base.poi.dto.ImportBaseModeDto;
import com.yunxi.dg.base.poi.dto.ImportFileOperationCommonReqDto;
import com.yunxi.dg.base.poi.dto.ImportFileOperationCommonRespDto;
import com.yunxi.dg.base.poi.service.AbstractBaseFileOperationCommonService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="AbstractBaseFileOperationCommonService_stock_organization_import")
public class InventoryOrganizationCommonServiceImpl
extends AbstractBaseFileOperationCommonService {
    private static final Logger log = LoggerFactory.getLogger(InventoryOrganizationCommonServiceImpl.class);
    private Logger logger = LoggerFactory.getLogger(InventoryOrganizationCommonServiceImpl.class);
    @Resource
    private IDgTobOrganizationApi iDgTobOrganizationApi;
    @Resource
    private IDgOrganizationApi iDgOrganizationApi;

    public Object verifyImportFileOperationCommon(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto) {
        ArrayList<ImportInventoryOrganizationDto> list = new ArrayList<ImportInventoryOrganizationDto>();
        if (CollectionUtil.isEmpty((Collection)result.getList())) {
            return new ArrayList();
        }
        CubeBeanUtils.copyCollection(list, (Collection)result.getList(), ImportInventoryOrganizationDto.class);
        Map<String, OrganizationDto> organizationDtoMap = this.mapOrgInfoByCodes(this.listOrgCode(list));
        ArrayList<ImportInventoryOrganizationDto> passList = new ArrayList<ImportInventoryOrganizationDto>();
        for (ImportInventoryOrganizationDto dto : list) {
            Boolean verify = this.inventoryOrgVerify(dto, organizationDtoMap);
            if (!verify.booleanValue()) {
                dto.setErrorMsg(String.format("\u7b2c%s\u884c\u6570\u636e\u6709\u8bef,%s", dto.getRowNum() + FileModeTypeEnum.getInstance((String)commonReqDto.getKey()).getHeadRows(), dto.getErrorMsg()));
                respDto.getErrorDetails().add(dto);
                continue;
            }
            passList.add(dto);
        }
        return passList;
    }

    public void callBackImportFileOperationCommonAsync(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto, Object object) {
        List passList = (List)object;
        if (CollectionUtil.isEmpty((Collection)passList)) {
            respDto.setStatus(FileOperationStatusEnum.IMPORT_ERROR.getCode());
            return;
        }
        respDto.setStatus(FileOperationStatusEnum.IMPORT_SUCCESS.getCode());
        ArrayList<DgOrganizationReqDto> reqDtoList = new ArrayList<DgOrganizationReqDto>();
        try {
            for (ImportInventoryOrganizationDto dto : passList) {
                DgOrganizationReqDto reqDto = new DgOrganizationReqDto();
                reqDto.setCode(dto.getCode());
                reqDto.setName(dto.getName());
                reqDto.setParentCode(dto.getParentCode());
                reqDto.setParentName(dto.getParentName());
                reqDto.setParentId(dto.getParentId());
                reqDto.setOrgFuncType("stock");
                reqDtoList.add(reqDto);
            }
            log.info("\u6279\u91cf\u4fdd\u5b58\u9500\u552e\u7ec4\u7ec7,\u6570\u91cf\u4e3a:{}", (Object)reqDtoList.size());
            this.iDgTobOrganizationApi.addOrgBatch(reqDtoList);
        }
        catch (Exception e) {
            log.error("\u65b0\u589e\u7ec4\u7ec7\u5931\u8d25", (Throwable)e);
            respDto.setStatus(FileOperationStatusEnum.IMPORT_ERROR.getCode());
            passList.forEach(item -> item.setErrorMsg(String.format("\u7b2c%s\u884c\u6570\u636e\u6709\u8bef,%s", item.getRowNum() + FileModeTypeEnum.getInstance((String)commonReqDto.getKey()).getHeadRows(), "\u5199\u5165\u5931\u8d25" + e.getMessage())));
        }
    }

    private Boolean inventoryOrgVerify(ImportInventoryOrganizationDto dto, Map<String, OrganizationDto> organizationDtoMap) {
        if (organizationDtoMap.get(dto.getCode()) != null) {
            dto.setErrorMsg("\u7ec4\u7ec7\u7f16\u7801\u5df2\u7ecf\u5b58\u5728\uff1a" + dto.getCode());
            return false;
        }
        if (organizationDtoMap.get(dto.getParentCode()) == null) {
            dto.setErrorMsg("\u4e0a\u7ea7\u7ec4\u7ec7\u4e0d\u5b58\u5728\uff1a" + dto.getParentCode());
            return false;
        }
        dto.setParentId(organizationDtoMap.get(dto.getParentCode()).getId());
        return true;
    }

    private List<String> listOrgCode(List<ImportInventoryOrganizationDto> list) {
        ArrayList<String> codeList = new ArrayList<String>();
        list.forEach(e -> {
            codeList.add(e.getCode());
            codeList.add(e.getParentCode());
        });
        return codeList;
    }

    private Map<String, OrganizationDto> mapOrgInfoByCodes(List<String> codes) {
        List organizationDtos = (List)RestResponseHelper.extractData((RestResponse)this.iDgOrganizationApi.queryOrgListByCode(codes));
        return ((List)Optional.ofNullable(organizationDtos).orElse(new ArrayList())).stream().collect(Collectors.toMap(OrganizationDto::getCode, Function.identity()));
    }
}

