/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.mgmt.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.inventory.dto.entity.OutResultOrderReqDto;
import com.yunxi.dg.base.center.inventory.dto.entity.WarehouseRelationDto;
import com.yunxi.dg.base.center.inventory.dto.entity.WarehouseRelationPageReqDto;
import com.yunxi.dg.base.center.inventory.dto.transfer.BatchOrderOperationMsgDto;
import com.yunxi.dg.base.center.inventory.dto.transfer.TransferOrderAuditReqDto;
import com.yunxi.dg.base.center.inventory.dto.transfer.TransferOrderItemPageDto;
import com.yunxi.dg.base.center.inventory.dto.transfer.TransferOrderKeyDto;
import com.yunxi.dg.base.center.inventory.dto.transfer.TransferOrderPageDto;
import com.yunxi.dg.base.center.inventory.dto.transfer.TransferOrderRespDto;
import com.yunxi.dg.base.center.inventory.dto.transfer.TransferOrderSearchDto;
import com.yunxi.dg.base.center.inventory.proxy.baseorder.IInOutNoticeOrderApiProxy;
import com.yunxi.dg.base.center.inventory.proxy.entity.IWarehouseRelationApiProxy;
import com.yunxi.dg.base.center.inventory.proxy.order.ITransferOrderApiProxy;
import com.yunxi.dg.base.center.openapi.dto.e3.SkuDto;
import com.yunxi.dg.base.center.openapi.dto.e3.TransferOrderDto;
import com.yunxi.dg.base.center.openapi.dto.e3.TransferOrderStatusDto;
import com.yunxi.dg.base.center.openapi.proxy.e3.IExternalE3ApiProxy;
import com.yunxi.dg.base.center.report.dto.inventory.DgOutNoticeOrderDto;
import com.yunxi.dg.base.center.report.dto.inventory.DgOutNoticeOrderPageReqDto;
import com.yunxi.dg.base.center.report.proxy.inventory.IDgOutNoticeOrderApiProxy;
import com.yunxi.dg.base.center.report.proxy.inventory.TransferOrderControllerApiProxy;
import com.yunxi.dg.base.center.share.dto.entity.DgInventorySupplyStrategyWarehouseDto;
import com.yunxi.dg.base.center.share.dto.entity.DgLogicWarehouseVirtualSkuCodeDto;
import com.yunxi.dg.base.center.share.dto.entity.TransferGoodsOrderDetailDto;
import com.yunxi.dg.base.center.share.dto.entity.TransferGoodsOrderExtDto;
import com.yunxi.dg.base.center.share.proxy.entity.ITransferGoodsOrderApiProxy;
import com.yunxi.dg.base.center.share.proxy.strategy.IDgInventorySupplyStrategyQueryApiProxy;
import com.yunxi.dg.base.commons.dto.BaseDto;
import com.yunxi.dg.base.commons.enums.YesNoEnum;
import com.yunxi.dg.base.commons.helper.YesNoHelper;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.commons.utils.decimal.BigDecimalUtils;
import com.yunxi.dg.base.mgmt.application.rpc.dto.transfer.TransferOrderComboReqDto;
import com.yunxi.dg.base.mgmt.application.rpc.dto.transfer.TransferOrderDetailReqDto;
import com.yunxi.dg.base.mgmt.application.rpc.dto.transfer.TransferOrderReqDto;
import com.yunxi.dg.base.mgmt.application.rpc.dto.transfer.TransferOrderTypeEnum;
import com.yunxi.dg.base.mgmt.application.rpc.proxy.dictbiz.IPcpDictQueryApiProxy;
import com.yunxi.dg.base.mgmt.application.rpc.proxy.sku.IItemSkuDgQueryApiProxy;
import com.yunxi.dg.base.mgmt.service.IOcsTransferOrderService;
import com.yunxi.dg.base.mgmt.service.enums.ExportTransferGoodsOrderEnum;
import com.yunxi.dg.base.ocs.mgmt.application.dto.enums.AuditStatusEnum;
import com.yunxi.dg.base.ocs.mgmt.application.dto.enums.CommitEnum;
import com.yunxi.dg.base.ocs.mgmt.application.dto.enums.DisplayBusinessTypeEnum;
import com.yunxi.dg.base.ocs.mgmt.application.dto.enums.OrderTypeConstant;
import com.yunxi.dg.base.ocs.mgmt.application.dto.enums.PushE3StatusEnum;
import com.yunxi.dg.base.ocs.mgmt.application.dto.enums.TransferOrderStatusEnum;
import com.yunxi.dg.base.ocs.mgmt.application.dto.proxy.item.ItemSkuDgRespDto;
import com.yunxi.dg.base.ocs.mgmt.application.dto.response.DictDto;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.assertj.core.util.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OcsTransferOrderServiceImpl
implements IOcsTransferOrderService {
    private static final Logger log = LoggerFactory.getLogger(OcsTransferOrderServiceImpl.class);
    @Autowired
    private IExternalE3ApiProxy iExternalE3ApiProxy;
    @Autowired
    private ITransferOrderApiProxy iTransferOrderApiProxy;
    @Autowired
    private IWarehouseRelationApiProxy iWarehouseRelationApiProxy;
    @Autowired
    private TransferOrderControllerApiProxy transferOrderControllerApiProxy;
    @Autowired
    private IItemSkuDgQueryApiProxy iItemSkuDgQueryApiProxy;
    @Autowired
    private IDgOutNoticeOrderApiProxy iDgOutNoticeOrderApiProxy;
    @Autowired
    private IInOutNoticeOrderApiProxy iInOutNoticeOrderApiProxy;
    @Autowired
    private IDgInventorySupplyStrategyQueryApiProxy iDgInventorySupplyStrategyQueryApiProxy;
    @Autowired
    private IPcpDictQueryApiProxy iPcpDictQueryApiProxy;
    @Autowired
    private ITransferGoodsOrderApiProxy iTransferGoodsOrderApiProxy;

    @Override
    public RestResponse<BatchOrderOperationMsgDto> batchWithdraw(List<TransferOrderKeyDto> reqDto) {
        return new RestResponse(RestResponseHelper.extractData((RestResponse)this.iTransferOrderApiProxy.batchWithdraw(reqDto)));
    }

    @Override
    public RestResponse<Long> add(TransferOrderComboReqDto reqDto) {
        Long id;
        TransferOrderReqDto orderReqDto = reqDto.getTransferOrderReqDto();
        List detailList = reqDto.getDetailList();
        List<String> skuCodeList = detailList.stream().map(TransferOrderDetailReqDto::getSkuCode).collect(Collectors.toList());
        ArrayList checkInventoryOrderTypeList = Lists.newArrayList((Object[])new String[]{TransferOrderTypeEnum.CLOUD_WAREHOUSE_B_C.getCode(), TransferOrderTypeEnum.EXTERNAL_WAREHOUSE_B_C.getCode()});
        if (checkInventoryOrderTypeList.contains(orderReqDto.getType())) {
            this.checkInventory(orderReqDto, detailList, skuCodeList);
        }
        try {
            id = (Long)RestResponseHelper.extractData((RestResponse)this.iTransferOrderApiProxy.add(reqDto));
        }
        catch (Exception e) {
            log.info("\u521b\u5efa\u8c03\u62e8\u5355\u5931\u8d25:{}", (Object)e.getMessage());
            throw new BizException(e.getMessage());
        }
        return new RestResponse((Object)id);
    }

    private void checkInventory(TransferOrderReqDto orderReqDto, List<TransferOrderDetailReqDto> detailList, List<String> skuCodeList) {
        DictDto dictDto = (DictDto)RestResponseHelper.extractData((RestResponse)this.iPcpDictQueryApiProxy.queryByGroupCodeAndCode("check_inventory_type", "check_inventory_type"));
        log.info("\u67e5\u8be2\u5230\u901a\u7528\u914d\u7f6e\u662f\u5426\u6821\u9a8c\u5e93\u5b58:{}", (Object)JSON.toJSONString((Object)dictDto));
        if (null == dictDto) {
            return;
        }
        if (!dictDto.getStatus().equals(YesNoHelper.YES)) {
            return;
        }
        List orderTypeList = JSON.parseArray((String)dictDto.getValue(), String.class);
        if (orderTypeList.contains(orderReqDto.getType())) {
            log.info("\u8fdb\u5165\u6821\u9a8c\u4f9b\u8d27\u5e93\u5b58");
            boolean borrowGoods = Boolean.FALSE;
            DgInventorySupplyStrategyWarehouseDto logicWarehouseReqDto = new DgInventorySupplyStrategyWarehouseDto();
            logicWarehouseReqDto.setWarehouseCode(orderReqDto.getOutLogicWarehouseCode());
            logicWarehouseReqDto.setSkuCodeList(skuCodeList);
            List virtualSkuCodeDtoList = (List)RestResponseHelper.extractData((RestResponse)this.iDgInventorySupplyStrategyQueryApiProxy.queryLogicWarehouseVirtualSkuCode(logicWarehouseReqDto));
            log.info("\u67e5\u8be2\u5230\u4f9b\u8d27\u7b56\u7565:{}", (Object)JSON.toJSONString((Object)virtualSkuCodeDtoList));
            if (CollectionUtil.isEmpty((Collection)virtualSkuCodeDtoList)) {
                log.info("\u6ca1\u6709\u67e5\u5230\u5173\u8054\u7684\u4f9b\u8d27\u4ed3\uff0c\u4e0d\u6821\u9a8c\u5e93\u5b58");
                return;
            }
            this.checkInventorySufficient(detailList, virtualSkuCodeDtoList);
            if (StringUtils.isNotBlank((String)orderReqDto.getSubWarehouseCode())) {
                List<DgLogicWarehouseVirtualSkuCodeDto> virtualInventoryDtoList = virtualSkuCodeDtoList.stream().filter(r -> StringUtils.equals((String)r.getOverallWarehouseCode(), (String)orderReqDto.getSubWarehouseCode())).collect(Collectors.toList());
                AssertUtils.notEmpty(virtualInventoryDtoList, (String)"\u903b\u8f91\u4ed3\u5173\u8054\u7684\u4f9b\u8d27\u7b56\u7565\u6ca1\u6709\u627e\u5230\u8be5\u5e73\u8d26\u5b50\u4ed3");
                DgLogicWarehouseVirtualSkuCodeDto dgVirtualInventoryDto = (DgLogicWarehouseVirtualSkuCodeDto)virtualInventoryDtoList.get(0);
                borrowGoods = this.isBorrowGoods(orderReqDto, detailList, borrowGoods, virtualInventoryDtoList);
                if (borrowGoods) {
                    log.info("\u9700\u8981\u501f\u8d27");
                    TransferGoodsOrderExtDto transferGoodsOrderExtDto = new TransferGoodsOrderExtDto();
                    transferGoodsOrderExtDto.setCommitType(CommitEnum.COMMIT.getCode());
                    transferGoodsOrderExtDto.setBusinessType(ExportTransferGoodsOrderEnum.CHANNEL_TRANSFER_GOODS.getCode());
                    transferGoodsOrderExtDto.setWarehouseCode(dgVirtualInventoryDto.getOverallWarehouseCode());
                    transferGoodsOrderExtDto.setWarehouseName(dgVirtualInventoryDto.getOverallWarehouseName());
                    ArrayList orderDetailDtos = Lists.newArrayList();
                    for (TransferOrderDetailReqDto transferOrderDetailReqDto : detailList) {
                        TransferGoodsOrderDetailDto detailDto = new TransferGoodsOrderDetailDto();
                        detailDto.setSkuCode(transferOrderDetailReqDto.getSkuCode());
                        detailDto.setSkuName(transferOrderDetailReqDto.getSkuName());
                        detailDto.setQuantity(transferOrderDetailReqDto.getQuantity());
                        orderDetailDtos.add(detailDto);
                    }
                    transferGoodsOrderExtDto.setOrderDetail((List)orderDetailDtos);
                    log.info("\u65b0\u589e\u6e20\u9053\u8c03\u8d27\u5355\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)transferGoodsOrderExtDto));
                    RestResponseHelper.extractData((RestResponse)this.iTransferGoodsOrderApiProxy.insert(transferGoodsOrderExtDto));
                }
            }
        }
    }

    private void checkInventorySufficient(List<TransferOrderDetailReqDto> detailList, List<DgLogicWarehouseVirtualSkuCodeDto> virtualInventoryDtoList) {
        Map<String, BigDecimal> skuCodeAvailableMap = virtualInventoryDtoList.stream().collect(Collectors.groupingBy(DgLogicWarehouseVirtualSkuCodeDto::getSkuCode, Collectors.mapping(DgLogicWarehouseVirtualSkuCodeDto::getAvailable, Collectors.reducing(BigDecimal.ZERO, BigDecimal::add))));
        for (TransferOrderDetailReqDto transferOrderDetailEo : detailList) {
            if (!skuCodeAvailableMap.containsKey(transferOrderDetailEo.getSkuCode())) {
                throw new BizException("\u903b\u8f91\u4ed3\u672a\u5173\u8054\u4f9b\u8d27\u7b56\u7565");
            }
            BigDecimal virtualAvailable = skuCodeAvailableMap.get(transferOrderDetailEo.getSkuCode());
            if (!BigDecimalUtils.lt((BigDecimal)virtualAvailable, (BigDecimal)transferOrderDetailEo.getQuantity()).booleanValue()) continue;
            throw new BizException("\u5546\u54c1\u7f16\u7801" + transferOrderDetailEo.getSkuCode() + "\u4f9b\u8d27\u4ed3\u5e93\u5b58\u4e0d\u8db3");
        }
    }

    private boolean isBorrowGoods(TransferOrderReqDto orderReqDto, List<TransferOrderDetailReqDto> detailList, boolean borrowGoods, List<DgLogicWarehouseVirtualSkuCodeDto> virtualInventoryDtoList) {
        Map<String, BigDecimal> skuCodeAvailableMap = virtualInventoryDtoList.stream().collect(Collectors.toMap(DgLogicWarehouseVirtualSkuCodeDto::getSkuCode, DgLogicWarehouseVirtualSkuCodeDto::getAvailable, (k, k1) -> k));
        for (TransferOrderDetailReqDto transferOrderDetailEo : detailList) {
            if (!skuCodeAvailableMap.containsKey(transferOrderDetailEo.getSkuCode())) {
                throw new BizException("\u903b\u8f91\u4ed3\u672a\u5173\u8054\u4f9b\u8d27\u7b56\u7565");
            }
            BigDecimal virtualAvailable = skuCodeAvailableMap.get(transferOrderDetailEo.getSkuCode());
            if (BigDecimalUtils.le((BigDecimal)virtualAvailable, (BigDecimal)transferOrderDetailEo.getQuantity()).booleanValue() && !ObjectUtil.equals((Object)YesNoEnum.YES.getValue(), (Object)orderReqDto.getIsBorrowGoods())) {
                throw new BizException("\u5546\u54c1\u7f16\u7801" + transferOrderDetailEo.getSkuCode() + "\u4f9b\u8d27\u4ed3\u5e93\u5b58\u4e0d\u8db3");
            }
            borrowGoods = BigDecimalUtils.le((BigDecimal)virtualAvailable, (BigDecimal)transferOrderDetailEo.getQuantity()) != false && ObjectUtil.equals((Object)YesNoEnum.YES.getValue(), (Object)orderReqDto.getIsBorrowGoods());
        }
        return borrowGoods;
    }

    @Override
    public RestResponse<BatchOrderOperationMsgDto> audit(TransferOrderAuditReqDto dto) {
        ArrayList orderTypeList = Lists.newArrayList((Object[])new String[]{TransferOrderTypeEnum.CLOUD_WAREHOUSE_C_B.getCode(), TransferOrderTypeEnum.CLOUD_WAREHOUSE_C_C.getCode()});
        BatchOrderOperationMsgDto batchOrderOperationMsgDto = (BatchOrderOperationMsgDto)RestResponseHelper.extractData((RestResponse)this.iTransferOrderApiProxy.audit(dto));
        if (Objects.equals(AuditStatusEnum.AUDIT_PASS.getCode(), dto.getAuditResult())) {
            Map<String, List<TransferOrderItemPageDto>> transferOrderItemMap = this.getTransferOrderItemMap(dto);
            Map<String, Long> outNoticeOrderIdMap = this.getOutNoticeOrderIdMap(dto);
            TransferOrderSearchDto orderSearchDto = new TransferOrderSearchDto();
            orderSearchDto.setTransferOrderNoList(dto.getTransferOrderNos());
            List transferOrderPageDtos = (List)RestResponseHelper.extractData((RestResponse)this.iTransferOrderApiProxy.queryTransferOrderList(orderSearchDto));
            if (CollectionUtil.isEmpty((Collection)transferOrderPageDtos)) {
                log.info("\u67e5\u8be2\u4e0d\u5230\u8c03\u62e8\u5355");
                return new RestResponse((Object)batchOrderOperationMsgDto);
            }
            for (TransferOrderPageDto orderPageDto : transferOrderPageDtos) {
                if (!Objects.equals(TransferOrderStatusEnum.WAITING_FOR_DELIVERY.getCode(), orderPageDto.getOrderStatus())) {
                    log.info("\u8c03\u62e8\u5355\u72b6\u6001\u4e0d\u662f\u5f85\u53d1\u8d27\u72b6\u6001");
                    continue;
                }
                if (StringUtils.equals((String)orderPageDto.getType(), (String)DisplayBusinessTypeEnum.EXTERNAL_WAREHOUSE_C_B.getType())) {
                    this.productOutbound(outNoticeOrderIdMap, orderPageDto);
                }
                if (StringUtils.isBlank((String)orderPageDto.getExternalOrderNo())) {
                    log.info("\u8c03\u62e8\u5355\u7684\u5916\u90e8\u5355\u53f7\u4e3a\u7a7a");
                    continue;
                }
                if (!orderTypeList.contains(orderPageDto.getType())) {
                    log.info("\u8c03\u62e8\u5355\u7c7b\u578b\u4e0d\u662fCC\u8c03\u62e8\u548cCB\u8c03\u62e8");
                    continue;
                }
                List<TransferOrderItemPageDto> transferOrderItemPageDtos = transferOrderItemMap.get(orderPageDto.getTransferOrderNo());
                boolean isMoreBar = transferOrderItemPageDtos.stream().anyMatch(o -> o.getMoreBar().equals(YesNoHelper.YES));
                if (isMoreBar) {
                    log.info("\u5546\u54c1\u5b58\u5728\u591a\u6761\u7801,\u4eba\u5de5\u5ba1\u6838");
                    continue;
                }
                try {
                    TransferOrderStatusDto transferOrderStatusDto = new TransferOrderStatusDto();
                    transferOrderStatusDto.setTransferOrderNo(orderPageDto.getExternalOrderNo());
                    RestResponseHelper.extractData((RestResponse)this.iExternalE3ApiProxy.syncTransferOrderAuditStatus(transferOrderStatusDto));
                }
                catch (Exception e) {
                    log.info("E3\u540c\u6b65\u8c03\u62e8\u5355\u5ba1\u6838\u72b6\u6001\u5931\u8d25:{}", (Object)e.getMessage());
                    this.updateTransferE3Status(orderPageDto.getTransferOrderNo(), PushE3StatusEnum.E3_WAIT_AUDIT.getCode(), e.getMessage(), null);
                    return new RestResponse((Object)batchOrderOperationMsgDto);
                }
                this.updateTransferE3Status(orderPageDto.getTransferOrderNo(), PushE3StatusEnum.E3_ALREADY_AUDIT.getCode(), null, null);
            }
        }
        return new RestResponse((Object)batchOrderOperationMsgDto);
    }

    private void productOutbound(Map<String, Long> outNoticeOrderIdMap, TransferOrderPageDto orderPageDto) {
        if (outNoticeOrderIdMap.containsKey(orderPageDto.getTransferOrderNo())) {
            Long id = outNoticeOrderIdMap.get(orderPageDto.getTransferOrderNo());
            OutResultOrderReqDto outResultOrderReqDto = new OutResultOrderReqDto();
            outResultOrderReqDto.setId(id);
            outResultOrderReqDto.setBizDate(new Date());
            this.iInOutNoticeOrderApiProxy.productOutbound(outResultOrderReqDto);
        }
    }

    private Map<String, Long> getOutNoticeOrderIdMap(TransferOrderAuditReqDto dto) {
        DgOutNoticeOrderPageReqDto dgOutNoticeOrderPageReqDto = new DgOutNoticeOrderPageReqDto();
        dgOutNoticeOrderPageReqDto.setRelevanceNoList(dto.getTransferOrderNos());
        dgOutNoticeOrderPageReqDto.setOrderType(OrderTypeConstant.OUTNOTICEORDER_OUT);
        List dgOutNoticeOrderDtos = (List)RestResponseHelper.extractData((RestResponse)this.iDgOutNoticeOrderApiProxy.queryList(dgOutNoticeOrderPageReqDto));
        Map<String, Long> outNoticeOrderIdMap = dgOutNoticeOrderDtos.stream().collect(Collectors.toMap(DgOutNoticeOrderDto::getRelevanceNo, BaseDto::getId, (k1, k2) -> k1));
        log.info("\u6839\u636e\u8c03\u62e8\u5355\u53f7\u67e5\u8be2\u5230\u51fa\u5e93\u901a\u77e5\u7684id:{}", (Object)JSON.toJSONString(outNoticeOrderIdMap));
        return outNoticeOrderIdMap;
    }

    @Override
    public RestResponse<Void> delete(TransferOrderKeyDto reqDto) {
        return new RestResponse(RestResponseHelper.extractData((RestResponse)this.iTransferOrderApiProxy.delete(reqDto)));
    }

    @Override
    public RestResponse<Void> automationInTask() {
        RestResponseHelper.extractData((RestResponse)this.iTransferOrderApiProxy.automationInTask());
        return RestResponse.VOID;
    }

    private Map<String, List<TransferOrderItemPageDto>> getTransferOrderItemMap(TransferOrderAuditReqDto dto) {
        TransferOrderSearchDto transferOrderSearchDto = new TransferOrderSearchDto();
        transferOrderSearchDto.setTransferOrderNoList(dto.getTransferOrderNos());
        transferOrderSearchDto.setPageNum(Integer.valueOf(1));
        transferOrderSearchDto.setPageSize(Integer.valueOf(999));
        PageInfo transferOrderItemPageDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.transferOrderControllerApiProxy.pageItem(transferOrderSearchDto));
        AssertUtils.notEmpty((Collection)transferOrderItemPageDtoPageInfo.getList(), (String)"\u8c03\u62e8\u5355\u53f7\u627e\u4e0d\u5230\u660e\u7ec6");
        List transferOrderItemPageDtoList = transferOrderItemPageDtoPageInfo.getList();
        List skuCodeList = transferOrderItemPageDtoList.stream().map(TransferOrderItemPageDto::getSkuCode).collect(Collectors.toList());
        List skuDgRespDtoList = (List)Optional.ofNullable(RestResponseHelper.extractData((RestResponse)this.iItemSkuDgQueryApiProxy.queryBySkuCode(skuCodeList))).orElse(Lists.newArrayList());
        Map<String, Integer> skuCodeMoreBarMap = skuDgRespDtoList.stream().collect(Collectors.toMap(ItemSkuDgRespDto::getCode, ItemSkuDgRespDto::getMoreBar, (k1, k2) -> k1));
        log.info("\u67e5\u8be2\u5230\u5546\u54c1\u591a\u6761\u7801:{}", (Object)JSON.toJSONString(skuCodeMoreBarMap));
        transferOrderItemPageDtoList.forEach(transferOrderItemPageDto -> {
            if (skuCodeMoreBarMap.containsKey(transferOrderItemPageDto.getSkuCode())) {
                transferOrderItemPageDto.setMoreBar((Integer)skuCodeMoreBarMap.get(transferOrderItemPageDto.getSkuCode()));
            }
        });
        Map<String, List<TransferOrderItemPageDto>> transferOrderItemMap = transferOrderItemPageDtoList.stream().collect(Collectors.groupingBy(TransferOrderItemPageDto::getTransferOrderNo));
        return transferOrderItemMap;
    }

    private void updateTransferE3Status(String transferOrderNo, String pushE3Status, String message, String externalOrderNo) {
        TransferOrderReqDto transferOrderReqDto = new TransferOrderReqDto();
        transferOrderReqDto.setTransferOrderNo(transferOrderNo);
        transferOrderReqDto.setPushE3Status(pushE3Status);
        transferOrderReqDto.setE3FailReason(message);
        transferOrderReqDto.setExternalOrderNo(externalOrderNo);
        RestResponseHelper.extractData((RestResponse)this.iTransferOrderApiProxy.modifyE3Status(transferOrderReqDto));
    }

    private TransferOrderDto getTransferOrderDto(TransferOrderReqDto orderReqDto, List<TransferOrderDetailReqDto> detailList, TransferOrderRespDto transferOrderRespDto) {
        WarehouseRelationDto warehouseRelationDto;
        Map<String, WarehouseRelationDto> warehouseRelationMap = this.getWarehouseRelationMap(orderReqDto);
        TransferOrderDto dto = new TransferOrderDto();
        dto.setTransferOrderNo(transferOrderRespDto.getTransferOrderNo());
        if (warehouseRelationMap.containsKey(orderReqDto.getOutLogicWarehouseCode())) {
            warehouseRelationDto = warehouseRelationMap.get(orderReqDto.getOutLogicWarehouseCode());
            dto.setOutWarehouseCode(warehouseRelationDto.getErpId());
            dto.setOutOrgCode(warehouseRelationDto.getE3ChannelCode());
        }
        if (warehouseRelationMap.containsKey(orderReqDto.getInLogicWarehouseCode())) {
            warehouseRelationDto = warehouseRelationMap.get(orderReqDto.getInLogicWarehouseCode());
            dto.setInWarehouseCode(warehouseRelationDto.getErpId());
            dto.setInOrgCode(warehouseRelationDto.getE3ChannelCode());
        }
        dto.setBizDate(orderReqDto.getBizDate());
        dto.setRemark(orderReqDto.getRemark());
        dto.setAuditStatus(YesNoHelper.NO);
        ArrayList skuDtoList = Lists.newArrayList();
        detailList.forEach(detail -> {
            SkuDto skuDto = new SkuDto();
            skuDto.setSkuCode(detail.getSkuCode());
            skuDto.setItemCode(detail.getSkuCode());
            skuDto.setNum(detail.getQuantity());
            skuDtoList.add(skuDto);
        });
        dto.setSkuList((List)skuDtoList);
        return dto;
    }

    private Map<String, WarehouseRelationDto> getWarehouseRelationMap(TransferOrderReqDto orderReqDto) {
        ArrayList logicWarehouseCodeList = Lists.newArrayList((Object[])new String[]{orderReqDto.getOutLogicWarehouseCode(), orderReqDto.getInLogicWarehouseCode()});
        WarehouseRelationPageReqDto reqDto = new WarehouseRelationPageReqDto();
        reqDto.setLogicWarehouseCodeList((List)logicWarehouseCodeList);
        List warehouseRelationDtoList = (List)Optional.ofNullable(RestResponseHelper.extractData((RestResponse)this.iWarehouseRelationApiProxy.queryList(reqDto))).orElse(Lists.newArrayList());
        log.info("\u6839\u636e\u903b\u8f91\u4ed3\u67e5\u5230E3\u5173\u7cfb\u4ed3:{}", (Object)JSON.toJSONString((Object)warehouseRelationDtoList));
        Map<String, WarehouseRelationDto> warehouseRelationDtoMap = warehouseRelationDtoList.stream().collect(Collectors.toMap(WarehouseRelationDto::getLogicWarehouseCode, Function.identity(), (o1, o2) -> o1));
        return warehouseRelationDtoMap;
    }

    private TransferOrderRespDto getTransferOrderRespDto(Long id) {
        TransferOrderKeyDto keyDto = new TransferOrderKeyDto();
        keyDto.setId(id);
        return (TransferOrderRespDto)RestResponseHelper.extractData((RestResponse)this.iTransferOrderApiProxy.detail(keyDto));
    }
}

