/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.mgmt.service.finance.impl;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.aliyun.openservices.shade.org.apache.commons.lang3.StringUtils;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.util.ParamConverter;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.finance.api.entity.IBillInfoApi;
import com.yunxi.dg.base.center.finance.dto.entity.OrderMergeBillInfoQueryDto;
import com.yunxi.dg.base.center.finance.dto.entity.OrderMergeBillInfoRespDto;
import com.yunxi.dg.base.center.finance.dto.entity.OrderMergeRedAgainBillReqDto;
import com.yunxi.dg.base.center.finance.dto.entity.SaleOrderBillRecordPageReqDto;
import com.yunxi.dg.base.center.finance.dto.request.BillInfoReqDto;
import com.yunxi.dg.base.center.finance.dto.request.BillItemReqDto;
import com.yunxi.dg.base.center.finance.dto.request.BillOrderItemQueryDto;
import com.yunxi.dg.base.center.finance.dto.response.BatchOperationRespDto;
import com.yunxi.dg.base.center.finance.dto.response.BillOrderItemRespDto;
import com.yunxi.dg.base.center.finance.proxy.entity.IBillOrderItemApiProxy;
import com.yunxi.dg.base.center.finance.proxy.entity.IMergeBillInfoApiProxy;
import com.yunxi.dg.base.center.finance.proxy.entity.ISaleOrderBillRecordQueryApiProxy;
import com.yunxi.dg.base.center.trade.dto.entity.BatchUpdateInvoiceDto;
import com.yunxi.dg.base.center.trade.dto.entity.SaleOrderBillRecordReqDto;
import com.yunxi.dg.base.center.trade.proxy.aftersale.IDgAfterSaleOrderApiProxy;
import com.yunxi.dg.base.center.trade.proxy.entity.ISaleOrderBillRecordApiProxy;
import com.yunxi.dg.base.mgmt.service.finance.FinancialManagementInvoiceManagementTobInvoiceManagementService;
import com.yunxi.dg.base.mgmt.service.utils.AssertUtil;
import com.yunxi.dg.base.ocs.mgmt.application.constants.AfterInvoiceFlagEnum;
import com.yunxi.dg.base.ocs.mgmt.application.constants.SaleOrderInvoiceStateEnum;
import com.yunxi.dg.base.ocs.mgmt.application.dto.finance.AddTocInvoiceParams;
import com.yunxi.dg.base.ocs.mgmt.application.dto.finance.CancelTobInvoiceParams;
import com.yunxi.dg.base.ocs.mgmt.application.dto.finance.GetTobInvoiceInfoParams;
import com.yunxi.dg.base.ocs.mgmt.application.dto.finance.InvoiceOrderInfoQuery;
import com.yunxi.dg.base.ocs.mgmt.application.dto.finance.InvoiceOrderInfoVO;
import com.yunxi.dg.base.ocs.mgmt.application.dto.finance.RedFlushReopenTobInvoiceParams;
import com.yunxi.dg.base.ocs.mgmt.application.dto.finance.TobInvoiceinfoVO;
import com.yunxi.dg.base.ocs.mgmt.application.dto.finance.UpdateTobInvoiceFlag;
import com.yunxi.dg.base.ocs.mgmt.application.dto.finance.UpdateTobInvoiceFlagInfo;
import io.swagger.annotations.ApiParam;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.validation.Valid;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestBody;

@Service
public class FinancialManagementInvoiceManagementTobInvoiceManagementServiceServiceImpl
implements FinancialManagementInvoiceManagementTobInvoiceManagementService {
    private static Logger logger = LoggerFactory.getLogger(FinancialManagementInvoiceManagementTobInvoiceManagementServiceServiceImpl.class);
    @Resource
    private IMergeBillInfoApiProxy mergeBillInfoApi;
    @Resource
    private ISaleOrderBillRecordApiProxy saleOrderBillRecordApiProxy;
    @Resource
    private IDgAfterSaleOrderApiProxy dgAfterSaleOrderApiProxy;
    @Resource
    private ISaleOrderBillRecordQueryApiProxy saleOrderBillRecordQueryApi;
    @Resource
    private IBillOrderItemApiProxy billOrderItemQueryApi;
    @Resource
    private IBillInfoApi billInfoApi;

    @Override
    public RestResponse<Object> addTobInvoice(@ApiParam(value="") @Valid @RequestBody(required=false) AddTocInvoiceParams addTobInvoice) {
        BillInfoReqDto billInfoReqDto = new BillInfoReqDto();
        this.addBillInfoParam(addTobInvoice, billInfoReqDto);
        Long id = (Long)RestResponseHelper.extractData((RestResponse)this.billInfoApi.addBillInfo(billInfoReqDto));
        return new RestResponse((Object)id);
    }

    @Override
    public RestResponse<Object> cancelTobInvoice(@ApiParam(value="") @Valid @RequestBody(required=false) CancelTobInvoiceParams cancelTobInvoiceParams) {
        AssertUtil.assertNotEmpty(cancelTobInvoiceParams.getInvoiceTradeNos(), "\u8bf7\u9009\u62e9\u9700\u8981\u53d6\u6d88\u7684\u53d1\u7968");
        logger.info("\u53d6\u6d88B\u7aef\u5f00\u7968:{}", (Object)JSON.toJSONString((Object)cancelTobInvoiceParams.getInvoiceTradeNos()));
        BatchOperationRespDto batchOperationRespDto = (BatchOperationRespDto)RestResponseHelper.extractData((RestResponse)this.mergeBillInfoApi.cancelMergeBill(cancelTobInvoiceParams.getInvoiceTradeNos()));
        return new RestResponse((Object)batchOperationRespDto);
    }

    @Override
    public RestResponse<PageInfo<TobInvoiceinfoVO>> getTobInvoiceInfo(@ApiParam(value="") @Valid @RequestBody(required=false) GetTobInvoiceInfoParams getTobInvoiceInfoParams) {
        OrderMergeBillInfoQueryDto queryDto = new OrderMergeBillInfoQueryDto();
        CubeBeanUtils.copyProperties((Object)queryDto, (Object)getTobInvoiceInfoParams, (String[])new String[0]);
        logger.info("\u83b7\u53d6\u5408\u5e76\u53d1\u7968\u884c\u660e\u7ec6\u5217\u8868:{}", (Object)JSON.toJSONString((Object)queryDto));
        PageInfo mergeBillInfoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.mergeBillInfoApi.getOrderMergeBillInfoPage(queryDto));
        PageInfo pageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)pageInfo, (Object)mergeBillInfoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        if (CollectionUtils.isEmpty((Collection)mergeBillInfoPageInfo.getList())) {
            return new RestResponse((Object)pageInfo);
        }
        List list = mergeBillInfoPageInfo.getList().stream().map(info -> {
            TobInvoiceinfoVO tobInvoiceinfoVO = new TobInvoiceinfoVO();
            this.mergeBillInfoToResp((OrderMergeBillInfoRespDto)info, tobInvoiceinfoVO);
            return tobInvoiceinfoVO;
        }).collect(Collectors.toList());
        pageInfo.setList(list);
        return new RestResponse((Object)pageInfo);
    }

    public void mergeBillInfoToResp(OrderMergeBillInfoRespDto respDto, TobInvoiceinfoVO vo) {
        CubeBeanUtils.copyProperties((Object)vo, (Object)respDto, (String[])new String[0]);
        vo.setAmount(null != respDto.getAmount() ? respDto.getAmount().stripTrailingZeros().toPlainString() : null);
        vo.setTaxAmount(null != respDto.getTaxAmount() ? respDto.getTaxAmount().stripTrailingZeros().toPlainString() : null);
        vo.setItemId(ParamConverter.convertToString((Object)respDto.getItemId()));
        vo.setShopId(ParamConverter.convertToString((Object)respDto.getShopId()));
        vo.setQuantity(null != respDto.getQuantity() ? respDto.getQuantity().stripTrailingZeros().toPlainString() : null);
        vo.setTaxRate(null != respDto.getTaxRate() ? respDto.getTaxRate().stripTrailingZeros().toPlainString() : null);
        if ("after".equals(respDto.getType())) {
            vo.setOrderType(null != respDto.getOrderType() ? respDto.getOrderType().toUpperCase() : null);
        }
    }

    @Override
    public RestResponse<Object> redFlushReopenTobInvoice(@ApiParam(value="") @Valid @RequestBody(required=false) RedFlushReopenTobInvoiceParams redFlushReopenTobInvoiceParams) {
        OrderMergeRedAgainBillReqDto reqDto = new OrderMergeRedAgainBillReqDto();
        CubeBeanUtils.copyProperties((Object)reqDto, (Object)redFlushReopenTobInvoiceParams, (String[])new String[0]);
        reqDto.setBillFlowNo(redFlushReopenTobInvoiceParams.getInvoiceTradeNo());
        logger.info("\u5408\u5e76\u5f00\u7968\u7ea2\u51b2\u5e76\u91cd\u5f00:{}", (Object)JSON.toJSONString((Object)reqDto));
        RestResponseHelper.extractData((RestResponse)this.mergeBillInfoApi.redAgainMergeBill(reqDto));
        return new RestResponse();
    }

    @Override
    public RestResponse<Object> tobInvoiceSymbol(@ApiParam(value="") @Valid @RequestBody(required=false) UpdateTobInvoiceFlag updateTobInvoiceFlag) {
        logger.info("\u624b\u52a8\u66f4\u65b0B\u7aef\u5f00\u7968\u6807\u8bc6:{}", (Object)JSON.toJSONString((Object)updateTobInvoiceFlag));
        AssertUtil.isTrue(null != updateTobInvoiceFlag.getOrderTypeCode(), "\u6b63\u9006\u5411\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)updateTobInvoiceFlag.getOrderDto()), "\u5355\u636e\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        if (1 == updateTobInvoiceFlag.getOrderTypeCode()) {
            List list = updateTobInvoiceFlag.getOrderDto().stream().map(UpdateTobInvoiceFlagInfo::getOrderNo).distinct().collect(Collectors.toList());
            BatchUpdateInvoiceDto batchUpdateInvoiceDto = new BatchUpdateInvoiceDto();
            batchUpdateInvoiceDto.setAfterSaleOrderNoList(list);
            batchUpdateInvoiceDto.setInvoice(AfterInvoiceFlagEnum.YES_INVOICE.getCode());
            this.dgAfterSaleOrderApiProxy.batchUpdateInvoiceByAfterSaleOrderNos(batchUpdateInvoiceDto);
        } else {
            updateTobInvoiceFlag.getOrderDto().forEach(order -> {
                SaleOrderBillRecordPageReqDto saleOrderBillRecordQueryReqDto = new SaleOrderBillRecordPageReqDto();
                saleOrderBillRecordQueryReqDto.setSaleOrderNo(order.getOrderNo());
                List saleOrderBillRecordRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.saleOrderBillRecordQueryApi.queryByReqDto(saleOrderBillRecordQueryReqDto));
                if (CollectionUtils.isNotEmpty((Collection)saleOrderBillRecordRespDtos)) {
                    saleOrderBillRecordRespDtos.forEach(info -> {
                        SaleOrderBillRecordReqDto saleOrderBillRecordReqDto = new SaleOrderBillRecordReqDto();
                        saleOrderBillRecordReqDto.setId(info.getId());
                        saleOrderBillRecordReqDto.setWhetherInvoice(SaleOrderInvoiceStateEnum.INVOICED.getCode());
                        this.saleOrderBillRecordApiProxy.modifySaleOrderBillRecord(saleOrderBillRecordReqDto);
                    });
                } else {
                    this.addOrderBillInfo((UpdateTobInvoiceFlagInfo)order);
                }
            });
        }
        return new RestResponse();
    }

    public void addOrderBillInfo(UpdateTobInvoiceFlagInfo updateTobInvoiceFlagInfo) {
        SaleOrderBillRecordReqDto saleOrderBillRecordReqDto = new SaleOrderBillRecordReqDto();
        saleOrderBillRecordReqDto.setSaleOrderNo(updateTobInvoiceFlagInfo.getOrderNo());
        saleOrderBillRecordReqDto.setPlatformOrderNo(updateTobInvoiceFlagInfo.getPlatformOrderNo());
        saleOrderBillRecordReqDto.setWhetherInvoice(SaleOrderInvoiceStateEnum.INVOICED.getCode());
        this.saleOrderBillRecordApiProxy.addSaleOrderBillRecord(saleOrderBillRecordReqDto);
    }

    @Override
    public RestResponse<PageInfo<InvoiceOrderInfoVO>> invoiceOrderInfo(@ApiParam(value="") @Valid @RequestBody(required=false) InvoiceOrderInfoQuery query) {
        BillOrderItemQueryDto queryDto = new BillOrderItemQueryDto();
        queryDto.setPageNum(query.getPageNum());
        queryDto.setPageSize(query.getPageSize());
        queryDto.setBillFlowNo(query.getInvoiceTradeNo());
        logger.info("\u5f00\u7968\u8ba2\u5355\u660e\u7ec6\u67e5\u8be2\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)queryDto));
        PageInfo billOrderItemRespDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.billOrderItemQueryApi.queryByPage(queryDto));
        PageInfo pageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)pageInfo, (Object)billOrderItemRespDtoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        if (CollectionUtils.isEmpty((Collection)billOrderItemRespDtoPageInfo.getList())) {
            return new RestResponse((Object)pageInfo);
        }
        List list = billOrderItemRespDtoPageInfo.getList().stream().map(info -> {
            InvoiceOrderInfoVO invoiceOrderInfoVO = new InvoiceOrderInfoVO();
            this.getInvoiceOrderInfoVO(invoiceOrderInfoVO, (BillOrderItemRespDto)info);
            return invoiceOrderInfoVO;
        }).collect(Collectors.toList());
        pageInfo.setList(list);
        return new RestResponse((Object)pageInfo);
    }

    public void getInvoiceOrderInfoVO(InvoiceOrderInfoVO vo, BillOrderItemRespDto respDto) {
        CubeBeanUtils.copyProperties((Object)vo, (Object)respDto, (String[])new String[0]);
        vo.setAmount(null != respDto.getAmount() ? respDto.getAmount().stripTrailingZeros().toPlainString() : null);
        vo.setTaxAmount(null != respDto.getTaxAmount() ? respDto.getTaxAmount().stripTrailingZeros().toPlainString() : null);
        vo.setQuantity(null != respDto.getQuantity() ? respDto.getQuantity().stripTrailingZeros().toPlainString() : null);
        vo.setTaxRate(null != respDto.getTaxRate() ? respDto.getTaxRate().stripTrailingZeros().toPlainString() : null);
        if ("after".equals(respDto.getType())) {
            vo.setOrderType(null != respDto.getOrderType() ? respDto.getOrderType().toUpperCase() : null);
        }
        vo.setType(respDto.getType());
        vo.setCreateTime(null != respDto.getCreateTime() ? DateUtil.format((Date)respDto.getCreateTime(), (String)"yyyy-MM-dd HH:mm:ss") : null);
        vo.setUpdateTime(null != respDto.getUpdateTime() ? DateUtil.format((Date)respDto.getUpdateTime(), (String)"yyyy-MM-dd HH:mm:ss") : null);
        vo.setCreatePerson(respDto.getCreatePerson());
        vo.setUpdatePerson(respDto.getUpdatePerson());
        vo.setId(respDto.getId());
    }

    public void addBillInfoParam(AddTocInvoiceParams addTocInvoiceParams, BillInfoReqDto billInfoReqDto) {
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)addTocInvoiceParams.getIsRelatedOrder()), "\u662f\u5426\u5173\u8054\u8ba2\u5355\u4e0d\u80fd\u4e3a\u7a7a");
        if ("0".equals(addTocInvoiceParams.getIsRelatedOrder())) {
            billInfoReqDto.setRelOrder(Boolean.valueOf(false));
            AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)addTocInvoiceParams.getInvoiceEntityId()), "\u672a\u5173\u8054\u8ba2\u5355,\u5f00\u7968\u4e3b\u9898\u4e0d\u80fd\u4e3a\u7a7a");
            billInfoReqDto.setEntityId(ParamConverter.convertToLong((Object)addTocInvoiceParams.getInvoiceEntityId()));
        } else {
            billInfoReqDto.setRelOrder(Boolean.valueOf(true));
            AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)addTocInvoiceParams.getPlatformOrderNo()), "\u5173\u8054\u8ba2\u5355,\u5e73\u53f0\u8ba2\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            billInfoReqDto.setPlatformOrderNo(addTocInvoiceParams.getPlatformOrderNo());
        }
        billInfoReqDto.setInvoiceType(addTocInvoiceParams.getInvoiceType());
        billInfoReqDto.setTitleType(addTocInvoiceParams.getInvoiceHeaderType());
        billInfoReqDto.setBillTitle(addTocInvoiceParams.getInvoiceHeader());
        billInfoReqDto.setTaxesCode(addTocInvoiceParams.getTaxpayerIdentificationNo());
        billInfoReqDto.setRegisteredAddress(addTocInvoiceParams.getRegisterAddress());
        billInfoReqDto.setRegisteredPhone(addTocInvoiceParams.getRegisterPhone());
        billInfoReqDto.setBank(addTocInvoiceParams.getDepositBank());
        billInfoReqDto.setBankAccount(addTocInvoiceParams.getBankAccountNo());
        billInfoReqDto.setBillPersonName(addTocInvoiceParams.getReceiveName());
        billInfoReqDto.setBillPersonPhone(addTocInvoiceParams.getReceivePhone());
        billInfoReqDto.setBillAddress(addTocInvoiceParams.getReceiveAddress());
        billInfoReqDto.setMailbox(addTocInvoiceParams.getReceiveInvoiceEmail());
        billInfoReqDto.setPhone(addTocInvoiceParams.getReceiveInvoicePhone());
        billInfoReqDto.setFileUrl(addTocInvoiceParams.getFileUrl());
        billInfoReqDto.setInvoiceRemarks(StrUtil.isNotBlank((CharSequence)addTocInvoiceParams.getRemark()) ? addTocInvoiceParams.getRemark() : addTocInvoiceParams.getInvoiceRemark());
        if (CollectionUtils.isNotEmpty((Collection)addTocInvoiceParams.getGoodsList())) {
            ArrayList billItemReqDtoList = new ArrayList();
            addTocInvoiceParams.getGoodsList().forEach(good -> {
                BillItemReqDto billItemReqDto = new BillItemReqDto();
                billItemReqDto.setItemName(good.getGoodsName());
                billItemReqDto.setTaxClassificationCode(good.getTaxClassificationCode());
                billItemReqDto.setTaxRate(good.getTaxRate());
                billItemReqDto.setClinchDealAmount(good.getRealPayAmount());
                billItemReqDto.setAmount(good.getRealPayAmount());
                billItemReqDto.setUnitPrice(good.getRealPayAmount().divide(good.getGoodsNum(), 2).setScale(2, 4));
                billItemReqDto.setTaxAmount(good.getRealPayAmount().multiply(good.getTaxRate()));
                billItemReqDto.setQuantity(good.getGoodsNum());
                billItemReqDto.setSpecification(good.getGoodsCode());
                billItemReqDto.setUnit(good.getUnitName());
                billItemReqDto.setBillLineItemName(good.getGoodsName());
                billItemReqDtoList.add(billItemReqDto);
            });
            billInfoReqDto.setBillItemReqDtoList(billItemReqDtoList);
        }
    }
}

