/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.mgmt.service.impl;

import cn.afterturn.easypoi.excel.entity.result.ExcelImportResult;
import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.map.MapUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.rest.RestResponse;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yundt.boot.center.data.dto.dto.DictDto;
import com.yundt.boot.center.data.dto.dto.DictValueDto;
import com.yundt.boot.center.data.dto.response.AreaTreeRespExtDto;
import com.yundt.boot.center.data.proxy.query.IDictQueryApiProxy;
import com.yunxi.dg.base.center.customer.dto.request.DgCsShipmentEnterprisePageReqDto;
import com.yunxi.dg.base.center.customer.dto.response.DgCsShipmentEnterpriseRespDto;
import com.yunxi.dg.base.center.customer.proxy.query.IDgCsShipmentEnterpriseQueryApiProxy;
import com.yunxi.dg.base.center.inventory.dto.entity.LogicWarehousePageReqDto;
import com.yunxi.dg.base.center.inventory.dto.entity.LogicWarehouseRespDto;
import com.yunxi.dg.base.center.inventory.proxy.warehouse.ILogicWarehouseApiProxy;
import com.yunxi.dg.base.center.trade.dto.aftersale.DgAfterSaleOrderItemModifyReqDto;
import com.yunxi.dg.base.center.trade.dto.aftersale.DgAfterSaleOrderItemSnRecordDto;
import com.yunxi.dg.base.center.trade.dto.aftersale.DgBizAfterSaleOrderReqDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgAfterTypeRecordDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgAfterTypeRecordPageReqDto;
import com.yunxi.dg.base.center.trade.proxy.aftersale.IDgAfterSaleOrderApiProxy;
import com.yunxi.dg.base.center.trade.proxy.aftersale.IDgAfterTypeRecordApiProxy;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import com.yunxi.dg.base.mgmt.application.rpc.dto.entity.ShopReturnWarehouseConfigDto;
import com.yunxi.dg.base.mgmt.application.rpc.dto.entity.ShopReturnWarehouseConfigPageReqDto;
import com.yunxi.dg.base.mgmt.application.rpc.dto.request.AreaQueryExtReqDto;
import com.yunxi.dg.base.mgmt.application.rpc.dto.request.DgShopQueryReqDto;
import com.yunxi.dg.base.mgmt.application.rpc.dto.request.ItemQueryDgReqDto;
import com.yunxi.dg.base.mgmt.application.rpc.dto.response.DgItemSkuDetailRespDto;
import com.yunxi.dg.base.mgmt.application.rpc.dto.response.DgItemSkuRespDto;
import com.yunxi.dg.base.mgmt.application.rpc.dto.response.DgShopRespDto;
import com.yunxi.dg.base.mgmt.application.rpc.proxy.query.IAreaExtQueryApiProxy;
import com.yunxi.dg.base.mgmt.application.rpc.proxy.query.IDgShopQueryApiProxy;
import com.yunxi.dg.base.mgmt.application.rpc.proxy.shop.IShopReturnWarehouseConfigApiProxy;
import com.yunxi.dg.base.mgmt.application.rpc.proxy.sku.IItemSkuDgQueryApiProxy;
import com.yunxi.dg.base.ocs.mgmt.application.dto.enums.FileModeTypeEnum;
import com.yunxi.dg.base.ocs.mgmt.application.dto.enums.FileOperationStatusEnum;
import com.yunxi.dg.base.ocs.mgmt.application.dto.request.AfterBusinessTypeDto;
import com.yunxi.dg.base.ocs.mgmt.application.dto.request.AfterSaleNoSourceOrderImportDto;
import com.yunxi.dg.base.poi.dto.ImportBaseModeDto;
import com.yunxi.dg.base.poi.dto.ImportFileOperationCommonReqDto;
import com.yunxi.dg.base.poi.dto.ImportFileOperationCommonRespDto;
import com.yunxi.dg.base.poi.service.AbstractBaseFileOperationCommonService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="AbstractBaseFileOperationCommonService_after_no_source_order_import")
public class AfterSaleNoSourceOrderCommonServiceImpl
extends AbstractBaseFileOperationCommonService {
    private static final Logger log = LoggerFactory.getLogger(AfterSaleNoSourceOrderCommonServiceImpl.class);
    @Resource
    private IItemSkuDgQueryApiProxy itemSkuDgQueryApiProxy;
    @Resource
    private IDgShopQueryApiProxy shopQueryApiProxy;
    @Autowired
    private IDictQueryApiProxy dictQueryApiProxy;
    @Resource
    private IDgCsShipmentEnterpriseQueryApiProxy shipmentEnterpriseQueryApiProxy;
    @Resource(name="warehouseApiProxy")
    private ILogicWarehouseApiProxy logicWarehouseApiProxy;
    @Resource
    private IAreaExtQueryApiProxy areaExtQueryApiProxy;
    @Resource
    private IDgAfterSaleOrderApiProxy dgAfterSaleOrderApiProxy;
    @Resource
    private IDgAfterTypeRecordApiProxy dgAfterTypeRecordApiProxy;
    @Resource
    private IShopReturnWarehouseConfigApiProxy shopReturnWarehouseConfigApiProxy;
    public static Map<String, String> areaNameDataMap = new ConcurrentHashMap<String, String>();
    public static final String BIZ_MODEL = "THTK";
    public static final String BIZ_TYPE = "\u666e\u901a\u9000\u8d27";

    public Object verifyImportFileOperationCommon(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto) {
        log.info("\u552e\u540e\u65e0\u539f\u5355\u5bfc\u5165\u6570\u636e\uff1a{}", (Object)JSONObject.toJSONString(result));
        ArrayList passList = Lists.newArrayList();
        List resultList = BeanUtil.copyToList((Collection)result.getList(), AfterSaleNoSourceOrderImportDto.class);
        if (CollectionUtil.isEmpty((Collection)resultList)) {
            respDto.setErrorMsg("\u5bfc\u5165\u5185\u5bb9\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01");
            respDto.setStatus(FileOperationStatusEnum.IMPORT_ERROR.getCode());
            return new ArrayList();
        }
        if (resultList.size() > 2000) {
            respDto.setErrorMsg("\u6279\u91cf\u5bfc\u5165\u4e0d\u652f\u6301\u8d85\u8fc72000\u884c");
            respDto.setStatus(FileOperationStatusEnum.IMPORT_ERROR.getCode());
            return new ArrayList();
        }
        Set skuCodes = resultList.stream().map(AfterSaleNoSourceOrderImportDto::getSkuCode).collect(Collectors.toSet());
        Set<String> warehouseCodes = resultList.stream().map(AfterSaleNoSourceOrderImportDto::getReturnWarehouseCode).collect(Collectors.toSet());
        Set shopCodes = resultList.stream().map(AfterSaleNoSourceOrderImportDto::getShopCode).collect(Collectors.toSet());
        ArrayList<String> shopCodeList = new ArrayList<String>(shopCodes);
        Map<String, DgItemSkuDetailRespDto> skuInfoMap = this.getSkuInfoByCodes(new ArrayList<String>(skuCodes));
        Map<String, DgShopRespDto> shopInfoMap = this.getShop(shopCodeList);
        Map<String, List<LogicWarehouseRespDto>> warehouseByCodeMap = this.getWarehouseByCode(warehouseCodes);
        Map<String, List<ShopReturnWarehouseConfigDto>> shopReturnWarehouseConfigMap = this.getReturnWarehouseList(shopCodeList);
        for (AfterSaleNoSourceOrderImportDto importDto : resultList) {
            boolean isPass = this.checkAndInitParam(importDto, skuInfoMap, shopInfoMap, warehouseByCodeMap, shopReturnWarehouseConfigMap);
            if (isPass) {
                importDto.setErrorMsg(String.format("\u7b2c%s\u884c\u6570\u636e\u6709\u8bef,%s", importDto.getRowNum() + FileModeTypeEnum.getInstance((String)commonReqDto.getKey()).getHeadRows(), importDto.getErrorMsg()));
                respDto.getErrorDetails().add(importDto);
                continue;
            }
            passList.add(importDto);
        }
        respDto.setDetails((List)passList);
        return passList;
    }

    private Map<String, String> getDict(String groupCode, String code) {
        DictDto dictDto = (DictDto)RestResponseHelper.extractData((RestResponse)this.dictQueryApiProxy.queryByGroupCodeAndCode(groupCode, code));
        if (Objects.isNull(dictDto) || CollectionUtil.isEmpty((Collection)dictDto.getDictValueList())) {
            return MapUtil.empty();
        }
        return dictDto.getDictValueList().stream().collect(Collectors.toMap(DictValueDto::getLabel, DictValueDto::getValue, (v1, v2) -> v2));
    }

    public boolean checkAndInitParam(AfterSaleNoSourceOrderImportDto importDto, Map<String, DgItemSkuDetailRespDto> skuInfoMap, Map<String, DgShopRespDto> shopInfoMap, Map<String, List<LogicWarehouseRespDto>> warehouseByCodeMap, Map<String, List<ShopReturnWarehouseConfigDto>> shopReturnWarehouseConfigMap) {
        boolean allowSmallTypeText;
        StringBuffer errorMsg = new StringBuffer();
        DgItemSkuDetailRespDto dgItemSkuDetailRespDto = skuInfoMap.get(importDto.getSkuCode());
        if (Objects.isNull(dgItemSkuDetailRespDto)) {
            errorMsg.append("\u5546\u54c1\u4e0d\u5b58\u5728;");
        } else {
            importDto.setSkuName(dgItemSkuDetailRespDto.getSkuName());
            importDto.setItemId(dgItemSkuDetailRespDto.getItemId());
            importDto.setItemCode(dgItemSkuDetailRespDto.getItemCode());
            importDto.setItemName(dgItemSkuDetailRespDto.getItemName());
            importDto.setVolume(dgItemSkuDetailRespDto.getVolume());
            importDto.setWeight(dgItemSkuDetailRespDto.getGrossWeight());
        }
        DgShopRespDto dgShopRespDto = shopInfoMap.get(importDto.getShopCode());
        if (Objects.isNull(dgShopRespDto)) {
            errorMsg.append("\u5e97\u94fa\u4e0d\u5b58\u5728;");
        } else if (Objects.isNull(dgShopRespDto.getStoreType())) {
            errorMsg.append("\u5e97\u94fa\u7c7b\u578b\u4e0d\u5b58\u5728");
        } else {
            importDto.setShopId(dgShopRespDto.getId());
            importDto.setShopName(dgShopRespDto.getStoreName());
        }
        List<LogicWarehouseRespDto> logicWarehouseRespDtoList = warehouseByCodeMap.get(importDto.getReturnWarehouseCode());
        if (CollectionUtil.isEmpty(logicWarehouseRespDtoList)) {
            errorMsg.append("\u9000\u8d27\u5165\u5e93\u4ed3\u4e0d\u5b58\u5728;");
        } else {
            LogicWarehouseRespDto logicWarehouseRespDto = logicWarehouseRespDtoList.get(0);
            log.info("\u4ed3\u5e93\u6821\u9a8c{}", (Object)JSONObject.toJSONString((Object)logicWarehouseRespDto));
            Optional.ofNullable(dgShopRespDto).map(DgShopRespDto::getStoreType).ifPresent(storeType -> {
                List<String> chooseWarehouseCodes = Arrays.asList("T0001", "T0002", "T0003");
                if (storeType == 4) {
                    List returnWarehouseConfigList = (List)shopReturnWarehouseConfigMap.get(dgShopRespDto.getStoreCode());
                    if (CollectionUtil.isEmpty((Collection)returnWarehouseConfigList)) {
                        errorMsg.append("\u5e97\u94fa\u9000\u8d27\u4ed3\u672a\u914d\u7f6e");
                    } else if (returnWarehouseConfigList.stream().noneMatch(config -> Objects.equals(config.getReturnWarehouseCode(), importDto.getReturnWarehouseCode()))) {
                        errorMsg.append("\u9000\u8d27\u4ed3\u672a\u5728\u914d\u7f6e\u7684\u5e97\u94fa\u9000\u8d27\u4ed3\u914d\u7f6e\u91cc");
                    } else {
                        importDto.setReturnWarehouseId(logicWarehouseRespDto.getId());
                        importDto.setReturnWarehouseName(logicWarehouseRespDto.getWarehouseName());
                    }
                } else if (chooseWarehouseCodes.contains(importDto.getReturnWarehouseCode())) {
                    importDto.setReturnWarehouseId(logicWarehouseRespDto.getId());
                    importDto.setReturnWarehouseName(logicWarehouseRespDto.getWarehouseName());
                } else {
                    errorMsg.append("\u975e\u5e73\u53f0\u5382\u9001\u7684\u5e97\u94fa\u53ea\u5141\u8bb8\u9009\u62e9\u3010T0001/T0002/T0003\u3011");
                }
            });
        }
        if (StringUtils.isNotBlank((CharSequence)importDto.getReturnProvinceName())) {
            String province = this.getAreaCodeByName(importDto.getReturnProvinceName());
            if (Objects.isNull(province)) {
                errorMsg.append("\u7701\u4e0d\u5b58\u5728;");
            } else {
                importDto.setReturnProvinceCode(province);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)importDto.getReturnCityName())) {
            String city = this.getAreaCodeByName(importDto.getReturnCityName());
            if (Objects.isNull(city)) {
                errorMsg.append("\u5e02\u4e0d\u5b58\u5728;");
            } else {
                importDto.setReturnCityCode(city);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)importDto.getReturnCountyName())) {
            String county = this.getAreaCodeByName(importDto.getReturnCountyName());
            if (Objects.isNull(county)) {
                errorMsg.append("\u533a\u4e0d\u5b58\u5728;");
            } else {
                importDto.setReturnCountyCode(county);
            }
        }
        boolean bl = allowSmallTypeText = StringUtils.isBlank((CharSequence)importDto.getIsSmallRefund()) || "\u662f".equals(importDto.getIsSmallRefund().trim()) || "\u5426".equals(importDto.getIsSmallRefund().trim());
        if (!allowSmallTypeText) {
            errorMsg.append("\u662f\u5426\u5c0f\u989d\u4ec5\u5141\u8bb8\u586b\u5199[\u662f/\u5426];");
        }
        importDto.setErrorMsg(errorMsg.toString());
        return errorMsg.length() > 0;
    }

    public void callBackImportFileOperationCommonAsync(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto, Object object) {
        DgAfterTypeRecordDto afterTypeRecordDto;
        log.info("\u552e\u540e\u65e0\u539f\u5355-callBackImportFileOperationCommonAsync-->result:{}", (Object)JSON.toJSONString(result));
        List passList = (List)object;
        if (CollectionUtil.isEmpty((Collection)passList)) {
            respDto.setStatus(FileOperationStatusEnum.IMPORT_ERROR.getCode());
            return;
        }
        if (!respDto.getErrorDetails().isEmpty()) {
            respDto.setStatus(FileOperationStatusEnum.IMPORT_PARTIAL_SUCCESS.getCode());
        }
        if ((afterTypeRecordDto = this.getAfterTypeMap().get(BIZ_MODEL)) == null) {
            respDto.setStatus(FileOperationStatusEnum.IMPORT_ERROR.getCode());
            return;
        }
        AfterBusinessTypeDto typeDto = new AfterBusinessTypeDto();
        typeDto.setBizType(this.getDict("AJE_RETURN_BIZ_TYPE", "AJE_RETURN_BIZ_TYPE").get(BIZ_TYPE));
        typeDto.setAfterBusinessTypeCode(afterTypeRecordDto.getAfterBusinessTypeCode());
        typeDto.setAfterBusinessTypeName(afterTypeRecordDto.getAfterBusinessTypeName());
        typeDto.setIfInvoice(afterTypeRecordDto.getIfInvoice());
        typeDto.setIfRecord(afterTypeRecordDto.getIfRecord());
        Map<String, List<AfterSaleNoSourceOrderImportDto>> orderMap = passList.stream().collect(Collectors.groupingBy(AfterSaleNoSourceOrderImportDto::getOrderUniqueKey));
        for (String orderKey : orderMap.keySet()) {
            List<AfterSaleNoSourceOrderImportDto> afterSaleNoSourceOrderImportDtos = this.processSameSkuCode(orderMap.get(orderKey));
            AfterSaleNoSourceOrderImportDto dto = afterSaleNoSourceOrderImportDtos.get(0);
            DgBizAfterSaleOrderReqDto reqDto = this.buildDgBizAfterSaleOrderReqDto(afterSaleNoSourceOrderImportDtos, typeDto);
            this.saveOrder(respDto, reqDto, dto);
            afterSaleNoSourceOrderImportDtos.forEach(giftDto -> giftDto.setErrorMsg(dto.getErrorMsg()));
        }
    }

    public List<AfterSaleNoSourceOrderImportDto> processSameSkuCode(List<AfterSaleNoSourceOrderImportDto> list) {
        return list.stream().collect(Collectors.toMap(AfterSaleNoSourceOrderImportDto::getSkuCode, Function.identity(), (o1, o2) -> {
            o1.setItemNum(Integer.valueOf(o1.getItemNum() + o2.getItemNum()));
            o1.setRefundAmount(o1.getRefundAmount().add(o2.getRefundAmount()));
            if (StringUtils.isNotBlank((CharSequence)o2.getSnCode()) && StringUtils.isBlank((CharSequence)o1.getSnCode())) {
                o1.setSnCode(o2.getSnCode());
            } else if (StringUtils.isNotBlank((CharSequence)o2.getSnCode())) {
                o1.setSnCode(String.join((CharSequence)",", o1.getSnCode(), o2.getSnCode()));
            }
            return o1;
        })).values().stream().collect(Collectors.toList());
    }

    private void saveOrder(ImportFileOperationCommonRespDto respDto, DgBizAfterSaleOrderReqDto reqDto, AfterSaleNoSourceOrderImportDto dto) {
        try {
            log.info("createAfterSale\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
            RestResponseHelper.extractData((RestResponse)this.dgAfterSaleOrderApiProxy.createAfterSale(BIZ_MODEL, reqDto));
        }
        catch (Exception e) {
            log.error("\u5bfc\u5165\u552e\u540e\u65e0\u539f\u5355\uff0c\u4fdd\u5b58\u5931\u8d25 {}", (Object)reqDto.getPlatformOrderNo(), (Object)e);
            this.setErrorMsg(dto, "\u5bfc\u5165\u552e\u540e\u65e0\u539f\u5355\u4fdd\u5b58\u5931\u8d25\uff1a" + e.getMessage());
            respDto.getErrorDetails().add(dto);
        }
    }

    public DgBizAfterSaleOrderReqDto buildDgBizAfterSaleOrderReqDto(List<AfterSaleNoSourceOrderImportDto> afterSaleNoSourceOrderImportDtos, AfterBusinessTypeDto typeDto) {
        AfterSaleNoSourceOrderImportDto afterSaleNoSourceOrderImportDto = afterSaleNoSourceOrderImportDtos.get(0);
        DgBizAfterSaleOrderReqDto reqDto = new DgBizAfterSaleOrderReqDto();
        BeanUtil.copyProperties((Object)afterSaleNoSourceOrderImportDto, (Object)reqDto, (String[])new String[0]);
        reqDto.setBizDate(new Date());
        reqDto.setBizType(typeDto.getBizType());
        reqDto.setChannelCode("INNER");
        reqDto.setAfterSaleOrderType(BIZ_MODEL);
        reqDto.setAfterBusinessTypeCode(typeDto.getAfterBusinessTypeCode());
        reqDto.setAfterBusinessTypeName(typeDto.getAfterBusinessTypeName());
        reqDto.setIfRecord(typeDto.getIfRecord());
        reqDto.setIfInvoice(typeDto.getIfInvoice());
        reqDto.setPlatformApplyRefundType("REFUND_RETURN");
        reqDto.setStatus("WAIT_AUDIT");
        reqDto.setRelateToPlatformOrder(Integer.valueOf(1));
        reqDto.setOrderSource(Integer.valueOf(0));
        reqDto.setRefundType("\u662f".equals(afterSaleNoSourceOrderImportDto.getIsSmallRefund()) ? "small_refund" : null);
        BigDecimal refundFee = BigDecimal.ZERO;
        ArrayList<DgAfterSaleOrderItemModifyReqDto> afterSaleOrderItemReqDtoList = new ArrayList<DgAfterSaleOrderItemModifyReqDto>();
        for (AfterSaleNoSourceOrderImportDto detail : afterSaleNoSourceOrderImportDtos) {
            DgAfterSaleOrderItemModifyReqDto modifyReqDto = new DgAfterSaleOrderItemModifyReqDto();
            BeanUtil.copyProperties((Object)detail, (Object)modifyReqDto, (String[])new String[0]);
            modifyReqDto.setAfterSaleOrderItemType(Integer.valueOf(0));
            refundFee = refundFee.add(detail.getRefundAmount());
            if (StringUtils.isNotBlank((CharSequence)detail.getSnCode())) {
                DgAfterSaleOrderItemSnRecordDto recordDto = new DgAfterSaleOrderItemSnRecordDto();
                recordDto.setSnCode(detail.getSnCode());
                ArrayList<DgAfterSaleOrderItemSnRecordDto> list = new ArrayList<DgAfterSaleOrderItemSnRecordDto>();
                list.add(recordDto);
                modifyReqDto.setSnRecordDtoList(list);
            }
            afterSaleOrderItemReqDtoList.add(modifyReqDto);
        }
        reqDto.setRefundFee(refundFee);
        reqDto.setAfterSaleOrderItemReqDtoList(afterSaleOrderItemReqDtoList);
        return reqDto;
    }

    private void setErrorMsg(AfterSaleNoSourceOrderImportDto dto, String msg) {
        dto.setErrorMsg(StringUtils.isBlank((CharSequence)dto.getErrorMsg()) ? String.format("\u7b2c%s\u884c\u6570\u636e\u6709\u8bef\uff0c%s", dto.getRowNum(), msg) : dto.getErrorMsg() + ";" + msg);
    }

    private Map<String, DgItemSkuDetailRespDto> getSkuInfoByCodes(List<String> skuCodes) {
        ItemQueryDgReqDto skuReqDto = new ItemQueryDgReqDto();
        skuReqDto.setSkuCodes(skuCodes);
        return ((List)this.itemSkuDgQueryApiProxy.querySkuList(skuReqDto).getData()).stream().collect(Collectors.toMap(DgItemSkuRespDto::getSkuCode, Function.identity()));
    }

    private Map<String, DgShopRespDto> getShop(List<String> shopCodes) {
        DgShopQueryReqDto reqDto = new DgShopQueryReqDto();
        reqDto.setStoreCodeList(shopCodes);
        reqDto.setStatusList((List)ListUtil.toList((Object[])new Integer[]{1}));
        List dgShopRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.shopQueryApiProxy.queryListShop(reqDto));
        if (Objects.isNull(dgShopRespDtos) || CollectionUtil.isEmpty((Collection)dgShopRespDtos)) {
            return MapUtil.empty();
        }
        return dgShopRespDtos.stream().collect(Collectors.toMap(DgShopRespDto::getStoreCode, Function.identity(), (v1, v2) -> v2));
    }

    private Map<String, DgCsShipmentEnterpriseRespDto> getShipmentEnterprise() {
        DgCsShipmentEnterprisePageReqDto reqDto = new DgCsShipmentEnterprisePageReqDto();
        reqDto.setStatusList((List)ListUtil.toList((Object[])new Integer[]{0}));
        reqDto.setPageSize(Integer.valueOf(1000));
        PageInfo pageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.shipmentEnterpriseQueryApiProxy.page(reqDto));
        if (Objects.isNull(pageInfo) || CollectionUtil.isEmpty((Collection)pageInfo.getList())) {
            return MapUtil.empty();
        }
        return pageInfo.getList().stream().collect(Collectors.toMap(DgCsShipmentEnterpriseRespDto::getName, Function.identity(), (v1, v2) -> v2));
    }

    private Map<String, DgAfterTypeRecordDto> getAfterTypeMap() {
        DgAfterTypeRecordPageReqDto reqDto = new DgAfterTypeRecordPageReqDto();
        reqDto.setPageSize(Integer.valueOf(1000));
        PageInfo pageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.dgAfterTypeRecordApiProxy.page(reqDto));
        if (Objects.isNull(pageInfo) || CollectionUtil.isEmpty((Collection)pageInfo.getList())) {
            return MapUtil.empty();
        }
        return pageInfo.getList().stream().collect(Collectors.toMap(DgAfterTypeRecordDto::getAfterTypeCode, Function.identity(), (v1, v2) -> v1));
    }

    private Map<String, List<LogicWarehouseRespDto>> getWarehouseByCode(Set<String> warehouseCodes) {
        if (CollectionUtil.isEmpty(warehouseCodes)) {
            return new HashMap<String, List<LogicWarehouseRespDto>>();
        }
        LogicWarehousePageReqDto reqDto = new LogicWarehousePageReqDto();
        reqDto.setWarehouseCodeList(new ArrayList<String>(warehouseCodes));
        reqDto.setPageSize(Integer.valueOf(2000));
        reqDto.setWarehouseStatus("enable");
        PageInfo pageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.logicWarehouseApiProxy.queryData(reqDto));
        if (Objects.isNull(pageInfo) || CollectionUtil.isEmpty((Collection)pageInfo.getList())) {
            return MapUtil.empty();
        }
        return pageInfo.getList().stream().filter(f -> StringUtils.isNotBlank((CharSequence)f.getWarehouseCode())).collect(Collectors.groupingBy(LogicWarehouseRespDto::getWarehouseCode));
    }

    private String getAreaCodeByName(String name) {
        if (areaNameDataMap.isEmpty()) {
            AreaQueryExtReqDto reqDto = new AreaQueryExtReqDto();
            reqDto.setLevelId(Integer.valueOf(3));
            List areaTreeRespExtDtos = (List)RestResponseHelper.extractData((RestResponse)this.areaExtQueryApiProxy.queryByTree(reqDto));
            if (CollectionUtil.isEmpty((Collection)areaTreeRespExtDtos)) {
                return null;
            }
            this.getAreaNameMap(areaTreeRespExtDtos);
        }
        return areaNameDataMap.get(name);
    }

    private void getAreaNameMap(List<AreaTreeRespExtDto> areaTreeRespExtDtos) {
        if (CollectionUtil.isEmpty(areaTreeRespExtDtos)) {
            return;
        }
        areaTreeRespExtDtos.forEach(dto -> {
            areaNameDataMap.put(dto.getName(), dto.getCode());
            this.getAreaNameMap(dto.getChildren());
        });
    }

    private Map<String, List<ShopReturnWarehouseConfigDto>> getReturnWarehouseList(List<String> shopCodeList) {
        ShopReturnWarehouseConfigPageReqDto reqDto = new ShopReturnWarehouseConfigPageReqDto();
        reqDto.setShopCodeList(shopCodeList);
        List list = (List)this.shopReturnWarehouseConfigApiProxy.queryList(reqDto).getData();
        if (CollectionUtil.isEmpty((Collection)list)) {
            return MapUtil.empty();
        }
        return list.stream().collect(Collectors.groupingBy(p -> p.getShopCode()));
    }
}

