/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.mgmt.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.huieryun.lock.api.ILockService;
import com.dtyunxi.huieryun.lock.api.Mutex;
import com.dtyunxi.rest.RestResponse;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.inventory.dto.entity.AdjustmentOrderDetailDto;
import com.yunxi.dg.base.center.inventory.dto.entity.AdjustmentOrderDto;
import com.yunxi.dg.base.center.inventory.proxy.business.IInventoryAdjustmentOrderApiProxy;
import com.yunxi.dg.base.commons.dto.BaseDto;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import com.yunxi.dg.base.mgmt.convert.InventoryTransactionConverter;
import com.yunxi.dg.base.mgmt.service.IInventoryTransactionService;
import com.yunxi.dg.base.ocs.mgmt.application.domain.entity.IInventoryTransactionDomain;
import com.yunxi.dg.base.ocs.mgmt.application.dto.inventory.InventoryTransactionDto;
import com.yunxi.dg.base.ocs.mgmt.application.dto.inventory.InventoryTransactionPageReqDto;
import com.yunxi.dg.base.ocs.mgmt.application.eo.InventoryTransactionEo;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class InventoryTransactionServiceImpl
extends BaseServiceImpl<InventoryTransactionDto, InventoryTransactionEo, IInventoryTransactionDomain>
implements IInventoryTransactionService {
    private static final Logger logger = LoggerFactory.getLogger(InventoryTransactionServiceImpl.class);
    @Resource
    private IInventoryAdjustmentOrderApiProxy inventoryAdjustmentOrderApiProxy;
    @Resource
    private ILockService lockService;

    public InventoryTransactionServiceImpl(IInventoryTransactionDomain domain) {
        super((IBaseDomain)domain);
    }

    public IConverter<InventoryTransactionDto, InventoryTransactionEo> converter() {
        return InventoryTransactionConverter.INSTANCE;
    }

    @Transactional(rollbackFor={Exception.class})
    public RestResponse<Integer> insertBatch(List<InventoryTransactionDto> dtoList) {
        logger.info("\u5e93\u5b58\u5f02\u52a8\u6279\u91cf\u65b0\u589e\uff1a{}", (Object)JSON.toJSONString(dtoList));
        for (InventoryTransactionDto dto : dtoList) {
            if (ObjectUtils.isNotEmpty((Object)this.checkRepeat(dto.getExternalOrderNo()))) {
                logger.error("\u5916\u90e8\u5355\u53f7\u5df2\u5b58\u5728\uff1a{}", (Object)dto.getExternalOrderNo());
                continue;
            }
            if (ObjectUtils.isEmpty((Object)dto.getStatus())) {
                dto.setStatus(Integer.valueOf(0));
            }
            super.insert((BaseDto)dto);
        }
        return new RestResponse((Object)dtoList.size());
    }

    public RestResponse<Long> insert(InventoryTransactionDto dto) {
        AssertUtils.isFalse((boolean)StringUtils.isBlank((CharSequence)dto.getExternalOrderNo()), (String)"\u5916\u90e8\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        if (ObjectUtils.isNotEmpty((Object)this.checkRepeat(dto.getExternalOrderNo()))) {
            throw new BizException("-1", "\u5916\u90e8\u5355\u53f7\u91cd\u590d\uff1a" + dto.getExternalOrderNo());
        }
        return super.insert((BaseDto)dto);
    }

    private InventoryTransactionEo checkRepeat(String externalOrderNo) {
        InventoryTransactionEo queryEo = new InventoryTransactionEo();
        queryEo.setExternalOrderNo(externalOrderNo);
        List inventoryTransactionEos = ((IInventoryTransactionDomain)this.domain).selectList((BaseEo)queryEo);
        if (CollectionUtil.isNotEmpty((Collection)inventoryTransactionEos)) {
            return (InventoryTransactionEo)inventoryTransactionEos.get(0);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void createInventoryAdjustment(Long id) {
        logger.info("\u751f\u6210\u5e93\u5b58\u8c03\u6574\u5355\uff08\u76d8\u76c8\u76d8\u4e8f\uff09\uff1a{}", (Object)id);
        InventoryTransactionEo inventoryTransactionEo = (InventoryTransactionEo)((IInventoryTransactionDomain)this.domain).selectByPrimaryKey(id);
        AssertUtils.isFalse((boolean)ObjectUtils.isEmpty((Object)inventoryTransactionEo), (String)("\u627e\u4e0d\u5230\u5e93\u5b58\u5f02\u52a8\u4fe1\u606f\uff1a" + id));
        Mutex mutex = null;
        try {
            mutex = this.lockService.lock("createInventoryAdjustment", inventoryTransactionEo.getExternalOrderNo(), 20, 20, TimeUnit.SECONDS);
            if (mutex == null) {
                throw new BizException("-1", "\u83b7\u53d6\u5206\u5e03\u5f0f\u9501\u5f02\u5e38");
            }
            AdjustmentOrderDto adjustmentOrderDto = (AdjustmentOrderDto)RestResponseHelper.extractData((RestResponse)this.inventoryAdjustmentOrderApiProxy.queryByAdjustmentNo(inventoryTransactionEo.getExternalOrderNo()));
            AssertUtils.isFalse((ObjectUtils.isNotEmpty((Object)adjustmentOrderDto) && ObjectUtils.isNotEmpty((Object)adjustmentOrderDto.getId()) ? 1 : 0) != 0, (String)("\u5df2\u5b58\u5728\u76d8\u76c8\u76d8\u4e8f\u5355\uff1a" + inventoryTransactionEo.getExternalOrderNo()));
            AdjustmentOrderDto orderDto = new AdjustmentOrderDto();
            orderDto.setAdjustmentNo(inventoryTransactionEo.getExternalOrderNo());
            orderDto.setAdjustmentType(null);
            orderDto.setOrderType("INVENTORY_ADJUSTMENT");
            orderDto.setBusinessType("adjustment_dish_order");
            orderDto.setRelevanceNo(null);
            orderDto.setSourceType(null);
            orderDto.setPreOrderNo(null);
            orderDto.setExternalOrderNo(inventoryTransactionEo.getExternalOrderNo());
            orderDto.setEvent("audit_success");
            orderDto.setPushSap(Integer.valueOf(0));
            orderDto.setPushWms(Integer.valueOf(0));
            orderDto.setWarehouseCode(inventoryTransactionEo.getWarehouseCode());
            orderDto.setWarehouseName(inventoryTransactionEo.getWarehouseName());
            orderDto.setOrganizationCode(inventoryTransactionEo.getOrgCode());
            orderDto.setBizDate(inventoryTransactionEo.getBizDate());
            orderDto.setHasHangup(false);
            orderDto.setAutoComplete(true);
            orderDto.setValidInventory(false);
            AdjustmentOrderDetailDto detailDto = new AdjustmentOrderDetailDto();
            detailDto.setAdjustmentNo(orderDto.getAdjustmentNo());
            detailDto.setSkuCode(inventoryTransactionEo.getSkuCode());
            detailDto.setSkuName(inventoryTransactionEo.getSkuName());
            if (inventoryTransactionEo.getChangeType() == 1) {
                detailDto.setChangeType("increase");
                detailDto.setChangeQuantity(inventoryTransactionEo.getChangeNum());
            } else {
                detailDto.setChangeType("decrease");
                detailDto.setChangeQuantity(inventoryTransactionEo.getChangeNum());
            }
            detailDto.setUnit(inventoryTransactionEo.getUnit());
            orderDto.setAdjustmentOrderDetailDtos((List)Lists.newArrayList((Object[])new AdjustmentOrderDetailDto[]{detailDto}));
            orderDto.setInventoryProperty("qualified");
            try {
                logger.info("\u8bf7\u6c42\u521b\u5efa\u76d8\u76c8\u76d8\u4e8f\u5355\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)orderDto));
                RestResponseHelper.extractData((RestResponse)this.inventoryAdjustmentOrderApiProxy.insert(orderDto));
                inventoryTransactionEo.setAdjustmentNo(orderDto.getAdjustmentNo());
                inventoryTransactionEo.setFailReason("");
                inventoryTransactionEo.setStatus(Integer.valueOf(1));
            }
            catch (Exception e) {
                inventoryTransactionEo.setStatus(Integer.valueOf(-1));
                inventoryTransactionEo.setFailReason(e.getMessage());
                logger.error("\u751f\u6210\u5e93\u5b58\u8c03\u6574\u5355\uff08\u76d8\u76c8\u76d8\u4e8f\uff09\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
                logger.error(e.getMessage(), (Throwable)e);
            }
            finally {
                ((IInventoryTransactionDomain)this.domain).update((BaseEo)inventoryTransactionEo);
            }
            if (mutex == null) return;
        }
        catch (Exception e) {
            try {
                logger.error(e.getMessage(), (Throwable)e);
                throw new BizException("-1", "\u751f\u6210\u5e93\u5b58\u76d8\u76c8\u76d8\u4e8f\u5355\u5f02\u5e38\uff1a" + e.getMessage());
            }
            catch (Throwable throwable) {
                if (mutex == null) throw throwable;
                this.lockService.unlock(mutex);
                throw throwable;
            }
        }
        this.lockService.unlock(mutex);
        return;
    }

    @Override
    public Integer dispose() {
        logger.info("\u5904\u7406\u5f85\u5904\u7406\u7684\u5e93\u5b58\u5f02\u52a8\u6570\u636e");
        InventoryTransactionDto queryParams = new InventoryTransactionDto();
        queryParams.setStatus(Integer.valueOf(0));
        int page = 1;
        int result = 0;
        PageInfo pageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)super.page((BaseDto)queryParams, Integer.valueOf(page), Integer.valueOf(1000)));
        while (ObjectUtils.isNotEmpty((Object)pageInfo) && CollectionUtil.isNotEmpty((Collection)pageInfo.getList())) {
            result += pageInfo.getList().size();
            pageInfo.getList().forEach(dto -> this.createInventoryAdjustment(dto.getId()));
            pageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)super.page((BaseDto)queryParams, Integer.valueOf(++page), Integer.valueOf(1000)));
        }
        return result;
    }

    @Override
    public PageInfo<InventoryTransactionDto> queryPage(InventoryTransactionPageReqDto dto) {
        ExtQueryChainWrapper sqlFilters = ((IInventoryTransactionDomain)this.domain).filter();
        if (Objects.nonNull(dto.getStatus())) {
            sqlFilters.eq((Object)"status", (Object)dto.getStatus());
        }
        if (CollectionUtil.isNotEmpty((Collection)dto.getOrderNos())) {
            sqlFilters.and(wrapper -> {
                QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)((QueryWrapper)wrapper.in((Object)"external_order_no", (Collection)dto.getOrderNos())).or()).in((Object)"adjustment_no", (Collection)dto.getOrderNos());
            });
        }
        if (Objects.nonNull(dto.getCreateTimeStart())) {
            sqlFilters.ge((Object)"create_time", (Object)dto.getCreateTimeStart());
        }
        if (Objects.nonNull(dto.getCreateTimeEnd())) {
            sqlFilters.le((Object)"create_time", (Object)dto.getCreateTimeEnd());
        }
        if (Objects.nonNull(dto.getBizDateStart())) {
            sqlFilters.ge((Object)"biz_date", (Object)dto.getBizDateStart());
        }
        if (Objects.nonNull(dto.getBizDateEnd())) {
            sqlFilters.le((Object)"biz_date", (Object)dto.getBizDateEnd());
        }
        if (CollectionUtil.isNotEmpty((Collection)dto.getChangeTypes())) {
            sqlFilters.in((Object)"change_type", (Collection)dto.getChangeTypes());
        }
        if (CollectionUtil.isNotEmpty((Collection)dto.getWarehouseCodes())) {
            sqlFilters.in((Object)"warehouse_code", (Collection)dto.getWarehouseCodes());
        }
        if (CollectionUtil.isNotEmpty((Collection)dto.getSkuCodes())) {
            sqlFilters.in((Object)"sku_code", (Collection)dto.getSkuCodes());
        }
        sqlFilters.last(" ORDER BY create_time DESC");
        PageInfo dtoPageInfo = new PageInfo();
        PageInfo eoPageInfo = sqlFilters.page(dto.getPageNum(), dto.getPageSize());
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        dtoPageInfo.setList(BeanUtil.copyToList((Collection)eoPageInfo.getList(), InventoryTransactionDto.class));
        return dtoPageInfo;
    }
}

