/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.mgmt.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.huieryun.log.RequestId;
import com.dtyunxi.rest.RestResponse;
import com.github.pagehelper.PageInfo;
import com.yundt.boot.center.data.dto.dto.DictDto;
import com.yundt.boot.center.data.proxy.query.IDictQueryApiProxy;
import com.yunxi.dg.base.center.inventory.dto.entity.InOutResultOrderDto;
import com.yunxi.dg.base.center.inventory.dto.entity.InOutResultOrderPageReqDto;
import com.yunxi.dg.base.center.inventory.proxy.baseorder.IInOutResultOrderApiProxy;
import com.yunxi.dg.base.center.logistics.dto.entity.LogisticsInfoDto;
import com.yunxi.dg.base.center.logistics.dto.entity.LogisticsInfoPageReqDto;
import com.yunxi.dg.base.center.logistics.dto.entity.LogisticsTrackPageReqDto;
import com.yunxi.dg.base.center.logistics.proxy.entity.ILogisticsInfoApiProxy;
import com.yunxi.dg.base.center.logistics.proxy.entity.ILogisticsTrackApiProxy;
import com.yunxi.dg.base.center.openapi.dto.request.StdLogisticsInfoReqDto;
import com.yunxi.dg.base.center.openapi.dto.response.StdLogisticsInfoDto;
import com.yunxi.dg.base.center.openapi.dto.response.StdLogisticsInfoRespDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformNoticeSyncRecordDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformNoticeSyncRecordShippingDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformNoticeSyncRecordShippingPageReqDto;
import com.yunxi.dg.base.center.trade.proxy.entity.IDgPerformNoticeSyncRecordApiProxy;
import com.yunxi.dg.base.center.trade.proxy.entity.IDgPerformNoticeSyncRecordShippingApiProxy;
import com.yunxi.dg.base.center.trade.proxy.order.IPerformOrderQueryApiProxy;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import com.yunxi.dg.base.mgmt.service.IOcsKuaidi100Service;
import com.yunxi.dg.base.mgmt.service.IOcsLogisticsInfoService;
import com.yunxi.dg.base.ocs.mgmt.application.dto.enums.PerformOrderGeneralConfigDataEnum;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.stereotype.Service;

@Service
public class OcsLogisticsInfoServiceImpl
implements IOcsLogisticsInfoService {
    private static final Logger logger = LoggerFactory.getLogger(OcsLogisticsInfoServiceImpl.class);
    @Resource
    private IOcsKuaidi100Service ocsKuaidi100Service;
    @Resource
    private IDictQueryApiProxy dictQueryApiProxy;
    @Resource
    private ILogisticsInfoApiProxy logisticsInfoApiProxy;
    @Resource
    private ILogisticsTrackApiProxy logisticsTrackApiProxy;
    @Resource
    private IDgPerformNoticeSyncRecordShippingApiProxy dgPerformNoticeSyncRecordShippingApiProxy;
    @Resource
    private IPerformOrderQueryApiProxy performOrderQueryApiProxy;
    @Resource
    private IDgPerformNoticeSyncRecordApiProxy dgPerformNoticeSyncRecordApiProxy;
    @Resource
    private IInOutResultOrderApiProxy inOutResultOrderApiProxy;

    @Override
    public StdLogisticsInfoRespDto queryLogisticsTrack(String logisticsOrderNo, String phoneNum, Integer orderType) {
        DictDto dictDto = null;
        if (orderType == 1) {
            dictDto = (DictDto)RestResponseHelper.extractData((RestResponse)this.dictQueryApiProxy.queryByGroupCodeAndCode("yunxi-dg-base-center-trade", PerformOrderGeneralConfigDataEnum.SALE_ORDER_QUERY_LOGISTICS_TYPE.getCode()));
        } else if (orderType == 2) {
            dictDto = (DictDto)RestResponseHelper.extractData((RestResponse)this.dictQueryApiProxy.queryByGroupCodeAndCode("yunxi-dg-base-center-trade", PerformOrderGeneralConfigDataEnum.AFTER_ORDER_QUERY_LOGISTICS_TYPE.getCode()));
        }
        int status = Integer.parseInt(Optional.ofNullable(dictDto).map(DictDto::getValue).orElse("2"));
        if (status == 2) {
            StdLogisticsInfoReqDto reqDto = new StdLogisticsInfoReqDto();
            reqDto.setExpressCode(logisticsOrderNo);
            reqDto.setPhoneNum(phoneNum);
            StdLogisticsInfoRespDto respDto = (StdLogisticsInfoRespDto)RestResponseHelper.extractData(this.ocsKuaidi100Service.getLogisticsInfo(reqDto));
            if (respDto != null && CollectionUtil.isNotEmpty((Collection)respDto.getLogisticsInfoDtos())) {
                respDto.setState(((StdLogisticsInfoDto)respDto.getLogisticsInfoDtos().get(0)).getStatus());
            }
            CompletableFuture.runAsync(() -> this.updateLogisticsTime(logisticsOrderNo, orderType, respDto));
            return respDto;
        }
        LogisticsInfoPageReqDto reqDto = new LogisticsInfoPageReqDto();
        reqDto.setLogisticsOrderNo(logisticsOrderNo);
        reqDto.setPageNum(Integer.valueOf(1));
        reqDto.setPageSize(Integer.valueOf(1));
        PageInfo pageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.logisticsInfoApiProxy.pageList(reqDto));
        if (CollectionUtil.isEmpty((Collection)pageInfo.getList())) {
            return null;
        }
        StdLogisticsInfoRespDto respDto = new StdLogisticsInfoRespDto();
        respDto.setCom(((LogisticsInfoDto)pageInfo.getList().get(0)).getLogisticsCompanyName());
        respDto.setNu(((LogisticsInfoDto)pageInfo.getList().get(0)).getLogisticsOrderNo());
        respDto.setState(((LogisticsInfoDto)pageInfo.getList().get(0)).getLogisticsStatus());
        LogisticsTrackPageReqDto trackPageReqDto = new LogisticsTrackPageReqDto();
        trackPageReqDto.setLogisticsOrderNo(logisticsOrderNo);
        trackPageReqDto.setPageNum(Integer.valueOf(1));
        trackPageReqDto.setPageSize(Integer.valueOf(1000));
        PageInfo trackDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.logisticsTrackApiProxy.page(trackPageReqDto));
        if (CollectionUtil.isNotEmpty((Collection)trackDtoPageInfo.getList())) {
            List collect = trackDtoPageInfo.getList().stream().map(track -> {
                StdLogisticsInfoDto stdLogisticsInfoDto = new StdLogisticsInfoDto();
                BeanUtil.copyProperties((Object)track, (Object)stdLogisticsInfoDto, (String[])new String[0]);
                stdLogisticsInfoDto.setStatus(track.getTrackName());
                stdLogisticsInfoDto.setStatusCode(track.getTrackCode());
                stdLogisticsInfoDto.setContext(track.getContent());
                stdLogisticsInfoDto.setTime(track.getLogisticsTime());
                return stdLogisticsInfoDto;
            }).collect(Collectors.toList());
            respDto.setLogisticsInfoDtos(collect);
        }
        return respDto;
    }

    private void updateLogisticsTime(String logisticsOrderNo, Integer orderType, StdLogisticsInfoRespDto respDto) {
        if (StringUtils.isBlank((CharSequence)MDC.get((String)"yes.req.requestId"))) {
            MDC.put((String)"yes.req.requestId", (String)RequestId.createReqId());
        }
        if (ObjectUtil.isEmpty((Object)respDto) || CollectionUtil.isEmpty((Collection)respDto.getLogisticsInfoDtos())) {
            logger.info("\u65e0\u6570\u636e\u66f4\u65b0");
            return;
        }
        logger.info("\u66f4\u65b0\u7269\u6d41\u4fe1\u606f\uff1a{}\uff0c{}\uff0c{}", new Object[]{logisticsOrderNo, orderType, JSON.toJSON((Object)respDto)});
        List trackList = respDto.getLogisticsInfoDtos();
        LogisticsInfoDto infoDto = new LogisticsInfoDto();
        infoDto.setLogisticsOrderNo(logisticsOrderNo);
        trackList.stream().forEach(track -> {
            if (track.getStatus().equals("\u63fd\u6536")) {
                infoDto.setCollectTime(track.getTime());
            } else if (track.getStatus().equals("\u7b7e\u6536")) {
                infoDto.setSignTime(track.getTime());
            }
        });
        DgPerformNoticeSyncRecordShippingPageReqDto pageReqDto = new DgPerformNoticeSyncRecordShippingPageReqDto();
        pageReqDto.setConsignmentNo(logisticsOrderNo);
        pageReqDto.setPageNum(Integer.valueOf(1));
        pageReqDto.setPageSize(Integer.valueOf(100));
        PageInfo pageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.dgPerformNoticeSyncRecordShippingApiProxy.page(pageReqDto));
        if (CollectionUtil.isEmpty((Collection)pageInfo.getList())) {
            logger.info("\u7f3a\u5c11\u4ea4\u6613\u7269\u6d41\u8bb0\u5f55\u4fe1\u606f\uff1a" + logisticsOrderNo);
            return;
        }
        logger.info("\u4ea4\u6613\u7269\u6d41\u8bb0\u5f55\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)pageInfo.getList()));
        for (DgPerformNoticeSyncRecordShippingDto shippingDto : pageInfo.getList()) {
            logger.info("\u5904\u7406\uff1a{}", (Object)shippingDto.getRecordId());
            DgPerformNoticeSyncRecordDto recordDto = (DgPerformNoticeSyncRecordDto)RestResponseHelper.extractData((RestResponse)this.dgPerformNoticeSyncRecordApiProxy.get(shippingDto.getRecordId()));
            if (ObjectUtil.isEmpty((Object)recordDto)) {
                logger.error("\u627e\u4e0d\u5230\u51fa\u5e93\u8bb0\u5f55\uff1a{}", (Object)shippingDto.getRecordId());
                continue;
            }
            InOutResultOrderPageReqDto queryDto = new InOutResultOrderPageReqDto();
            queryDto.setRelevanceNo(recordDto.getBusinessNo());
            queryDto.setOrderType("out");
            queryDto.setPageNum(Integer.valueOf(1));
            queryDto.setPageSize(Integer.valueOf(1));
            logger.info("\u67e5\u8be2\u51fa\u5e93\u7ed3\u679c\u5355\uff1a{}", (Object)JSON.toJSONString((Object)pageReqDto));
            PageInfo inOutResultOrderDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.inOutResultOrderApiProxy.page(queryDto));
            if (CollectionUtil.isNotEmpty((Collection)inOutResultOrderDtoPageInfo.getList())) {
                InOutResultOrderDto orderDto = (InOutResultOrderDto)inOutResultOrderDtoPageInfo.getList().get(0);
                infoDto.setScanTime(ObjectUtil.isNotEmpty((Object)orderDto.getInOutTime()) ? orderDto.getInOutTime() : orderDto.getCreateTime());
                infoDto.setLogisticsCompanyCode(orderDto.getShippingCompanyCode());
                infoDto.setLogisticsCompanyName(orderDto.getShippingCompany());
                infoDto.setDeliveryWarehouseCode(orderDto.getOutLogicWarehouseCode());
                infoDto.setDeliveryWarehouseName(orderDto.getOutLogicWarehouseName());
                infoDto.setTotalWeight(orderDto.getTotalWeight());
                infoDto.setTotalVolume(orderDto.getTotalVolume());
                infoDto.setTotalQuantity(orderDto.getTotalQuantity());
                infoDto.setTransportTypeCode(orderDto.getShippingType());
                infoDto.setTransportStyle(StringUtils.isBlank((CharSequence)orderDto.getTransportStyle()) ? null : Integer.valueOf(Integer.parseInt(orderDto.getTransportStyle())));
            }
            if (orderType == 1) {
                infoDto.setBusinessType("cs_sale_order");
                infoDto.setBusinessOrderNo(recordDto.getBusinessNo());
            } else {
                infoDto.setBusinessType("cs_order_after_sale");
            }
            infoDto.setShopCode(null);
            infoDto.setShopName(null);
            infoDto.setLogisticsStatus(respDto.getState());
            logger.info("\u66f4\u65b0\u7269\u6d41\u4fe1\u606f\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)infoDto));
            RestResponseHelper.extractData((RestResponse)this.logisticsInfoApiProxy.updateOrCreate(infoDto));
        }
    }
}

