/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.mgmt.service.impl;

import cn.afterturn.easypoi.excel.entity.result.ExcelImportResult;
import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.mgmt.application.rpc.proxy.reconciliationbiz.IChannelBillApiProxy;
import com.yunxi.dg.base.ocs.mgmt.application.dto.enums.ChannelEnum;
import com.yunxi.dg.base.ocs.mgmt.application.dto.enums.FileModeTypeEnum;
import com.yunxi.dg.base.ocs.mgmt.application.dto.enums.FileOperationStatusEnum;
import com.yunxi.dg.base.ocs.mgmt.application.dto.request.ImportZfbBillDto;
import com.yunxi.dg.base.ocs.mgmt.application.dto.response.ChannelBillDto;
import com.yunxi.dg.base.ocs.mgmt.application.dto.response.ZfbBillDto;
import com.yunxi.dg.base.poi.dto.ImportBaseModeDto;
import com.yunxi.dg.base.poi.dto.ImportFileOperationCommonReqDto;
import com.yunxi.dg.base.poi.dto.ImportFileOperationCommonRespDto;
import com.yunxi.dg.base.poi.service.AbstractBaseFileOperationCommonService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="AbstractBaseFileOperationCommonService_zfb_bill_import")
public class ZfbBillCommonServiceImpl
extends AbstractBaseFileOperationCommonService {
    private static final Logger log = LoggerFactory.getLogger(ZfbBillCommonServiceImpl.class);
    @Resource
    protected IChannelBillApiProxy channelBillApi;

    public Object verifyImportFileOperationCommon(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto) {
        ArrayList list = new ArrayList();
        if (CollectionUtil.isEmpty((Collection)result.getList())) {
            return new ArrayList();
        }
        CubeBeanUtils.copyCollection(list, (Collection)result.getList(), ImportZfbBillDto.class);
        ArrayList<ImportZfbBillDto> passList = new ArrayList<ImportZfbBillDto>();
        for (ImportZfbBillDto dto : list) {
            Boolean billVerify = this.zfbBillVerify(dto);
            if (!billVerify.booleanValue()) {
                dto.setErrorMsg(String.format("\u7b2c%s\u884c\u6570\u636e\u6709\u8bef,%s", dto.getRowNum() + FileModeTypeEnum.getInstance((String)commonReqDto.getKey()).getHeadRows(), dto.getErrorMsg()));
                respDto.getErrorDetails().add(dto);
                continue;
            }
            passList.add(dto);
        }
        respDto.setDetails(passList);
        return passList;
    }

    public void callBackImportFileOperationCommonAsync(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto, Object object) {
        List passList = (List)object;
        ArrayList<ZfbBillDto> zfbBillDtos = new ArrayList<ZfbBillDto>(passList.size());
        for (Object o : passList) {
            ZfbBillDto zfbBillDto = new ZfbBillDto();
            zfbBillDto.setTransDt(com.dtyunxi.util.DateUtil.format((Date)o.getExcelTransDt(), (String)"yyyy-MM-dd"));
            zfbBillDto.setAccountLogId(o.getAccountLogId());
            zfbBillDto.setAlipayOrderNo(o.getAlipayOrderNo());
            zfbBillDto.setMerchantOrderNo(o.getMerchantOrderNo());
            if (o.getIncomeAmount().compareTo(BigDecimal.ZERO) > 0) {
                zfbBillDto.setTransAmount(o.getIncomeAmount().toString());
                zfbBillDto.setDirection("\u6536\u5165");
            }
            if (o.getExpenditureAmount().compareTo(BigDecimal.ZERO) < 0) {
                zfbBillDto.setTransAmount(o.getExpenditureAmount().toString());
                zfbBillDto.setDirection("\u652f\u51fa");
            }
            zfbBillDto.setBalance(o.getBalance().toString());
            zfbBillDto.setType(o.getType());
            zfbBillDto.setOtherAccount(o.getOtherAccount());
            zfbBillDto.setTransMemo(o.getTransMemo());
            zfbBillDto.setBillSource(o.getBillSource());
            zfbBillDto.setBizNos(o.getBizNos());
            zfbBillDto.setBizOrigNo(o.getBizOrigNo());
            zfbBillDto.setBizDesc(o.getBizDesc());
            zfbBillDtos.add(zfbBillDto);
        }
        if (CollectionUtil.isEmpty((Collection)passList)) {
            respDto.setStatus(FileOperationStatusEnum.IMPORT_ERROR.getCode());
            return;
        }
        respDto.setStatus(FileOperationStatusEnum.IMPORT_SUCCESS.getCode());
        if (CollectionUtil.isNotEmpty((Collection)passList) && !respDto.getErrorDetails().isEmpty()) {
            respDto.setStatus(FileOperationStatusEnum.IMPORT_PARTIAL_SUCCESS.getCode());
        }
        ArrayList channelBillDtos = Lists.newArrayList();
        try {
            for (ZfbBillDto billDto : zfbBillDtos) {
                ChannelBillDto dto = new ChannelBillDto();
                billDto.setTransDt(billDto.getTransDt());
                dto.setChannelCode(ChannelEnum.ZFB.getCode());
                dto.setChannelName(ChannelEnum.ZFB.getName());
                dto.setSerialNo(billDto.getBizOrigNo());
                dto.setPlatformSerialNo(billDto.getAccountLogId());
                dto.setUniqueSerialNo(billDto.getAccountLogId());
                dto.setProduceDate(DateUtil.parseDate((String)billDto.getTransDt(), (String)"yyyy-MM-dd"));
                dto.setData(JSON.toJSONString((Object)billDto));
                this.setCreatePerson(commonReqDto, dto);
                channelBillDtos.add(dto);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        log.info("\u6279\u91cf\u4fdd\u5b58\u652f\u4ed8\u5b9d\u539f\u59cb\u8d26\u5355,\u6570\u91cf\u4e3a:{}", (Object)channelBillDtos.size());
        this.channelBillApi.importInsertBatch((List)channelBillDtos);
    }

    private Boolean zfbBillVerify(ImportZfbBillDto importZfbBillDto) {
        return true;
    }

    protected void setCreatePerson(ImportFileOperationCommonReqDto commonReqDto, ChannelBillDto dto) {
        dto.setCreatePerson(commonReqDto.getCreatePerson());
        dto.setUpdatePerson(commonReqDto.getCreatePerson());
    }
}

