/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.sap.interceptor.enums;

import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.RangeQueryBuilder;

public enum EsOperator {
    GTE("gte", "\u5927\u4e8e\u7b49\u4e8e"){

        @Override
        public QueryBuilder buildQuery(String fieldName, String value) {
            return QueryBuilders.rangeQuery((String)fieldName).gte((Object)value);
        }
    }
    ,
    LTE("lte", "\u5c0f\u4e8e\u7b49\u4e8e"){

        @Override
        public QueryBuilder buildQuery(String fieldName, String value) {
            return QueryBuilders.rangeQuery((String)fieldName).lte((Object)value);
        }
    }
    ,
    GT("gt", "\u5927\u4e8e"){

        @Override
        public QueryBuilder buildQuery(String fieldName, String value) {
            return QueryBuilders.rangeQuery((String)fieldName).gt((Object)value);
        }
    }
    ,
    LT("lt", "\u5c0f\u4e8e"){

        @Override
        public QueryBuilder buildQuery(String fieldName, String value) {
            return QueryBuilders.rangeQuery((String)fieldName).lt((Object)value);
        }
    }
    ,
    EQ("eq", "\u7b49\u4e8e"){

        @Override
        public QueryBuilder buildQuery(String fieldName, String value) {
            return QueryBuilders.termQuery((String)fieldName, (String)value);
        }
    }
    ,
    NE("ne", "\u4e0d\u7b49\u4e8e"){

        @Override
        public QueryBuilder buildQuery(String fieldName, String value) {
            return QueryBuilders.boolQuery().mustNot((QueryBuilder)QueryBuilders.termQuery((String)fieldName, (String)value));
        }
    }
    ,
    RANGE("range", "\u8303\u56f4\u67e5\u8be2"){

        @Override
        public QueryBuilder buildQuery(String fieldName, String value) {
            String upperBound;
            String[] parts = value.split(",");
            if (parts.length != 2) {
                throw new IllegalArgumentException("\u8303\u56f4\u67e5\u8be2\u503c\u683c\u5f0f\u9519\u8bef\uff0c\u5e94\u4e3a\uff1avalue1,value2");
            }
            RangeQueryBuilder rangeQuery = QueryBuilders.rangeQuery((String)fieldName);
            String lowerBound = parts[0].trim();
            if (!lowerBound.isEmpty() && !"*".equals(lowerBound)) {
                rangeQuery.gte((Object)lowerBound);
            }
            if (!(upperBound = parts[1].trim()).isEmpty() && !"*".equals(upperBound)) {
                rangeQuery.lte((Object)upperBound);
            }
            return rangeQuery;
        }
    }
    ,
    EXISTS("exists", "\u5b57\u6bb5\u5b58\u5728"){

        @Override
        public QueryBuilder buildQuery(String fieldName, String value) {
            return QueryBuilders.existsQuery((String)fieldName);
        }
    }
    ,
    MATCH("match", "\u6a21\u7cca\u5339\u914d"){

        @Override
        public QueryBuilder buildQuery(String fieldName, String value) {
            return QueryBuilders.matchQuery((String)fieldName, (Object)value);
        }
    };

    private final String name;
    private final String description;

    private EsOperator(String name, String description) {
        this.name = name;
        this.description = description;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public abstract QueryBuilder buildQuery(String var1, String var2);

    public static EsOperator fromName(String name) {
        if (name == null) {
            return GTE;
        }
        for (EsOperator operator : EsOperator.values()) {
            if (!operator.name.equalsIgnoreCase(name)) continue;
            return operator;
        }
        throw new IllegalArgumentException("\u4e0d\u652f\u6301\u7684ES\u64cd\u4f5c\u7b26: " + name + "\uff0c\u652f\u6301\u7684\u64cd\u4f5c\u7b26: gte, lte, gt, lt, eq, ne, range, exists, match");
    }

    public String getOperatorName() {
        return this.name;
    }

    public String toString() {
        return this.name + "(" + this.description + ")";
    }
}

