/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.sap.interceptor.autoconfigure;

import com.dtyunxi.sap.interceptor.config.SapConfigProperties;
import com.dtyunxi.sap.interceptor.context.DefaultServiceContextProvider;
import com.dtyunxi.sap.interceptor.context.ServiceContextProvider;
import com.dtyunxi.sap.interceptor.mybatis.SapLimitInterceptor;
import com.dtyunxi.sap.interceptor.web.SapHeaderInterceptor;
import com.dtyunxi.sap.interceptor.web.SapPathInterceptor;
import java.util.List;
import javax.annotation.PostConstruct;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.boot.autoconfigure.MybatisAutoConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
@EnableConfigurationProperties(value={SapConfigProperties.class})
@ConditionalOnProperty(prefix="ocs.sap", name={"enabled"}, havingValue="true", matchIfMissing=true)
public class SapInterceptorAutoConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(SapInterceptorAutoConfiguration.class);

    @PostConstruct
    public void init() {
        logger.info("SAP\u62e6\u622a\u5668\u81ea\u52a8\u914d\u7f6e\u5df2\u52a0\u8f7d");
    }

    @Bean
    @ConditionalOnMissingBean(value={ServiceContextProvider.class})
    public ServiceContextProvider serviceContextProvider() {
        logger.info("\u4f7f\u7528\u9ed8\u8ba4\u7684ServiceContextProvider\u5b9e\u73b0");
        return new DefaultServiceContextProvider();
    }

    @Configuration
    @ConditionalOnProperty(prefix="ocs.sap.compatibility", name={"enabled"}, havingValue="true", matchIfMissing=false)
    public static class CompatibilityConfiguration {
        @PostConstruct
        public void init() {
            logger.info("SAP\u62e6\u622a\u5668\u517c\u5bb9\u6027\u6a21\u5f0f\u5df2\u542f\u7528");
        }
    }

    @Configuration
    @ConditionalOnClass(value={SqlSessionFactory.class})
    @AutoConfigureAfter(value={MybatisAutoConfiguration.class})
    @ConditionalOnProperty(prefix="ocs.sap.mybatis", name={"enabled"}, havingValue="true", matchIfMissing=true)
    public static class MybatisInterceptorConfiguration {
        private final SapConfigProperties sapConfigProperties;
        private final ServiceContextProvider serviceContextProvider;

        public MybatisInterceptorConfiguration(SapConfigProperties sapConfigProperties, ServiceContextProvider serviceContextProvider) {
            this.sapConfigProperties = sapConfigProperties;
            this.serviceContextProvider = serviceContextProvider;
        }

        @Bean
        public SapLimitInterceptor sapLimitInterceptor() {
            logger.info("\u6ce8\u518cSAP MyBatis\u62e6\u622a\u5668");
            return new SapLimitInterceptor(this.sapConfigProperties, this.serviceContextProvider);
        }

        @Autowired
        public void addInterceptor(List<SqlSessionFactory> sqlSessionFactoryList) {
            SapLimitInterceptor interceptor = this.sapLimitInterceptor();
            for (SqlSessionFactory sqlSessionFactory : sqlSessionFactoryList) {
                sqlSessionFactory.getConfiguration().addInterceptor((Interceptor)interceptor);
                logger.info("SAP MyBatis\u62e6\u622a\u5668\u5df2\u6dfb\u52a0\u5230SqlSessionFactory");
            }
        }
    }

    @Configuration
    @ConditionalOnClass(name={"org.springframework.web.servlet.config.annotation.WebMvcConfigurer"})
    public static class WebInterceptorConfiguration
    implements WebMvcConfigurer {
        private final SapConfigProperties sapConfigProperties;
        private final ServiceContextProvider serviceContextProvider;

        public WebInterceptorConfiguration(SapConfigProperties sapConfigProperties, ServiceContextProvider serviceContextProvider) {
            this.sapConfigProperties = sapConfigProperties;
            this.serviceContextProvider = serviceContextProvider;
        }

        @Bean
        @ConditionalOnProperty(prefix="ocs.sap.header", name={"enabled"}, havingValue="true", matchIfMissing=false)
        public SapHeaderInterceptor sapHeaderInterceptor() {
            logger.info("\u6ce8\u518cSAP\u8bf7\u6c42\u5934\u62e6\u622a\u5668");
            return new SapHeaderInterceptor(this.sapConfigProperties, this.serviceContextProvider);
        }

        @Bean
        @ConditionalOnProperty(prefix="ocs.sap.path", name={"enabled"}, havingValue="true", matchIfMissing=true)
        public SapPathInterceptor sapPathInterceptor() {
            logger.info("\u6ce8\u518cSAP\u8def\u5f84\u62e6\u622a\u5668");
            return new SapPathInterceptor(this.sapConfigProperties, this.serviceContextProvider);
        }

        public void addInterceptors(InterceptorRegistry registry) {
            SapHeaderInterceptor headerInterceptor = null;
            try {
                headerInterceptor = this.sapHeaderInterceptor();
            }
            catch (Exception e) {
                logger.debug("SAP\u8bf7\u6c42\u5934\u62e6\u622a\u5668\u672a\u542f\u7528");
            }
            if (headerInterceptor != null) {
                registry.addInterceptor((HandlerInterceptor)headerInterceptor).order(1);
                logger.info("SAP\u8bf7\u6c42\u5934\u62e6\u622a\u5668\u5df2\u6ce8\u518c\uff0c\u4f18\u5148\u7ea7\uff1a1");
            }
            SapPathInterceptor pathInterceptor = null;
            try {
                pathInterceptor = this.sapPathInterceptor();
            }
            catch (Exception e) {
                logger.debug("SAP\u8def\u5f84\u62e6\u622a\u5668\u672a\u542f\u7528");
            }
            if (pathInterceptor != null) {
                registry.addInterceptor((HandlerInterceptor)pathInterceptor).order(2);
                logger.info("SAP\u8def\u5f84\u62e6\u622a\u5668\u5df2\u6ce8\u518c\uff0c\u4f18\u5148\u7ea7\uff1a2");
            }
        }
    }
}

