/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.sap.interceptor.config;

import com.dtyunxi.sap.interceptor.config.SapConfigProperties;
import com.dtyunxi.sap.interceptor.context.DefaultServiceContextProvider;
import com.dtyunxi.sap.interceptor.context.ServiceContextProvider;
import com.dtyunxi.sap.interceptor.context.TransmittableServiceContextProvider;
import com.dtyunxi.sap.interceptor.feign.SapFeignInterceptor;
import com.dtyunxi.sap.interceptor.mybatis.SapLimitInterceptor;
import com.dtyunxi.sap.interceptor.web.SapHeaderInterceptor;
import com.dtyunxi.sap.interceptor.web.SapPathInterceptor;
import org.apache.ibatis.session.SqlSessionFactory;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
@EnableConfigurationProperties(value={SapConfigProperties.class})
@ConditionalOnProperty(prefix="ocs.sap", name={"enabled"}, havingValue="true", matchIfMissing=true)
public class SapInterceptorAutoConfiguration {

    @Configuration
    @ConditionalOnClass(name={"feign.RequestInterceptor"})
    @ConditionalOnProperty(prefix="ocs.sap.feign", name={"enabled"}, havingValue="true")
    public static class FeignInterceptorConfiguration {
        @Bean
        @ConditionalOnMissingBean
        public SapFeignInterceptor sapFeignInterceptor(ServiceContextProvider serviceContextProvider) {
            return new SapFeignInterceptor(serviceContextProvider);
        }
    }

    @Configuration
    @ConditionalOnClass(value={SqlSessionFactory.class})
    @ConditionalOnProperty(prefix="ocs.sap.mybatis", name={"enabled"}, havingValue="true")
    @AutoConfigureAfter(name={"org.mybatis.spring.boot.autoconfigure.MybatisAutoConfiguration"})
    public static class MybatisInterceptorConfiguration {
        @Bean
        @ConditionalOnMissingBean
        public SapLimitInterceptor sapLimitInterceptor(SapConfigProperties sapConfigProperties, ServiceContextProvider serviceContextProvider) {
            return new SapLimitInterceptor(sapConfigProperties, serviceContextProvider);
        }
    }

    @Configuration
    @ConditionalOnClass(name={"org.springframework.web.servlet.HandlerInterceptor"})
    @ConditionalOnProperty(prefix="ocs.sap", name={"enabled"}, havingValue="true", matchIfMissing=true)
    public static class WebInterceptorConfiguration
    implements WebMvcConfigurer {
        @Bean
        @ConditionalOnProperty(prefix="ocs.sap.header", name={"enabled"}, havingValue="true")
        public SapHeaderInterceptor sapHeaderInterceptor(SapConfigProperties sapConfigProperties, ServiceContextProvider serviceContextProvider) {
            return new SapHeaderInterceptor(sapConfigProperties, serviceContextProvider);
        }

        @Bean
        @ConditionalOnProperty(prefix="ocs.sap.path", name={"enabled"}, havingValue="true")
        public SapPathInterceptor sapPathInterceptor(SapConfigProperties sapConfigProperties, ServiceContextProvider serviceContextProvider) {
            return new SapPathInterceptor(sapConfigProperties, serviceContextProvider);
        }

        public void addInterceptors(InterceptorRegistry registry) {
            registry.addInterceptor((HandlerInterceptor)this.sapHeaderInterceptor(null, null)).addPathPatterns(new String[]{"/**"});
            registry.addInterceptor((HandlerInterceptor)this.sapPathInterceptor(null, null)).addPathPatterns(new String[]{"/**"});
        }
    }

    @Configuration
    @ConditionalOnProperty(prefix="ocs.sap", name={"enabled"}, havingValue="true", matchIfMissing=true)
    public static class ServiceContextConfiguration {
        @Bean
        @ConditionalOnMissingBean
        @ConditionalOnProperty(prefix="ocs.sap.context", name={"transmittable"}, havingValue="true")
        public ServiceContextProvider transmittableServiceContextProvider() {
            return new TransmittableServiceContextProvider();
        }

        @Bean
        @ConditionalOnMissingBean
        @ConditionalOnProperty(prefix="ocs.sap.context", name={"transmittable"}, havingValue="false", matchIfMissing=true)
        public ServiceContextProvider defaultServiceContextProvider() {
            return new DefaultServiceContextProvider();
        }
    }
}

