/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.sap.interceptor.config;

import com.dtyunxi.sap.interceptor.config.SapConfigProperties;
import com.dtyunxi.sap.interceptor.context.SapDefaultServiceContextProvider;
import com.dtyunxi.sap.interceptor.context.SapServiceContextProvider;
import com.dtyunxi.sap.interceptor.context.SapTransmittableServiceContextProvider;
import com.dtyunxi.sap.interceptor.feign.IPcpDictExtQueryApi;
import com.dtyunxi.sap.interceptor.feign.SapFeignInterceptor;
import com.dtyunxi.sap.interceptor.mybatis.SapLimitInterceptor;
import com.dtyunxi.sap.interceptor.web.SapHeaderInterceptor;
import com.dtyunxi.sap.interceptor.web.SapPathInterceptor;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.session.SqlSessionFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.openfeign.FeignClientBuilder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
@EnableConfigurationProperties(value={SapConfigProperties.class})
@ConditionalOnProperty(prefix="ocs.sap", name={"enabled"}, havingValue="true", matchIfMissing=true)
public class SapInterceptorAutoConfiguration {

    @Configuration
    @ConditionalOnProperty(prefix="ocs.sap", name={"enabled"}, havingValue="true")
    public static class SapFeignClientConfiguration {
        private final String serviceName;
        private final String serviceUrl;

        public SapFeignClientConfiguration(@Value(value="${yundt.cube.center.data.api.name:yundt-cube-center-data}") String serviceName, @Value(value="${yundt.cube.center.data.api:}") String serviceUrl) {
            this.serviceName = serviceName;
            this.serviceUrl = serviceUrl;
        }

        @Bean
        public IPcpDictExtQueryApi pcpDictExtQueryApi(FeignClientBuilder feignClientBuilder) {
            FeignClientBuilder.Builder builder = feignClientBuilder.forType(IPcpDictExtQueryApi.class, this.serviceName);
            if (StringUtils.isNotBlank((CharSequence)this.serviceUrl)) {
                builder.url(this.serviceUrl);
            }
            return (IPcpDictExtQueryApi)builder.build();
        }
    }

    @Configuration
    @ConditionalOnClass(name={"feign.RequestInterceptor"})
    @ConditionalOnProperty(prefix="ocs.sap.feign", name={"enabled"}, havingValue="true")
    public static class SapFeignInterceptorConfiguration {
        @Bean
        @ConditionalOnMissingBean
        public SapFeignInterceptor sapFeignInterceptor(SapServiceContextProvider serviceContextProvider) {
            return new SapFeignInterceptor(serviceContextProvider);
        }
    }

    @Configuration
    @ConditionalOnClass(value={SqlSessionFactory.class})
    @ConditionalOnProperty(prefix="ocs.sap.mybatis", name={"enabled"}, havingValue="true")
    @AutoConfigureAfter(name={"org.mybatis.spring.boot.autoconfigure.MybatisAutoConfiguration"})
    public static class SapMybatisInterceptorConfiguration {
        @Bean
        @ConditionalOnMissingBean
        public SapLimitInterceptor sapLimitInterceptor(SapConfigProperties sapConfigProperties, SapServiceContextProvider serviceContextProvider) {
            return new SapLimitInterceptor(sapConfigProperties, serviceContextProvider);
        }
    }

    @Configuration
    @ConditionalOnClass(name={"org.springframework.web.servlet.HandlerInterceptor"})
    @ConditionalOnProperty(prefix="ocs.sap", name={"enabled"}, havingValue="true", matchIfMissing=true)
    public static class WebInterceptorConfiguration
    implements WebMvcConfigurer {
        @Bean
        public SapHeaderInterceptor sapHeaderInterceptor(SapConfigProperties sapConfigProperties, SapServiceContextProvider serviceContextProvider) {
            return new SapHeaderInterceptor(sapConfigProperties, serviceContextProvider);
        }

        @Bean
        public SapPathInterceptor sapPathInterceptor(SapConfigProperties sapConfigProperties, SapServiceContextProvider serviceContextProvider) {
            return new SapPathInterceptor(sapConfigProperties, serviceContextProvider);
        }

        public void addInterceptors(InterceptorRegistry registry) {
            registry.addInterceptor((HandlerInterceptor)this.sapHeaderInterceptor(null, null)).addPathPatterns(new String[]{"/**"});
            registry.addInterceptor((HandlerInterceptor)this.sapPathInterceptor(null, null)).addPathPatterns(new String[]{"/**"});
        }
    }

    @Configuration
    @ConditionalOnProperty(prefix="ocs.sap", name={"enabled"}, havingValue="true", matchIfMissing=true)
    public static class ServiceContextConfiguration {
        @Bean
        @ConditionalOnMissingBean
        @ConditionalOnProperty(prefix="ocs.sap.context", name={"transmittable"}, havingValue="true")
        public SapServiceContextProvider sapTransmittableServiceContextProvider() {
            return new SapTransmittableServiceContextProvider();
        }

        @Bean
        @ConditionalOnMissingBean
        @ConditionalOnProperty(prefix="ocs.sap.context", name={"transmittable"}, havingValue="false", matchIfMissing=true)
        public SapServiceContextProvider sapDefaultServiceContextProvider() {
            return new SapDefaultServiceContextProvider();
        }
    }
}

