/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.sap.interceptor.config;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class SapConfigMonitor {
    private static final Logger log = LoggerFactory.getLogger(SapConfigMonitor.class);
    private final AtomicLong totalRefreshCount = new AtomicLong(0L);
    private final AtomicLong successRefreshCount = new AtomicLong(0L);
    private final AtomicLong failedRefreshCount = new AtomicLong(0L);
    private final AtomicLong totalRefreshTime = new AtomicLong(0L);
    private final AtomicReference<LocalDateTime> lastRefreshTime = new AtomicReference();
    private final AtomicReference<LocalDateTime> lastSuccessTime = new AtomicReference();
    private final AtomicReference<LocalDateTime> lastFailedTime = new AtomicReference();
    private final AtomicReference<String> lastError = new AtomicReference();

    public void recordRefreshStart() {
        this.totalRefreshCount.incrementAndGet();
        this.lastRefreshTime.set(LocalDateTime.now());
    }

    public void recordRefreshSuccess(long durationMs) {
        this.successRefreshCount.incrementAndGet();
        this.lastSuccessTime.set(LocalDateTime.now());
        this.totalRefreshTime.addAndGet(durationMs);
        this.lastError.set(null);
        log.info("\u914d\u7f6e\u5237\u65b0\u6210\u529f\uff0c\u8017\u65f6: {}ms", (Object)durationMs);
    }

    public void recordRefreshFailure(String error, long durationMs) {
        this.failedRefreshCount.incrementAndGet();
        this.lastFailedTime.set(LocalDateTime.now());
        this.totalRefreshTime.addAndGet(durationMs);
        this.lastError.set(error);
        log.error("\u914d\u7f6e\u5237\u65b0\u5931\u8d25\uff0c\u8017\u65f6: {}ms\uff0c\u9519\u8bef: {}", (Object)durationMs, (Object)error);
    }

    public RefreshStats getRefreshStats() {
        long total = this.totalRefreshCount.get();
        long success = this.successRefreshCount.get();
        long failed = this.failedRefreshCount.get();
        double successRate = total > 0L ? (double)success / (double)total * 100.0 : 0.0;
        double failedRate = total > 0L ? (double)failed / (double)total * 100.0 : 0.0;
        double avgDuration = total > 0L ? (double)this.totalRefreshTime.get() / (double)total : 0.0;
        return RefreshStats.builder().totalRefreshCount(total).successRefreshCount(success).failedRefreshCount(failed).successRate(successRate).failedRate(failedRate).averageRefreshTime(avgDuration).lastRefreshTime(this.formatDateTime(this.lastRefreshTime.get())).lastSuccessTime(this.formatDateTime(this.lastSuccessTime.get())).lastFailedTime(this.formatDateTime(this.lastFailedTime.get())).lastError(this.lastError.get()).build();
    }

    public HealthStatus getHealthStatus() {
        long total = this.totalRefreshCount.get();
        long failed = this.failedRefreshCount.get();
        if (total == 0L) {
            return HealthStatus.HEALTHY;
        }
        double failedRate = (double)failed / (double)total * 100.0;
        if (failedRate > 50.0) {
            return HealthStatus.UNHEALTHY;
        }
        if (this.lastError.get() != null) {
            return HealthStatus.WARNING;
        }
        return HealthStatus.HEALTHY;
    }

    public void resetStats() {
        this.totalRefreshCount.set(0L);
        this.successRefreshCount.set(0L);
        this.failedRefreshCount.set(0L);
        this.totalRefreshTime.set(0L);
        this.lastRefreshTime.set(null);
        this.lastSuccessTime.set(null);
        this.lastFailedTime.set(null);
        this.lastError.set(null);
        log.info("\u914d\u7f6e\u76d1\u63a7\u7edf\u8ba1\u4fe1\u606f\u5df2\u91cd\u7f6e");
    }

    private String formatDateTime(LocalDateTime dateTime) {
        if (dateTime == null) {
            return "\u4ece\u672a";
        }
        return dateTime.format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
    }

    public static enum HealthStatus {
        HEALTHY("\u5065\u5eb7"),
        WARNING("\u8b66\u544a"),
        UNHEALTHY("\u4e0d\u5065\u5eb7");

        private final String description;

        private HealthStatus(String description) {
            this.description = description;
        }

        public String getDescription() {
            return this.description;
        }
    }

    public static class RefreshStats {
        private final long totalRefreshCount;
        private final long successRefreshCount;
        private final long failedRefreshCount;
        private final double successRate;
        private final double failedRate;
        private final double averageRefreshTime;
        private final String lastRefreshTime;
        private final String lastSuccessTime;
        private final String lastFailedTime;
        private final String lastError;

        private RefreshStats(Builder builder) {
            this.totalRefreshCount = builder.totalRefreshCount;
            this.successRefreshCount = builder.successRefreshCount;
            this.failedRefreshCount = builder.failedRefreshCount;
            this.successRate = builder.successRate;
            this.failedRate = builder.failedRate;
            this.averageRefreshTime = builder.averageRefreshTime;
            this.lastRefreshTime = builder.lastRefreshTime;
            this.lastSuccessTime = builder.lastSuccessTime;
            this.lastFailedTime = builder.lastFailedTime;
            this.lastError = builder.lastError;
        }

        public long getTotalRefreshCount() {
            return this.totalRefreshCount;
        }

        public long getSuccessRefreshCount() {
            return this.successRefreshCount;
        }

        public long getFailedRefreshCount() {
            return this.failedRefreshCount;
        }

        public double getSuccessRate() {
            return this.successRate;
        }

        public double getFailedRate() {
            return this.failedRate;
        }

        public double getAverageRefreshTime() {
            return this.averageRefreshTime;
        }

        public String getLastRefreshTime() {
            return this.lastRefreshTime;
        }

        public String getLastSuccessTime() {
            return this.lastSuccessTime;
        }

        public String getLastFailedTime() {
            return this.lastFailedTime;
        }

        public String getLastError() {
            return this.lastError;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder {
            private long totalRefreshCount;
            private long successRefreshCount;
            private long failedRefreshCount;
            private double successRate;
            private double failedRate;
            private double averageRefreshTime;
            private String lastRefreshTime;
            private String lastSuccessTime;
            private String lastFailedTime;
            private String lastError;

            public Builder totalRefreshCount(long totalRefreshCount) {
                this.totalRefreshCount = totalRefreshCount;
                return this;
            }

            public Builder successRefreshCount(long successRefreshCount) {
                this.successRefreshCount = successRefreshCount;
                return this;
            }

            public Builder failedRefreshCount(long failedRefreshCount) {
                this.failedRefreshCount = failedRefreshCount;
                return this;
            }

            public Builder successRate(double successRate) {
                this.successRate = successRate;
                return this;
            }

            public Builder failedRate(double failedRate) {
                this.failedRate = failedRate;
                return this;
            }

            public Builder averageRefreshTime(double averageRefreshTime) {
                this.averageRefreshTime = averageRefreshTime;
                return this;
            }

            public Builder lastRefreshTime(String lastRefreshTime) {
                this.lastRefreshTime = lastRefreshTime;
                return this;
            }

            public Builder lastSuccessTime(String lastSuccessTime) {
                this.lastSuccessTime = lastSuccessTime;
                return this;
            }

            public Builder lastFailedTime(String lastFailedTime) {
                this.lastFailedTime = lastFailedTime;
                return this;
            }

            public Builder lastError(String lastError) {
                this.lastError = lastError;
                return this;
            }

            public RefreshStats build() {
                return new RefreshStats(this);
            }
        }
    }
}

