/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.sap.interceptor.enums;

public enum SqlOperator {
    GTE(">=", "\u5927\u4e8e\u7b49\u4e8e"),
    EQ("=", "\u7b49\u4e8e"),
    NEQ("!=", "\u4e0d\u7b49\u4e8e"),
    IN("IN", "\u5305\u542b"),
    NOT_IN("NOT IN", "\u4e0d\u5305\u542b"),
    LT("<", "\u5c0f\u4e8e"),
    LTE("<=", "\u5c0f\u4e8e\u7b49\u4e8e"),
    GT(">", "\u5927\u4e8e"),
    LIKE("LIKE", "\u6a21\u7cca\u5339\u914d");

    private final String symbol;
    private final String description;

    private SqlOperator(String symbol, String description) {
        this.symbol = symbol;
        this.description = description;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public String getDescription() {
        return this.description;
    }

    public static SqlOperator fromName(String name) {
        if (name == null || name.trim().isEmpty()) {
            return GTE;
        }
        try {
            return SqlOperator.valueOf(name.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            return GTE;
        }
    }

    public String buildCondition(String fieldName, String conditionValue) {
        if (fieldName == null || fieldName.trim().isEmpty()) {
            return "";
        }
        if (conditionValue == null || conditionValue.trim().isEmpty()) {
            return "";
        }
        switch (this) {
            case IN: 
            case NOT_IN: {
                if (!conditionValue.trim().startsWith("(")) {
                    conditionValue = conditionValue.contains(",") ? "(" + conditionValue + ")" : "(" + conditionValue + ")";
                }
                return fieldName + " " + this.symbol + " " + conditionValue;
            }
            case LIKE: {
                if (!conditionValue.contains("%")) {
                    conditionValue = "'%" + conditionValue + "%'";
                } else if (!conditionValue.startsWith("'")) {
                    conditionValue = "'" + conditionValue + "'";
                }
                return fieldName + " " + this.symbol + " " + conditionValue;
            }
        }
        return fieldName + " " + this.symbol + " " + conditionValue;
    }

    public String toString() {
        return "SqlOperator{name='" + this.name() + '\'' + ", symbol='" + this.symbol + '\'' + ", description='" + this.description + '\'' + '}';
    }
}

