/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.sap.interceptor.config;

import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.sap.interceptor.config.SapConfigProperties;
import com.dtyunxi.sap.interceptor.feign.DictDto;
import com.dtyunxi.sap.interceptor.feign.IPcpDictExtQueryApi;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
@RefreshScope
public class SapDictManager {
    private static final Logger log = LoggerFactory.getLogger(SapDictManager.class);
    @Resource
    private IPcpDictExtQueryApi pcpDictQueryApi;
    @Resource
    private SapConfigProperties sapConfigProperties;
    private final Map<String, DictDto> dictCache = new ConcurrentHashMap<String, DictDto>();
    private final Map<String, List<DictDto>> groupCache = new ConcurrentHashMap<String, List<DictDto>>();

    @PostConstruct
    public void init() {
        log.info("\u5f00\u59cb\u521d\u59cb\u5316SAP\u5b57\u5178\u914d\u7f6e\u7ba1\u7406\u5668");
        this.loadAllSapConfigs();
        log.info("SAP\u5b57\u5178\u914d\u7f6e\u7ba1\u7406\u5668\u521d\u59cb\u5316\u5b8c\u6210");
    }

    @Scheduled(fixedRate=300000L)
    public void refreshDictConfig() {
        log.info("\u5f00\u59cb\u5b9a\u65f6\u5237\u65b0SAP\u5b57\u5178\u914d\u7f6e");
        this.loadAllSapConfigs();
        log.info("SAP\u5b57\u5178\u914d\u7f6e\u5b9a\u65f6\u5237\u65b0\u5b8c\u6210");
    }

    public void loadAllSapConfigs() {
        try {
            this.loadGlobalConfig();
            this.loadMybatisConfig();
            this.loadPathMappingConfig();
            this.loadOtherConfigs();
            log.info("\u6240\u6709SAP\u5b57\u5178\u914d\u7f6e\u52a0\u8f7d\u5b8c\u6210\uff0c\u7f13\u5b58\u5927\u5c0f: {}", (Object)this.dictCache.size());
        }
        catch (Exception e) {
            log.error("\u52a0\u8f7dSAP\u5b57\u5178\u914d\u7f6e\u5931\u8d25", (Throwable)e);
        }
    }

    private void loadGlobalConfig() {
        try {
            DictDto globalEnabled = (DictDto)this.pcpDictQueryApi.queryByGroupCodeAndCode("SAP_CONFIG", "global:" + ServiceContext.getContext().getRequestUserId()).getData();
            DictDto globalForceMode = (DictDto)this.pcpDictQueryApi.queryByGroupCodeAndCode("SAP_CONFIG", "global.force-mode").getData();
            if (globalEnabled != null) {
                boolean enabled = StringUtils.equals((CharSequence)globalEnabled.getValue(), (CharSequence)"1");
                this.sapConfigProperties.getGlobal().setEnabled(enabled);
                log.info("\u4ece\u5b57\u5178\u52a0\u8f7d\u5168\u5c40\u5f00\u5173: {}", (Object)enabled);
            }
            if (globalForceMode != null) {
                boolean forceMode = StringUtils.equals((CharSequence)globalForceMode.getValue(), (CharSequence)"1");
                this.sapConfigProperties.getGlobal().setForceMode(forceMode);
                log.info("\u4ece\u5b57\u5178\u52a0\u8f7d\u5f3a\u5236\u6a21\u5f0f: {}", (Object)forceMode);
            }
        }
        catch (Exception e) {
            log.warn("\u52a0\u8f7d\u5168\u5c40\u914d\u7f6e\u5931\u8d25\uff0c\u4f7f\u7528\u9ed8\u8ba4\u914d\u7f6e", (Throwable)e);
        }
    }

    private void loadMybatisConfig() {
        try {
            DictDto mybatisEnabled = (DictDto)this.pcpDictQueryApi.queryByGroupCodeAndCode("SAP_CONFIG", "mybatis.enabled").getData();
            DictDto defaultOperator = (DictDto)this.pcpDictQueryApi.queryByGroupCodeAndCode("SAP_CONFIG", "mybatis.default-operator").getData();
            DictDto defaultConditionValue = (DictDto)this.pcpDictQueryApi.queryByGroupCodeAndCode("SAP_CONFIG", "mybatis.default-condition-value").getData();
            if (mybatisEnabled != null) {
                boolean enabled = StringUtils.equals((CharSequence)mybatisEnabled.getValue(), (CharSequence)"1");
                this.sapConfigProperties.getMybatis().setEnabled(enabled);
                log.info("\u4ece\u5b57\u5178\u52a0\u8f7dMyBatis\u5f00\u5173: {}", (Object)enabled);
            }
            if (defaultOperator != null && StringUtils.isNotEmpty((CharSequence)defaultOperator.getValue())) {
                this.sapConfigProperties.getMybatis().setDefaultOperator(defaultOperator.getValue());
                log.info("\u4ece\u5b57\u5178\u52a0\u8f7d\u9ed8\u8ba4\u64cd\u4f5c\u7b26: {}", (Object)defaultOperator.getValue());
            }
            if (defaultConditionValue != null && StringUtils.isNotEmpty((CharSequence)defaultConditionValue.getValue())) {
                this.sapConfigProperties.getMybatis().setDefaultConditionValue(defaultConditionValue.getValue());
                log.info("\u4ece\u5b57\u5178\u52a0\u8f7d\u9ed8\u8ba4\u6761\u4ef6\u503c: {}", (Object)defaultConditionValue.getValue());
            }
        }
        catch (Exception e) {
            log.warn("\u52a0\u8f7dMyBatis\u914d\u7f6e\u5931\u8d25\uff0c\u4f7f\u7528\u9ed8\u8ba4\u914d\u7f6e", (Throwable)e);
        }
    }

    private void loadPathMappingConfig() {
        try {
            List pathMappings = (List)this.pcpDictQueryApi.queryByGroupCode("SAP_PATH_MAPPING").getData();
            if (pathMappings != null && !pathMappings.isEmpty()) {
                List<SapConfigProperties.PathMapping> configs = pathMappings.stream().map(this::convertToPathMapping).filter(mapping -> mapping != null && mapping.isEnabled()).collect(Collectors.toList());
                this.sapConfigProperties.setPathMapping(configs);
                log.info("\u4ece\u5b57\u5178\u52a0\u8f7d\u8def\u5f84\u6620\u5c04\u914d\u7f6e: {} \u6761", (Object)configs.size());
            }
        }
        catch (Exception e) {
            log.warn("\u52a0\u8f7d\u8def\u5f84\u6620\u5c04\u914d\u7f6e\u5931\u8d25\uff0c\u4f7f\u7528\u9ed8\u8ba4\u914d\u7f6e", (Throwable)e);
        }
    }

    private void loadOtherConfigs() {
        try {
            boolean enabled;
            DictDto limitTime = (DictDto)this.pcpDictQueryApi.queryByGroupCodeAndCode("SAP_CONFIG", "limit-time").getData();
            DictDto headerEnabled = (DictDto)this.pcpDictQueryApi.queryByGroupCodeAndCode("SAP_CONFIG", "header.enabled").getData();
            DictDto feignEnabled = (DictDto)this.pcpDictQueryApi.queryByGroupCodeAndCode("SAP_CONFIG", "feign.enabled").getData();
            if (limitTime != null && StringUtils.isNotEmpty((CharSequence)limitTime.getValue())) {
                this.sapConfigProperties.setLimitTime(limitTime.getValue());
                log.info("\u4ece\u5b57\u5178\u52a0\u8f7d\u9650\u5236\u65f6\u95f4: {}", (Object)limitTime.getValue());
            }
            if (headerEnabled != null) {
                enabled = StringUtils.equals((CharSequence)headerEnabled.getValue(), (CharSequence)"1");
                this.sapConfigProperties.getHeader().setEnabled(enabled);
                log.info("\u4ece\u5b57\u5178\u52a0\u8f7d\u8bf7\u6c42\u5934\u5f00\u5173: {}", (Object)enabled);
            }
            if (feignEnabled != null) {
                enabled = StringUtils.equals((CharSequence)feignEnabled.getValue(), (CharSequence)"1");
                this.sapConfigProperties.getFeign().setEnabled(enabled);
                log.info("\u4ece\u5b57\u5178\u52a0\u8f7dFeign\u5f00\u5173: {}", (Object)enabled);
            }
        }
        catch (Exception e) {
            log.warn("\u52a0\u8f7d\u5176\u4ed6\u914d\u7f6e\u5931\u8d25\uff0c\u4f7f\u7528\u9ed8\u8ba4\u914d\u7f6e", (Throwable)e);
        }
    }

    private SapConfigProperties.PathMapping convertToPathMapping(DictDto dictDto) {
        try {
            SapConfigProperties.PathMapping mapping = new SapConfigProperties.PathMapping();
            String[] parts = dictDto.getCode().split("\\.");
            if (parts.length >= 3) {
                mapping.setPath(parts[0]);
                mapping.setTable(parts[1]);
                mapping.setField(parts[2]);
                if (parts.length > 3) {
                    mapping.setEnabled(StringUtils.equals((CharSequence)parts[3], (CharSequence)"1"));
                }
                if (parts.length > 4) {
                    mapping.setIgnoreGlobal(StringUtils.equals((CharSequence)parts[4], (CharSequence)"1"));
                }
                if (parts.length > 5) {
                    mapping.setOperator(parts[5]);
                }
                if (parts.length > 6) {
                    mapping.setConditionValue(parts[6]);
                }
                return mapping;
            }
        }
        catch (Exception e) {
            log.warn("\u8f6c\u6362\u8def\u5f84\u6620\u5c04\u914d\u7f6e\u5931\u8d25: {}", (Object)dictDto.getCode(), (Object)e);
        }
        return null;
    }

    public DictDto getDictConfig(String groupCode, String code) {
        String key = groupCode + "." + code;
        return this.dictCache.get(key);
    }

    public List<DictDto> getDictGroup(String groupCode) {
        return this.groupCache.get(groupCode);
    }

    public void refreshGroup(String groupCode) {
        try {
            List dicts = (List)this.pcpDictQueryApi.queryByGroupCode(groupCode).getData();
            if (dicts != null) {
                this.groupCache.put(groupCode, dicts);
                for (DictDto dict : dicts) {
                    String key = groupCode + "." + dict.getCode();
                    this.dictCache.put(key, dict);
                }
                log.info("\u624b\u52a8\u5237\u65b0\u5b57\u5178\u5206\u7ec4 {} \u5b8c\u6210\uff0c\u5171 {} \u6761\u914d\u7f6e", (Object)groupCode, (Object)dicts.size());
            }
        }
        catch (Exception e) {
            log.error("\u624b\u52a8\u5237\u65b0\u5b57\u5178\u5206\u7ec4 {} \u5931\u8d25", (Object)groupCode, (Object)e);
        }
    }

    public Map<String, DictDto> getAllDictConfigs() {
        return new ConcurrentHashMap<String, DictDto>(this.dictCache);
    }

    public void clearCache() {
        this.dictCache.clear();
        this.groupCache.clear();
        log.info("\u5b57\u5178\u914d\u7f6e\u7f13\u5b58\u5df2\u6e05\u7a7a");
    }

    public String getCacheStats() {
        return String.format("\u5b57\u5178\u914d\u7f6e\u7f13\u5b58\u7edf\u8ba1 - \u5355\u4e2a\u914d\u7f6e: %d, \u5206\u7ec4\u914d\u7f6e: %d", this.dictCache.size(), this.groupCache.size());
    }
}

