/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.sap.interceptor.feign;

import com.dtyunxi.sap.interceptor.context.SapServiceContextProvider;
import feign.RequestInterceptor;
import feign.RequestTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class SapFeignInterceptor
implements RequestInterceptor {
    private static final Logger logger = LoggerFactory.getLogger(SapFeignInterceptor.class);
    private static final String SAP_HEADER_NAME = "X-SAP-Flag";
    private final SapServiceContextProvider serviceContextProvider;

    public SapFeignInterceptor(SapServiceContextProvider serviceContextProvider) {
        this.serviceContextProvider = serviceContextProvider;
    }

    public void apply(RequestTemplate requestTemplate) {
        String sapFlag = (String)this.serviceContextProvider.getAttachment("sap-flag");
        if (!StringUtils.isEmpty((Object)sapFlag)) {
            requestTemplate.header(SAP_HEADER_NAME, new String[]{sapFlag});
            logger.debug("Feign\u8c03\u7528\u900f\u4f20SAP\u6807\u8bc6: {} -> {}", (Object)sapFlag, (Object)requestTemplate.url());
        } else {
            logger.debug("Feign\u8c03\u7528\u672a\u53d1\u73b0SAP\u6807\u8bc6\uff0c\u8df3\u8fc7\u900f\u4f20: {}", (Object)requestTemplate.url());
        }
    }
}

