/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.item.biz.base.apiimpl.query;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.dto.RequestDto;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.item.api.base.constants.ItemBizTypeEnum;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.BranchQueryItemReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.BundleItemReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.DirItemRelativeReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemAllowOrderQueryReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemDirQueryReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemSearchQueryReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemSearchReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemShelfQueryReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemSkuReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ShelfQueryReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ShelfReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ShelfTaskQueryReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.BranchItemRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.BundleItemRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.DirItemRelativeQueryRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemAllowOrderQueryRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemAttributesRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemDetailBaseInfoRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemDetailRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemDirQueryRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemMediasRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemOnShelfRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemPriceRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemSearchRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemShelfCountRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemShelfQueryRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemShelfRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemShelfSkuRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemSkuCodeQueryRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemSkuDetailRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemSkuListRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemSkuRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemStatRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.PointsDeductionRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.PropNameRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ShelfQueryRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ShelfTaskQueryRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.exception.ItemBusinessRuntimeException;
import com.dtyunxi.yundt.cube.center.item.api.base.exception.ItemExceptionCode;
import com.dtyunxi.yundt.cube.center.item.biz.base.apiimpl.query.AbstractItemQueryApiImpl;
import com.dtyunxi.yundt.cube.center.item.biz.base.plugin.EnableCachePlugin;
import com.dtyunxi.yundt.cube.center.item.biz.base.service.IDirService;
import com.dtyunxi.yundt.cube.center.item.biz.base.service.IDirectoryItemService;
import com.dtyunxi.yundt.cube.center.item.biz.base.service.IItemAttributesService;
import com.dtyunxi.yundt.cube.center.item.biz.base.service.IItemMediasService;
import com.dtyunxi.yundt.cube.center.item.biz.base.service.IItemPriceService;
import com.dtyunxi.yundt.cube.center.item.biz.base.service.IItemService;
import com.dtyunxi.yundt.cube.center.item.biz.base.service.IItemShelfService;
import com.dtyunxi.yundt.cube.center.item.biz.base.service.IItemSkuService;
import com.dtyunxi.yundt.cube.center.item.biz.base.service.IItemTagService;
import com.dtyunxi.yundt.cube.center.item.biz.base.service.IPropService;
import com.dtyunxi.yundt.cube.center.item.biz.base.service.IShelfService;
import com.dtyunxi.yundt.cube.center.item.biz.base.util.QueryParamUtils;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.DirItemRelationEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.ItemAttributesEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.ItemEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.ItemMediasEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.ItemPriceEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.ItemSkuEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.ItemTagRelationEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.StdItemTagRelationEo;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.common.primitives.Longs;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="vattiItemQueryApi")
public class VattiItemQueryApiImpl
extends AbstractItemQueryApiImpl {
    private Logger logger = LoggerFactory.getLogger(VattiItemQueryApiImpl.class);
    @Resource
    private IItemService itemService;
    @Resource
    private IItemTagService itemTagService;
    @Resource
    private IItemAttributesService itemAttributesService;
    @Resource
    private IItemMediasService iItemMediasService;
    @Resource
    private IItemSkuService iItemSkuService;
    @Resource
    private IItemShelfService itemShelfService;
    @Resource
    private IItemPriceService iItemPriceService;
    @Resource
    private IDirectoryItemService directoryItemService;
    @Resource(name="${yunxi.dg.base.project:tcbj}ShelfService")
    private IShelfService shelfService;
    @Resource
    private IDirService dirService;
    @Resource
    private IPropService propService;
    @Resource
    private ICacheService cacheService;
    @Value(value="${item.query.redis.timeout:300}")
    private Integer queryTimeout;

    @Override
    public RestResponse<PageInfo<ItemOnShelfRespDto>> findItemOnSelf(String filter, Integer pageNum, Integer pageSize) {
        return new RestResponse(this.itemService.findItemOnSelf(filter, pageNum, pageSize));
    }

    @Override
    public RestResponse<PageInfo<ItemRespDto>> queryItemLibByPage(ItemReqDto itemReqDto, Integer pageNum, Integer pageSize) {
        String filter = itemReqDto != null ? JSON.toJSONString((Object)itemReqDto) : "";
        return this.queryByPage(filter, pageNum, pageSize);
    }

    @Override
    public RestResponse<PageInfo<ItemRespDto>> queryByPage(String filters, Integer pageNum, Integer pageSize) {
        this.logger.info("\u67e5\u8be2\u5546\u54c1\u6570\u636e\uff0c\u5165\u53c2\uff1a{}, ", (Object)filters);
        PageInfo<ItemRespDto> pageInfo = new PageInfo<ItemRespDto>();
        pageInfo.setPageNum(pageNum.intValue());
        pageInfo.setPageSize(pageSize.intValue());
        ItemEo itemEo = ItemEo.newInstance();
        if (StringUtils.isNotBlank((CharSequence)filters) && !"{}".equals(filters)) {
            ItemReqDto itemDto = (ItemReqDto)JSON.parseObject((String)filters, ItemReqDto.class);
            DtoHelper.dto2Eo((BaseVo)itemDto, (BaseEo)itemEo);
            QueryParamUtils.fillQueryCreateStartTime(itemDto.getCreateBeginTime(), (BaseEo)itemEo);
            QueryParamUtils.fillQueryCreateEndTime(itemDto.getCreateEndTime(), (BaseEo)itemEo);
            QueryParamUtils.fillQueryUpdateTime(itemDto.getUpdateBeginTime(), itemDto.getUpdateEndTime(), (BaseEo)itemEo);
            QueryParamUtils.columnLike((BaseEo)itemEo, "name", itemDto.getName());
            ArrayList<SqlFilter> sqlFilterList = itemEo.getSqlFilters();
            if (sqlFilterList == null) {
                sqlFilterList = new ArrayList<SqlFilter>();
            }
            if (!CollectionUtils.isEmpty((Collection)itemDto.getItemIds())) {
                itemEo.setId((Long)null);
                sqlFilterList.add(SqlFilter.in((String)"id", (Object)itemDto.getItemIds()));
            }
            if (!CollectionUtils.isEmpty((Collection)itemDto.getShopIds())) {
                itemEo.setShopId((Long)null);
                sqlFilterList.add(SqlFilter.in((String)"shop_id", (Object)itemDto.getShopIds()));
            }
            if (!CollectionUtils.isEmpty((Collection)itemDto.getStatusList())) {
                itemEo.setStatus((Integer)null);
                sqlFilterList.add(SqlFilter.in((String)"status", (Object)itemDto.getStatusList()));
            }
            if (!CollectionUtils.isEmpty((Collection)itemDto.getTypeList())) {
                itemEo.setType((Integer)null);
                sqlFilterList.add(SqlFilter.in((String)"type", (Object)itemDto.getTypeList()));
            }
            List<Object> dirIdList = new ArrayList();
            if (Objects.nonNull(itemDto.getDirId())) {
                dirIdList = this.dirService.getChildDirIdList(Lists.newArrayList((Object[])new Long[]{itemDto.getDirId()}), null, null);
            }
            if (CollectionUtils.isNotEmpty(dirIdList)) {
                itemEo.setDirId((Long)null);
                sqlFilterList.add(SqlFilter.in((String)"dirId", dirIdList));
            }
            if (Objects.nonNull(itemDto.getCode())) {
                itemEo.setCode((String)null);
                sqlFilterList.add(SqlFilter.eq((String)"code", (Object)itemDto.getCode()));
            }
            if (StringUtils.isNotBlank((CharSequence)itemDto.getSkuCode())) {
                ItemSkuEo itemSkuEo = this.iItemSkuService.getBySkuCode(itemDto.getSkuCode());
                if (null == itemSkuEo) {
                    return new RestResponse(pageInfo);
                }
                itemEo.setId(itemSkuEo.getItemId());
            }
            if (null != itemDto.getYearBegin()) {
                sqlFilterList.add(SqlFilter.ge((String)"year", (Object)itemDto.getYearBegin()));
            }
            if (null != itemDto.getYearEnd()) {
                sqlFilterList.add(SqlFilter.le((String)"year", (Object)itemDto.getYearEnd()));
            }
            if (null != itemDto.getBizType() && ItemBizTypeEnum.ITEM_LIB.getType().equals(itemDto.getBizType())) {
                sqlFilterList.add(SqlFilter.eq((String)"sellerId", (Object)0));
            } else {
                sqlFilterList.add(SqlFilter.ne((String)"sellerId", (Object)0));
            }
            if (!CollectionUtils.isEmpty((Collection)itemDto.getDirIdList())) {
                sqlFilterList.add(SqlFilter.in((String)"dir_id", (Object)itemDto.getDirIdList()));
            }
            if (!CollectionUtils.isEmpty((Collection)itemDto.getBrandIdList())) {
                sqlFilterList.add(SqlFilter.in((String)"brand_id", (Object)itemDto.getBrandIdList()));
            }
            itemEo.setSqlFilters(sqlFilterList);
        }
        itemEo.setOrderByDesc("update_time");
        pageInfo = this.itemService.queryByPage(itemEo, pageNum, pageSize);
        return new RestResponse(pageInfo);
    }

    @Override
    public RestResponse<PageInfo<ItemShelfQueryRespDto>> queryShelfItemByPage(ItemShelfQueryReqDto itemShelfQueryReqDto, Integer pageNum, Integer pageSize) {
        PageInfo<ItemShelfQueryRespDto> pageInfo = this.shelfService.getItemShelfPage(itemShelfQueryReqDto, pageNum, pageSize);
        return new RestResponse(pageInfo);
    }

    @Override
    public RestResponse<ItemShelfCountRespDto> countShelfItem(ItemShelfQueryReqDto itemShelfQueryReqDto) {
        if (itemShelfQueryReqDto == null) {
            itemShelfQueryReqDto = new ItemShelfQueryReqDto();
        }
        ItemShelfCountRespDto dto = new ItemShelfCountRespDto();
        Long totalNum = 0L;
        Long onShelfNum = 0L;
        Long offShelfNum = 0L;
        Long sellOutNum = 0L;
        itemShelfQueryReqDto.setItemStatus((Integer)null);
        itemShelfQueryReqDto.setSellOut((Boolean)null);
        itemShelfQueryReqDto.setItemType(itemShelfQueryReqDto.getItemType());
        totalNum = this.shelfService.countItemShelf(itemShelfQueryReqDto);
        dto.setTotalNum(totalNum);
        itemShelfQueryReqDto.setItemStatus(Integer.valueOf(1));
        onShelfNum = this.shelfService.countItemShelf(itemShelfQueryReqDto);
        itemShelfQueryReqDto.setItemStatus(Integer.valueOf(2));
        offShelfNum = this.shelfService.countItemShelf(itemShelfQueryReqDto);
        itemShelfQueryReqDto.setItemStatus((Integer)null);
        itemShelfQueryReqDto.setSellOut(Boolean.valueOf(true));
        sellOutNum = this.shelfService.countItemShelf(itemShelfQueryReqDto);
        dto.setTotalNum(totalNum);
        dto.setOnShelfNum(onShelfNum);
        dto.setOffShelfNum(offShelfNum);
        dto.setSellOutNum(sellOutNum);
        return new RestResponse((Object)dto);
    }

    @Override
    public RestResponse<List<ItemShelfSkuRespDto>> queryShelfItemSkuList(Long shopId, Long itemId, Integer busType) {
        return new RestResponse(this.shelfService.queryShelfItemSkuList(shopId, itemId, busType));
    }

    @Override
    public RestResponse<ItemDetailRespDto> queryItemDetail(Long id, String field, Long dirId) {
        String cacheKey = "queryItemDetail_" + Long.toString(id);
        ItemDetailRespDto itemDetailDto = (ItemDetailRespDto)this.cacheService.getCache("item_trade_", cacheKey, ItemDetailRespDto.class);
        if (null != itemDetailDto && null != itemDetailDto.getItem()) {
            return new RestResponse((Object)itemDetailDto);
        }
        itemDetailDto = this.itemService.queryItemDetail(id, field, dirId);
        this.cacheService.setCache("item_trade_", cacheKey, (Object)itemDetailDto, this.queryTimeout.intValue());
        return new RestResponse((Object)itemDetailDto);
    }

    @Override
    public RestResponse<ItemSearchRespDto> queryByKeyword(ItemSearchReqDto itemSearchReqDto) {
        Long tenantId = ServiceContext.getContext().getRequestTenantId();
        Long instanceId = ServiceContext.getContext().getRequestInstanceId();
        ItemSearchQueryReqDto itemSearchQueryReqDto = new ItemSearchQueryReqDto();
        itemSearchQueryReqDto.setKeyword(itemSearchReqDto.getKeyword());
        itemSearchQueryReqDto.setBrandId(itemSearchReqDto.getBrandId());
        itemSearchQueryReqDto.setProp(itemSearchReqDto.getProp());
        ArrayList dirIds = Lists.newArrayList();
        dirIds.add(itemSearchReqDto.getDirId());
        itemSearchQueryReqDto.setDirIds((List)dirIds);
        itemSearchQueryReqDto.setBusType(itemSearchReqDto.getItemType());
        itemSearchQueryReqDto.setInstanceId(instanceId);
        itemSearchQueryReqDto.setTenantId(tenantId);
        if (StringUtils.isNotEmpty((CharSequence)itemSearchReqDto.getLat())) {
            itemSearchQueryReqDto.setLat(Double.valueOf(itemSearchReqDto.getLat()));
        }
        if (StringUtils.isNotEmpty((CharSequence)itemSearchReqDto.getLon())) {
            itemSearchQueryReqDto.setLon(Double.valueOf(itemSearchReqDto.getLon()));
        }
        ItemSearchRespDto itemSearchRespDto = this.itemService.queryByKeyword(itemSearchQueryReqDto, itemSearchReqDto.getPageNum(), itemSearchReqDto.getPageSize());
        return new RestResponse((Object)itemSearchRespDto);
    }

    @Override
    public RestResponse<ItemSearchRespDto> queryByKeyword(String filter, Integer pageNum, Integer pageSize) {
        ItemSearchQueryReqDto itemSearchQueryReqDto = (ItemSearchQueryReqDto)JSON.parseObject((String)filter, ItemSearchQueryReqDto.class);
        if (itemSearchQueryReqDto == null) {
            throw new ItemBusinessRuntimeException(ItemExceptionCode.NON_EXIST_PARAM);
        }
        return new RestResponse((Object)this.itemService.queryByKeyword(itemSearchQueryReqDto, pageNum, pageSize));
    }

    @Override
    public RestResponse<PageInfo<ItemRespDto>> queryItemByTagId(String ids, Integer pageNum, Integer pageSize, String filter) {
        RequestDto requestDto = this.parseFilter(filter);
        List<ItemTagRelationEo> itemTagEos = this.itemTagService.queryItemTag(ids, requestDto.getTenantId(), requestDto.getInstanceId());
        PageInfo<ItemRespDto> pageInfo = new PageInfo<ItemRespDto>();
        if (CollectionUtils.isEmpty(itemTagEos)) {
            pageInfo.setPageNum(pageNum.intValue());
            pageInfo.setPageSize(pageSize.intValue());
            return new RestResponse((Object)pageInfo);
        }
        List itemIds = itemTagEos.stream().map(StdItemTagRelationEo::getItemId).collect(Collectors.toList());
        ItemEo example = ItemEo.newInstance();
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        sqlFilters.add(SqlFilter.in((String)"id", (Object)StringUtils.join(itemIds, (String)",")));
        example.setSqlFilters(sqlFilters);
        pageInfo = this.itemService.queryByPage(example, pageNum, pageSize);
        return new RestResponse(pageInfo);
    }

    private RequestDto parseFilter(String filter) {
        return StringUtils.isNotBlank((CharSequence)filter) ? (RequestDto)JSON.parseObject((String)filter, RequestDto.class) : new RequestDto();
    }

    private ItemReqDto parseItemFilter(String filter) {
        return StringUtils.isNotBlank((CharSequence)filter) ? (ItemReqDto)JSON.parseObject((String)filter, ItemReqDto.class) : new ItemReqDto();
    }

    @Override
    public RestResponse<PageInfo<ItemRespDto>> queryItemByBrandId(String brandIds, Integer pageNum, Integer pageSize, String filter) {
        ItemReqDto itemReqDto = (ItemReqDto)JSON.parseObject((String)filter, ItemReqDto.class);
        ItemEo example = ItemEo.newInstance();
        CubeBeanUtils.copyProperties((Object)example, (Object)itemReqDto, (String[])new String[0]);
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        sqlFilters.add(SqlFilter.in((String)"brand_id", (Object)brandIds));
        example.setSqlFilters(sqlFilters);
        PageInfo<ItemRespDto> pageInfo = this.itemService.queryByPage(example, pageNum, pageSize);
        return new RestResponse(pageInfo);
    }

    @Override
    public RestResponse<PageInfo<ItemRespDto>> queryItemByDirId(String dirIds, Integer pageNum, Integer pageSize, String filter) {
        ItemReqDto itemReqDto;
        List<Object> dirs = Lists.newArrayList();
        if (StringUtils.isNotEmpty((CharSequence)dirIds)) {
            long[] longArray = (long[])ConvertUtils.convert((String[])StringUtils.split((String)dirIds, (String)","), Long.TYPE);
            dirs = Longs.asList((long[])longArray);
        }
        if ((itemReqDto = this.parseItemFilter(filter)).getInstanceId() != null && itemReqDto.getTenantId() != null) {
            dirs = this.directoryItemService.convertLinkDir(dirs, itemReqDto.getInstanceId(), itemReqDto.getTenantId());
            PageInfo<ItemRespDto> pageInfo = new PageInfo<ItemRespDto>();
            if (CollectionUtils.isEmpty((Collection)dirs)) {
                pageInfo.setPageNum(pageNum.intValue());
                pageInfo.setPageSize(pageSize.intValue());
                return new RestResponse((Object)pageInfo);
            }
            PageInfo<DirItemRelationEo> dirsItemPageInfo = this.itemShelfService.queryByDirIds(itemReqDto.getTenantId(), itemReqDto.getInstanceId(), dirs, pageNum, pageSize);
            List dirsItemsEoList = dirsItemPageInfo.getList();
            if (CollectionUtils.isEmpty((Collection)dirsItemsEoList)) {
                pageInfo.setPageSize(pageSize.intValue());
                pageInfo.setPageNum(pageNum.intValue());
                return new RestResponse((Object)pageInfo);
            }
            ArrayList<Long> itemIds = new ArrayList<Long>();
            for (DirItemRelationEo dirsItemsEo : dirsItemsEoList) {
                itemIds.add(dirsItemsEo.getItemId());
            }
            ItemEo example = ItemEo.newInstance();
            ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
            sqlFilters.add(SqlFilter.in((String)"id", (Object)StringUtils.join(itemIds, (String)",")));
            sqlFilters.add(SqlFilter.eq((String)"status", (Object)itemReqDto.getStatus()));
            if (StringUtils.isNotBlank((CharSequence)itemReqDto.getName())) {
                sqlFilters.add(SqlFilter.like((String)"name", (Object)("%" + StringUtils.trim((String)itemReqDto.getName()) + "%")));
            }
            if (StringUtils.isNotBlank((CharSequence)itemReqDto.getCode())) {
                sqlFilters.add(SqlFilter.eq((String)"code", (Object)StringUtils.trim((String)itemReqDto.getCode())));
            }
            List<Object> dirIdList = new ArrayList();
            if (Objects.nonNull(itemReqDto.getDirId())) {
                dirIdList = this.dirService.getChildDirIdList(Lists.newArrayList((Object[])new Long[]{itemReqDto.getDirId()}), null, null);
            }
            if (CollectionUtils.isNotEmpty(dirIdList)) {
                sqlFilters.add(SqlFilter.in((String)"dirId", dirIdList));
            }
            if (StringUtils.isNotBlank((CharSequence)itemReqDto.getSkuCode())) {
                ItemSkuEo itemSkuEo = this.iItemSkuService.getBySkuCode(itemReqDto.getSkuCode());
                if (null == itemSkuEo) {
                    return new RestResponse((Object)pageInfo);
                }
                example.setId(itemSkuEo.getItemId());
            }
            if (null != itemReqDto.getYearEnd()) {
                sqlFilters.add(SqlFilter.le((String)"year", (Object)itemReqDto.getYearEnd()));
            }
            if (null != itemReqDto.getYearBegin()) {
                sqlFilters.add(SqlFilter.ge((String)"year", (Object)itemReqDto.getYearBegin()));
            }
            if (null != itemReqDto.getBizType() && ItemBizTypeEnum.ITEM_LIB.getType().equals(itemReqDto.getBizType())) {
                sqlFilters.add(SqlFilter.eq((String)"sellerId", (Object)0));
            } else {
                sqlFilters.add(SqlFilter.ne((String)"sellerId", (Object)0));
            }
            example.setSqlFilters(sqlFilters);
            pageInfo = this.itemService.queryByPage(example, pageNum, pageSize);
            return new RestResponse(pageInfo);
        }
        throw new ItemBusinessRuntimeException(ItemExceptionCode.NON_EXIST_PARAM);
    }

    @Override
    @EnableCachePlugin
    public RestResponse<ItemSearchRespDto> queryItemByDirIdDepth(ItemSearchQueryReqDto itemSearchReqDto, Integer pageNum, Integer pageSize) {
        return new RestResponse((Object)this.itemService.queryItemByDirIdDepth(itemSearchReqDto, pageNum, pageSize));
    }

    @Override
    public RestResponse<PageInfo<ItemAttributesRespDto>> queryItemAttrById(Long id, Integer pageNum, Integer pageSize) {
        ItemAttributesEo itemAttributesEo = ItemAttributesEo.newInstance();
        itemAttributesEo.setItemId(id);
        PageInfo<ItemAttributesEo> pageInfo = this.itemAttributesService.queryByPage(itemAttributesEo, pageNum, pageSize);
        PageInfo itemAttributesDtoPageInfo = new PageInfo();
        ArrayList itemAttributesRespDtos = new ArrayList();
        CubeBeanUtils.copyProperties((Object)itemAttributesDtoPageInfo, pageInfo, (String[])new String[]{"list", "navigatepageNums"});
        DtoHelper.eoList2DtoList((Collection)pageInfo.getList(), itemAttributesRespDtos, ItemAttributesRespDto.class);
        itemAttributesDtoPageInfo.setList(itemAttributesRespDtos);
        return new RestResponse((Object)itemAttributesDtoPageInfo);
    }

    @Override
    public RestResponse<List<ItemSkuRespDto>> queryItemSkuByItemId(Long itemId) {
        ItemSkuEo itemSkuEo = ItemSkuEo.newInstance();
        itemSkuEo.setItemId(itemId);
        List<ItemSkuEo> itemSkuEos = this.iItemSkuService.queryItemSku(itemSkuEo);
        ArrayList list = new ArrayList();
        DtoHelper.eoList2DtoList(itemSkuEos, list, ItemSkuRespDto.class);
        return new RestResponse(list);
    }

    @Override
    public RestResponse<List<ItemMediasRespDto>> queryItemMediasByItemId(Long itemId) {
        ItemMediasEo itemMediasEo = ItemMediasEo.newInstance();
        itemMediasEo.setOrderBy("id");
        itemMediasEo.setItemId(itemId);
        List<ItemMediasEo> itemMediasEos = this.iItemMediasService.queryItemMedias(itemMediasEo);
        ArrayList list = new ArrayList();
        DtoHelper.eoList2DtoList(itemMediasEos, list, ItemMediasRespDto.class);
        return new RestResponse(list);
    }

    @Override
    public RestResponse<ItemSkuListRespDto> queryItemBySkuId(List<Long> skuIds) {
        return new RestResponse((Object)this.itemService.queryItemBySkuId(skuIds));
    }

    @Override
    public RestResponse<List<ItemPriceRespDto>> queryItemPriceByItemId(Long id) {
        List<ItemPriceEo> itemPriceEos = this.iItemPriceService.queryItemPriceById(id);
        ArrayList itemPriceDtos = Lists.newArrayList();
        DtoHelper.eoList2DtoList(itemPriceEos, (Collection)itemPriceDtos, ItemPriceRespDto.class);
        return new RestResponse((Object)itemPriceDtos);
    }

    @Override
    public RestResponse<List<ItemDirQueryRespDto>> queryItemDir(String filter) {
        ItemDirQueryReqDto itemDirQueryReqDto = (ItemDirQueryReqDto)JSON.parseObject((String)filter, ItemDirQueryReqDto.class);
        return new RestResponse(this.itemService.queryItemDir(itemDirQueryReqDto));
    }

    @Override
    public RestResponse<List<DirItemRelativeQueryRespDto>> queryItemDirRelative(String filter) {
        DirItemRelativeReqDto dirItemReqDto = (DirItemRelativeReqDto)JSON.parseObject((String)filter, DirItemRelativeReqDto.class);
        return new RestResponse(this.itemService.queryItemDirRelative(dirItemReqDto));
    }

    @Override
    public RestResponse<PageInfo<ShelfTaskQueryRespDto>> queryShelfTask(String filter, Integer pageNum, Integer pageSize) {
        ShelfTaskQueryReqDto shelfTaskQueryReqDto = (ShelfTaskQueryReqDto)JSON.parseObject((String)filter, ShelfTaskQueryReqDto.class);
        return new RestResponse(this.itemService.queryShelfTask(shelfTaskQueryReqDto, pageNum, pageSize));
    }

    @Override
    public RestResponse<ItemAllowOrderQueryRespDto> checkItemAllowOrder(String filter) {
        List itemAllowOrderReqDtoList = JSON.parseArray((String)filter, ItemAllowOrderQueryReqDto.class);
        return new RestResponse((Object)this.itemService.checkItemAllowOrder(itemAllowOrderReqDtoList));
    }

    @Override
    public RestResponse<ItemSkuCodeQueryRespDto> querySkuByCode(String codes) {
        List<String> codeList = Arrays.asList(codes.trim().split(","));
        return new RestResponse((Object)this.iItemSkuService.querySkuByCode(codeList));
    }

    @Override
    public RestResponse<List<ItemRespDto>> checkShoppingCartItemInvalid(String itemIds, String filter) {
        String[] ids;
        ArrayList<Long> itemIdList = new ArrayList<Long>();
        String[] var5 = ids = itemIds.trim().split(",");
        int var6 = ids.length;
        for (int var7 = 0; var7 < var6; ++var7) {
            String id = var5[var7];
            itemIdList.add(Long.parseLong(id));
        }
        return new RestResponse(this.itemService.queryItemStatus(itemIdList));
    }

    @Override
    public RestResponse<ItemStatRespDto> queryItemSalesCountByItemId(Long itemId, String filter) {
        return new RestResponse((Object)this.itemService.queryItemSalesCountByItemId(itemId, filter));
    }

    @Override
    public RestResponse<List<ItemRespDto>> queryByItemIds(String itemIds) {
        String[] ids;
        ArrayList<Long> itemIdList = new ArrayList<Long>();
        String[] var4 = ids = itemIds.trim().split(",");
        int var5 = ids.length;
        for (int var6 = 0; var6 < var5; ++var6) {
            String id = var4[var6];
            itemIdList.add(Long.parseLong(id));
        }
        return new RestResponse(this.itemService.queryItems(itemIdList));
    }

    @Override
    public RestResponse<PageInfo<Long>> querySaleOut(String itemReq, int page, int size) {
        ItemReqDto itemDto = (ItemReqDto)JSON.parseObject((String)itemReq, ItemReqDto.class);
        return new RestResponse(this.itemService.querySaleOut(itemDto, page, size));
    }

    @Override
    public RestResponse<Long> queryCount(String filter) {
        ItemReqDto itemDto = (ItemReqDto)JSON.parseObject((String)filter, ItemReqDto.class);
        return new RestResponse((Object)this.itemService.queryCount(itemDto));
    }

    @Override
    public RestResponse<PageInfo<ItemShelfRespDto>> queryItemShelf(String filter, Integer pageNum, Integer pageSize) {
        ShelfReqDto shelfReqDto = (ShelfReqDto)JSON.parseObject((String)filter, ShelfReqDto.class);
        return new RestResponse(this.itemService.queryItemShelf(shelfReqDto, pageNum, pageSize));
    }

    @Override
    public RestResponse<List<Long>> queryItemIds(String filter) {
        ItemReqDto itemReqDto = (ItemReqDto)JSON.parseObject((String)filter, ItemReqDto.class);
        return new RestResponse(this.itemService.queryItemIds(itemReqDto));
    }

    @Override
    public RestResponse<ItemRespDto> queryItemAndSku(Long itemId, Long skuId) {
        return new RestResponse((Object)this.itemService.queryItemAndSku(itemId, skuId));
    }

    @Override
    public RestResponse<ItemSkuDetailRespDto> getSkuDetail(ItemSkuReqDto itemSkuReqDto) {
        return new RestResponse((Object)this.iItemSkuService.getSkuDetail(itemSkuReqDto));
    }

    @Override
    public RestResponse<BigDecimal> getSkuCostPrice(Long skuId) {
        return null;
    }

    @Override
    public RestResponse<ItemDetailBaseInfoRespDto> detail(long id, long shopId) {
        return new RestResponse((Object)this.itemService.queryItemDetail(id, shopId));
    }

    @Override
    public RestResponse<Integer> countByFreightTemplateId(Long freightTemplateId) {
        int count = this.itemShelfService.countByFreightTemplateId(freightTemplateId);
        return new RestResponse((Object)count);
    }

    @Override
    public RestResponse<BranchItemRespDto> branchQueryItem(BranchQueryItemReqDto branchQueryItemReqDto) {
        return new RestResponse((Object)this.itemService.branchQueryItem(branchQueryItemReqDto));
    }

    @Override
    public RestResponse<List<PointsDeductionRespDto>> queryShelfSkuPointsDeduction(Set<Long> shelfIds) {
        return new RestResponse(this.shelfService.queryShelfItemPointsDeduction(shelfIds));
    }

    @Override
    public RestResponse<List<ShelfQueryRespDto>> queryShelfList(ShelfQueryReqDto shelfQueryReqDto) {
        return new RestResponse(this.shelfService.queryShelfList(shelfQueryReqDto));
    }

    @Override
    public RestResponse<List<BundleItemRespDto>> queryBundleItemDetail(Long shopId, Long itemId, Integer itemBusType) {
        return new RestResponse(this.itemService.queryBundleItemDetail(shopId, itemId, itemBusType));
    }

    @Override
    public RestResponse<List<ItemSkuRespDto>> queryItemSkus(List<Long> skuIds) {
        return new RestResponse(this.iItemSkuService.queryBySkuId(skuIds));
    }

    @Override
    public RestResponse<List<BundleItemRespDto>> queryBundleItem(Long itemId) {
        return new RestResponse(this.itemService.queryBundleItem(itemId));
    }

    @Override
    public RestResponse<List<BundleItemRespDto>> queryBundleItemList(BundleItemReqDto bundleItemReqDto) {
        return new RestResponse(this.itemService.queryBundleItem(bundleItemReqDto));
    }

    @Override
    public RestResponse<List<PropNameRespDto>> queryItemBasePropList(Long itemId) {
        return new RestResponse(this.propService.queryPropNameListByItemId(itemId));
    }

    @Override
    public RestResponse<ItemRespDto> queryByItemCode(String itemCode) {
        return new RestResponse((Object)this.itemService.queryByItemCode(itemCode));
    }

    @Override
    public RestResponse<List<ItemAttributesRespDto>> queryItemAttrByItemIdList(List<Long> itemIdList) {
        return new RestResponse(this.itemAttributesService.queryItemAttrByItemIdList(itemIdList));
    }
}

