/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.item.biz.service.handle.strategy;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.util.SpringBeanUtil;
import com.dtyunxi.yundt.cube.center.item.biz.service.handle.strategy.AbstractSyncItemStrategy;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.ItemDas;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.ItemSkuDas;
import com.dtyunxi.yundt.cube.center.item.dao.das.ItemExtendDas;
import com.dtyunxi.yundt.cube.center.item.dao.eo.ItemExtendEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.ItemEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.ItemSkuEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.StdItemSkuEo;
import com.yunxi.dg.base.center.item.dto.request.DgSyncItemSkuInfoDto;
import com.yunxi.dg.base.center.item.dto.sync.DgSyncItemInfoDto;
import com.yunxi.dg.base.commons.constants.CommonConstants;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.assertj.core.util.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyncItemCoverStrategy
extends AbstractSyncItemStrategy {
    private static final Logger log = LoggerFactory.getLogger(SyncItemCoverStrategy.class);

    @Override
    public void dealWithSyncItemInfo(DgSyncItemInfoDto itemInfoDto) {
        ItemDas itemDas = (ItemDas)SpringBeanUtil.getBean(ItemDas.class);
        ItemSkuDas itemSkuDas = (ItemSkuDas)SpringBeanUtil.getBean(ItemSkuDas.class);
        ItemExtendDas itemExtendDas = (ItemExtendDas)SpringBeanUtil.getBean(ItemExtendDas.class);
        ItemEo itemEo = this.extractItemEo(itemInfoDto, itemDas.listByLongCode((List)Lists.newArrayList((Object[])new String[]{itemInfoDto.getLongCode()})));
        itemDas.insertOrUpdate((BaseEo)itemEo);
        itemSkuDas.insertOrUpdateBatch(this.handleItemSkuInfo(itemInfoDto, itemEo, itemSkuDas));
        itemExtendDas.insertOrUpdateBatch(this.handleItemExtendInfo(itemInfoDto, itemEo, itemExtendDas));
        itemInfoDto.setId(itemEo.getId());
    }

    private List<ItemExtendEo> handleItemExtendInfo(DgSyncItemInfoDto itemInfoDto, ItemEo itemEo, ItemExtendDas itemExtendDas) {
        Map<String, ItemExtendEo> extendEoMap = this.mapItemExtendBySkuCodes(itemInfoDto, itemExtendDas);
        ArrayList<ItemExtendEo> itemExtendEos = new ArrayList<ItemExtendEo>();
        for (DgSyncItemSkuInfoDto skuInfoDto : itemInfoDto.getDgSyncItemSkuInfoDtos()) {
            if (CollectionUtil.isEmpty((Map)skuInfoDto.getExtensionMap())) continue;
            ItemExtendEo itemExtendEo = extendEoMap.get(skuInfoDto.getCode());
            itemExtendEos.add(this.getToBeanItemExtendEo(skuInfoDto, itemExtendEo, itemEo));
        }
        log.info("handleItemExtendInfo->>>>\u540c\u6b65\u6269\u5c55\u4fe1\u606f-{}", (Object)JSON.toJSONString(itemExtendEos));
        return itemExtendEos;
    }

    private ItemExtendEo getToBeanItemExtendEo(DgSyncItemSkuInfoDto skuInfoDto, ItemExtendEo itemExtendEo, ItemEo itemEo) {
        ItemExtendEo newEo = new ItemExtendEo();
        BeanUtil.copyProperties((Object)skuInfoDto.getExtensionMap(), (Object)newEo, (String[])new String[0]);
        if (Objects.nonNull(itemExtendEo)) {
            newEo.setId(itemExtendEo.getId());
            newEo.setCreatePerson(itemExtendEo.getCreatePerson());
            newEo.setCreateTime(itemExtendEo.getCreateTime());
        }
        if (StrUtil.isBlank((CharSequence)newEo.getItemCode())) {
            newEo.setItemCode(skuInfoDto.getCode());
        }
        newEo.setItemId(itemEo.getId());
        return newEo;
    }

    private Map<String, ItemExtendEo> mapItemExtendBySkuCodes(DgSyncItemInfoDto itemInfoDto, ItemExtendDas itemExtendDas) {
        Set skuCodes = itemInfoDto.getDgSyncItemSkuInfoDtos().stream().map(DgSyncItemSkuInfoDto::getCode).collect(Collectors.toSet());
        List list = itemExtendDas.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(ItemExtendEo.class).in(ItemExtendEo::getItemCode, skuCodes)).eq(BaseEo::getDr, (Object)CommonConstants.Dr.NO));
        return ((List)Optional.ofNullable(list).orElse(new ArrayList())).stream().collect(Collectors.toMap(ItemExtendEo::getItemCode, Function.identity(), (v1, v2) -> v2));
    }

    private List<ItemSkuEo> handleItemSkuInfo(DgSyncItemInfoDto itemInfoDto, ItemEo itemEo, ItemSkuDas itemSkuDas) {
        ArrayList<ItemSkuEo> skuEoList = new ArrayList<ItemSkuEo>();
        Map<String, ItemSkuEo> itemSkuEoMap = this.mapBySkuCodes(itemInfoDto, itemSkuDas);
        for (DgSyncItemSkuInfoDto skuInfoDto : itemInfoDto.getDgSyncItemSkuInfoDtos()) {
            ItemSkuEo itemSkuEo = itemSkuEoMap.get(skuInfoDto.getCode());
            itemSkuEo = this.getToBeanItemSkuEo(skuInfoDto, itemSkuEo);
            itemSkuEo.setItemId(itemEo.getId());
            skuEoList.add(itemSkuEo);
        }
        log.info("\u540c\u6b65sku ->handleItemSkuInfo---->{}", (Object)JSON.toJSONString(skuEoList));
        return skuEoList;
    }

    private ItemSkuEo getToBeanItemSkuEo(DgSyncItemSkuInfoDto skuInfoDto, ItemSkuEo itemSkuEo) {
        ItemSkuEo newEo = (ItemSkuEo)BeanUtil.toBean((Object)skuInfoDto, ItemSkuEo.class);
        if (CollectionUtil.isNotEmpty((Map)skuInfoDto.getExtensionMap())) {
            BeanUtil.copyProperties((Object)skuInfoDto.getExtensionMap(), (Object)newEo, (String[])new String[0]);
        }
        if (Objects.nonNull(itemSkuEo)) {
            newEo.setId(itemSkuEo.getId());
            newEo.setCreatePerson(itemSkuEo.getCreatePerson());
            newEo.setCreateTime(itemSkuEo.getCreateTime());
        }
        return newEo;
    }

    private Map<String, ItemSkuEo> mapBySkuCodes(DgSyncItemInfoDto itemInfoDto, ItemSkuDas itemSkuDas) {
        Set skuCodes = itemInfoDto.getDgSyncItemSkuInfoDtos().stream().map(DgSyncItemSkuInfoDto::getCode).collect(Collectors.toSet());
        List itemSkuEos = itemSkuDas.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(ItemSkuEo.class).in(StdItemSkuEo::getCode, skuCodes)).eq(BaseEo::getDr, (Object)CommonConstants.Dr.NO));
        return ((List)Optional.ofNullable(itemSkuEos).orElse(new ArrayList())).stream().collect(Collectors.toMap(StdItemSkuEo::getCode, Function.identity(), (v1, v2) -> v1));
    }

    private ItemEo extractItemEo(DgSyncItemInfoDto itemInfoDto, List<ItemEo> itemEos) {
        ItemEo coverItem = (ItemEo)BeanUtil.toBean((Object)itemInfoDto, ItemEo.class);
        if (CollectionUtil.isNotEmpty((Map)itemInfoDto.getExtensionMap())) {
            BeanUtil.copyProperties((Object)itemInfoDto.getExtensionMap(), (Object)coverItem, (String[])new String[0]);
        }
        if (CollectionUtil.isNotEmpty(itemEos)) {
            ItemEo itemEo = itemEos.get(0);
            coverItem.setId(itemEo.getId());
            coverItem.setCreatePerson(itemEo.getCreatePerson());
            coverItem.setCreateTime(itemEo.getCreateTime());
        }
        return coverItem;
    }
}

