/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.item.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemRespDto;
import com.dtyunxi.yundt.cube.center.item.api.constants.TaxRateEnum;
import com.dtyunxi.yundt.cube.center.item.api.dto.request.ItemDataQueryReqDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.request.ItemExtendImportDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.request.ItemExtendReqDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.request.ItemInfoSkuReqDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.request.PcpItemQueryDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.response.ItemBaseUnitQueryRespDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.response.ItemDataQueryRespDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.response.ItemDepartmentPriceRespDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.response.ItemExtendRespDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.response.ItemInfoSkuRespDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.response.ItemUnitConversionRespDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.response.OmsItemDetailDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.response.OmsItemRespDto;
import com.dtyunxi.yundt.cube.center.item.biz.base.service.IItemService;
import com.dtyunxi.yundt.cube.center.item.biz.base.service.IItemSkuService;
import com.dtyunxi.yundt.cube.center.item.biz.service.IItemDepartmentPriceService;
import com.dtyunxi.yundt.cube.center.item.biz.service.IItemExtendService;
import com.dtyunxi.yundt.cube.center.item.biz.service.IItemUnitConversionService;
import com.dtyunxi.yundt.cube.center.item.biz.util.LengthUnitUtils;
import com.dtyunxi.yundt.cube.center.item.biz.util.WeightUnitUtils;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.ItemDas;
import com.dtyunxi.yundt.cube.center.item.dao.das.ItemExtendDas;
import com.dtyunxi.yundt.cube.center.item.dao.eo.ItemExtendEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.ItemEo;
import com.dtyunxi.yundt.cube.center.item.dao.mapper.ItemExtendMapper;
import com.fasterxml.jackson.core.type.TypeReference;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import icu.mhb.mybatisplus.plugln.base.service.impl.JoinServiceImpl;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;

public abstract class AbstractItemExtendServiceImpl
extends JoinServiceImpl<ItemExtendMapper, ItemExtendEo>
implements IItemExtendService {
    private static final Logger log = LoggerFactory.getLogger(AbstractItemExtendServiceImpl.class);
    @Resource
    private IItemSkuService itemSkuService;
    @Resource
    private ItemExtendDas itemExtendDas;
    @Resource
    private IItemService itemService;
    @Resource
    private ItemDas itemDas;
    @Resource
    private IItemDepartmentPriceService priceService;
    @Resource
    private IItemUnitConversionService itemUnitConversionService;
    @Resource
    private ICacheService cacheService;

    @Override
    public void addItemExtendBatch(List<ItemExtendReqDto> addReqDto) {
        addReqDto.stream().forEach(this::addItemExtend);
    }

    @Override
    public void modifyPrice(ItemExtendReqDto modifyReqDto) {
        if (StringUtils.isBlank((CharSequence)modifyReqDto.getItemCode())) {
            throw new BizException("\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.eq(ItemExtendEo::getItemCode, (Object)modifyReqDto.getItemCode())).eq(BaseEo::getDr, (Object)0);
        ItemExtendEo itemExtendEo1 = (ItemExtendEo)this.itemExtendDas.getMapper().selectOne((Wrapper)queryWrapper);
        if (itemExtendEo1 == null) {
            ItemExtendEo itemExtendEo = new ItemExtendEo();
            itemExtendEo.setRecommendPrice(modifyReqDto.getRecommendPrice());
            itemExtendEo.setClaimPrice(modifyReqDto.getClaimPrice());
            itemExtendEo.setItemCode(modifyReqDto.getItemCode());
            this.itemExtendDas.insert((BaseEo)itemExtendEo);
            return;
        }
        if (modifyReqDto.getRecommendPrice() != null) {
            itemExtendEo1.setRecommendPrice(modifyReqDto.getRecommendPrice());
        }
        if (modifyReqDto.getClaimPrice() != null) {
            itemExtendEo1.setClaimPrice(modifyReqDto.getClaimPrice());
        }
        this.itemExtendDas.update((BaseEo)itemExtendEo1);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeItemExtend(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.itemExtendDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public List<ItemExtendRespDto> queryParam(ItemExtendReqDto reqDto) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        if (StringUtils.isNotEmpty((CharSequence)reqDto.getItemCode())) {
            queryWrapper.eq(ItemExtendEo::getItemCode, (Object)reqDto.getItemCode());
        }
        if (CollectionUtils.isNotEmpty((Collection)reqDto.getItemCodeList())) {
            queryWrapper.in(ItemExtendEo::getItemCode, (Collection)reqDto.getItemCodeList());
        }
        queryWrapper.eq(BaseEo::getDr, (Object)"0");
        List list = this.itemExtendDas.getMapper().selectList((Wrapper)queryWrapper);
        ArrayList<ItemExtendRespDto> dtoList = new ArrayList<ItemExtendRespDto>();
        DtoHelper.eoList2DtoList((Collection)list, dtoList, ItemExtendRespDto.class);
        return dtoList;
    }

    @Override
    public ItemExtendRespDto queryById(Long id) {
        ItemExtendEo itemExtendEo = (ItemExtendEo)this.itemExtendDas.selectByPrimaryKey(id);
        ItemExtendRespDto itemExtendRespDto = new ItemExtendRespDto();
        DtoHelper.eo2Dto((BaseEo)itemExtendEo, (BaseVo)itemExtendRespDto);
        return itemExtendRespDto;
    }

    @Override
    public PageInfo<ItemExtendRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        ItemExtendReqDto itemExtendReqDto = (ItemExtendReqDto)JSON.parseObject((String)filter, ItemExtendReqDto.class);
        ItemExtendEo itemExtendEo = new ItemExtendEo();
        DtoHelper.dto2Eo((BaseVo)itemExtendReqDto, (BaseEo)itemExtendEo);
        PageInfo eoPageInfo = this.itemExtendDas.selectPage((BaseEo)itemExtendEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, ItemExtendRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public PageInfo<OmsItemRespDto> queryByPage(PcpItemQueryDto queryDto) {
        PageHelper.startPage((int)queryDto.getPageNum(), (int)queryDto.getPageSize());
        PageInfo pageInfo = new PageInfo(this.itemExtendDas.queryItemDataByParams(queryDto));
        return pageInfo;
    }

    @Override
    public OmsItemDetailDto queryItemDetailById(Long id) {
        TaxRateEnum rateEnum;
        if (null == id) {
            return null;
        }
        OmsItemDetailDto detailDto = this.itemExtendDas.queryItemDetailById(id);
        if (null == detailDto.getTaxRate()) {
            detailDto.setTaxRate(Integer.valueOf(0));
        }
        if (null != (rateEnum = TaxRateEnum.getValueByCode((Integer)detailDto.getTaxRate()))) {
            detailDto.setTaxRate(rateEnum.getValue());
        }
        return detailDto;
    }

    @Override
    public OmsItemDetailDto queryItemDetailByCode(String code) {
        TaxRateEnum rateEnum;
        if (StringUtils.isEmpty((CharSequence)code)) {
            return null;
        }
        OmsItemDetailDto detailDto = this.itemExtendDas.queryItemDetailByCode(code);
        if (null == detailDto.getTaxRate()) {
            detailDto.setTaxRate(Integer.valueOf(0));
        }
        if (null != (rateEnum = TaxRateEnum.getValueByCode((Integer)detailDto.getTaxRate()))) {
            detailDto.setTaxRate(rateEnum.getValue());
        }
        return detailDto;
    }

    @Override
    public ItemInfoSkuRespDto queryItemSkuByCode(ItemInfoSkuReqDto itemInfoSkuReqDto) {
        if (StringUtils.isEmpty((CharSequence)itemInfoSkuReqDto.getCode())) {
            return null;
        }
        ItemRespDto itemRespDto = this.itemService.queryByItemCode(itemInfoSkuReqDto.getCode());
        OmsItemDetailDto detailDto = this.queryItemDetailById(itemRespDto.getId());
        List<ItemUnitConversionRespDto> itemSkuEoList = this.itemUnitConversionService.queryItemUnitById(itemRespDto.getId());
        ItemInfoSkuRespDto respDto = new ItemInfoSkuRespDto();
        if (CollectionUtils.isNotEmpty(itemSkuEoList)) {
            Map<String, List<ItemUnitConversionRespDto>> itemSkuEoMap = itemSkuEoList.stream().collect(Collectors.groupingBy(ItemUnitConversionRespDto::getConversionUnit));
            respDto.setId(itemRespDto.getId());
            respDto.setCode(itemRespDto.getLongCode());
            respDto.setName(itemRespDto.getName());
            respDto.setBaseUnit(detailDto.getBaseUnit());
            respDto.setSpecification(detailDto.getSpecification());
            if (StringUtils.isNotEmpty((CharSequence)itemInfoSkuReqDto.getUnit())) {
                respDto.setConversionNum(null != itemSkuEoMap.get(itemInfoSkuReqDto.getUnit()).get(0).getConversionNum() ? itemSkuEoMap.get(detailDto.getBaseUnit()).get(0).getConversionNum().toString() : null);
                respDto.setBaseUnitNum(null != itemSkuEoMap.get(itemInfoSkuReqDto.getUnit()).get(0).getBaseUnitNum() ? itemSkuEoMap.get(detailDto.getBaseUnit()).get(0).getBaseUnitNum().toString() : null);
                respDto.setConversionUnit(itemSkuEoMap.get(itemInfoSkuReqDto.getUnit()).get(0).getConversionUnit());
            } else if (StringUtils.isNotEmpty((CharSequence)detailDto.getBaseUnit())) {
                respDto.setConversionNum(null != itemSkuEoMap.get(detailDto.getBaseUnit()).get(0).getConversionNum() ? itemSkuEoMap.get(detailDto.getBaseUnit()).get(0).getConversionNum().toString() : null);
                respDto.setBaseUnitNum(null != itemSkuEoMap.get(detailDto.getBaseUnit()).get(0).getBaseUnitNum() ? itemSkuEoMap.get(detailDto.getBaseUnit()).get(0).getBaseUnitNum().toString() : null);
                respDto.setConversionUnit(itemSkuEoMap.get(detailDto.getBaseUnit()).get(0).getConversionUnit());
            }
            if (StringUtils.isNotEmpty((CharSequence)itemInfoSkuReqDto.getToUnit())) {
                respDto.setConversionNum(null != itemSkuEoMap.get(itemInfoSkuReqDto.getToUnit()).get(0).getConversionNum() ? itemSkuEoMap.get(detailDto.getBaseUnit()).get(0).getConversionNum().toString() : null);
                respDto.setBaseUnitNum(null != itemSkuEoMap.get(itemInfoSkuReqDto.getToUnit()).get(0).getBaseUnitNum() ? itemSkuEoMap.get(detailDto.getBaseUnit()).get(0).getBaseUnitNum().toString() : null);
                respDto.setConversionUnit(itemSkuEoMap.get(itemInfoSkuReqDto.getToUnit()).get(0).getConversionUnit());
            }
            if (StringUtils.isNotEmpty((CharSequence)itemInfoSkuReqDto.getUnit()) && StringUtils.isNotEmpty((CharSequence)itemInfoSkuReqDto.getToUnit()) && null != itemInfoSkuReqDto.getNum()) {
                Integer minPackage = itemSkuEoMap.get(itemInfoSkuReqDto.getUnit()).get(0).getConversionNum();
                Integer quantity = itemSkuEoMap.get(itemInfoSkuReqDto.getUnit()).get(0).getBaseUnitNum();
                Integer toMinPackage = itemSkuEoMap.get(itemInfoSkuReqDto.getToUnit()).get(0).getConversionNum();
                Integer toQuantity = itemSkuEoMap.get(itemInfoSkuReqDto.getToUnit()).get(0).getBaseUnitNum();
                BigDecimal num = new BigDecimal(minPackage).divide(new BigDecimal(quantity)).divide(new BigDecimal(toMinPackage).divide(new BigDecimal(toQuantity)));
                respDto.setToNum(itemInfoSkuReqDto.getNum().multiply(num).toString());
                respDto.setToUnit(itemSkuEoMap.get(itemInfoSkuReqDto.getToUnit()).get(0).getConversionUnit());
            }
        }
        return respDto;
    }

    @Override
    public List<OmsItemDetailDto> queryItemDetailByListCode(List<String> codeList) {
        if (CollectionUtils.isNotEmpty(codeList)) {
            return this.itemExtendDas.queryItemDetailByListCode(codeList);
        }
        return null;
    }

    @Override
    public List<OmsItemDetailDto> queryItemDetailByCode(ItemDataQueryReqDto queryReqDto) {
        if (CollectionUtils.isEmpty((Collection)queryReqDto.getItemCodeList())) {
            return null;
        }
        return this.queryItemDetailByListCode(queryReqDto.getItemCodeList());
    }

    @Override
    public List<ItemDataQueryRespDto> queryItemData(ItemDataQueryReqDto queryReqDto) {
        if (CollectionUtils.isEmpty((Collection)queryReqDto.getItemCodeList())) {
            return null;
        }
        ArrayList<ItemDataQueryRespDto> respDtoList = new ArrayList<ItemDataQueryRespDto>();
        List<ItemRespDto> itemRespDtoList = this.itemService.queryByItemLongCodes(queryReqDto.getItemCodeList());
        if (CollectionUtils.isNotEmpty(itemRespDtoList)) {
            for (ItemRespDto itemRespDto : itemRespDtoList) {
                ItemDataQueryRespDto respDto = new ItemDataQueryRespDto();
                respDto.setId(itemRespDto.getId());
                respDto.setCode(itemRespDto.getLongCode());
                respDto.setName(itemRespDto.getName());
                OmsItemDetailDto detailDto = this.queryItemDetailById(itemRespDto.getId());
                respDto.setSpecifications(detailDto.getSpecification());
                respDto.setPackageSpecification(detailDto.getPackageSpecification());
                respDto.setStorageCondition(detailDto.getStorageCondition());
                respDto.setProductType(detailDto.getProductType());
                respDto.setProductTypeDescribe(detailDto.getProductTypeDescribe());
                respDto.setExpirationDate(detailDto.getExpirationDate());
                respDto.setExpirationUnit(detailDto.getExpirationUnit());
                respDto.setSalesType(detailDto.getSalesType());
                if (null != detailDto.getTaxRate()) {
                    respDto.setTaxRate(new BigDecimal(detailDto.getTaxRate()));
                }
                respDto.setBaseUnit(detailDto.getBaseUnit());
                if (StringUtils.isNotEmpty((CharSequence)detailDto.getSaleUnit())) {
                    respDto.setSaleUnit(detailDto.getSaleUnit());
                } else {
                    respDto.setSaleUnit(detailDto.getBaseUnit());
                }
                List<ItemUnitConversionRespDto> conversionRespDtoList = this.itemUnitConversionService.queryItemUnitById(itemRespDto.getId());
                if (CollectionUtils.isNotEmpty(conversionRespDtoList)) {
                    List unitList = conversionRespDtoList.stream().map(ItemUnitConversionRespDto::getConversionUnit).collect(Collectors.toList());
                    respDto.setUnitList(unitList);
                    ItemDepartmentPriceRespDto priceRespDto = this.priceService.queryItemPriceByCode(itemRespDto.getLongCode(), detailDto.getBaseUnit());
                    for (ItemUnitConversionRespDto conversionRespDto : conversionRespDtoList) {
                        BigDecimal totalVolume = LengthUnitUtils.totalVolume(conversionRespDto.getLength(), conversionRespDto.getWidth(), conversionRespDto.getHeight(), conversionRespDto.getSizeUnit());
                        conversionRespDto.setVolume(totalVolume);
                        BigDecimal total = WeightUnitUtils.totalWeight(conversionRespDto.getNetWeight(), conversionRespDto.getWeightUnit());
                        conversionRespDto.setWeight(null != total ? total.toString() : "0");
                        if (null == priceRespDto || null == priceRespDto.getId()) continue;
                        BigDecimal price = new BigDecimal(conversionRespDto.getBaseUnitNum() + "").multiply(priceRespDto.getItemPrice()).divide(new BigDecimal(conversionRespDto.getConversionNum() + ""), 2, RoundingMode.FLOOR);
                        conversionRespDto.setOutFactoryPrice(price);
                        conversionRespDto.setOutFactoryUnit(conversionRespDto.getConversionUnit());
                    }
                    respDto.setConversionRespDtoList(conversionRespDtoList);
                }
                respDtoList.add(respDto);
            }
        }
        return respDtoList;
    }

    @Override
    public List<ItemBaseUnitQueryRespDto> queryBaseUnitByLongCodes(ItemDataQueryReqDto queryReqDto) {
        if (CollectionUtils.isEmpty((Collection)queryReqDto.getItemCodeList())) {
            return null;
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        if (CollectionUtils.isNotEmpty((Collection)queryReqDto.getItemCodeList())) {
            queryWrapper.in(ItemExtendEo::getItemCode, (Collection)queryReqDto.getItemCodeList());
        }
        queryWrapper.eq(BaseEo::getDr, (Object)"0");
        List list = this.itemExtendDas.getMapper().selectList((Wrapper)queryWrapper);
        ArrayList<ItemBaseUnitQueryRespDto> dtoList = new ArrayList<ItemBaseUnitQueryRespDto>();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            list.stream().forEach(itemInfo -> {
                ItemBaseUnitQueryRespDto itemBaseUnitQueryRespDto = new ItemBaseUnitQueryRespDto();
                itemBaseUnitQueryRespDto.setCode(itemInfo.getItemCode());
                itemBaseUnitQueryRespDto.setBaseUnit(itemInfo.getBaseUnit());
                itemBaseUnitQueryRespDto.setStorageCondition(itemInfo.getStorageCondition());
                dtoList.add(itemBaseUnitQueryRespDto);
            });
        }
        return dtoList;
    }

    @Override
    public List<ItemDataQueryRespDto> querySimpleItemDataForReportByItemCodes(List<String> itemCodeList) {
        if (CollectionUtils.isEmpty(itemCodeList)) {
            return null;
        }
        ArrayList<ItemDataQueryRespDto> respDtoList = new ArrayList<ItemDataQueryRespDto>();
        List<ItemRespDto> itemRespDtoList = this.itemService.queryByItemLongCodes(itemCodeList);
        if (CollectionUtils.isNotEmpty(itemRespDtoList)) {
            for (ItemRespDto itemRespDto : itemRespDtoList) {
                ItemDataQueryRespDto respDto = new ItemDataQueryRespDto();
                respDto.setId(itemRespDto.getId());
                respDto.setCode(itemRespDto.getLongCode());
                respDto.setName(itemRespDto.getName());
                String key = this.getClass().getSimpleName() + "_itemDetail:" + itemRespDto.getId();
                OmsItemDetailDto detailDto = (OmsItemDetailDto)this.cacheService.getCache(key, OmsItemDetailDto.class);
                if (detailDto == null) {
                    detailDto = this.queryItemDetailById(itemRespDto.getId());
                    this.cacheService.setCache(key, (Object)detailDto, 3600);
                }
                respDto.setSpecifications(detailDto.getSpecification());
                respDto.setPackageSpecification(detailDto.getPackageSpecification());
                respDto.setStorageCondition(detailDto.getStorageCondition());
                respDto.setProductType(detailDto.getProductType());
                respDto.setItemType(detailDto.getGoodsType());
                if (null != detailDto.getTaxRate()) {
                    respDto.setTaxRate(new BigDecimal(detailDto.getTaxRate()));
                }
                respDto.setBaseUnit(detailDto.getBaseUnit());
                if (StringUtils.isNotEmpty((CharSequence)detailDto.getSaleUnit())) {
                    respDto.setSaleUnit(detailDto.getSaleUnit());
                } else {
                    respDto.setSaleUnit(detailDto.getBaseUnit());
                }
                key = this.getClass().getSimpleName() + "_itemUnit:" + itemRespDto.getId();
                List<ItemUnitConversionRespDto> conversionRespDtoList = (List<ItemUnitConversionRespDto>)this.cacheService.getCache(key, (TypeReference)new TypeReference<List<ItemUnitConversionRespDto>>(){});
                if (conversionRespDtoList == null) {
                    conversionRespDtoList = this.itemUnitConversionService.queryItemUnitById(itemRespDto.getId());
                    this.cacheService.setCache(key, conversionRespDtoList, 3600);
                }
                if (CollectionUtils.isNotEmpty((Collection)conversionRespDtoList)) {
                    respDto.setConversionRespDtoList(conversionRespDtoList);
                }
                respDtoList.add(respDto);
            }
        }
        return respDtoList;
    }

    @Override
    public List<ItemDataQueryRespDto> queryItemDataByCode(ItemDataQueryReqDto queryReqDto) {
        if (CollectionUtils.isEmpty((Collection)queryReqDto.getItemCodeList())) {
            return null;
        }
        if (StringUtils.isNotEmpty((CharSequence)queryReqDto.getItemCode())) {
            List codeList = queryReqDto.getItemCodeList();
            codeList.add(queryReqDto.getItemCode());
            queryReqDto.setItemCodeList(codeList);
        }
        ArrayList<ItemDataQueryRespDto> respDtoList = new ArrayList<ItemDataQueryRespDto>();
        List<ItemRespDto> itemRespDtoList = this.itemService.queryByItemLongCodes(queryReqDto.getItemCodeList());
        if (CollectionUtils.isNotEmpty(itemRespDtoList)) {
            for (ItemRespDto itemRespDto : itemRespDtoList) {
                ItemDataQueryRespDto respDto = new ItemDataQueryRespDto();
                respDto.setId(itemRespDto.getId());
                respDto.setCode(itemRespDto.getLongCode());
                respDto.setName(itemRespDto.getName());
                OmsItemDetailDto detailDto = this.queryItemDetailById(itemRespDto.getId());
                respDto.setSpecifications(detailDto.getSpecification());
                respDto.setPackageSpecification(detailDto.getPackageSpecification());
                respDto.setStorageCondition(detailDto.getStorageCondition());
                respDto.setProductType(detailDto.getProductType());
                respDto.setProductTypeDescribe(detailDto.getProductTypeDescribe());
                respDto.setExpirationDate(detailDto.getExpirationDate());
                respDto.setExpirationUnit(detailDto.getExpirationUnit());
                respDto.setSalesType(detailDto.getSalesType());
                if (null != detailDto.getTaxRate()) {
                    respDto.setTaxRate(new BigDecimal(detailDto.getTaxRate()));
                }
                respDto.setBaseUnit(detailDto.getBaseUnit());
                if (StringUtils.isNotEmpty((CharSequence)detailDto.getSaleUnit())) {
                    respDto.setSaleUnit(detailDto.getSaleUnit());
                } else {
                    respDto.setSaleUnit(detailDto.getBaseUnit());
                }
                List<ItemUnitConversionRespDto> conversionRespDtoList = this.itemUnitConversionService.queryItemUnitById(itemRespDto.getId());
                if (CollectionUtils.isNotEmpty(conversionRespDtoList)) {
                    List unitList = conversionRespDtoList.stream().map(ItemUnitConversionRespDto::getConversionUnit).collect(Collectors.toList());
                    respDto.setUnitList(unitList);
                    ItemDepartmentPriceRespDto priceRespDto = this.priceService.queryItemPriceByCode(queryReqDto.getDepartmentCode(), itemRespDto.getLongCode(), detailDto.getBaseUnit());
                    for (ItemUnitConversionRespDto conversionRespDto : conversionRespDtoList) {
                        BigDecimal totalVolume = LengthUnitUtils.totalVolume(conversionRespDto.getLength(), conversionRespDto.getWidth(), conversionRespDto.getHeight(), conversionRespDto.getSizeUnit());
                        conversionRespDto.setVolume(totalVolume);
                        BigDecimal total = WeightUnitUtils.totalWeight(conversionRespDto.getNetWeight(), conversionRespDto.getWeightUnit());
                        conversionRespDto.setWeight(null != total ? total.toString() : "0");
                        if (null == priceRespDto || null == priceRespDto.getId()) continue;
                        BigDecimal price = new BigDecimal(conversionRespDto.getBaseUnitNum() + "").multiply(priceRespDto.getItemPrice()).divide(new BigDecimal(conversionRespDto.getConversionNum() + ""), 2, RoundingMode.FLOOR);
                        conversionRespDto.setOutFactoryPrice(price);
                        conversionRespDto.setOutFactoryUnit(conversionRespDto.getConversionUnit());
                    }
                    respDto.setConversionRespDtoList(conversionRespDtoList);
                }
                respDtoList.add(respDto);
            }
        }
        return respDtoList;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateImportData(List<ItemExtendImportDto> updateDtoList) {
        if (CollectionUtils.isNotEmpty(updateDtoList)) {
            for (ItemExtendImportDto itemExtendImportDto : updateDtoList) {
                if (itemExtendImportDto.getClaimPrice() != null || itemExtendImportDto.getRecommendPrice() != null || itemExtendImportDto.getZhTrayNum() != null || itemExtendImportDto.getBigBox() != null || itemExtendImportDto.getBigRatio() != null || itemExtendImportDto.getSmallBox() != null) {
                    this.itemExtendDas.updateImportData(itemExtendImportDto);
                }
                if (!StringUtils.isNotBlank((CharSequence)itemExtendImportDto.getItemType())) continue;
                ItemEo itemEo = new ItemEo();
                itemEo.setLongCode(itemExtendImportDto.getItemCode());
                List select = this.itemDas.select((BaseEo)itemEo);
                if (!CollectionUtils.isNotEmpty((Collection)select)) continue;
                for (ItemEo eo : select) {
                    ItemEo updateEo = new ItemEo();
                    updateEo.setId(eo.getId());
                    updateEo.setSubType(Integer.valueOf(itemExtendImportDto.getItemType()));
                    this.itemDas.updateSelective((BaseEo)updateEo);
                }
            }
        }
    }
}

