/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.item.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.commons.exceptions.ValidateException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.item.api.base.constants.ItemBusTypeEnum;
import com.dtyunxi.yundt.cube.center.item.api.base.constants.ItemStatus;
import com.dtyunxi.yundt.cube.center.item.api.base.constants.ShelfTaskStatusEnum;
import com.dtyunxi.yundt.cube.center.item.api.base.constants.ShelfTaskTypeEnum;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.AllowOrderTimeReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemShelfReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.OffItemReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.PointsDeductionReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ShelfIntegralAddReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ShelfIntegralModifyReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ShelfReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ShelfTimeDetailReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ShelfIntegralRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.exception.ItemBusinessRuntimeException;
import com.dtyunxi.yundt.cube.center.item.api.base.exception.ItemExceptionCode;
import com.dtyunxi.yundt.cube.center.item.biz.base.mq.ItemShelfProducer;
import com.dtyunxi.yundt.cube.center.item.biz.base.service.IDirItemAttributesService;
import com.dtyunxi.yundt.cube.center.item.biz.base.service.IDirectoryItemService;
import com.dtyunxi.yundt.cube.center.item.biz.base.service.IDistributionSetService;
import com.dtyunxi.yundt.cube.center.item.biz.base.service.IItemAttributesService;
import com.dtyunxi.yundt.cube.center.item.biz.base.service.IItemSearchService;
import com.dtyunxi.yundt.cube.center.item.biz.base.service.IItemService;
import com.dtyunxi.yundt.cube.center.item.biz.base.service.IItemSkuService;
import com.dtyunxi.yundt.cube.center.item.biz.base.service.IShelfIntegralService;
import com.dtyunxi.yundt.cube.center.item.biz.base.service.IShelfService;
import com.dtyunxi.yundt.cube.center.item.biz.base.service.dto.ShelfItemDto;
import com.dtyunxi.yundt.cube.center.item.biz.service.ItemExtShelfService;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.DirItemRelationDas;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.ItemBundleRelationDas;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.ItemDas;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.ShelfDas;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.ShelfPointsDeductionDas;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.ShelfTaskDas;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.DirEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.DirItemRelationEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.ItemAttributesEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.ItemBundleRelationEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.ItemEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.ItemSkuEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.ShelfEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.ShelfPointsDeductionEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.ShelfTaskEo;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class ItemExtShelfServiceImpl
implements ItemExtShelfService {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    private DirItemRelationDas dirItemRelationDas;
    @Resource
    private IItemAttributesService itemAttributesService;
    @Resource
    private IDirItemAttributesService dirItemAttributesService;
    @Resource
    private ShelfDas shelfDas;
    @Resource(name="${yunxi.dg.base.project:tcbj}ShelfService")
    private IShelfService shelfService;
    @Resource
    private IItemService itemService;
    @Resource
    private IItemSearchService itemSearchService;
    @Resource
    private ItemShelfProducer itemShelfProducer;
    @Resource
    private ShelfTaskDas shelfTaskDas;
    @Resource
    private IDirectoryItemService directoryItemService;
    @Resource
    private IItemSkuService itemSkuService;
    @Resource
    private ShelfPointsDeductionDas shelfPointsDeductionDas;
    @Resource
    private ItemBundleRelationDas itemBundleRelationDas;
    @Resource
    private ItemDas itemDas;
    @Autowired(required=false)
    private IShelfIntegralService shelfIntegralService;
    @Autowired(required=false)
    private IDistributionSetService distributionSetService;

    @Override
    public List<ShelfEo> saveShelf(List<ShelfReqDto> shelfReqDtos, Integer itemStatus) {
        ShelfEo result;
        ShelfEo shelfQuery;
        Map<String, ShelfReqDto> shelfMap = shelfReqDtos.stream().collect(Collectors.toMap(shelfReqDto -> shelfReqDto.getShopId() + shelfReqDto.getItemId() + shelfReqDto.getSkuId().toString() + shelfReqDto.getShelfAddress(), e -> e, (e1, e2) -> e1));
        ArrayList<ShelfEo> shelfEoList = new ArrayList<ShelfEo>();
        ArrayList subShelfEoList = new ArrayList();
        Date shelfTime = new Date();
        for (ShelfReqDto shelfReqDto2 : shelfMap.values()) {
            ItemEo itemEo = this.itemService.queryById(shelfReqDto2.getItemId());
            shelfQuery = new ShelfEo();
            if (ItemStatus.ITEM_OFFSHELF.getStatus().equals(itemStatus)) {
                shelfQuery.setId(shelfReqDto2.getId());
            }
            shelfQuery.setItemId(shelfReqDto2.getItemId());
            shelfQuery.setSkuId(shelfReqDto2.getSkuId());
            shelfQuery.setFreightTemplateId(shelfReqDto2.getFreightTemplateId());
            shelfQuery.setShopId(shelfReqDto2.getShopId());
            shelfQuery.setInstanceId(itemEo.getInstanceId());
            shelfQuery.setTenantId(itemEo.getTenantId());
            shelfQuery.setSellerId(shelfReqDto2.getSellerId());
            shelfQuery.setDistribution(shelfReqDto2.getDistribution());
            shelfQuery.setItemType(shelfReqDto2.getItemType());
            shelfQuery.setBusType(shelfReqDto2.getBusType());
            shelfQuery.setPointsDeduction(shelfReqDto2.getPointsDeduction());
            shelfQuery.setShelfAddress(shelfReqDto2.getShelfAddress());
            result = (ShelfEo)this.shelfDas.selectOne((BaseEo)shelfQuery);
            if (null != result) {
                result.setShelfTime(shelfTime);
                result.setStatus(itemStatus);
                result.setItemType(shelfReqDto2.getItemType());
                result.setType(result.getType());
                result.setPrice(shelfReqDto2.getPrice());
                result.setVersionId(itemEo.getVersion());
                shelfQuery.setFreightTemplateId(shelfReqDto2.getFreightTemplateId());
                this.shelfDas.updateSelective((BaseEo)result);
                continue;
            }
            shelfQuery.setOrganizationId(shelfReqDto2.getOrganizationId());
            shelfQuery.setOrganizationName(shelfReqDto2.getOrganizationName());
            shelfQuery.setShelfTime(shelfTime);
            shelfQuery.setStatus(itemStatus);
            shelfQuery.setPrice(shelfReqDto2.getPrice());
            shelfQuery.setItemType(shelfReqDto2.getItemType());
            shelfQuery.setType(shelfReqDto2.getType());
            shelfQuery.setVersionId(itemEo.getVersion());
            shelfQuery.setSellerId(shelfReqDto2.getSellerId());
            shelfQuery.setFreightTemplateId(shelfReqDto2.getFreightTemplateId());
            shelfQuery.setShelfAddress(shelfReqDto2.getShelfAddress());
            shelfEoList.add(shelfQuery);
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(shelfEoList)) {
            this.shelfDas.insertBatch(shelfEoList);
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(subShelfEoList)) {
            this.shelfDas.insertBatch(subShelfEoList);
        }
        if (null != this.shelfIntegralService && ItemBusTypeEnum.INTEGRAL.getType().equals(shelfReqDtos.get(0).getBusType())) {
            for (ShelfReqDto shelfReqDto3 : shelfMap.values()) {
                shelfQuery = new ShelfEo();
                shelfQuery.setItemType(shelfReqDto3.getItemType());
                shelfQuery.setSkuId(shelfReqDto3.getSkuId());
                shelfQuery.setBusType(shelfReqDto3.getBusType());
                shelfQuery.setItemId(shelfReqDto3.getItemId());
                shelfQuery.setShopId(shelfReqDto3.getShopId());
                result = (ShelfEo)this.shelfDas.selectOne((BaseEo)shelfQuery);
                ShelfIntegralRespDto shelfIntegralRespDto = this.shelfIntegralService.queryBySkuInfo(shelfReqDto3.getSkuId(), shelfReqDto3.getShopId());
                if (shelfIntegralRespDto == null) {
                    ShelfIntegralAddReqDto shelfIntegralAddReqDto = new ShelfIntegralAddReqDto();
                    shelfIntegralAddReqDto.setCashAmount(shelfReqDto3.getCashAmount());
                    shelfIntegralAddReqDto.setShelfId(result.getId());
                    shelfIntegralAddReqDto.setCashType(shelfReqDto3.getCashType());
                    shelfIntegralAddReqDto.setCashLimit(shelfReqDto3.getCashLimit());
                    shelfIntegralAddReqDto.setCashIntegral(shelfReqDto3.getCashIntegral());
                    shelfIntegralAddReqDto.setRuleRemark(shelfReqDto3.getRuleRemark());
                    shelfIntegralAddReqDto.setSkuId(shelfReqDto3.getSkuId());
                    shelfIntegralAddReqDto.setItemId(shelfReqDto3.getItemId());
                    shelfIntegralAddReqDto.setShopId(shelfReqDto3.getShopId());
                    this.shelfIntegralService.add(shelfIntegralAddReqDto);
                    continue;
                }
                ShelfIntegralModifyReqDto shelfIntegralModifyReqDto = new ShelfIntegralModifyReqDto();
                shelfIntegralModifyReqDto.setCashAmount(shelfReqDto3.getCashAmount());
                shelfIntegralModifyReqDto.setShelfId(result.getId());
                shelfIntegralModifyReqDto.setCashType(shelfReqDto3.getCashType());
                shelfIntegralModifyReqDto.setId(shelfIntegralRespDto.getId());
                shelfIntegralModifyReqDto.setCashLimit(shelfReqDto3.getCashLimit());
                shelfIntegralModifyReqDto.setCashIntegral(shelfReqDto3.getCashIntegral());
                shelfIntegralModifyReqDto.setItemId(shelfReqDto3.getItemId());
                shelfIntegralModifyReqDto.setRuleRemark(shelfReqDto3.getRuleRemark());
                shelfIntegralModifyReqDto.setShopId(shelfReqDto3.getShopId());
                shelfIntegralModifyReqDto.setSkuId(shelfReqDto3.getSkuId());
                if (ItemStatus.ITEM_ONSHELF.getStatus().equals(itemStatus)) {
                    this.shelfIntegralService.modify(shelfIntegralModifyReqDto);
                    continue;
                }
                this.shelfIntegralService.modifySelective(shelfIntegralModifyReqDto);
            }
        }
        for (ShelfReqDto shelfReqDto3 : shelfMap.values()) {
            this.shelfService.clearItemShelfCache(shelfReqDto3);
        }
        return shelfEoList;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void onShelfOperation(List<ItemShelfReqDto> onShelfDtoList, boolean isManual, Long taskId) {
        this.logger.info("\u5f00\u59cb\u8fdb\u884c\u4e0a\u67b6\u64cd\u4f5c\u2026\u2026");
        ArrayList shelfDirItems = Lists.newArrayList();
        List<DirItemRelationEo> dirsItemsEos = onShelfDtoList.stream().map(dtox -> {
            DirItemRelationEo dirItemRelationEo = DirItemRelationEo.newInstance();
            if (dtox.getShelfTimeReqDto() == null) {
                DtoHelper.dto2Eo((BaseVo)dtox, (BaseEo)dirItemRelationEo);
            } else if (org.apache.commons.collections.CollectionUtils.isNotEmpty(this.getAllowOrderTime((ItemShelfReqDto)dtox))) {
                dirItemRelationEo.setAllowOrderTime(this.Date2JsonString(this.getAllowOrderTime((ItemShelfReqDto)dtox), "yyyy-MM-dd HH:mm:ss"));
            }
            return dirItemRelationEo;
        }).collect(Collectors.toList());
        if (dirsItemsEos.stream().anyMatch(dtox -> dtox.getDirId() != null)) {
            this.logger.info("\u4fdd\u5b58\u4e0a\u67b6\u5546\u54c1\u548c\u76ee\u5f55\u5173\u7cfb");
            this.verifyDirItems(dirsItemsEos);
            dirsItemsEos = this.removeReply(dirsItemsEos);
            HashSet itemIds = new HashSet();
            HashSet dirIds = new HashSet();
            HashSet skuIds = new HashSet();
            dirsItemsEos.forEach(dirItem -> {
                itemIds.add(dirItem.getItemId());
                dirIds.add(dirItem.getDirId());
                skuIds.add(dirItem.getSkuId());
            });
            this.verifyItemIds(Lists.newArrayList(itemIds), Lists.newArrayList(dirIds), Lists.newArrayList(skuIds), taskId, ShelfTaskTypeEnum.ON.getType());
            ArrayList<DirItemRelationEo> insertEos = new ArrayList<DirItemRelationEo>();
            ArrayList<DirItemRelationEo> updateEos = new ArrayList<DirItemRelationEo>();
            for (DirItemRelationEo dirsItemsEo : dirsItemsEos) {
                DirItemRelationEo result = this.queryDirItemRelationInfo(dirsItemsEo);
                if (result == null) {
                    dirsItemsEo.setStatus(ItemStatus.ITEM_ONSHELF.getStatus());
                    insertEos.add(dirsItemsEo);
                    continue;
                }
                dirsItemsEo.setStatus(ItemStatus.ITEM_ONSHELF.getStatus());
                dirsItemsEo.setId(result.getId());
                updateEos.add(dirsItemsEo);
            }
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty(updateEos)) {
                updateEos.forEach(dirsItemsEox -> this.dirItemRelationDas.updateSelective((BaseEo)dirsItemsEox));
                shelfDirItems.addAll(updateEos);
            }
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty(insertEos)) {
                this.dirItemRelationDas.insertBatch(insertEos);
                shelfDirItems.addAll(insertEos);
            }
            List<ItemAttributesEo> allItemAttributes = this.itemAttributesService.queryByItemIds(Lists.newArrayList(itemIds));
            Map<Long, List<ItemAttributesEo>> groupItemIdAttributes = this.getGroupItemIdAttributes(Lists.newArrayList(itemIds), allItemAttributes);
            for (DirItemRelationEo dirsItemsEo : dirsItemsEos) {
                List<ItemAttributesEo> attributesList = groupItemIdAttributes.get(dirsItemsEo.getItemId());
                if (!org.apache.commons.collections.CollectionUtils.isNotEmpty(attributesList)) continue;
                this.dirItemAttributesService.addSearchAttrsAttributes(dirsItemsEo.getDirId(), attributesList);
            }
        }
        this.logger.info("\u4fdd\u5b58\u4e0a\u67b6\u8bb0\u5f55");
        ArrayList shelfReqDtos = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)shelfReqDtos, onShelfDtoList, ShelfReqDto.class);
        List<ShelfEo> shelfEoList = this.saveShelf(shelfReqDtos, ItemStatus.ITEM_ONSHELF.getStatus());
    }

    private List<AllowOrderTimeReqDto> getAllowOrderTime(ItemShelfReqDto itemShelfReqDto) {
        List shelfTimeDetailReqDtos = itemShelfReqDto.getShelfTimeReqDto().getShelfTimeDetailReqDtoList();
        ArrayList<AllowOrderTimeReqDto> allowOrderTimeReqDtoList = new ArrayList<AllowOrderTimeReqDto>();
        for (ShelfTimeDetailReqDto shelfTimeDetailReqDto : shelfTimeDetailReqDtos) {
            if (!org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)shelfTimeDetailReqDto.getAllowOrderTimeReqDtoList())) continue;
            allowOrderTimeReqDtoList.addAll(shelfTimeDetailReqDto.getAllowOrderTimeReqDtoList());
        }
        return allowOrderTimeReqDtoList;
    }

    private String Date2JsonString(Object object, String format) {
        return JSON.toJSONStringWithDateFormat((Object)object, (String)format, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteDateUseDateFormat});
    }

    private void verifyDirItems(List<DirItemRelationEo> dirsItemsEos) {
        if (org.apache.commons.collections.CollectionUtils.isEmpty(dirsItemsEos)) {
            ValidateException validateException = new ValidateException(ItemExceptionCode.EMPTY_PARAM_ERROR.getCode(), ItemExceptionCode.EMPTY_PARAM_ERROR.getMsg());
            validateException.addError("dirsItemsEos", "dirsItemsEos \u4e0d\u80fd\u4e3a\u7a7a");
            throw validateException;
        }
        for (DirItemRelationEo dirsItemsEo : dirsItemsEos) {
            ValidateException validateException = new ValidateException(ItemExceptionCode.EMPTY_PARAM_ERROR.getCode(), ItemExceptionCode.EMPTY_PARAM_ERROR.getMsg());
            if (dirsItemsEo == null) {
                validateException.addError("itemId", "itemId \u4e0d\u80fd\u4e3a\u7a7a");
                throw validateException;
            }
            if (dirsItemsEo.getItemId() != null && dirsItemsEo.getItemId() != 0L) continue;
            validateException.addError("itemId", "itemId \u4e0d\u80fd\u4e3a\u7a7a");
            throw validateException;
        }
    }

    private List<DirItemRelationEo> removeReply(List<DirItemRelationEo> dirItemRelationEoList) {
        HashMap<String, DirItemRelationEo> dirsItemsEoMap = new HashMap<String, DirItemRelationEo>();
        for (DirItemRelationEo dirsItemsEo : dirItemRelationEoList) {
            StringBuilder sb = new StringBuilder();
            sb.append(dirsItemsEo.getDirId()).append("_");
            sb.append(dirsItemsEo.getItemId()).append("_");
            sb.append(dirsItemsEo.getSkuId()).append("_");
            sb.append(dirsItemsEo.getShopId()).append("_");
            sb.append(dirsItemsEo.getBusType());
            dirsItemsEoMap.put(sb.toString(), dirsItemsEo);
        }
        ArrayList<DirItemRelationEo> resultEos = new ArrayList<DirItemRelationEo>();
        resultEos.addAll(dirsItemsEoMap.values());
        return resultEos;
    }

    private void verifyItemIds(List<Long> itemIds, List<Long> dirIds, List<Long> skuIds, Long taskId, String type) {
        List<ItemSkuEo> itemSkuEos;
        List<DirEo> directoryItemEos;
        Object shelfItemDto;
        boolean isExist;
        List<ItemEo> itemEos;
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(itemIds) && (itemEos = this.itemService.queryItemByIds(itemIds)).size() != itemIds.size()) {
            for (Long id : itemIds) {
                isExist = false;
                for (ItemEo itemEo : itemEos) {
                    if (!id.equals(itemEo.getId())) continue;
                    isExist = true;
                    break;
                }
                if (isExist) continue;
                shelfItemDto = new ShelfItemDto();
                ((ShelfItemDto)((Object)shelfItemDto)).setItemId(id);
                ((ShelfItemDto)((Object)shelfItemDto)).setTaskId(taskId);
                this.updateShelfTaskStatus((ShelfItemDto)((Object)shelfItemDto), ShelfTaskStatusEnum.UNPROCESSED.getStatus(), type, ShelfTaskStatusEnum.FAIL.getStatus());
                throw new BizException(ItemExceptionCode.EMPTY_PARAM_ERROR.getCode(), "itemId=" + id + "\u4e0d\u5b58\u5728");
            }
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(dirIds) && (directoryItemEos = this.directoryItemService.queryByIds(dirIds)).size() != dirIds.size()) {
            for (Long id : dirIds) {
                isExist = false;
                for (DirEo directoryItemEo : directoryItemEos) {
                    if (!id.equals(directoryItemEo.getId())) continue;
                    isExist = true;
                    break;
                }
                if (isExist) continue;
                shelfItemDto = new ShelfItemDto();
                ((ShelfItemDto)((Object)shelfItemDto)).setDirId(id);
                ((ShelfItemDto)((Object)shelfItemDto)).setTaskId(taskId);
                this.updateShelfTaskStatus((ShelfItemDto)((Object)shelfItemDto), ShelfTaskStatusEnum.UNPROCESSED.getStatus(), type, ShelfTaskStatusEnum.FAIL.getStatus());
                throw new BizException(ItemExceptionCode.EMPTY_PARAM_ERROR.getCode(), "dirId=" + id + "\u4e0d\u5b58\u5728");
            }
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(skuIds) && (itemSkuEos = this.itemSkuService.queryItemSkuByIds(skuIds)).size() != skuIds.size()) {
            for (Long skuId : skuIds) {
                isExist = false;
                for (ItemSkuEo eo : itemSkuEos) {
                    if (!skuId.equals(eo.getId())) continue;
                    isExist = true;
                    break;
                }
                if (isExist) continue;
                shelfItemDto = new ShelfItemDto();
                ((ShelfItemDto)((Object)shelfItemDto)).setSkuId(skuId);
                ((ShelfItemDto)((Object)shelfItemDto)).setTaskId(taskId);
                this.updateShelfTaskStatus((ShelfItemDto)((Object)shelfItemDto), ShelfTaskStatusEnum.UNPROCESSED.getStatus(), type, ShelfTaskStatusEnum.FAIL.getStatus());
                throw new BizException(ItemExceptionCode.EMPTY_PARAM_ERROR.getCode(), "skuId=" + skuId + "\u4e0d\u5b58\u5728");
            }
        }
    }

    private DirItemRelationEo queryDirItemRelationInfo(DirItemRelationEo dirItemRelationEo) {
        if (dirItemRelationEo == null) {
            throw new ItemBusinessRuntimeException(ItemExceptionCode.EMPTY_PARAM_ERROR);
        }
        if (dirItemRelationEo.getItemId() == null && dirItemRelationEo.getSkuId() == null) {
            throw new ItemBusinessRuntimeException(ItemExceptionCode.EMPTY_PARAM_ERROR);
        }
        return (DirItemRelationEo)this.dirItemRelationDas.selectOne((BaseEo)dirItemRelationEo);
    }

    private Map<Long, List<ItemAttributesEo>> getGroupItemIdAttributes(List<Long> itemIds, List<ItemAttributesEo> itemAttributesEos) {
        HashMap<Long, List<ItemAttributesEo>> divisionItemAttributesMap = new HashMap<Long, List<ItemAttributesEo>>();
        for (Long itemId : itemIds) {
            ArrayList<ItemAttributesEo> itemAttributes = new ArrayList<ItemAttributesEo>();
            for (ItemAttributesEo itemAttributesEo : itemAttributesEos) {
                if (!itemAttributesEo.getItemId().equals(itemId)) continue;
                itemAttributes.add(itemAttributesEo);
            }
            divisionItemAttributesMap.put(itemId, itemAttributes);
        }
        return divisionItemAttributesMap;
    }

    private void saveDistribution(List<ItemShelfReqDto> onShelfDtoList) {
        if (null != this.distributionSetService) {
            HashSet distributionSets = Sets.newHashSet();
            onShelfDtoList.forEach(itemShelfReqDto -> {
                if (itemShelfReqDto.getDistribution() == 1 && null != itemShelfReqDto.getDistribution()) {
                    distributionSets.add(itemShelfReqDto.getDistributionSet());
                }
            });
            this.distributionSetService.saveBatch(distributionSets.stream().collect(Collectors.toList()));
        }
    }

    private void savePointsDeductionRule(List<ItemShelfReqDto> onShelfDtoList, List<ShelfEo> shelfEoList) {
        Map<String, Long> ShelfMap = shelfEoList.stream().filter(shelfEo -> shelfEo.getId() != null).collect(Collectors.toMap(shelfEo -> shelfEo.getShopId() + "" + shelfEo.getSkuId() + "" + shelfEo.getShelfAddress(), BaseEo::getId));
        onShelfDtoList.stream().filter(itemShelfReqDto -> itemShelfReqDto.getPointsDeduction() != null && 1 == itemShelfReqDto.getPointsDeduction() && itemShelfReqDto.getPointsDeductionReqDto() != null).forEach(itemShelfReqDto -> {
            PointsDeductionReqDto pointsDeductionReqDto = itemShelfReqDto.getPointsDeductionReqDto();
            ShelfPointsDeductionEo query = ShelfPointsDeductionEo.newInstance();
            query.setShelfId((Long)ShelfMap.get(itemShelfReqDto.getShopId() + "" + itemShelfReqDto.getSkuId()));
            query.setShopId(itemShelfReqDto.getShopId());
            query.setShopId(itemShelfReqDto.getShopId());
            query.setItemId(itemShelfReqDto.getItemId());
            query.setSkuId(itemShelfReqDto.getSkuId());
            List list = this.shelfPointsDeductionDas.select((BaseEo)query);
            if (CollectionUtils.isEmpty((Collection)list)) {
                ShelfPointsDeductionEo shelfPointsDeductionEo = ShelfPointsDeductionEo.newInstance();
                shelfPointsDeductionEo.setShelfId((Long)ShelfMap.get(itemShelfReqDto.getShopId() + "" + itemShelfReqDto.getSkuId()));
                shelfPointsDeductionEo.setShopId(itemShelfReqDto.getShopId());
                shelfPointsDeductionEo.setItemId(itemShelfReqDto.getItemId());
                shelfPointsDeductionEo.setSkuId(itemShelfReqDto.getSkuId());
                shelfPointsDeductionEo.setMinPoints(pointsDeductionReqDto.getMinPoints());
                shelfPointsDeductionEo.setMaxPoints(pointsDeductionReqDto.getMaxPoints());
                shelfPointsDeductionEo.setCustom(pointsDeductionReqDto.getCustom());
                this.shelfPointsDeductionDas.insert((BaseEo)shelfPointsDeductionEo);
            } else {
                this.logger.info("{}\u79ef\u5206\u62b5\u6263\u89c4\u5219\u5df2\u7ecf\u5b58\u5728", (Object)query.getShelfId());
                ShelfPointsDeductionEo shelfPointsDeductionEo = (ShelfPointsDeductionEo)list.get(0);
                shelfPointsDeductionEo.setShelfId((Long)ShelfMap.get(itemShelfReqDto.getShopId() + "" + itemShelfReqDto.getSkuId()));
                shelfPointsDeductionEo.setShopId(itemShelfReqDto.getShopId());
                shelfPointsDeductionEo.setItemId(itemShelfReqDto.getItemId());
                shelfPointsDeductionEo.setSkuId(itemShelfReqDto.getSkuId());
                shelfPointsDeductionEo.setMinPoints(pointsDeductionReqDto.getMinPoints());
                shelfPointsDeductionEo.setMaxPoints(pointsDeductionReqDto.getMaxPoints());
                shelfPointsDeductionEo.setCustom(pointsDeductionReqDto.getCustom());
                this.shelfPointsDeductionDas.update((BaseEo)shelfPointsDeductionEo);
                if (list.size() > 1) {
                    this.logger.info("{}\u79ef\u5206\u62b5\u6263\u89c4\u5219\u5b58\u5728\u591a\u6761\uff0c\u9700\u8981\u5220\u9664", (Object)query.getShelfId());
                    for (int i = 1; i < list.size(); ++i) {
                        ShelfPointsDeductionEo eo = (ShelfPointsDeductionEo)list.get(i);
                        if (eo == null) continue;
                        this.shelfPointsDeductionDas.logicDelete((BaseEo)eo);
                    }
                }
            }
        });
    }

    private void updateShelfTaskStatus(ShelfItemDto shelfItemDto, Integer oldStatus, String type, Integer newStatus) {
        ShelfTaskEo shelfTaskEo = ShelfTaskEo.newInstance();
        DtoHelper.dto2Eo((BaseVo)shelfItemDto, (BaseEo)shelfTaskEo);
        shelfTaskEo.setStatus(oldStatus);
        shelfTaskEo.setType(type);
        List shelfTaskEoList = this.shelfTaskDas.select((BaseEo)shelfTaskEo);
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)shelfTaskEoList)) {
            for (ShelfTaskEo eo : shelfTaskEoList) {
                eo.setStatus(newStatus);
                this.shelfTaskDas.updateSelective((BaseEo)eo);
            }
        }
    }

    @Override
    public void offShelfOperation(List<OffItemReqDto> offItemReqDtos, boolean isManual, Long taskId) {
        HashSet itemIds = Sets.newHashSet();
        ArrayList offDirItems = Lists.newArrayList();
        for (OffItemReqDto offItemReqDto : offItemReqDtos) {
            if (offItemReqDto.getItemId() == null) {
                throw new ItemBusinessRuntimeException(ItemExceptionCode.NON_EXIST_PARAM);
            }
            itemIds.add(offItemReqDto.getItemId());
            ItemEo itemEo = this.itemService.queryById(offItemReqDto.getItemId());
            if (itemEo != null) {
                ArrayList<Long> dirIds;
                if (offItemReqDto.getSkuId() != null) {
                    dirIds = new ArrayList<Long>();
                    dirIds.add(offItemReqDto.getSkuId());
                    this.verifyItemIds(null, null, dirIds, taskId, ShelfTaskTypeEnum.OFF.getType());
                }
                if (offItemReqDto.getDirId() != null) {
                    dirIds = new ArrayList();
                    dirIds.add(offItemReqDto.getDirId());
                    this.verifyItemIds(null, dirIds, null, taskId, ShelfTaskTypeEnum.OFF.getType());
                }
                DirItemRelationEo dirItemRelationEo = DirItemRelationEo.newInstance();
                dirItemRelationEo.setItemId(itemEo.getId());
                dirItemRelationEo.setSkuId(offItemReqDto.getSkuId());
                dirItemRelationEo.setShopId(offItemReqDto.getShopId());
                dirItemRelationEo.setDirId(offItemReqDto.getDirId());
                dirItemRelationEo.setStatus(ItemStatus.ITEM_ONSHELF.getStatus());
                dirItemRelationEo.setTenantId(offItemReqDto.getTenantId());
                dirItemRelationEo.setInstanceId(offItemReqDto.getInstanceId());
                dirItemRelationEo.setBusType(offItemReqDto.getBusType());
                List relations = this.dirItemRelationDas.select((BaseEo)dirItemRelationEo);
                for (DirItemRelationEo e : relations) {
                    DirItemRelationEo updateEo = DirItemRelationEo.newInstance();
                    updateEo.setId(e.getId());
                    updateEo.setStatus(ItemStatus.ITEM_OFFSHELF.getStatus());
                    this.dirItemRelationDas.updateSelective((BaseEo)updateEo);
                    this.dirItemRelationDas.logicDeleteById(e.getId());
                    offDirItems.add(e);
                }
                if (isManual) continue;
                ShelfItemDto shelfItemDto = new ShelfItemDto();
                CubeBeanUtils.copyProperties((Object)((Object)shelfItemDto), (Object)offItemReqDto, (String[])new String[0]);
                shelfItemDto.setTaskId(taskId);
                this.updateShelfTaskStatus(shelfItemDto, ShelfTaskStatusEnum.UNPROCESSED.getStatus(), ShelfTaskTypeEnum.OFF.getType(), ShelfTaskStatusEnum.SUCCESS.getStatus());
                continue;
            }
            if (taskId == null) continue;
            ShelfItemDto shelfItemDto = new ShelfItemDto();
            shelfItemDto.setItemId(offItemReqDto.getItemId());
            shelfItemDto.setTaskId(taskId);
            this.updateShelfTaskStatus(shelfItemDto, ShelfTaskStatusEnum.UNPROCESSED.getStatus(), ShelfTaskTypeEnum.OFF.getType(), ShelfTaskStatusEnum.FAIL.getStatus());
        }
        ArrayList shelfReqDtos = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)shelfReqDtos, offItemReqDtos, ShelfReqDto.class);
        this.saveShelf(shelfReqDtos, ItemStatus.ITEM_OFFSHELF.getStatus());
    }

    @Deprecated
    private void offShelfCheckItemStatus(List<OffItemReqDto> offItemReqDtoList) {
        if (org.apache.commons.collections.CollectionUtils.isEmpty(offItemReqDtoList)) {
            return;
        }
        for (OffItemReqDto offItemReqDto : offItemReqDtoList) {
            List itemBundleRelationEoList;
            ItemBundleRelationEo itemBundleRelationEo = new ItemBundleRelationEo();
            itemBundleRelationEo.setSubItemId(offItemReqDto.getItemId());
            itemBundleRelationEo.setSubSkuId(offItemReqDto.getSkuId());
            if (this.itemBundleRelationDas.count((BaseEo)itemBundleRelationEo) == 0 || org.apache.commons.collections.CollectionUtils.isEmpty((Collection)(itemBundleRelationEoList = this.itemBundleRelationDas.select((BaseEo)itemBundleRelationEo)))) continue;
            for (ItemBundleRelationEo bundleRelationEo : itemBundleRelationEoList) {
                ItemEo itemEo;
                if (bundleRelationEo.getItemId() == null || (itemEo = (ItemEo)this.itemDas.selectByPrimaryKey(bundleRelationEo.getItemId())) == null || !ItemStatus.ITEM_ONSHELF.getStatus().equals(itemEo.getStatus())) continue;
                throw new ItemBusinessRuntimeException("10000", "\u5b50\u5546\u54c1\u4e0b\u67b6\u5931\u8d25\uff0c\u7ec4\u5408\u5546\u54c1\u662f\u4e0a\u67b6\u72b6\u6001");
            }
        }
    }
}

