/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.item.biz.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.item.api.dto.request.ItemExtendReqDto;
import com.dtyunxi.yundt.cube.center.item.api.utils.UnitFormatUtils;
import com.dtyunxi.yundt.cube.center.item.biz.service.IPcpItemService;
import com.dtyunxi.yundt.cube.center.item.biz.service.impl.AbstractItemExtendServiceImpl;
import com.dtyunxi.yundt.cube.center.item.dao.das.ItemExtendDas;
import com.dtyunxi.yundt.cube.center.item.dao.eo.ItemExtendEo;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.List;
import java.util.Optional;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service(value="mkldItemExtendService")
public class MkldItemExtendServiceImpl
extends AbstractItemExtendServiceImpl {
    @Resource
    private ItemExtendDas itemExtendDas;
    @Resource(name="${yunxi.dg.base.project:tcbj}PcpItemAdaptorService")
    private IPcpItemService pcpItemService;

    @Override
    public Long addItemExtend(ItemExtendReqDto addReqDto) {
        long id;
        addReqDto.setVolume((BigDecimal)Optional.ofNullable(addReqDto.getVolume()).map(va -> UnitFormatUtils.formatVolume((BigDecimal)va, (String)Optional.ofNullable(addReqDto.getVolumnUnit()).orElse(UnitFormatUtils.VolumeEnum.CM.getName()), (String)UnitFormatUtils.VolumeEnum.M.getName())).orElse(null));
        addReqDto.setVolumnUnit(UnitFormatUtils.VolumeEnum.M.getName());
        ItemExtendEo queryEo = (ItemExtendEo)this.itemExtendDas.selectByLogicKey((Object)addReqDto.getItemCode());
        if (queryEo != null && queryEo.getId() != null) {
            addReqDto.setId(queryEo.getId());
            this.modifyItemExtend(addReqDto);
            id = queryEo.getId();
        } else {
            ItemExtendEo itemExtendEo = new ItemExtendEo();
            DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)itemExtendEo);
            itemExtendEo.setSpecification(addReqDto.getSpecifications());
            this.itemExtendDas.insert((BaseEo)itemExtendEo);
            this.pcpItemService.publishItemSyncEvent(itemExtendEo);
            id = itemExtendEo.getId();
        }
        return id;
    }

    @Override
    public void modifyItemExtend(ItemExtendReqDto modifyReqDto) {
        ItemExtendEo itemExtendEo = new ItemExtendEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)itemExtendEo);
        itemExtendEo.setSpecification(modifyReqDto.getSpecifications());
        this.itemExtendDas.updateSelective((BaseEo)itemExtendEo);
        this.pcpItemService.publishItemSyncEvent(itemExtendEo);
    }

    @Override
    public void modifyPrice(ItemExtendReqDto modifyReqDto) {
        if (StringUtils.isBlank((CharSequence)modifyReqDto.getItemCode())) {
            throw new BizException("\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.eq(ItemExtendEo::getItemCode, (Object)modifyReqDto.getItemCode())).eq(BaseEo::getDr, (Object)0);
        ItemExtendEo itemExtendEo1 = (ItemExtendEo)this.itemExtendDas.getMapper().selectOne((Wrapper)queryWrapper);
        if (itemExtendEo1 == null) {
            ItemExtendEo itemExtendEo = new ItemExtendEo();
            itemExtendEo.setRecommendPrice(modifyReqDto.getRecommendPrice());
            itemExtendEo.setClaimPrice(modifyReqDto.getClaimPrice());
            itemExtendEo.setItemCode(modifyReqDto.getItemCode());
            this.itemExtendDas.insert((BaseEo)itemExtendEo);
            return;
        }
        ItemExtendEo itemExtendEo = new ItemExtendEo();
        if (modifyReqDto.getRecommendPrice() != null) {
            itemExtendEo.setRecommendPrice(modifyReqDto.getRecommendPrice());
        }
        if (modifyReqDto.getClaimPrice() != null) {
            itemExtendEo.setClaimPrice(modifyReqDto.getClaimPrice());
        }
        itemExtendEo.setSqlFilters((List)Lists.newArrayList((Object[])new SqlFilter[]{SqlFilter.eq((String)"item_code", (Object)modifyReqDto.getItemCode())}));
        this.itemExtendDas.updateSelectiveSqlFilter((BaseEo)itemExtendEo);
    }
}

