/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.item.biz.b2b.service.impl;

import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.yundt.cube.center.item.api.b2b.dto.request.CustomerBlockItemReqDto;
import com.dtyunxi.yundt.cube.center.item.api.b2b.dto.response.CustomerBlockItemRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.constants.ItemSkuStatusEnum;
import com.dtyunxi.yundt.cube.center.item.api.base.constants.RangeTypeEnum;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ManagementBlockReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ManagementBlockSaveReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemMgmtBlockRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemShelfSkuRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ManagementBlockRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.exception.ItemBusinessRuntimeException;
import com.dtyunxi.yundt.cube.center.item.api.base.exception.ItemExceptionCode;
import com.dtyunxi.yundt.cube.center.item.biz.b2b.service.IManagementBlockService;
import com.dtyunxi.yundt.cube.center.item.biz.base.service.IItemMediasService;
import com.dtyunxi.yundt.cube.center.item.biz.base.service.IShelfService;
import com.dtyunxi.yundt.cube.center.item.dao.b2b.das.ManagementBlockAreaRefDas;
import com.dtyunxi.yundt.cube.center.item.dao.b2b.das.ManagementBlockCustomerTypeRefDas;
import com.dtyunxi.yundt.cube.center.item.dao.b2b.das.ManagementBlockDas;
import com.dtyunxi.yundt.cube.center.item.dao.b2b.das.ManagementCustomerRefDas;
import com.dtyunxi.yundt.cube.center.item.dao.b2b.vo.CustomerBlockItemQueryVo;
import com.dtyunxi.yundt.cube.center.item.dao.b2b.vo.CustomerBlockItemVo;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.ItemMediasDas;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.ItemSkuDas;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.ShelfDas;
import com.dtyunxi.yundt.cube.center.item.dao.base.vo.ManagementBlockItemVo;
import com.dtyunxi.yundt.cube.center.item.dao.base.vo.ManagementBlockSearchVo;
import com.dtyunxi.yundt.cube.center.item.dao.base.vo.ManagementBlockVo;
import com.dtyunxi.yundt.cube.center.item.dao.base.vo.ShelfItemSkuVo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.b2b.ManagementBlockAreaRefEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.b2b.ManagementBlockCustomerTypeRefEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.b2b.ManagementBlockEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.b2b.ManagementCustomerRefEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.ItemSkuEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.StdItemSkuEo;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Transactional;

@Service(value="managementBlock")
public class ManagementBlockServiceImpl
implements IManagementBlockService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    private ItemMediasDas itemMediasDas;
    @Resource
    private ItemSkuDas itemSkuDas;
    @Resource(name="${yunxi.dg.base.project:tcbj}ShelfService")
    private IShelfService iShelfService;
    @Resource
    private ShelfDas shelfDas;
    @Resource
    private ManagementBlockDas managementBlockDas;
    @Resource
    private ManagementBlockAreaRefDas managementBlockAreaRefDas;
    @Resource
    private ManagementBlockCustomerTypeRefDas managementBlockCustomerTypeRefDas;
    @Resource
    private ManagementCustomerRefDas managementCustomerRefDas;
    @Resource
    private IItemMediasService itemMediasService;

    @Override
    public PageInfo<ManagementBlockRespDto> pageManagementBlock(ManagementBlockReqDto managementBlockReqDto) {
        List<Long> managementBlockIds = new ArrayList<Long>();
        if ((Objects.nonNull(managementBlockReqDto.getCustomerTypeId()) || CollectionUtils.isNotEmpty((Collection)managementBlockReqDto.getAreaCodes()) || CollectionUtils.isNotEmpty((Collection)managementBlockReqDto.getCustomerId())) && CollectionUtils.isEmpty(managementBlockIds = this.managementBlockDas.findManagementBlockIdsByCondition(managementBlockReqDto.getAreaCodes(), managementBlockReqDto.getCustomerId(), managementBlockReqDto.getCustomerTypeId(), managementBlockReqDto.getTenantId(), managementBlockReqDto.getInstanceId()))) {
            return new PageInfo((List)Lists.newArrayList());
        }
        List<ManagementBlockVo> itemEoList = this.getManagementBlockVos(managementBlockReqDto, managementBlockIds);
        ArrayList<ManagementBlockRespDto> managementBlockRespDtos = new ArrayList<ManagementBlockRespDto>();
        if (CollectionUtils.isNotEmpty(itemEoList)) {
            new ArrayList();
            List<Long> itemIds = itemEoList.stream().map(ManagementBlockVo::getItemId).distinct().filter(o -> o != null).collect(Collectors.toList());
            new ArrayList();
            List skuIds = itemEoList.stream().map(ManagementBlockVo::getSkuId).distinct().filter(o -> o != null).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(managementBlockIds)) {
                managementBlockIds = itemEoList.stream().map(ManagementBlockVo::getManagementBlockId).distinct().filter(o -> o != null).collect(Collectors.toList());
            }
            Map<Long, List<String>> areaCodesMap = this.getAreaCodesByManagementBlockIds(managementBlockIds);
            Map<Long, List<Long>> customerTypeIdsMap = this.getCustomerTypeIdsByManagementBlockIds(managementBlockIds);
            Map<Long, List<Long>> customerIdsMap = this.getCustomerIdsByManagementBlockIds(managementBlockIds);
            Map<Long, String> mainPicMap = this.itemMediasService.getMainPicByItemIds(itemIds);
            List shelfItemSkuVos = this.shelfDas.selectSelfItemSkuListBySkuIds(skuIds);
            for (ManagementBlockVo managementBlockVo : itemEoList) {
                ManagementBlockRespDto newOne = new ManagementBlockRespDto();
                BeanUtils.copyProperties((Object)managementBlockVo, (Object)newOne);
                newOne.setAreaCodes(RangeTypeEnum.ALL != RangeTypeEnum.fromCode((Integer)newOne.getIsAllArea()) ? areaCodesMap.get(newOne.getManagementBlockId()) : new ArrayList());
                newOne.setCustomerTypeIds(RangeTypeEnum.ALL != RangeTypeEnum.fromCode((Integer)newOne.getIsAllCustomerType()) ? customerTypeIdsMap.get(newOne.getManagementBlockId()) : new ArrayList());
                newOne.setCustomerIds(customerIdsMap.get(newOne.getManagementBlockId()));
                newOne.setImgPath(mainPicMap.get(managementBlockVo.getItemId()));
                newOne.setItemStatus(ItemSkuStatusEnum.ONSHELF.getStatus().equals(managementBlockVo.getShelfStatus()) ? ItemSkuStatusEnum.ONSHELF.getStatus() : ItemSkuStatusEnum.OFFSHELF.getStatus());
                List skuIdList = shelfItemSkuVos.stream().filter(o -> o.getShopId().equals(managementBlockVo.getShopId()) && o.getId().equals(managementBlockVo.getSkuId())).map(o -> {
                    ItemShelfSkuRespDto itemShelfSkuRespDto = new ItemShelfSkuRespDto();
                    BeanUtils.copyProperties((Object)o, (Object)itemShelfSkuRespDto);
                    return itemShelfSkuRespDto;
                }).collect(Collectors.toList());
                newOne.setSkuList(skuIdList);
                Long toalStock = newOne.getSkuList().stream().mapToLong(sku -> sku.getBalance() == null ? 0L : sku.getBalance()).sum();
                newOne.setItemTotalStorage(toalStock);
                managementBlockRespDtos.add(newOne);
            }
        }
        PageInfo result = new PageInfo();
        CubeBeanUtils.copyProperties((Object)result, (Object)new PageInfo(itemEoList), (String[])new String[]{"list", "navigatepageNums"});
        result.setList(managementBlockRespDtos);
        return result;
    }

    private List<ManagementBlockVo> getManagementBlockVos(ManagementBlockReqDto customerImportLogSearchReqDto, List<Long> managementBlockIdSet) {
        ManagementBlockSearchVo managementBlockSearchVo = new ManagementBlockSearchVo();
        BeanUtils.copyProperties((Object)customerImportLogSearchReqDto, (Object)managementBlockSearchVo);
        managementBlockSearchVo.setManagementBlockIds(new ArrayList<Long>(managementBlockIdSet));
        PageHelper.startPage((int)(customerImportLogSearchReqDto.getPageNum() == null ? 1 : customerImportLogSearchReqDto.getPageNum()), (int)(customerImportLogSearchReqDto.getPageSize() == null ? 10 : customerImportLogSearchReqDto.getPageSize()));
        return this.managementBlockDas.pageManagementBlock(managementBlockSearchVo);
    }

    private List<ItemShelfSkuRespDto> getSkuListBySkuIds(List<Long> skuIds) {
        ArrayList<ItemShelfSkuRespDto> itemShelfSkuRespDtos = new ArrayList<ItemShelfSkuRespDto>();
        List shelfItemSkuVos = this.shelfDas.selectSelfItemSkuListBySkuIds(skuIds);
        for (ShelfItemSkuVo shelfItemSkuVo : shelfItemSkuVos) {
            ItemShelfSkuRespDto itemShelfSkuRespDto = new ItemShelfSkuRespDto();
            BeanUtils.copyProperties((Object)shelfItemSkuVo, (Object)itemShelfSkuRespDto);
            itemShelfSkuRespDtos.add(itemShelfSkuRespDto);
        }
        return itemShelfSkuRespDtos;
    }

    private Map<Long, List<Long>> getCustomerIdsByManagementBlockIds(List<Long> managementBlockIds) {
        HashMap<Long, List<Long>> result = new HashMap<Long, List<Long>>();
        if (CollectionUtils.isNotEmpty(managementBlockIds)) {
            ManagementCustomerRefEo customerRefEo = new ManagementCustomerRefEo();
            ArrayList filters = Lists.newArrayList();
            filters.add(SqlFilter.in((String)"management_block_id", (Object)StringUtils.join(managementBlockIds, (String)",")));
            customerRefEo.setSqlFilters((List)filters);
            List select = this.managementCustomerRefDas.select((BaseEo)customerRefEo);
            if (CollectionUtils.isNotEmpty((Collection)select)) {
                for (ManagementCustomerRefEo eo : select) {
                    if (!result.containsKey(eo.getManagementBlockId())) {
                        result.put(eo.getManagementBlockId(), new ArrayList());
                    }
                    ((List)result.get(eo.getManagementBlockId())).add(eo.getCustomerId());
                }
            }
        }
        return result;
    }

    private Map<Long, List<Long>> getCustomerTypeIdsByManagementBlockIds(List<Long> managementBlockIds) {
        HashMap<Long, List<Long>> result = new HashMap<Long, List<Long>>();
        if (CollectionUtils.isNotEmpty(managementBlockIds)) {
            ManagementBlockCustomerTypeRefEo customerTypeRefEo = new ManagementBlockCustomerTypeRefEo();
            ArrayList filters = Lists.newArrayList();
            filters.add(SqlFilter.in((String)"management_block_id", (Object)StringUtils.join(managementBlockIds, (String)",")));
            customerTypeRefEo.setSqlFilters((List)filters);
            List select = this.managementBlockCustomerTypeRefDas.select((BaseEo)customerTypeRefEo);
            if (CollectionUtils.isNotEmpty((Collection)select)) {
                for (ManagementBlockCustomerTypeRefEo eo : select) {
                    if (!result.containsKey(eo.getManagementBlockId())) {
                        result.put(eo.getManagementBlockId(), new ArrayList());
                    }
                    ((List)result.get(eo.getManagementBlockId())).add(eo.getCustomerTypeId());
                }
            }
        }
        return result;
    }

    private Map<Long, List<String>> getAreaCodesByManagementBlockIds(List<Long> managementBlockIds) {
        HashMap<Long, List<String>> result = new HashMap<Long, List<String>>();
        if (CollectionUtils.isNotEmpty(managementBlockIds)) {
            ManagementBlockAreaRefEo managementBlockAreaRefEo = new ManagementBlockAreaRefEo();
            ArrayList filters = Lists.newArrayList();
            filters.add(SqlFilter.in((String)"management_block_id", (Object)StringUtils.join(managementBlockIds, (String)",")));
            managementBlockAreaRefEo.setSqlFilters((List)filters);
            List select = this.managementBlockAreaRefDas.select((BaseEo)managementBlockAreaRefEo);
            if (CollectionUtils.isNotEmpty((Collection)select)) {
                for (ManagementBlockAreaRefEo eo : select) {
                    if (!result.containsKey(eo.getManagementBlockId())) {
                        result.put(eo.getManagementBlockId(), new ArrayList());
                    }
                    ((List)result.get(eo.getManagementBlockId())).add(eo.getAreaCode());
                }
            }
        }
        return result;
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, isolation=Isolation.READ_COMMITTED)
    public void addOrModifyManagementBlock(ManagementBlockSaveReqDto managementBlockSaveReqDto) {
        if (managementBlockSaveReqDto.getSkuId() != null) {
            managementBlockSaveReqDto.getSkuIds().add(managementBlockSaveReqDto.getSkuId());
        }
        this.checkData(managementBlockSaveReqDto);
        if (CollectionUtils.isNotEmpty((Collection)managementBlockSaveReqDto.getSkuIds())) {
            this.batchDeleteManagementOldData(managementBlockSaveReqDto.getSkuIds());
            for (Long itemSkuId : managementBlockSaveReqDto.getSkuIds()) {
                this.batchSave(managementBlockSaveReqDto, itemSkuId);
            }
        }
    }

    private void batchDeleteManagementOldData(List<Long> skuIds) {
        ManagementBlockEo queryEo = new ManagementBlockEo();
        ArrayList filters = Lists.newArrayList();
        filters.add(SqlFilter.in((String)"sku_id", (Object)StringUtils.join(skuIds, (String)",")));
        queryEo.setSqlFilters((List)filters);
        List managementBlockEoList = this.managementBlockDas.select((BaseEo)queryEo);
        ArrayList managementBlockIds = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)managementBlockEoList)) {
            for (ManagementBlockEo managementBlockEo : managementBlockEoList) {
                managementBlockIds.add(managementBlockEo.getId());
            }
            this.managementBlockDas.deleteByManagementBlockIds((List)managementBlockIds);
            ManagementBlockAreaRefEo areaQueryEo = new ManagementBlockAreaRefEo();
            ArrayList areaFilters = Lists.newArrayList();
            areaFilters.add(SqlFilter.in((String)"management_block_id", (Object)StringUtils.join((Iterable)managementBlockIds, (String)",")));
            areaQueryEo.setSqlFilters((List)areaFilters);
            this.managementBlockAreaRefDas.delete((BaseEo)areaQueryEo);
            ManagementBlockCustomerTypeRefEo typeQueryEo = new ManagementBlockCustomerTypeRefEo();
            ArrayList typeFilters = Lists.newArrayList();
            typeFilters.add(SqlFilter.in((String)"management_block_id", (Object)StringUtils.join((Iterable)managementBlockIds, (String)",")));
            typeQueryEo.setSqlFilters((List)typeFilters);
            this.managementBlockCustomerTypeRefDas.delete((BaseEo)typeQueryEo);
            ManagementCustomerRefEo customerQueryEo = new ManagementCustomerRefEo();
            ArrayList customerFilters = Lists.newArrayList();
            customerFilters.add(SqlFilter.in((String)"management_block_id", (Object)StringUtils.join((Iterable)managementBlockIds, (String)",")));
            customerQueryEo.setSqlFilters((List)customerFilters);
            this.managementCustomerRefDas.delete((BaseEo)customerQueryEo);
        }
    }

    private void batchSave(ManagementBlockSaveReqDto managementBlockSaveReqDto, Long skuId) {
        ItemSkuEo itemSkuEo = (ItemSkuEo)this.itemSkuDas.selectByPrimaryKey(skuId);
        ManagementBlockEo managementBlockEo = new ManagementBlockEo();
        managementBlockEo.setSkuId(skuId);
        if (null != itemSkuEo) {
            managementBlockEo.setItemId(itemSkuEo.getItemId());
        }
        managementBlockEo.setIsAllArea(managementBlockSaveReqDto.getIsAllArea());
        managementBlockEo.setIsAllCustomerType(managementBlockSaveReqDto.getIsAllCustomer());
        this.managementBlockDas.insert((BaseEo)managementBlockEo);
        this.batchAddArea(managementBlockSaveReqDto, managementBlockEo.getId());
        this.batchAddCustomerType(managementBlockSaveReqDto, managementBlockEo.getId());
        this.batchAddCustomer(managementBlockSaveReqDto, managementBlockEo.getId());
    }

    @Override
    public List<ItemMgmtBlockRespDto> queryItemMgmtBlockList(Long itemId) {
        ArrayList<ItemMgmtBlockRespDto> itemMgmtBlockRespDtos = new ArrayList<ItemMgmtBlockRespDto>();
        ItemSkuEo itemSkuEo = ItemSkuEo.newInstance();
        itemSkuEo.setItemId(itemId);
        List select = this.itemSkuDas.select((BaseEo)itemSkuEo);
        if (select == null) {
            return itemMgmtBlockRespDtos;
        }
        for (ItemSkuEo skuEo : select) {
            ItemMgmtBlockRespDto itemMgmtBlockRespDto = new ItemMgmtBlockRespDto();
            ManagementBlockEo managementBlockEo = new ManagementBlockEo();
            managementBlockEo.setSkuId(skuEo.getId());
            ManagementBlockItemVo mgmtBlockItem = this.managementBlockDas.findManagementBlockVo(managementBlockEo);
            if (mgmtBlockItem == null) continue;
            itemMgmtBlockRespDto.setAreaCodes(mgmtBlockItem.getAreaCodes());
            itemMgmtBlockRespDto.setCustomerIds(mgmtBlockItem.getCustomerIds());
            itemMgmtBlockRespDto.setCustomerTypeIds(mgmtBlockItem.getCustomerTypeIds());
            itemMgmtBlockRespDto.setSkuId(skuEo.getId());
            itemMgmtBlockRespDto.setSkuCode(skuEo.getCode());
            itemMgmtBlockRespDto.setItemId(itemId);
            itemMgmtBlockRespDto.setAttr(skuEo.getAttr());
            itemMgmtBlockRespDtos.add(itemMgmtBlockRespDto);
        }
        return itemMgmtBlockRespDtos;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @Transactional(rollbackFor={Exception.class})
    public void cancelManagementBlock(List<Long> skuIds) {
        if (!CollectionUtils.isEmpty(skuIds)) {
            var2 = skuIds.iterator();
            block0: while (true) {
                if (!var2.hasNext()) {
                    return;
                }
                skuId = var2.next();
                managementBlockEo = new ManagementBlockEo();
                managementBlockEo.setSkuId(skuId);
                selects = this.managementBlockDas.select((BaseEo)managementBlockEo);
                this.managementBlockDas.delete((BaseEo)managementBlockEo);
                if (CollectionUtils.isEmpty((Collection)selects)) continue;
                var6 = selects.iterator();
                while (true) {
                    if (var6.hasNext()) ** break;
                    continue block0;
                    select = (ManagementBlockEo)var6.next();
                    managementBlockAreaRefEo = new ManagementBlockAreaRefEo();
                    managementBlockAreaRefEo.setManagementBlockId(select.getId());
                    this.managementBlockAreaRefDas.delete((BaseEo)managementBlockAreaRefEo);
                    managementBlockCustomerTypeRefEo = new ManagementBlockCustomerTypeRefEo();
                    managementBlockCustomerTypeRefEo.setManagementBlockId(select.getId());
                    this.managementBlockCustomerTypeRefDas.delete((BaseEo)managementBlockCustomerTypeRefEo);
                    managementCustomerRef = new ManagementCustomerRefEo();
                    managementCustomerRef.setManagementBlockId(select.getId());
                    this.managementCustomerRefDas.delete((BaseEo)managementCustomerRef);
                }
                break;
            }
        }
    }

    private void checkData(ManagementBlockSaveReqDto managementBlockSaveReqDto) {
        ItemSkuEo itemSkuEo;
        int count;
        Iterator var2 = managementBlockSaveReqDto.getSkuIds().iterator();
        do {
            if (!var2.hasNext()) {
                return;
            }
            Long itemSkuId = (Long)var2.next();
            itemSkuEo = ItemSkuEo.newInstance();
            itemSkuEo.setId(itemSkuId);
        } while ((count = this.itemSkuDas.count((BaseEo)itemSkuEo)) > 0);
        throw new ItemBusinessRuntimeException(ItemExceptionCode.NON_EXIST_ITEM);
    }

    private void batchAddCustomer(ManagementBlockSaveReqDto managementBlockSaveReqDto, Long managementBlockId) {
        if (!CollectionUtils.isEmpty((Collection)managementBlockSaveReqDto.getCustomerIds())) {
            ArrayList<ManagementCustomerRefEo> managementCustomerRefEos = new ArrayList<ManagementCustomerRefEo>(managementBlockSaveReqDto.getCustomerIds().size());
            for (Long customerId : managementBlockSaveReqDto.getCustomerIds()) {
                ManagementCustomerRefEo customerRefEo = new ManagementCustomerRefEo();
                customerRefEo.setManagementBlockId(managementBlockId);
                customerRefEo.setCustomerId(customerId);
                managementCustomerRefEos.add(customerRefEo);
            }
            this.managementCustomerRefDas.getMapper().insertBatch(managementCustomerRefEos);
        }
    }

    private void batchAddCustomerType(ManagementBlockSaveReqDto managementBlockSaveReqDto, Long managementBlockId) {
        if (RangeTypeEnum.ALL != RangeTypeEnum.fromCode((Integer)managementBlockSaveReqDto.getIsAllCustomer()) && CollectionUtils.isNotEmpty((Collection)managementBlockSaveReqDto.getCustomerTypeIds())) {
            ArrayList<ManagementBlockCustomerTypeRefEo> managementBlockCustomerTypeRefEos = new ArrayList<ManagementBlockCustomerTypeRefEo>(managementBlockSaveReqDto.getCustomerTypeIds().size());
            for (Long areaGroupId : managementBlockSaveReqDto.getCustomerTypeIds()) {
                ManagementBlockCustomerTypeRefEo managementBlockAreaRefEo = new ManagementBlockCustomerTypeRefEo();
                managementBlockAreaRefEo.setManagementBlockId(managementBlockId);
                managementBlockAreaRefEo.setCustomerTypeId(areaGroupId);
                managementBlockCustomerTypeRefEos.add(managementBlockAreaRefEo);
            }
            this.managementBlockCustomerTypeRefDas.getMapper().insertBatch(managementBlockCustomerTypeRefEos);
        }
    }

    private void batchAddArea(ManagementBlockSaveReqDto managementBlockSaveReqDto, Long managementBlockId) {
        if (RangeTypeEnum.ALL != RangeTypeEnum.fromCode((Integer)managementBlockSaveReqDto.getIsAllArea()) && CollectionUtils.isNotEmpty((Collection)managementBlockSaveReqDto.getAreaCodes())) {
            ArrayList<ManagementBlockAreaRefEo> managementBlockAreaRefEos = new ArrayList<ManagementBlockAreaRefEo>(managementBlockSaveReqDto.getAreaCodes().size());
            for (String areaGroupId : managementBlockSaveReqDto.getAreaCodes()) {
                ManagementBlockAreaRefEo managementBlockAreaRefEo = new ManagementBlockAreaRefEo();
                managementBlockAreaRefEo.setManagementBlockId(managementBlockId);
                managementBlockAreaRefEo.setAreaCode(areaGroupId);
                managementBlockAreaRefEos.add(managementBlockAreaRefEo);
            }
            this.managementBlockAreaRefDas.getMapper().insertBatch(managementBlockAreaRefEos);
        }
    }

    private void deleteManagementBlockOldData(Long skuId) {
        ManagementBlockEo queryManagementBlockEo = new ManagementBlockEo();
        queryManagementBlockEo.setSkuId(skuId);
        List select = this.managementBlockDas.select((BaseEo)queryManagementBlockEo);
        for (ManagementBlockEo managementBlockEo1 : select) {
            this.managementBlockDas.delete((BaseEo)managementBlockEo1);
            ArrayList<SqlFilter> sqlFilterList = new ArrayList<SqlFilter>();
            sqlFilterList.add(SqlFilter.eq((String)"MANAGEMENT_BLOCK_ID", (Object)managementBlockEo1.getId()));
            ManagementBlockAreaRefEo managementBlockAreaRefEo = new ManagementBlockAreaRefEo();
            managementBlockAreaRefEo.setSqlFilters(sqlFilterList);
            this.managementBlockAreaRefDas.delete((BaseEo)managementBlockAreaRefEo);
            ArrayList<SqlFilter> customerTypeSqlFilter = new ArrayList<SqlFilter>();
            customerTypeSqlFilter.add(SqlFilter.eq((String)"MANAGEMENT_BLOCK_ID", (Object)managementBlockEo1.getId()));
            ManagementBlockCustomerTypeRefEo managementBlockCustomerTypeRefEo = new ManagementBlockCustomerTypeRefEo();
            managementBlockCustomerTypeRefEo.setSqlFilters(customerTypeSqlFilter);
            this.managementBlockCustomerTypeRefDas.delete((BaseEo)managementBlockCustomerTypeRefEo);
            ArrayList<SqlFilter> customerSqlFilter = new ArrayList<SqlFilter>();
            customerSqlFilter.add(SqlFilter.eq((String)"MANAGEMENT_BLOCK_ID", (Object)managementBlockEo1.getId()));
            ManagementCustomerRefEo customerEo = new ManagementCustomerRefEo();
            customerEo.setSqlFilters(customerSqlFilter);
            this.managementCustomerRefDas.delete((BaseEo)customerEo);
        }
    }

    private Set<Long> buildManagementBlockId(ManagementBlockReqDto customerImportLogSearchReqDto) {
        List id;
        HashSet<Long> managementBlockIdSet = new HashSet<Long>();
        if (CollectionUtils.isNotEmpty((Collection)customerImportLogSearchReqDto.getAreaCodes())) {
            id = this.managementBlockAreaRefDas.findManagementBlockIdBykAreaCodes(customerImportLogSearchReqDto.getAreaCodes(), customerImportLogSearchReqDto.getInstanceId(), customerImportLogSearchReqDto.getTenantId());
            managementBlockIdSet.addAll(id);
        }
        if (null != customerImportLogSearchReqDto.getCustomerTypeId()) {
            id = this.managementBlockCustomerTypeRefDas.findManagementBlockIdBykCustomerTypeId(customerImportLogSearchReqDto.getCustomerTypeId(), customerImportLogSearchReqDto.getInstanceId(), customerImportLogSearchReqDto.getTenantId());
            managementBlockIdSet.addAll(id);
        }
        if (CollectionUtils.isNotEmpty((Collection)customerImportLogSearchReqDto.getCustomerId())) {
            id = this.managementCustomerRefDas.findManagementBlockIdBykCustomerIds(customerImportLogSearchReqDto.getCustomerId(), customerImportLogSearchReqDto.getInstanceId(), customerImportLogSearchReqDto.getTenantId());
            managementBlockIdSet.addAll(id);
        }
        return managementBlockIdSet;
    }

    @Override
    public List<CustomerBlockItemRespDto> queryCustomerBlockItemList(CustomerBlockItemReqDto customerBlockItemReqDto) {
        if (null == customerBlockItemReqDto.getCustomerId() && null == customerBlockItemReqDto.getCustomerTypeId() && StringUtils.isEmpty((CharSequence)customerBlockItemReqDto.getAreaCode())) {
            throw new BizException("\u5ba2\u6237ID\u3001\u5ba2\u6237\u7c7b\u578b\u3001\u5ba2\u6237\u5f52\u5c5e\u533a\u57df\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
        }
        ArrayList<CustomerBlockItemRespDto> customerBlockItemRespDtos = new ArrayList<CustomerBlockItemRespDto>();
        CustomerBlockItemQueryVo customerBlockItemQueryVo = new CustomerBlockItemQueryVo();
        BeanUtils.copyProperties((Object)customerBlockItemReqDto, (Object)customerBlockItemQueryVo);
        List customerBlockItemVos = this.managementBlockDas.queryCustomerBlockItemList(customerBlockItemQueryVo);
        if (CollectionUtils.isNotEmpty((Collection)customerBlockItemVos)) {
            List itemIds = customerBlockItemVos.stream().filter(bean -> null != bean.getItemId()).map(CustomerBlockItemVo::getItemId).distinct().collect(Collectors.toList());
            if (CollectionUtils.isEmpty(itemIds)) {
                return customerBlockItemRespDtos;
            }
            List itemSkuEos = this.itemSkuDas.selectByItemIds(itemIds);
            Map<Long, List<ItemSkuEo>> itemSkuEoMap = itemSkuEos.stream().filter(bean -> null != bean.getItemId()).collect(Collectors.groupingBy(StdItemSkuEo::getItemId));
            Map<Long, List<CustomerBlockItemVo>> customerBlockItemVoMap = customerBlockItemVos.stream().collect(Collectors.groupingBy(CustomerBlockItemVo::getItemId));
            if (null != customerBlockItemVoMap) {
                for (Map.Entry<Long, List<CustomerBlockItemVo>> customerBlockItemVoEntry : customerBlockItemVoMap.entrySet()) {
                    CustomerBlockItemRespDto customerBlockItemRespDto = new CustomerBlockItemRespDto();
                    Boolean flag = false;
                    Long key = customerBlockItemVoEntry.getKey();
                    List<CustomerBlockItemVo> customerBlockItemVoList = customerBlockItemVoEntry.getValue();
                    List<ItemSkuEo> itemSkuEosList = itemSkuEoMap.get(key);
                    if (CollectionUtils.isNotEmpty(itemSkuEosList) && CollectionUtils.isNotEmpty(customerBlockItemVoList) && itemSkuEosList.size() == customerBlockItemVoList.size()) {
                        flag = true;
                    }
                    List skuIds = customerBlockItemVoList.stream().map(CustomerBlockItemVo::getSkuId).distinct().collect(Collectors.toList());
                    customerBlockItemRespDto.setItemId(key);
                    customerBlockItemRespDto.setFlag(flag);
                    customerBlockItemRespDto.setSkuIds(skuIds);
                    customerBlockItemRespDtos.add(customerBlockItemRespDto);
                }
            }
        }
        return customerBlockItemRespDtos;
    }
}

